<?php
require_once 'smis-framework/smis/template/ModulTemplate.php';
require_once ("smis-base/smis-include-service-consumer.php");
require_once 'medical_record/class/table/DiagnosaTable.php';
require_once 'medical_record/class/adapter/DiagnosaAdapter.php';
require_once 'smis-libs-hrd/EmployeeResponder.php';

class MedicalRecordTemplate extends ModulTemplate {
	protected $db;
	protected $mode;
	protected $polislug;
	protected $page;
	protected $protoslug;
	protected $protoname;
	protected $protoimplement;
	protected $action;
	protected $dbtable;
	protected $uitable;
	protected $noreg_pasien;
	protected $nama_pasien;
	protected $nrm_pasien;
	protected $list_pesan;
	protected $list_hasil;
	protected $gol_umur;
	protected $jk;
	protected $kunjungan;
	protected $carabayar;
	protected $urji;
	protected $is_jkn_member;
	protected $no_bpjs;
	protected $is_bridging_with_pcare;
	public static $MODE_DAFTAR = "pendaftaran";
	public static $MODE_PERIKSA = "pemeriksaan";
	public function __construct($db, $mode, $polislug = "all", $noreg = "", $nrm = "", $nama = "", $page = "medical_record", $action = "diagnosa", $protoslug = "", $protoname = "", $protoimplement = "", $jenis_umur = "TGL LAHIR TDK VALID", $jk = "0", $kunjungan = "Baru", $carabayar = "Umum",$urji="0") {
		$this->db = $db;
		$this->mode = $mode;
		$this->urji=$urji;
		$this->noreg_pasien = $noreg;
		$this->nama_pasien = $nama;
		$this->gol_umur = $jenis_umur;
		$this->nrm_pasien = $nrm;
		$this->polislug = $polislug;
		$this->dbtable = new DBTable ( $this->db, "smis_mr_diagnosa" );
		$this->page = $page;
		$this->protoslug = $protoslug;
		$this->protoimplement = $protoimplement;
		$this->protoname = $protoname;
		$this->action = $action;
		$this->jk = $jk;
		$this->kunjungan = $kunjungan;
		$this->carabayar = $carabayar;
		if ($noreg != "")
			$this->dbtable->addCustomKriteria ( "noreg_pasien", "='" . $noreg. "'" );

		/// Get JKN Membership Status 
		$this->is_jkn_member = 0;
		$row = $this->db->get_row("
			SELECT 
				a.nobpjs, a.carabayar, b.nama asuransi
			FROM 
				smis_rg_layananpasien a LEFT JOIN smis_rg_asuransi b ON a.asuransi = b.id
			WHERE 
				a.id = '" . $noreg . "'
		");
		if ($row != null) {
			if ($row->carabayar == "bpjs" && $row->asuransi == "BPJS - KESEHATAN")
				$this->is_jkn_member = 1;
			$this->no_bpjs = $row->nobpjs;
		}

		// $this->is_bridging_with_pcare = getSettings($db, "reg-activate-pcare", 0);
		require_once ("registration/function/is_pcare.php");
		$this->is_bridging_with_pcare = is_pcare() ? 1 : 0;
		
		$array=array ('Tanggal','NRM',"No.Reg","Pasien","Jenis Kelamin","Dokter","ICD X","Nama ICD X","Ruangan" );
		if ($this->is_jkn_member == 1 && $this->is_bridging_with_pcare == 1) {
			$array = array('Tanggal', 'NRM', "No.Reg", "No. Kunjungan PCare", "Pasien", "Jenis Kelamin", "Dokter", "ICD X", "Nama ICD X", "Ruangan");
		}
		$this->uitable = new DiagnosaTable ($polislug,$noreg, $array , " Diagnosa " . ($this->polislug == "all" ? "" : ucfirst ( $this->protoname )), NULL, true );
		$this->uitable->setName ( $action );
		$this->uitable->setReloadButtonEnable(false);
		$this->uitable->setPrintButtonEnable(false);
		if ($this->mode == self::$MODE_PERIKSA) {
			$this->uitable->setAddButtonEnable ( false );
			$this->uitable->setDelButtonEnable ( false );
		}
	}
	public function command($command) {
		if ($_POST['command'] == "get_ppk_spesialis_option") {
			$nama_ppk_rujukan = $_POST['nama_ppk_rujukan'];
			$selected_spesialis = isset($_POST['selected_ppk_spesialis']) ? $_POST['selected_ppk_spesialis'] : "";
			$html = "<option value='' selected></option>";
			if ($selected_spesialis != "")
				"<option value=''></option>";
			$ppk_spesialis_rows = $this->db->get_result("
				SELECT
					spesialis
				FROM
					smis_rg_ppk_spesialis
				WHERE
					prop = '' AND nama_ppk_rujukan LIKE '%" . $nama_ppk_rujukan . "'
				ORDER BY
					spesialis ASC
			");
			if ($ppk_spesialis_rows != null) {
				foreach ($ppk_spesialis_rows as $ppk_spesialis) {
					if ($ppk_spesialis->spesialis == $selected_spesialis)
						$html .= "<option value='" . $ppk_spesialis->spesialis . "' selected>" . $ppk_spesialis->spesialis. "</option>";
					else
						$html .= "<option value='" . $ppk_spesialis->spesialis . "'>" . $ppk_spesialis->spesialis. "</option>";
				}
			}
			$data = array(
				'html' => $html
			);
			echo json_encode($data);
			return;
		} else if ($_POST['command'] == "validasi_resep") {
			$noreg_pasien = $_POST['noreg_pasien'];
			$service_consumer = new ServiceConsumer($this->db, "get_aktif_resep");
			$service_consumer->setMode(ServiceConsumer::$MULTIPLE_MODE);
			$service_consumer->addData("noreg_pasien", $noreg_pasien);
			$response = $service_consumer->execute()->getContent();

			$message = "Pasien masih memiliki Resep aktif di : <ul>";
			$resep_aktif = 0;
			if (count($response) > 0) {
			     foreach ($response as $key => $val) {
			          if (count($val) > 0) {
			               foreach ($val as $v_key => $v_val) {
			                    if ($v_val == 1) {
			                         $resep_aktif = 1;
			                         $message .= "<li>" . ArrayAdapter::format("unslug", $v_key) . "</li>";
			                    }
			               }
			          }
			     }
			}
			$message .= "</ul>";

			echo json_encode(array(
				'resep_aktif' => $resep_aktif,
				'message' => $resep_aktif == 1 ? $message : ""
			));

			return;
		} else if ($_POST['command'] == "pdf_surat_rujukan") {
			require_once("medical_record/snippet/create_pdf_surat_rujukan.php");
			echo json_encode(generatePDF($this->db, $_POST['id']));
			return;
		}

        require_once "smis-base/smis-include-duplicate.php";
		$adapter = new DiagnosaAdapter ();
		$adapter->add ( "Tanggal", "tanggal", "date d M Y" );
		$adapter->add ( "Pasien", "nama_pasien" );
		$adapter->add ( "NRM", "nrm_pasien", "digit8" );
		$adapter->add ( "No.Reg", "noreg_pasien" );
		if ($this->is_jkn_member == 1 && $this->is_bridging_with_pcare == 1) {
			$adapter->add ( "No. Kunjungan PCare", "no_kunjungan_pcare" );
		}
		$adapter->add ( "Dokter", "nama_dokter" );
		$adapter->add ( "ICD X", "kode_icd" );
		$adapter->add ( "Nama ICD X", "nama_icd" );
		$adapter->add ( "Kelas", "kelas", "unslug" );
		$adapter->add ( "Ruangan", "ruangan" );
		$adapter->add ( "Jenis Kelamin", "jk", "trivial_0_Laki-Laki_Perempuan" );
		$dbres = new DuplicateResponder( $this->dbtable, $this->uitable, $adapter );
		$dbres->setDuplicate(false,"");
        $dbres->setAutonomous(getSettings($this->db,"smis_autonomous_id",""));
        if ($dbres->isSave()) {
			$tgl_masuk = "";
			$tgl_lahir = "";
			if (isset($_POST['ruangan']) && isset($_POST['noreg_pasien'])) {
				$ruangan = $_POST['ruangan'];
				$noreg_pasien = $_POST['noreg_pasien'];

				$row = $this->db->get_row("
					SELECT tgl_lahir, tanggal
					FROM smis_rgv_layananpasien 
					WHERE id = '" . $noreg_pasien . "'
				");
				if ($row != null) {
					$tgl_masuk = $row->tanggal;
					$tgl_lahir = $row->tgl_lahir;
				}

				if ($_POST['command'] == "save") {
					// Update Data Antrian :
					$params = array();
					$params['noreg_pasien'] = $_POST['noreg_pasien'];
					$params['status_pulang'] = $_POST['status_pulang'];
					$params['tanggal_pulang'] = $_POST['tanggal_pulang'];
					$params['selesai'] = 1;
					$consumer_service = new ServiceConsumer(
						$this->db,
						"set_update_info_antrian",
						$params,
						$_POST['ruangan']
					);
					$consumer_service->setMode(ServiceConsumer::$CLEAN_BOTH);
					$consumer_service->execute();

					// Update Data Kunjungan :	
					$params = array();
					$params['noreg_pasien'] = $_POST['noreg_pasien'];
					$params['status_pulang'] = $_POST['status_pulang'];
					$params['tanggal_pulang'] = $_POST['tanggal_pulang'];
					$params['selesai'] = 1;
					$consumer_service = new ServiceConsumer(
						$this->db,
						"set_update_info_kunjungan",
						$params,
						"registration"
					);
					$consumer_service->setMode(ServiceConsumer::$CLEAN_BOTH);
					$consumer_service->execute();
				}

				/// Handling Info. Jenis Rujukan Vertikal :
				if ($_POST['jenis_rujuk_vertikal'] == "Spesialis") {
					$_POST['kode_kondisi_khusus_kategori'] = "";
					$_POST['nama_kondisi_khusus_kategori'] = "";
					$_POST['kode_kondisi_khusus_spesialis'] = "";
					$_POST['nama_kondisi_khusus_spesialis'] = "";
					$_POST['kondisi_khusus_alasan'] = "";
				} else if ($_POST['jenis_rujuk_vertikal'] == "Kondisi Khusus") {
					$_POST['kode_spesialis_spesialis'] = "";
					$_POST['nama_spesialis_spesialis'] = "";
					$_POST['kode_spesialis_subspesialis'] = "";
					$_POST['nama_spesialis_subspesialis'] = "";
					$_POST['kode_spesialis_sarana'] = "";
					$_POST['nama_spesialis_sarana'] = "";
				} else {
					$_POST['kode_kondisi_khusus_kategori'] = "";
					$_POST['nama_kondisi_khusus_kategori'] = "";
					$_POST['kode_kondisi_khusus_spesialis'] = "";
					$_POST['nama_kondisi_khusus_spesialis'] = "";
					$_POST['kondisi_khusus_alasan'] = "";
					$_POST['kode_spesialis_spesialis'] = "";
					$_POST['nama_spesialis_spesialis'] = "";
					$_POST['kode_spesialis_subspesialis'] = "";
					$_POST['nama_spesialis_subspesialis'] = "";
					$_POST['kode_spesialis_sarana'] = "";
					$_POST['nama_spesialis_sarana'] = "";
				}
			}
			$_POST['tgl_masuk'] = $tgl_masuk;
			$_POST['tgl_lahir'] = $tgl_lahir;
			// if (isset($_POST['tanggal_rencana_berkunjung']) && $_POST['tanggal_rencana_berkunjung'] != "")
			// 	$_POST['tanggal_rencana_berkunjung'] = implode('-', array_reverse(explode('-', $_POST['tanggal_rencana_berkunjung'])));
		} else if ($dbres->isDel()) {
			$noreg_pasien = $this->dbtable->get_var("
				SELECT
					noreg_pasien
				FROM
					smis_mr_diagnosa
				WHERE
					id = '" . $_POST['id'] . "'
			");

			// Update Data Antrian :
			$params = array();
			$params['noreg_pasien'] = $noreg_pasien;
			$params['status_pulang'] = "";
			$params['tanggal_pulang'] = "";
			$params['selesai'] = 0;
			$consumer_service = new ServiceConsumer(
				$this->db,
				"set_update_info_antrian",
				$params,
				$_POST['ruangan']
			);
			$consumer_service->setMode(ServiceConsumer::$CLEAN_BOTH);
			$consumer_service->execute();

			// Update Data Kunjungan :	
			$params = array();
			$params['noreg_pasien'] = $noreg_pasien;
			$params['status_pulang'] = "";
			$params['tanggal_pulang'] = "";
			$params['selesai'] = 0;
			$consumer_service = new ServiceConsumer(
				$this->db,
				"set_update_info_kunjungan",
				$params,
				"registration"
			);
			$consumer_service->setMode(ServiceConsumer::$CLEAN_BOTH);
			$consumer_service->execute();	
		}
        $data = $dbres->command ( $_POST ['command'] );
		echo json_encode ( $data );
		return;
	}
	public function phpPreLoad() {		
		$this->uitable->addModal ( "id", "hidden", "", "" );
		$this->uitable->addModal ( "is_jkn_member", "hidden", "", $this->is_jkn_member );
		$this->uitable->addModal ( "no_bpjs", "hidden", "", $this->no_bpjs );
		$this->uitable->addModal ( "gol_umur", "hidden", "", $this->gol_umur );
		if ($this->noreg_pasien != "") {
			$this->uitable->addModal ( "nama_pasien", "hidden", "", $this->nama_pasien, "n", null, true );
			$this->uitable->addModal ( "nrm_pasien", "hidden", "", $this->nrm_pasien, "n", null, true );
			$this->uitable->addModal ( "noreg_pasien", "hidden", "", $this->noreg_pasien, "n", null, true );
		} else {
			$this->uitable->addModal ( "nama_pasien", "chooser-" . $this->action . "-mr_pasien", "Pasien", $this->nama_pasien, "n", null, true );
			$this->uitable->addModal ( "nrm_pasien", "text", "NRM", $this->nrm_pasien, "n", null, true );
			$this->uitable->addModal ( "noreg_pasien", "text", "No Reg", $this->noreg_pasien, "n", null, true );
		}
		$this->uitable->addModal ( "jk", "hidden", "", $this->jk );
		$this->uitable->addModal ( "kunjungan", "hidden", "", $this->kunjungan );
		$this->uitable->addModal ( "carabayar", "hidden", "", $this->carabayar );
		$this->uitable->addModal ( "urji", "hidden", "", $this->urji);
		$this->uitable->addModal ( "tanggal", "date", "Tanggal", date ( "Y-m-d" ) );
        loadClass ( "ServiceProviderList" );
        $service = new ServiceProviderList ( $this->db, "push_antrian" );
        $service->execute ();
        $ruangan = $service->getContent ();
		if ($this->polislug == "all")
			$this->uitable->addModal ( "ruangan", "select", "Ruangan", $ruangan );
        else {
        	$ruangan_option = new OptionBuilder();
        	foreach ($ruangan as $r) {
        		if ($r['value'] == $this->polislug)
        			$ruangan_option->add($r['name'], $r['value'], "1");
        		else
        			$ruangan_option->add($r['name'], $r['value']);
        	}
        	$this->uitable->addModal ( "ruangan", "select", "Ruangan", $ruangan_option->getContent(), "n", null, true );
        }
        $this->uitable->addModal ( "keluhan", "textarea", "Keluhan", "" );
        $this->uitable->addModal ( "anamnesa", "textarea", "Anamnesa", "" );
        $this->uitable->addModal("", "label", "&nbsp;", "&nbsp;");
		$this->uitable->addModal("", "label", "<strong>Riwayat Alergi</strong>", "");
		$makanan_option = new OptionBuilder();
		$makanan_option->add("", "00", "1");
		$makanan_option->add("Seafood", "01");
		$makanan_option->add("Gandum", "02");
		$makanan_option->add("Susu Sapi", "03");
		$makanan_option->add("Kacang-Kacangan", "04");
		$makanan_option->add("Makanan Lain", "05");
		$this->uitable->addModal ( "makanan", "select", "Makanan", $makanan_option->getContent() );
		$udara_option = new OptionBuilder();
		$udara_option->add("", "00", "1");
		$udara_option->add("Udara Panas", "01");
		$udara_option->add("Udara Dingin", "02");
		$udara_option->add("Udara Kotor", "03");
		$this->uitable->addModal ( "udara", "select", "Udara", $udara_option->getContent() );
		$obat_obatan_option = new OptionBuilder();
		$obat_obatan_option->add("", "00", "1");
		$obat_obatan_option->add("Antibiotik", "01");
		$obat_obatan_option->add("Antiinflamasi", "02");
		$obat_obatan_option->add("Non Steroid", "03");
		$obat_obatan_option->add("Aspirin", "04");
		$obat_obatan_option->add("Kortikosteroid", "05");
		$obat_obatan_option->add("Insulin", "06");
		$obat_obatan_option->add("Obat-Obat Lain", "07");
		$this->uitable->addModal ( "obat_obatan", "select", "Obat-Obatan", $obat_obatan_option->getContent() );
		$prognosa_option = new OptionBuilder();
		$prognosa_option->add("Sanam (Sembuh)", "01", "1");
		$prognosa_option->add("Bonam (Baik)", "02");
		$prognosa_option->add("Malam (Buruk/Jelek)", "03");
		$prognosa_option->add("Dubia Ad Sanam/Bolam (Tidak Tentu/Ragu-Ragu, Cenderung Baik)", "04");
		$prognosa_option->add("Dubia Ad Malam (Tidak tentu/Ragu-Ragu, Cenderung Buruk/Jelek", "05");
		$this->uitable->addModal ( "prognosa", "select", "Prognosa", $prognosa_option->getContent() );
		$terapi_obat_textarea = new TextArea($this->action . "_terapi_obat", $this->action . "_terapi_obat", "");
		$terapi_obat_button = new Button("", "", "Refresh Terapi Obat");
		$terapi_obat_button->setIcon("fa fa-refresh");
        $terapi_obat_button->setIsButton(Button::$ICONIC);
        $terapi_obat_button->setAction("terapi_obat.view()");
        $terapi_obat_button->addClass("btn btn-inverse");
        $terapi_obat_input_group = new InputGroup("");
        $terapi_obat_input_group->addComponent($terapi_obat_textarea);
        $terapi_obat_input_group->addComponent($terapi_obat_button);
		$this->uitable->addModal ( "gb_terapi_obat", "html", "Terapi Obat", $terapi_obat_input_group->getHtml() );
		$this->uitable->addModal ( "terapi_non_obat", "textarea", "Terapi Non-Obat", "" );
		$this->uitable->addModal ( "bmhp", "textarea", "BMHP", "" );
		if ($this->is_jkn_member == 1 && $this->is_bridging_with_pcare == 1)
			$this->uitable->addModal ( "kode_icd", "chooser-" . $this->action . "-mr_icd-Diagnosa", "Diagnosa", "", "n", null, false );	
		else
			$this->uitable->addModal ( "kode_icd", "chooser-" . $this->action . "-mr_icd-Diagnosa", "Diagnosa", "", "n", null, true );
		$this->uitable->addModal ( "nama_icd", "text", "&nbsp;", "", "y", null, true );
		$this->uitable->addModal ( "sebab_sakit", "hidden", "", "", "y", null, true );
		$non_spesialis_option = new OptionBuilder();
		$non_spesialis_option->add("Non-Spesialis", "1", "1");
		$non_spesialis_option->add("Spesialis", "0");
		$this->uitable->addModal ( "non_spesialis", "select", "Non-Spesialis ?", $non_spesialis_option->getContent(), "n", null, true );
		if ($this->is_jkn_member == 1 && $this->is_bridging_with_pcare == 1)
			$this->uitable->addModal ( "kode_icd_sekunder", "chooser-" . $this->action . "-mr_icd_sekunder-Diagnosa Sekunder", "Diagnosa Sekunder", "", "y", null, false );
		else
			$this->uitable->addModal ( "kode_icd_sekunder", "chooser-" . $this->action . "-mr_icd_sekunder-Diagnosa Sekunder", "Diagnosa Sekunder", "", "y", null, true );
		$this->uitable->addModal ( "nama_icd_sekunder", "text", "&nbsp;", "", "y", null, true );
		$this->uitable->addModal ( "sebab_sakit_sekunder", "hidden", "", "", "y", null, true );
		$kasus_option = new OptionBuilder();
		$kasus_option->add("Baru", "Baru");
		$kasus_option->add("Lama", "Lama", "1");
		$this->uitable->addModal ( "kasus", "select", "Kasus", $kasus_option->getContent() );
		if ($this->is_jkn_member == 0 || $this->is_bridging_with_pcare == 0) {
			$this->uitable->addModal ( "kode_kesadaran", "hidden", "", "", "y" );
			$this->uitable->addModal ( "kesadaran", "text", "Kesadaran", "", "n" );
		} else {
			require_once("medical_record/class/pcare/PCareKesadaran.php");
			$pcare            = new PCareKesadaran();
            $pcare->setPCareAuthorization();
            $data_response    = $pcare->getListData();
            $data             = $data_response['response']['list'];
            $kesadaran_option = new OptionBuilder();
            $default_sadar = "";
            if (count($data) > 0) {
            	foreach ($data as $d) {
            		if ($default_sadar == "") {
            			$kesadaran_option->add($d['nmSadar'], $d['kdSadar'], "1");
            			$default_sadar = $d['nmSadar'];
            		} else
            			$kesadaran_option->add($d['nmSadar'], $d['kdSadar']);
            	}
            }
            $this->uitable->addModal ( "kesadaran", "hidden", "", $default_sadar, "y" );
            $this->uitable->addModal ( "kode_kesadaran", "select", "Kesadaran", $kesadaran_option->getContent(), "n" );
		}
		$this->uitable->addModal ( "suhu", "text", "Suhu (<sup>o</sup>C)", "", "n", "numeric" );
		$this->uitable->addModal("", "label", "&nbsp;", "&nbsp;");
		$this->uitable->addModal("", "label", "<strong>Pemeriksaan Fisik</strong>", "");
		$this->uitable->addModal ( "tinggi_badan", "text", "Tinggi Badan (cm)", "", "n", "numeric" );
		$this->uitable->addModal ( "berat_badan", "text", "Berat Badan (kg)", "", "n", "numeric" );
		$this->uitable->addModal ( "lingkar_perut", "text", "Lingkar Perut (cm)", "", "n", "numeric" );
		$this->uitable->addModal ( "imt", "text", "IMT (kg/m<sup>2</sup>)", "", "n", null, true );
		$this->uitable->addModal("", "label", "&nbsp;", "&nbsp;");
		$this->uitable->addModal("", "label", "<strong>Tekanan Darah</strong>", "" );
		$this->uitable->addModal ( "sistole", "text", "Sistole (mmHg)", "", "n", "numeric" );
		$this->uitable->addModal ( "diastole", "text", "Diastole (mmHg)", "", "n", "numeric" );
		$this->uitable->addModal ( "rr", "text", "Respiratory Rate (x/menit)", "", "n", "numeric" );
		$this->uitable->addModal ( "nadi", "text", "Heart Rate (bpm)", "", "n", "numeric" );
		$this->uitable->addModal("", "label", "&nbsp;", "&nbsp;");
		$this->uitable->addModal ( "id_dokter", "hidden", "", "" );
		$this->uitable->addModal ( "nama_dokter", "chooser-" . $this->action . "-mr_dokter-Tenaga Medis", "Tenaga Medis", "", "n", null, true );
		$pelayanan_non_kapitasi_option = new OptionBuilder();
		$pelayanan_non_kapitasi_option->add("", "", "1");
		$pelayanan_non_kapitasi_option->add("Pelayanan KB", "Pelayanan KB");
		$pelayanan_non_kapitasi_option->add("Pelayanan PNC", "Pelayanan PNC");
		$pelayanan_non_kapitasi_option->add("Pelayanan Ambulance", "Pelayanan Ambulance");
		$this->uitable->addModal ( "pelayanan_non_kapitasi", "select", "Pelayanan Non-Kapitasi", $pelayanan_non_kapitasi_option->getContent() );
		$this->uitable->addModal ( "tanggal_pulang", "date", "Tanggal Pulang", date("Y-m-d") );
		if ($this->is_jkn_member == 1 && $this->is_bridging_with_pcare == 1) {
			$this->uitable->addModal ( "status_pulang", "hidden", "", "", "n" );
			$status_pulang_option = new OptionBuilder();
			require_once("medical_record/class/pcare/PCareStatusPulang.php");
			$pcare            = new PCareStatusPulang();
            $pcare->setPCareAuthorization();
            if ($this->urji == 0) {
	            $data_response    = $pcare->getListDataRJTP();
	            $data             = $data_response['response']['list'];
				$status_pulang_option = new OptionBuilder();
				$status_pulang_option->add("", "", "1");
	            if (count($data) > 0) {
	            	foreach ($data as $d) {
	            		$status_pulang_option->add($d['nmStatusPulang'], $d['kdStatusPulang']);
	            	}
	            }
        	} else {
        		$data_response    = $pcare->getListDataRITP();
	            $data             = $data_response['response']['list'];
				$status_pulang_option = new OptionBuilder();
				$status_pulang_option->add("", "", "1");
	            if (count($data) > 0) {
	            	foreach ($data as $d) {
	            		$status_pulang_option->add($d['nmStatusPulang'], $d['kdStatusPulang']);
	            	}
	            }
        	}
        	$this->uitable->addModal ( "kode_status_pulang", "select", "Status Pulang", $status_pulang_option->getContent(), "n" );
		} else {
			$this->uitable->addModal ( "kode_status_pulang", "hidden", "", "", "y" );
			$status_pulang_option = new OptionBuilder();
			$status_pulang_option->add("", "", "1");
			$status_pulang_option->add("Berobat Jalan", "Berobat Jalan");
			$status_pulang_option->add("Rujuk", "Rujuk");
			$status_pulang_option->add("Meninggal", "Meninggal");
			$this->uitable->addModal ( "status_pulang", "select", "Status Pulang", $status_pulang_option->getContent(), "n" );
		}
		$this->uitable->addModal ( "status_horizontal", "html", "&nbsp;", "<small><sup>*</sup> Harap tetap mengentri juga pada <strong>PCare</strong></small>" );
		if ($this->is_jkn_member == 1 && $this->is_bridging_with_pcare == 1) {
			$search_button = new Button("", "", "Cari Rujukan");
			$search_button->setClass("btn-info");
			$search_button->setIsButton(Button::$ICONIC_TEXT);
			$search_button->setIcon("icon-white icon-search");
			$search_button->setAction("$('#rujukan_add_form').smodal('show')");
			$this->uitable->addModal ( "search_button", "html", "&nbsp;", $search_button->getHtml() );
		}
		$this->uitable->addModal ( "kode_ppk_rujukan", "hidden", "", "" );
		
		if ($this->is_jkn_member == 1 && $this->is_bridging_with_pcare == 1) {
			$this->uitable->addModal ( "ppk_rujukan", "text", "PPK Rujukan", "", "y", null, true );
			$this->uitable->addModal ( "spesialis_subspesialis", "text", "Spesialis/Subspesialis", "", "y", null, true );
		} else {
			$ppk_rujukan_option = new OptionBuilder();
			$ppk_rujukan_option->add("", "", "1");
			$ppk_rujukan_rows = $this->db->get_result("
				SELECT
					id, nama
				FROM
					smis_rg_ppk_rujukan
				WHERE
					prop = ''
				ORDER BY
					nama ASC
			");
			if ($ppk_rujukan_rows != null) {
				foreach ($ppk_rujukan_rows as $ppk_rujukan)
					$ppk_rujukan_option->add($ppk_rujukan->nama, $ppk_rujukan->nama);
			}
			$this->uitable->addModal ( "ppk_rujukan", "select", "PPK Rujukan", $ppk_rujukan_option->getContent() );
			$spesialis_option = new OptionBuilder();
			$spesialis_option->add("", "", "1");
			$this->uitable->addModal ( "spesialis_subspesialis", "select", "Spesialis/Subspesialis", $spesialis_option->getContent() );
		}
		$this->uitable->addModal ( "catatan", "textarea", "Catatan", "" );
		$this->uitable->addModal ( "tanggal_rencana_berkunjung", "idate", "Tgl. Rencana Berkunjung", "" );
		$this->uitable->addModal ( "no_surat_kematian", "text", "No. Surat Kematian", "" );

		if ($this->is_jkn_member == 1 && $this->is_bridging_with_pcare == 1) {
			$this->uitable->addModal ( "kode_tacc", "text", "Kode TACC", "", "y", null, true );
			$this->uitable->addModal ( "nama_tacc", "chooser-" . $this->action . "-pcare_tacc-TACC", "TACC", "", "y", null, true );
			$this->uitable->addModal ( "alasan_tacc", "text", "Alasan TACC", "", "y", null, true );
		} else {
			$this->uitable->addModal ( "kode_tacc", "hidden", "", "" );
			$this->uitable->addModal ( "nama_tacc", "hidden", "", "" );
			$this->uitable->addModal ( "alasan_tacc", "hidden", "", "" );
		}

		$this->uitable->addModal ( "jenis_rujuk_vertikal", "hidden", "", "" );
		$this->uitable->addModal ( "kode_kondisi_khusus_kategori", "hidden", "", "" );
		$this->uitable->addModal ( "nama_kondisi_khusus_kategori", "hidden", "", "" );
		$this->uitable->addModal ( "kode_kondisi_khusus_spesialis", "hidden", "", "" );
		$this->uitable->addModal ( "nama_kondisi_khusus_spesialis", "hidden", "", "" );
		$this->uitable->addModal ( "kondisi_khusus_alasan", "hidden", "", "" );
		$this->uitable->addModal ( "kode_spesialis_spesialis", "hidden", "", "" );
		$this->uitable->addModal ( "nama_spesialis_spesialis", "hidden", "", "" );
		$this->uitable->addModal ( "kode_spesialis_subspesialis", "hidden", "", "" );
		$this->uitable->addModal ( "nama_spesialis_subspesialis", "hidden", "", "" );
		$this->uitable->addModal ( "kode_spesialis_sarana", "hidden", "", "" );
		$this->uitable->addModal ( "nama_spesialis_sarana", "hidden", "", "" );
		$this->uitable->addModal ( "no_kunjungan_pcare", "hidden", "", "" );
		$this->uitable->addModal ( "jadwal", "hidden", "", "" );

		$modal = $this->uitable->getModal ();
		$modal->setComponentSize(Modal::$MEDIUM);
		$modal->setTitle ( "Diagnosa" );


		if ($this->is_jkn_member == 1 && $this->is_bridging_with_pcare == 1) {
			$rujukan_modal = new Modal("rujukan_add_form", "smis_form_container", "rujukan");
			$rujukan_modal->setTitle("PCare - Pencarian Rujukan");
			$rujukan_modal->setClass(Modal::$FULL_MODEL);
			/// Rujukan Vertical PCare :
			$rujuk_vertikal_option = new OptionBuilder();
			$rujuk_vertikal_option->add("Kondisi Khusus", "Kondisi Khusus", "1");
			$rujuk_vertikal_option->add("Spesialis", "Spesialis");
			$rujuk_vertikal_select = new Select("jenis_rujuk_vertikal", "jenis_rujuk_vertikal", $rujuk_vertikal_option->getContent());
			$rujukan_modal->addElement("Jenis", $rujuk_vertikal_select);

			//// A. Kondisi Khusus :
			require_once("medical_record/class/pcare/PCareSpesialisKhusus.php");
			$pcare            = new PCareSpesialisKhusus();
            $pcare->setPCareAuthorization();
            $data_response    = $pcare->getListData();
            $data             = $data_response['response']['list'];
            $kondisi_khusus_kategori_option = new OptionBuilder();
            if (count($data) > 0) {
            	$default = false;
            	foreach ($data as $d) {
            		if (!$default) {
            			$kondisi_khusus_kategori_option->add($d['nmKhusus'], $d['kdKhusus'], "1");
            			$default = true;
            		} else
            			$kondisi_khusus_kategori_option->add($d['nmKhusus'], $d['kdKhusus']);
            	}
            }
            $kondisi_khusus_kategori_select = new Select("kondisi_khusus_kategori", "kondisi_khusus_kategori", $kondisi_khusus_kategori_option->getContent());
            $rujukan_modal->addElement("Kategori", $kondisi_khusus_kategori_select);
            $kondisi_khusus_spesialis_select = new Select("kondisi_khusus_spesialis", "kondisi_khusus_spesialis", "");
            $rujukan_modal->addElement("Spesialis", $kondisi_khusus_spesialis_select);
            $kondisi_khusus_alasan_text = new Text("kondisi_khusus_alasan", "kondisi_khusus_alasan", "");
            $rujukan_modal->addElement("Alasan", $kondisi_khusus_alasan_text);

            //// B. Spesialis :
            require_once("medical_record/class/pcare/PCareSpesialisSpesialis.php");
			$pcare            = new PCareSpesialisSpesialis();
            $pcare->setPCareAuthorization();
            $data_response    = $pcare->getListData();
            $data             = $data_response['response']['list'];
            $spesialis_option = new OptionBuilder();
            if (count($data) > 0) {
            	$default = false;
            	foreach ($data as $d) {
            		if (!$default) {
            			$spesialis_option->add($d['nmSpesialis'], $d['kdSpesialis'], "1");
            			$default = true;
            		} else
            			$spesialis_option->add($d['nmSpesialis'], $d['kdSpesialis']);
            	}
            }
            $spesialis_select = new Select("spesialis_spesialis", "spesialis_spesialis", $spesialis_option->getContent());
            $rujukan_modal->addElement("Spesialis", $spesialis_select);
            $subspesialis_select = new Select("spesialis_subspesialis", "spesialis_subspesialis", "");
            $rujukan_modal->addElement("Sub-Spesialis", $subspesialis_select);
            require_once("medical_record/class/pcare/PCareSpesialisSarana.php");
			$pcare            = new PCareSpesialisSarana();
            $pcare->setPCareAuthorization();
            $data_response    = $pcare->getListData();
            $data             = $data_response['response']['list'];
            $sarana_option = new OptionBuilder();
            $sarana_option->add("", "0", "1");
            if (count($data) > 0) {
            	foreach ($data as $d) {
            		$sarana_option->add($d['nmSarana'], $d['kdSarana']);
            	}
            }
            $sarana_select = new Select("spesialis_sarana", "spesialis_sarana", $sarana_option->getContent());
            $rujukan_modal->addElement("Sarana", $sarana_select);
            $tanggal_rencana_berkunjung_text = new Text("tanggal_rencana_berkunjung", "tanggal_rencana_berkunjung", date('d-m-Y', strtotime(' +1 day')));
            $tanggal_rencana_berkunjung_text->setClass("mydate");
            $tanggal_rencana_berkunjung_text->setAtribute("data-date-format='dd-mm-yyyy'");
            $rujukan_modal->addElement("Tgl. R. Berkunjung", $tanggal_rencana_berkunjung_text);
            $search_button = new Button("", "", "Cari Faskes Rujukan");
			$search_button->setClass("btn-info");
			$search_button->setIsButton(Button::$ICONIC_TEXT);
			$search_button->setIcon("icon-white icon-search");
			$search_button->setAction("faskes.search()");
			$rujukan_modal->addElement("", $search_button);
            $faskes_table = new Table(
            	array("No.", "Faskes", "Kelas", "Kantor Cabang", "Alamat", "Telp.", "Jarak", "Total Rujukan", "Kapasitas", "(%)", "Jadwal", "Pilih"),
            	""
            );
            $faskes_table->setName("faskes");
            $faskes_table->setAction(false);
            $faskes_table->setFooterVisible(false);
            $rujukan_modal->addBody("faskes_table", $faskes_table);
			echo $rujukan_modal->getHtml();
		}

		$is_bridging_with_pcare_hidden = new Hidden("is_bridging_with_pcare", "is_bridging_with_pcare", $this->is_bridging_with_pcare);
		echo $is_bridging_with_pcare_hidden->getHtml();
		echo $this->uitable->getHtml ();
		echo $modal->getHtml ();
	}
	public function jsLoader() {
		echo addJS ( "framework/bootstrap/js/bootstrap-datepicker.js" );
		echo addJS ( "framework/smis/js/table_action.js" );
		loadLibrary ( "smis-libs-function-javascript" );
	}
	public function cssLoader() {
		echo addCSS ( "framework/bootstrap/css/datepicker.css" );
	}
	
	public function cssPreLoad() {
		?>
		<style type="text/css">
			#diagnosa_kode_icd {
				background-color: #7FCDCD !important;
			}
			#diagnosa_kesadaran {
				background-color: #7FCDCD !important;
			}
			#diagnosa_suhu {
				background-color: #7FCDCD !important;
			}
			#diagnosa_kode_icd {
				background-color: #7FCDCD !important;
			}
			#diagnosa_tinggi_badan {
				background-color: #7FCDCD !important;
			}
			#diagnosa_berat_badan {
				background-color: #7FCDCD !important;
			}
			#diagnosa_lingkar_perut {
				background-color: #7FCDCD !important;
			}
			#diagnosa_imt {
				background-color: #7FCDCD !important;
			}
			#diagnosa_sistole {
				background-color: #7FCDCD !important;
			}
			#diagnosa_diastole {
				background-color: #7FCDCD !important;
			}
			#diagnosa_rr {
				background-color: #7FCDCD !important;
			}
			#diagnosa_nadi {
				background-color: #7FCDCD !important;
			}
			#diagnosa_nama_dokter {
				background-color: #7FCDCD !important;
			}
			#diagnosa_status_pulang {
				background-color: #7FCDCD !important;
			}
			#diagnosa_kode_status_pulang {
				background-color: #7FCDCD !important;
			}
		</style>
		<?php
	}
	
	/* when it's star build */
	public function jsPreLoad() {
		?>
		<script type="text/javascript">
			var <?php echo $this->action; ?>;
			var mr_dokter;
			var mr_icd;
			var mr_icd_sekunder;
			var mr_pasien;
			var mr_diagnosa_icd;
			var mr_noreg="<?php echo $this->noreg_pasien; ?>";
			var mr_nama_pasien="<?php echo $this->nama_pasien; ?>";
			var mr_nrm_pasien="<?php echo $this->nrm_pasien; ?>";
			var mr_polislug="<?php echo $this->polislug; ?>";
			var mr_the_page="<?php echo $this->page; ?>";
			var mr_the_protoslug="<?php echo $this->protoslug; ?>";
			var mr_the_protoname="<?php echo $this->protoname; ?>";
			var mr_the_protoimplement="<?php echo $this->protoimplement; ?>";
			var faskes;
			var pcare_tacc;
			var pcare_alasan_tacc;
			var selected_spesialis_subspesialis;
			var terapi_obat;
			$(document).ready(function() {
				$('[data-toggle="popover"]').popover({
					trigger: 'hover',
					'placement': 'top'
				});
				$(".mydate").datepicker();

				terapi_obat = new TableAction(
					"terapi_obat",
					mr_the_page,
					"<?php echo $this->action; ?>",
					new Array()
				);
				terapi_obat.setSuperCommand("terapi_obat");
				terapi_obat.setPrototipe(
					mr_the_protoname,
					mr_the_protoslug,
					mr_the_protoimplement
				);
				terapi_obat.addRegulerData = function(data) {
					data['noreg_pasien'] = $("#<?php echo $this->action; ?>_noreg_pasien").val();
					return data;
				};
				terapi_obat.view = function() {
					var data = this.getRegulerData();
					data['super_command'] = "terapi_obat";
					data['command'] = "edit";
					showLoading();
					$.post(
						"",
						data,
						function(response) {
							var json = getContent(response);
							if (json == null) {
								dismissLoading();
								return;
							}
							$("#<?php echo $this->action; ?>_terapi_obat").val(json.terapi_obat);
							dismissLoading();
						}
					);
				};
				
				pcare_tacc=new TableAction("pcare_tacc",mr_the_page,"<?php echo $this->action; ?>",new Array());
				pcare_tacc.setSuperCommand("pcare_tacc");
				pcare_tacc.setPrototipe(mr_the_protoname,mr_the_protoslug,mr_the_protoimplement);
				pcare_tacc.select=function(row_index){
					var kode_tacc = $("tbody#pcare_tacc_list tr:eq(" + row_index + ") td:eq(1)").text();
					var nama_tacc = $("tbody#pcare_tacc_list tr:eq(" + row_index + ") td:eq(2)").text();
					var alasan_tacc_option = $("tbody#pcare_tacc_list tr:eq(" + row_index + ") td:eq(3)").html();
					var tipe_field_alasan_tacc = $("tbody#pcare_tacc_list tr:eq(" + row_index + ") td:eq(4)").text();
					var disable_alasan_tacc = $("tbody#pcare_tacc_list tr:eq(" + row_index + ") td:eq(5)").text();
					var disabled_prop = "";
					if (disable_alasan_tacc == 1)
						disabled_prop = "disabled='disabled'";
					var label = "<label>Alasan TACC</label>";
					$("#<?php echo $this->action; ?>_nama_tacc").val(nama_tacc);
					$("#<?php echo $this->action; ?>_kode_tacc").val(kode_tacc);
					if (tipe_field_alasan_tacc == "text") {
						if (nama_tacc == "Complication") {
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_alasan_tacc").html(
								label + 
								"<div class='input-append'>" + 
									"<input dv='' disabled='disabled' empty='y' typical='free' type='text' onkeyup='' class='smis-one-option-input' id='<?php echo $this->action; ?>_alasan_tacc' name='Alasan TACC' value=''>" +
									"<a href='#' id='<?php echo $this->action; ?>_chooser_alasan_tacc' class='input btn btn-primary '>" +
										"<i class='icon-list-alt icon-white'></i>" +
									"</a>" +
								"</div>"
							);
							$("#<?php echo $this->action; ?>_chooser_alasan_tacc").on("click", function() {
								<?php echo $this->action; ?>.chooser("<?php echo $this->action; ?>", "<?php echo $this->action; ?>_alasan_tacc","pcare_alasan_tacc",pcare_alasan_tacc,"Alasan TACC");
							});
							$("#<?php echo $this->action; ?>_alasan_tacc").val($("#<?php echo $this->action; ?>_kode_icd").val() + " - " + $("#<?php echo $this->action; ?>_nama_icd").val());
						} else {
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_alasan_tacc").html(
								label + 
								"<input dv='' " + disabled_prop + " empty='y' typical='free' type='text' onkeyup='' class='' id='diagnosa_alasan_tacc' name='Alasan TACC' value=''>"
							);
						}
					} else if (tipe_field_alasan_tacc == "select") {
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_alasan_tacc").html(
							label + 
							"<select empty='y' type='select' dv='' onchange='' class='' id='<?php echo $this->action; ?>_alasan_tacc' name='Alasan TACC'>" +
								alasan_tacc_option +
							"</select>"
						);
					}
					$($(this).data('target')).smodal('hide');
				};

				pcare_alasan_tacc=new TableAction("pcare_alasan_tacc",mr_the_page,"<?php echo $this->action; ?>",new Array());
				pcare_alasan_tacc.setSuperCommand("pcare_alasan_tacc");
				pcare_alasan_tacc.setPrototipe(mr_the_protoname,mr_the_protoslug,mr_the_protoimplement);
				pcare_alasan_tacc.addViewData = function(data) {
					data['is_bridging_with_pcare'] = $("#is_bridging_with_pcare").val();
					return data;
				};
				pcare_alasan_tacc.select=function(row_index){
					var kode_icd = $("tbody#pcare_alasan_tacc_list tr:eq(" + row_index + ") td:eq(1)").text();
					var nama_icd = $("tbody#pcare_alasan_tacc_list tr:eq(" + row_index + ") td:eq(2)").text();
					$("#<?php echo $this->action; ?>_alasan_tacc").val(kode_icd + " - " + nama_icd);
					$($(this).data('target')).smodal('hide');
				};

				mr_pasien=new TableAction("mr_pasien",mr_the_page,"<?php echo $this->action; ?>",new Array());
				mr_pasien.setSuperCommand("mr_pasien");
				mr_pasien.setPrototipe(mr_the_protoname,mr_the_protoslug,mr_the_protoimplement);
				mr_pasien.selected=function(json){
					var nama=json.nama_pasien;
					var nrm=json.nrm;
					var noreg=json.id;		
					$("#<?php echo $this->action; ?>_nama_pasien").val(nama);
					$("#<?php echo $this->action; ?>_nrm_pasien").val(nrm);
					$("#<?php echo $this->action; ?>_noreg_pasien").val(noreg);
				};
				
				mr_dokter=new TableAction("mr_dokter",mr_the_page,"<?php echo $this->action; ?>",new Array());
				mr_dokter.setSuperCommand("mr_dokter");
				mr_dokter.setPrototipe(mr_the_protoname,mr_the_protoslug,mr_the_protoimplement);
				<?php if ($this->is_jkn_member == 0 || $this->is_bridging_with_pcare == 0) { ?>
					mr_dokter.selected=function(json){
						var nama=json.nama;
						var nip=json.id;		
						$("#<?php echo $this->action; ?>_nama_dokter").val(nama);
						$("#<?php echo $this->action; ?>_id_dokter").val(nip);
					};
				<?php } else { ?>
					mr_dokter.addViewData = function(data) {
						data['is_bridging_with_pcare'] = $("#is_bridging_with_pcare").val();
						return data;
					};
					mr_dokter.select=function(row_index){
						var kode_dokter = $("tbody#mr_dokter_list tr:eq(" + row_index + ") td:eq(1)").text();
						var nama_dokter = $("tbody#mr_dokter_list tr:eq(" + row_index + ") td:eq(2)").text();
						$("#<?php echo $this->action; ?>_nama_dokter").val(nama_dokter);
						$("#<?php echo $this->action; ?>_id_dokter").val(kode_dokter);
						$($(this).data('target')).smodal('hide');
					};
				<?php } ?>

				mr_icd=new TableAction("mr_icd",mr_the_page,"<?php echo $this->action; ?>",new Array());
				mr_icd.setSuperCommand("mr_icd");
				mr_icd.setPrototipe(mr_the_protoname,mr_the_protoslug,mr_the_protoimplement);
				mr_icd.addViewData = function(data) {
					data['is_jkn_member'] = $("#<?php echo $this->action; ?>_is_jkn_member").val();
					return data;
				};
				<?php if ($this->is_jkn_member == 0 || $this->is_bridging_with_pcare == 0) { ?>
					mr_icd.selected=function(json){
						var nama=json.nama;
						var kode=json.icd;		
						var sebab=json.sebab;
						$("#<?php echo $this->action; ?>_nama_icd").val(nama);
						$("#<?php echo $this->action; ?>_kode_icd").val(kode);
						$("#<?php echo $this->action; ?>_sebab_sakit").val(sebab);
					};
				<?php } else { ?>
					mr_icd.addViewData = function(data) {
						data['is_bridging_with_pcare'] = $("#is_bridging_with_pcare").val();
						return data;
					};
					mr_icd.select=function(row_index){
						var kode_icd = $("tbody#mr_icd_list tr:eq(" + row_index + ") td:eq(1)").text();
						var nama_icd = $("tbody#mr_icd_list tr:eq(" + row_index + ") td:eq(2)").text();
						var non_spesialis = $("tbody#mr_icd_list tr:eq(" + row_index + ") td:eq(3)").text() == "Non-Spesialis" ? 1 : 0;
						$("#<?php echo $this->action; ?>_nama_icd").val(nama_icd);
						$("#<?php echo $this->action; ?>_kode_icd").val(kode_icd);
						$("#<?php echo $this->action; ?>_non_spesialis").val(non_spesialis);
						$($(this).data('target')).smodal('hide');
					};
				<?php } ?>

				mr_icd_sekunder=new TableAction("mr_icd_sekunder",mr_the_page,"<?php echo $this->action; ?>",new Array());
				mr_icd_sekunder.setSuperCommand("mr_icd_sekunder");
				mr_icd_sekunder.setPrototipe(mr_the_protoname,mr_the_protoslug,mr_the_protoimplement);
				<?php if ($this->is_jkn_member == 0 || $this->is_bridging_with_pcare == 0) { ?>
					mr_icd_sekunder.selected=function(json){
						var nama=json.nama;
						var kode=json.icd;		
						var sebab=json.sebab;
						$("#<?php echo $this->action; ?>_nama_icd_sekunder").val(nama);
						$("#<?php echo $this->action; ?>_kode_icd_sekunder").val(kode);
						$("#<?php echo $this->action; ?>_sebab_sakit_sekunder").val(sebab);
					};
				<?php } else { ?>
					mr_icd_sekunder.addViewData = function(data) {
						data['is_bridging_with_pcare'] = $("#is_bridging_with_pcare").val();
						return data;
					};
					mr_icd_sekunder.select=function(row_index){
						var kode_icd = $("tbody#mr_icd_sekunder_list tr:eq(" + row_index + ") td:eq(1)").text();
						var nama_icd = $("tbody#mr_icd_sekunder_list tr:eq(" + row_index + ") td:eq(2)").text();
						$("#<?php echo $this->action; ?>_nama_icd_sekunder").val(nama_icd);
						$("#<?php echo $this->action; ?>_kode_icd_sekunder").val(kode_icd);
						$($(this).data('target')).smodal('hide');
					};
				<?php } ?>
				
				mr_diagnosa_icd=new TableAction("mr_diagnosa_icd",mr_the_page,"<?php echo $this->action; ?>",new Array());
				mr_diagnosa_icd.setSuperCommand("mr_diagnosa_icd");
				mr_diagnosa_icd.setPrototipe(mr_the_protoname,mr_the_protoslug,mr_the_protoimplement);
				mr_diagnosa_icd.selected=function(json){
					var nama=json.nama;
					var kode=json.icd;		
					var sebab=json.sebab;
					$("#<?php echo $this->action; ?>_diagnosa").val(nama);
					$("#<?php echo $this->action; ?>_nama_icd").val(nama);
					$("#<?php echo $this->action; ?>_kode_icd").val(kode);
					$("#<?php echo $this->action; ?>_sebab_sakit").val(sebab);
				};
				
				stypeahead("#<?php echo $this->action; ?>_diagnosa",3,mr_diagnosa_icd,"nama",function(json){
					var nama=json.nama;
					var kode=json.icd;		
					var sebab=json.sebab;
					$("#<?php echo $this->action; ?>_diagnosa").val(nama);
					$("#<?php echo $this->action; ?>_nama_icd").val(nama);
					$("#<?php echo $this->action; ?>_kode_icd").val(kode);
					$("#<?php echo $this->action; ?>_sebab_sakit").val(sebab);
				});
						
				var column=new Array(
					"id", "no_bpjs", "is_jkn_member","tanggal","jk","kunjungan","carabayar","kasus","ruangan","nama_pasien","noreg_pasien","nrm_pasien","gol_umur","urji","diagnosa",'keterangan',"id_dokter","nama_dokter","kode_icd","nama_icd","sebab_sakit","tensi","nadi","suhu","rr","nyeri","keadaan_umum","keadaan_luka","gula_darah","berat_badan",
					"keluhan","anamnesa","makanan","udara","obat_obatan","prognosa","terapi_obat","terapi_non_obat","bmhp","kode_icd_sekunder","nama_icd_sekunder","sebab_sakit_sekunder","kode_kesadaran","kesadaran","tinggi_badan","lingkar_perut","imt","sistole","diastole","pelayanan_non_kapitasi","kode_status_pulang","status_pulang","kode_ppk_rujukan","ppk_rujukan","spesialis_subspesialis","catatan","tanggal_rencana_berkunjung","no_surat_kematian", 
					"jenis_rujuk_vertikal", "kode_kondisi_khusus_kategori", "nama_kondisi_khusus_kategori", "kode_kondisi_khusus_spesialis", "nama_kondisi_khusus_spesialis", "kondisi_khusus_alasan", "kode_spesialis_spesialis", "nama_spesialis_spesialis", "kode_spesialis_subspesialis", "nama_spesialis_subspesialis", "kode_spesialis_sarana", "nama_spesialis_sarana",
					"tanggal_pulang", "kode_tacc", "nama_tacc", "alasan_tacc", "no_kunjungan_pcare", "non_spesialis", "jadwal"

				);
				<?php echo $this->action; ?>=new TableAction("<?php echo $this->action; ?>",mr_the_page,"<?php echo $this->action; ?>",column);
				<?php echo $this->action; ?>.setPrototipe(mr_the_protoname,mr_the_protoslug,mr_the_protoimplement);
				<?php echo $this->action; ?>.setEnableAutofocus(true);
				<?php echo $this->action; ?>.setNextEnter();
				<?php echo $this->action; ?>.getRegulerData=function(){
					var reg_data={	
							page:this.page,
							action:this.action,
							super_command:this.super_command,
							prototype_name:this.prototype_name,
							prototype_slug:this.prototype_slug,
							prototype_implement:this.prototype_implement,
							polislug:mr_polislug,
							noreg_pasien:mr_noreg,
							nama_pasien:mr_nama_pasien,
							nrm_pasien:mr_nrm_pasien,
							jk:$("#<?php echo $this->action; ?>_jk").val()
							};
					return reg_data;
				};
				<?php echo $this->action; ?>.clear = function() {
					TableAction.prototype.clear.call(this);
					<?php if ($this->is_jkn_member == 1) { ?>
						$("#<?php echo $this->action; ?>_kode_status_pulang").trigger("change");
					<?php } else { ?>
						$("#<?php echo $this->action; ?>_status_pulang").trigger("change");
					<?php } ?>
					var label = "<label>Alasan TACC</label>";
					$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_alasan_tacc").html(
						label + 
						"<input dv='' disabled='disabled' empty='y' typical='free' type='text' onkeyup='' class='' id='diagnosa_alasan_tacc' name='Alasan TACC' value=''>"
					);
				};
				<?php echo $this->action; ?>.validateTACC = function() {
					var valid = true;
					var status_pulang = $("#<?php echo $this->action; ?>_kode_status_pulang").val();
					var diagnosa_non_spesialis = $("#<?php echo $this->action; ?>_non_spesialis").val();
					var nama_tacc = $("#<?php echo $this->action; ?>_nama_tacc").val();
					if (status_pulang == 4 && diagnosa_non_spesialis == 1 && nama_tacc == "") {
						valid = false;
						$("#<?php echo $this->action ?>_kode_tacc").addClass("error_field");
						$("#<?php echo $this->action ?>_nama_tacc").addClass("error_field");
						$("#modal_alert_<?php echo $this->action; ?>_add_form").html(
							"<div class='alert alert-block alert-danger'>" +
								"<h4>Peringatan</h4>" +
								"<strong>TACC</strong> masih kosong. Diagnosa pasien ini <strong>Non Spesialis</strong> dengan status pulang <strong>Rujuk Vertical</strong>." +
							"</div>"
						);
					} else {
						$("#<?php echo $this->action ?>_kode_tacc").removeClass("error_field");
						$("#<?php echo $this->action ?>_nama_tacc").removeClass("error_field");
						$("#modal_alert_<?php echo $this->action; ?>_add_form").html("");
					}
					return valid;
				};
				<?php echo $this->action; ?>.save = function() {
					var self = this;
					var kode_status_pulang = $("#<?php echo $this->action; ?>_kode_status_pulang").val();
	            	var is_jkn_member = <?php echo $this->is_jkn_member == null ? 0 : $this->is_jkn_member; ?>;
	            	var is_bridging_with_pcare = <?php echo $this->is_bridging_with_pcare == null ? 0 : $this->is_bridging_with_pcare; ?>;
	            	var id = $("#<?php echo $this->action; ?>_id").val();
	            	var no_kunjungan_pcare = $("#<?php echo $this->action; ?>_no_kunjungan_pcare").val();
	            	if (is_jkn_member == 1 && is_bridging_with_pcare == 1) {
	            		if (!this.validateTACC()) {
	            			return;
	            		}
	            		if (no_kunjungan_pcare == "") {
	            			var data = this.getSaveData();
	            			data['command'] = "add_kunjungan";
	            			data['super_command'] = "pcare_kunjungan";
	            			data['is_bridging_with_pcare'] = is_bridging_with_pcare;
	            			showLoading();
	            			$.post(
	            				"",
	            				data,
	            				function(response) {
	            					var json = JSON.parse(response);
	            					if (json != null && json.content.message == "FAILED") {
	            						$("#<?php echo $this->action; ?>_add_form").smodal('hide');
	            						var bb_message = json.alert.content != null ? json.alert.content : "Terjadi kesalahan pada server.";
		            					bootbox.dialog({
		            						closeButton : true,
									        title 		: json.alert.title,
									        message 	: bb_message
									    });
	            					}
	            					dismissLoading();
	            					var resp_no_kunjungan = json.content.no_kunjungan != null ? json.content.no_kunjungan : "";
	            					$("#<?php echo $this->action; ?>_no_kunjungan_pcare").val(resp_no_kunjungan);
	            					TableAction.prototype.save.call(self);
	            				}
	            			);
	            		} else if (no_kunjungan_pcare != "") {
	            			var data = this.getSaveData();
	            			data['command'] = "edit_kunjungan";
	            			data['super_command'] = "pcare_kunjungan";
	            			data['is_bridging_with_pcare'] = is_bridging_with_pcare;
	            			showLoading();
	            			$.post(
	            				"",
	            				data,
	            				function(response) {
	            					var json = JSON.parse(response);
	            					if (json != null && json.content.message == "FAILED") {
	            						$("#<?php echo $this->action; ?>_add_form").smodal('hide');
	            						var bb_message = json.alert.content != null ? json.alert.content : "Terjadi kesalahan pada server.";
		            					bootbox.dialog({
		            						closeButton : true,
									        title 		: json.alert.title,
									        message 	: bb_message
									    });
	            					}
	            					dismissLoading();
	            					TableAction.prototype.save.call(self);
	            				}
	            			);
	            		}
	            	} else
	            		TableAction.prototype.save.call(this);
				};
				<?php echo $this->action; ?>.edit = function(id) {
					var self		= this;
				    var json_obj	= new Array();
					showLoading();	
					var edit_data	= this.getEditData(id);
					$.post(
						'',
						edit_data,
						function(res) {		
							var json = getContent(res);
							if (json == null) return;
							for (var i = 0; i < self.column.length; i++) {
								if ($.inArray(self.column[i],self.noclear) != -1 && !self.edit_clear_for_no_clear)
									continue;
					            var name	= self.column[i];
								var the_id	= "#"+self.prefix+"_"+name;
					            if( name in self.json_column && self.json_column.length > 0) {
					                var json_grup_name=self.json_column[name];
					                if (json[json_grup_name] == "")
					                    continue;
					                if (!(json_grup_name in json_obj))
									    json_obj[json_grup_name] = $.parseJSON(json[json_grup_name]);
					                smis_edit(the_id,json_obj[json_grup_name][""+name]);    
					            } else
					                smis_edit(the_id,json[""+name]);
							}
							<?php if ($this->is_jkn_member == 1 && $this->is_bridging_with_pcare == 1) { ?>
								$("#<?php echo $this->action; ?>_kode_status_pulang").trigger("change");
							<?php } else { ?>
								$("#<?php echo $this->action; ?>_status_pulang").trigger("change");
							<?php } ?>
							$("#<?php echo $this->action; ?>_no_surat_kematian").val(json.no_surat_kematian);
							$("#<?php echo $this->action; ?>_ppk_rujukan").val(json.ppk_rujukan);
							selected_spesialis_subspesialis = json.spesialis_subspesialis;
							$("#<?php echo $this->action; ?>_ppk_rujukan").trigger("change");
							$("#<?php echo $this->action; ?>_catatan").val(json.catatan);
							if (json.tanggal_rencana_berkunjung.length > 0 && json.tanggal_rencana_berkunjung != null) {
								var date_part = json.tanggal_rencana_berkunjung.split("-");
								$("#<?php echo $this->action; ?>_tanggal_rencana_berkunjung").val(date_part[2] + "-" + date_part[1] + "-" + date_part[0]);
							} else {
								$("#<?php echo $this->action; ?>_tanggal_rencana_berkunjung").val("");
							}
							$("#<?php echo $this->action; ?>_kode_tacc").val(json.kode_tacc);
							$("#<?php echo $this->action; ?>_nama_tacc").val(json.nama_tacc);
							$("#<?php echo $this->action; ?>_kode_kondisi_khusus_kategori").val(json.kode_kondisi_khusus_kategori);
							$("#<?php echo $this->action; ?>_nama_kondisi_khusus_kategori").val(json.nama_kondisi_khusus_kategori);
							$("#<?php echo $this->action; ?>_kode_kondisi_khusus_spesialis").val(json.kode_kondisi_khusus_spesialis);
							$("#<?php echo $this->action; ?>_nama_kondisi_khusus_spesialis").val(json.nama_kondisi_khusus_spesialis);
							$("#<?php echo $this->action; ?>_kondisi_khusus_alasan").val(json.kondisi_khusus_alasan);
							$("#<?php echo $this->action; ?>_kode_spesialis_spesialis").val(json.kode_spesialis_spesialis);
							$("#<?php echo $this->action; ?>_nama_spesialis_spesialis").val(json.nama_spesialis_spesialis);
							$("#<?php echo $this->action; ?>_kode_spesialis_subspesialis").val(json.kode_spesialis_subspesialis);
							$("#<?php echo $this->action; ?>_nama_spesialis_subspesialis").val(json.nama_spesialis_subspesialis);
							$("#<?php echo $this->action; ?>_kode_spesialis_sarana").val(json.kode_spesialis_sarana);
							$("#<?php echo $this->action; ?>_nama_spesialis_sarana").val(json.nama_spesialis_sarana);
							var nama_tacc = json['nama_tacc'];
							var alasan_tacc = json['alasan_tacc'];
							var label = "<label>Alasan TACC</label>";
							if (nama_tacc == "Time" || nama_tacc == "Age" || nama_tacc == "Comorbidity") {
								var tacc_data = self.getRegulerData();
								tacc_data['super_command'] = "pcare_tacc";
								tacc_data['command'] = "get_option_alasan_tacc";
								tacc_data['nama_tacc'] = nama_tacc;
								$.post(
									"",
									tacc_data,
									function(response_tacc) {
										var json_tacc = JSON.parse(response_tacc);
										if (json_tacc == null) {
											dismissLoading();
											self.disabledOnEdit(self.column_disabled_on_edit);
											self.show_form();
										}
										$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_alasan_tacc").html(
											label + 
											"<select empty='y' type='select' dv='' onchange='' class='' id='<?php echo $this->action; ?>_alasan_tacc' name='Alasan TACC'>" +
												json_tacc.html +
											"</select>"
										);
										$("#<?php echo $this->action; ?>_alasan_tacc").val(alasan_tacc);
										dismissLoading();
										self.disabledOnEdit(self.column_disabled_on_edit);
										self.show_form();
									}
								);
							} else {
								if (nama_tacc == "Complication") {
									$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_alasan_tacc").html(
										label + 
										"<div class='input-append'>" + 
											"<input dv='' disabled='disabled' empty='y' typical='free' type='text' onkeyup='' class='smis-one-option-input' id='<?php echo $this->action; ?>_alasan_tacc' name='Alasan TACC' value=''>" +
											"<a href='#' id='<?php echo $this->action; ?>_chooser_alasan_tacc' class='input btn btn-primary '>" +
												"<i class='icon-list-alt icon-white'></i>" +
											"</a>" +
										"</div>"
									);
									$("#<?php echo $this->action; ?>_chooser_alasan_tacc").on("click", function() {
										<?php echo $this->action; ?>.chooser("<?php echo $this->action; ?>", "<?php echo $this->action; ?>_alasan_tacc","pcare_alasan_tacc",pcare_alasan_tacc,"Alasan TACC");
									});
									$("#<?php echo $this->action; ?>_alasan_tacc").val($("#<?php echo $this->action; ?>_kode_icd").val() + " - " + $("#<?php echo $this->action; ?>_nama_icd").val());
								} else {
									$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_alasan_tacc").html(
										label + 
										"<input dv='' disabled='disabled' empty='y' typical='free' type='text' onkeyup='' class='' id='diagnosa_alasan_tacc' name='Alasan TACC' value=''>"
									);
								}
								$("#<?php echo $this->action; ?>_alasan_tacc").val(alasan_tacc);
								dismissLoading();
								self.disabledOnEdit(self.column_disabled_on_edit);
								self.show_form();
							}
						}
					);
					return this;
				};
				<?php echo $this->action; ?>.del = function(id) {
					var self = this;
					var edit_data = this.getRegulerData();
					edit_data['command'] = "edit";
					edit_data['id'] = id;
					showLoading();
					$.post(
						"",
						edit_data,
						function(response_edit) {
							var json_edit = getContent(response_edit);
							if (json_edit == null) {
								dismissLoading();
								return;
							}
							var validasi_resep_data = self.getRegulerData();
							validasi_resep_data['command'] = "validasi_resep";
							validasi_resep_data['noreg_pasien'] = json_edit.noreg_pasien;
							$.post(
								"",
								validasi_resep_data,
								function(response_validasi_resep) {
									var json_validasi_resep = JSON.parse(response_validasi_resep);
									if (json_validasi_resep == null) {
										dismissLoading();
										return;
									}
									dismissLoading();
									if (json_validasi_resep.resep_aktif == 0) {
										bootbox.confirm("Yakin menghapus data ini?", function(result) {
										   	if (result) {
										   		var del_data = self.getDelData(id);
										   		showLoading();
												$.post(
											    	'',
											    	del_data,
											    	function(res) {
											    		var edit_data = self.getEditData(id);
												   		$.post(
												   			'',
												   			edit_data,
												   			function(edit_res) {
												   				var edit_json = getContent(edit_res);
																if (edit_json == null) {
																	var json=getContent(res);
																	if (json == null) {
																		dismissLoading();
																		return;
																	}
																	self.view();
																	dismissLoading();
													                self.is_post_action_del=true;
																	self.postAction(id);
																	return;
																}
																var is_jkn_member = edit_json.is_jkn_member;
																var no_kunjungan_pcare = edit_json.no_kunjungan_pcare;
																var is_bridging_with_pcare = <?php echo $this->is_bridging_with_pcare; ?>;
																if (is_jkn_member == 1 && no_kunjungan_pcare != "" && is_bridging_with_pcare == 1) {
																	var data = self.getRegulerData();
											            			data['command'] = "delete_kunjungan";
											            			data['no_kunjungan_pcare'] = no_kunjungan_pcare;
											            			data['super_command'] = "pcare_kunjungan";
											            			data['is_bridging_with_pcare'] = is_bridging_with_pcare;
											            			$.post(
											            				"",
											            				data,
											            				function(response) {
											            					var json = JSON.parse(response);
											            					if (json == null) {
											            						var json=getContent(res);
																				if (json == null) {
																					dismissLoading();
																					return;
																				}
																				self.view();
																				dismissLoading();
																                self.is_post_action_del=true;
																				self.postAction(id);
											            						return;
											            					}
											            					if (json.content.message == "FAILED") {
												            					bootbox.dialog({
												            						closeButton : false,
																			        title 		: json.alert.title,
																			        message 	: json.content.message,
																			        buttons 	: {
																			            sucess:{
																			                label 	: "OK"
																			            }
																			        }       
																			    });
											            					}
											            					var json=getContent(res);
																			if (json == null) {
																				dismissLoading();
																				return;
																			}
																			self.view();
																			dismissLoading();
															                self.is_post_action_del=true;
																			self.postAction(id);
											            				}
											            			);
																}
												   			}
												   		);
													}
												);
										   	}
										}); 
									} else {
										bootbox.alert(json_validasi_resep.message);
									}
								}
							);
						}
					);
					return self;
				};
				<?php echo $this->action; ?>.afterview = function (json) {
					if (json.list == "")
						$("#<?php echo $this->action; ?>_add").show();
					else
						$("#<?php echo $this->action; ?>_add").hide();
				};
				<?php echo $this->action; ?>.view();
				<?php echo $this->action; ?>.show=function(id){
					var data=$("#diagnosa_data_"+id).html();
					showWarning("Diagnosa ", data);
				};
				<?php echo $this->action; ?>.cetak_surat_rujukan = function(id) {
					showLoading();
		            var data = this.getRegulerData();
		            data['super_command'] = "";
		            data['command'] = "pdf_surat_rujukan";
		            data['id'] = id;
		            $.post(
		                "",
		                data,
		                function(response) {
		                    var json = JSON.parse(response);
		                    if (json == null) {
		                        dismissLoading();
		                        return;
		                    }
		                    var getUrl = window.location['pathname'] + json;
		                    window.open(getUrl, 'pdf');
		                    dismissLoading();
		                }
		            );
				};
	            
	            <?php echo $this->action; ?>.setEditClearForNoClear(true);
	            <?php echo $this->action; ?>.addNoClear("id_dokter");
	            <?php echo $this->action; ?>.addNoClear("nama_dokter");
	            <?php echo $this->action; ?>.setEnableAutofocus(true);
	            <?php echo $this->action; ?>.setNextEnter();
	            <?php echo $this->action; ?>.setMultipleInput(false);

	            $("#<?php echo $this->action; ?>_kode_kesadaran").on("change", function() {
	            	var nama_kesadaran = $("#<?php echo $this->action; ?>_kode_kesadaran option:selected").text();
	            	$("#<?php echo $this->action; ?>_kesadaran").val(nama_kesadaran);
	            });
	            $("#<?php echo $this->action; ?>_add_form_form > div.normal_model_medium_component.<?php echo $this->action; ?>_search_button.fcontainer_<?php echo $this->action; ?>_search_button").hide();
	            $("#<?php echo $this->action; ?>_status_pulang").on("change", function() {
	            	var status_pulang = $(this).val();
	            	var is_jkn_member = $("#<?php echo $this->action; ?>_is_jkn_member").val();
					$("#<?php echo $this->action; ?>_kode_status_pulang").val("");
					if (status_pulang == "Rujuk") {
						$("#<?php echo $this->action; ?>_add_form_form > div.normal_model_medium_component.<?php echo $this->action; ?>_search_button.fcontainer_<?php echo $this->action; ?>_search_button").hide();

						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_ppk_rujukan").show();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_spesialis_subspesialis").show();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_catatan").show();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_tanggal_rencana_berkunjung").show();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_no_surat_kematian").hide();

						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_status_horizontal").hide();

						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_kode_tacc").hide();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_nama_tacc").hide();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_alasan_tacc").hide();
					} else if (status_pulang == "Meninggal") {
						$("#<?php echo $this->action; ?>_add_form_form > div.normal_model_medium_component.<?php echo $this->action; ?>_search_button.fcontainer_<?php echo $this->action; ?>_search_button").hide();

						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_ppk_rujukan").hide();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_spesialis_subspesialis").hide();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_catatan").hide();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_tanggal_rencana_berkunjung").hide();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_no_surat_kematian").show();

						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_status_horizontal").hide();

						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_kode_tacc").hide();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_nama_tacc").hide();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_alasan_tacc").hide();
					} else {
						$("#<?php echo $this->action; ?>_add_form_form > div.normal_model_medium_component.<?php echo $this->action; ?>_search_button.fcontainer_<?php echo $this->action; ?>_search_button").hide();

						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_ppk_rujukan").hide();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_spesialis_subspesialis").hide();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_catatan").hide();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_tanggal_rencana_berkunjung").hide();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_no_surat_kematian").hide();

						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_status_horizontal").hide();

						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_kode_tacc").hide();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_nama_tacc").hide();
						$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_alasan_tacc").hide();						
					}
	            });
	            $("#<?php echo $this->action; ?>_kode_status_pulang").on("change", function() {
	            	var kode_status_pulang = $(this).val();
	            	var status_pulang = $("#<?php echo $this->action; ?>_kode_status_pulang option:selected").text();
	            	var is_jkn_member = $("#<?php echo $this->action; ?>_is_jkn_member").val();
	            	var urji = $("#<?php echo $this->action; ?>_urji").val();
	            	if (is_jkn_member == 1) {
	            		$("#<?php echo $this->action; ?>_status_pulang").val(status_pulang);
	            		if ((kode_status_pulang == 1 && urji == 0) || (kode_status_pulang == 1 && urji == 1)) {
		            		$("#<?php echo $this->action; ?>_add_form_form > div.normal_model_medium_component.<?php echo $this->action; ?>_search_button.fcontainer_<?php echo $this->action; ?>_search_button").hide();

		            		$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_ppk_rujukan").hide();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_spesialis_subspesialis").hide();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_catatan").hide();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_tanggal_rencana_berkunjung").hide();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_no_surat_kematian").show();

							$("#<?php echo $this->action; ?>_ppk_rujukan").val("");
							$("#<?php echo $this->action; ?>_spesialis_subspesialis").val("");
							$("#<?php echo $this->action; ?>_catatan").val("");
							$("#<?php echo $this->action; ?>_tanggal_rencana_berkunjung").val("");
							$("#<?php echo $this->action; ?>_no_surat_kematian").val("");

							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_status_horizontal").hide();

							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_kode_tacc").hide();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_nama_tacc").hide();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_alasan_tacc").hide();

							$("#<?php echo $this->action; ?>_kode_tacc").val("");
							$("#<?php echo $this->action; ?>_nama_tacc").val("");
							$("#<?php echo $this->action; ?>_alasan_tacc").val("");
						} else if (kode_status_pulang == 4 && urji == 0) {
							$("#<?php echo $this->action; ?>_ppk_rujukan").removeAttr("disabled");
							$("#<?php echo $this->action; ?>_ppk_rujukan").attr("disabled", "disabled");
							$("#<?php echo $this->action; ?>_spesialis_subspesialis").removeAttr("disabled");
							$("#<?php echo $this->action; ?>_spesialis_subspesialis").attr("disabled", "disabled");
							$("#<?php echo $this->action; ?>_catatan").removeAttr("disabled");
							$("#<?php echo $this->action; ?>_catatan").attr("disabled", "disabled");
							$("#<?php echo $this->action; ?>_tanggal_rencana_berkunjung").removeAttr("disabled");
							$("#<?php echo $this->action; ?>_tanggal_rencana_berkunjung").attr("disabled", "disabled");

							$("#<?php echo $this->action; ?>_add_form_form > div.normal_model_medium_component.<?php echo $this->action; ?>_search_button.fcontainer_<?php echo $this->action; ?>_search_button").show();

							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_ppk_rujukan").show();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_spesialis_subspesialis").show();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_catatan").show();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_tanggal_rencana_berkunjung").show();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_no_surat_kematian").hide();

							$("#<?php echo $this->action; ?>_ppk_rujukan").val("");
							$("#<?php echo $this->action; ?>_spesialis_subspesialis").val("");
							$("#<?php echo $this->action; ?>_catatan").val("");
							$("#<?php echo $this->action; ?>_tanggal_rencana_berkunjung").val("");
							$("#<?php echo $this->action; ?>_no_surat_kematian").val("");

							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_status_horizontal").hide();

							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_kode_tacc").show();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_nama_tacc").show();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_alasan_tacc").show();

							$("#<?php echo $this->action; ?>_kode_tacc").val("");
							$("#<?php echo $this->action; ?>_nama_tacc").val("");
							$("#<?php echo $this->action; ?>_alasan_tacc").val("");
						} else if ((kode_status_pulang == 6 && urji == 0) || (kode_status_pulang == 4 && urji == 1) || (kode_status_pulang == 6 && urji == 1)) {
							$("#<?php echo $this->action; ?>_ppk_rujukan").removeAttr("disabled");
							$("#<?php echo $this->action; ?>_spesialis_subspesialis").removeAttr("disabled");
							$("#<?php echo $this->action; ?>_catatan").removeAttr("disabled");
							$("#<?php echo $this->action; ?>_tanggal_rencana_berkunjung").removeAttr("disabled");

							$("#<?php echo $this->action; ?>_add_form_form > div.normal_model_medium_component.<?php echo $this->action; ?>_search_button.fcontainer_<?php echo $this->action; ?>_search_button").hide();

							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_ppk_rujukan").show();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_spesialis_subspesialis").show();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_catatan").show();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_tanggal_rencana_berkunjung").show();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_no_surat_kematian").hide();

							$("#<?php echo $this->action; ?>_ppk_rujukan").val("");
							$("#<?php echo $this->action; ?>_spesialis_subspesialis").val("");
							$("#<?php echo $this->action; ?>_catatan").val("");
							$("#<?php echo $this->action; ?>_tanggal_rencana_berkunjung").val("");
							$("#<?php echo $this->action; ?>_no_surat_kematian").val("");

							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_status_horizontal").show();

							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_kode_tacc").show();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_nama_tacc").show();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_alasan_tacc").show();
							
							$("#<?php echo $this->action; ?>_kode_tacc").val("");
							$("#<?php echo $this->action; ?>_nama_tacc").val("");
							$("#<?php echo $this->action; ?>_alasan_tacc").val("");
		            	} else {
		            		$("#<?php echo $this->action; ?>_add_form_form > div.normal_model_medium_component.<?php echo $this->action; ?>_search_button.fcontainer_<?php echo $this->action; ?>_search_button").hide();

		            		$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_ppk_rujukan").hide();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_spesialis_subspesialis").hide();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_catatan").hide();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_tanggal_rencana_berkunjung").hide();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_no_surat_kematian").hide();

							$("#<?php echo $this->action; ?>_ppk_rujukan").val("");
							$("#<?php echo $this->action; ?>_spesialis_subspesialis").val("");
							$("#<?php echo $this->action; ?>_catatan").val("");
							$("#<?php echo $this->action; ?>_tanggal_rencana_berkunjung").val("");
							$("#<?php echo $this->action; ?>_no_surat_kematian").val("");

							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_status_horizontal").hide();

							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_kode_tacc").hide();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_nama_tacc").hide();
							$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_alasan_tacc").hide();

							$("#<?php echo $this->action; ?>_kode_tacc").val("");
							$("#<?php echo $this->action; ?>_nama_tacc").val("");
							$("#<?php echo $this->action; ?>_alasan_tacc").val("");
		            	}
	            	}
	            });
	            $("#<?php echo $this->action; ?>_berat_badan").on("keyup", function() {
	            	var berat_badan = isNaN($("#<?php echo $this->action; ?>_berat_badan").val()) ? 0 : $("#<?php echo $this->action; ?>_berat_badan").val();
	            	var tinggi_badan = isNaN($("#<?php echo $this->action; ?>_tinggi_badan").val()) ? 0 : $("#<?php echo $this->action; ?>_tinggi_badan").val();
	            	var imt = 0;
	            	if (tinggi_badan != 0)
	            		imt = parseFloat(berat_badan / (2 * tinggi_badan / 100)).toFixed(2);
	            	$("#<?php echo $this->action; ?>_imt").val(imt);
	            });
	            $("#<?php echo $this->action; ?>_tinggi_badan").on("keyup", function() {
	            	var berat_badan = isNaN($("#<?php echo $this->action; ?>_berat_badan").val()) ? 0 : $("#<?php echo $this->action; ?>_berat_badan").val();
	            	var tinggi_badan = isNaN($("#<?php echo $this->action; ?>_tinggi_badan").val()) ? 0 : $("#<?php echo $this->action; ?>_tinggi_badan").val();
	            	var imt = 0;
	            	if (tinggi_badan != 0)
	            		imt = parseFloat(berat_badan / (2 * tinggi_badan / 100)).toFixed(2);
	            	$("#<?php echo $this->action; ?>_imt").val(imt);
	            });
	            $("#<?php echo $this->action; ?>_kode_icd").on("keyup", function(e) {
	            	if (e.which == 13) {
	            		var val = $(this).val();
	            		var data = mr_icd.getRegulerData();
	            		data['super_command'] = "pcare_icd";
	            		data['command'] = "get_pcare_diagnosa";
	            		data['is_bridging_with_pcare'] = $("#is_bridging_with_pcare").val();
	            		data['kode_icd'] = val;
	            		showLoading();
	            		$.post(
	            			"",
	            			data,
	            			function(response) {
	            				var json = JSON.parse(response);
	            				if (json == null) {
	            					dismissLoading();
	            					return;
	            				}
	            				$("#<?php echo $this->action; ?>_nama_icd").val(json.nama_diagnosa);
								$("#<?php echo $this->action; ?>_non_spesialis").val(json.non_spesialis);
	            				dismissLoading();
	            			}
	            		);
	            	}
	            });
	            $("#<?php echo $this->action; ?>_kode_icd_sekunder").on("keyup", function(e) {
	            	if (e.which == 13) {
	            		var val = $(this).val();
	            		var data = mr_icd.getRegulerData();
	            		data['super_command'] = "pcare_icd";
	            		data['command'] = "get_pcare_diagnosa";
	            		data['is_bridging_with_pcare'] = $("#is_bridging_with_pcare").val();
	            		data['kode_icd'] = val;
	            		showLoading();
	            		$.post(
	            			"",
	            			data,
	            			function(response) {
	            				var json = JSON.parse(response);
	            				if (json == null) {
	            					dismissLoading();
	            					return;
	            				}
	            				$("#<?php echo $this->action; ?>_nama_icd_sekunder").val(json.nama_diagnosa);
	            				dismissLoading();
	            			}
	            		);
	            	}
	            });
	            $("#jenis_rujuk_vertikal").on("change", function() {
	            	var jenis_rujuk_vertikal = $(this).val();
					if (jenis_rujuk_vertikal == "Kondisi Khusus") {
						$("#rujukan_add_form_form > div.full_model_small_component.kondisi_khusus_kategori").show();
						$("#kondisi_khusus_kategori").trigger("change");
						$("#rujukan_add_form_form > div.full_model_small_component.kondisi_khusus_alasan").show();

						$("#rujukan_add_form_form > div.full_model_small_component.spesialis_spesialis").hide();
						$("#rujukan_add_form_form > div.full_model_small_component.spesialis_subspesialis").hide();
						$("#rujukan_add_form_form > div.full_model_small_component.spesialis_sarana").hide();
					} else if (jenis_rujuk_vertikal == "Spesialis") {
						$("#rujukan_add_form_form > div.full_model_small_component.kondisi_khusus_kategori").hide();
						$("#rujukan_add_form_form > div.full_model_small_component.kondisi_khusus_spesialis").hide();
						$("#rujukan_add_form_form > div.full_model_small_component.kondisi_khusus_alasan").hide();

						$("#rujukan_add_form_form > div.full_model_small_component.spesialis_spesialis").show();
						$("#spesialis_spesialis").trigger("change");
						$("#rujukan_add_form_form > div.full_model_small_component.spesialis_subspesialis").show();
						$("#rujukan_add_form_form > div.full_model_small_component.spesialis_sarana").show();
					} else {
						$("#rujukan_add_form_form > div.full_model_small_component.kondisi_khusus_kategori").hide();
						$("#rujukan_add_form_form > div.full_model_small_component.kondisi_khusus_spesialis").hide();
						$("#rujukan_add_form_form > div.full_model_small_component.kondisi_khusus_alasan").hide();

						$("#rujukan_add_form_form > div.full_model_small_component.spesialis_spesialis").hide();
						$("#rujukan_add_form_form > div.full_model_small_component.spesialis_subspesialis").hide();
						$("#rujukan_add_form_form > div.full_model_small_component.spesialis_sarana").hide();
					}
	            });
	            $("#kondisi_khusus_kategori").on("change", function() {
					var kondisi_khusus_kategori = $(this).val();
					if (kondisi_khusus_kategori == "HEM" || kondisi_khusus_kategori == "THA") {
						var data = <?php echo $this->action; ?>.getRegulerData();
						data['super_command'] = "pcare_kategori_subspesialis";
						data['command'] = "get_subspesialis";
						data['is_bridging_with_pcare'] = $("#is_bridging_with_pcare").val();
						data['kategori'] = kondisi_khusus_kategori;
						showLoading();
						$.post(
							"",
							data,
							function(response) {
								var json = JSON.parse(response);
								if (json == null) {
									dismissLoading();
									$("#rujukan_add_form_form > div.full_model_small_component.kondisi_khusus_spesialis").show();
									return;
								}
								$("#kondisi_khusus_spesialis").html(json.html);
								$("#rujukan_add_form_form > div.full_model_small_component.kondisi_khusus_spesialis").show();
								dismissLoading();
							}
						);
					} else
						$("#rujukan_add_form_form > div.full_model_small_component.kondisi_khusus_spesialis").hide();
				});
				$("#spesialis_spesialis").on("change", function() {
					var spesialis = $(this).val();
					var data = <?php echo $this->action; ?>.getRegulerData();
					data['super_command'] = "pcare_spesialis_subspesialis";
					data['command'] = "get_subspesialis";
					data['is_bridging_with_pcare'] = $("#is_bridging_with_pcare").val();
					data['spesialis'] = spesialis;
					showLoading();
					$.post(
						"",
						data,
						function(response) {
							var json = JSON.parse(response);
							if (json == null) {
								dismissLoading();
								return;
							}
							$("#spesialis_subspesialis").html(json.html);
							dismissLoading();
						}
					);
				});
				faskes = new TableAction(
					"faskes",
					mr_the_page,
					"<?php echo $this->action; ?>",
					new Array()
				);
				faskes.setSuperCommand("faskes");
				faskes.setPrototipe(mr_the_protoname,mr_the_protoslug,mr_the_protoimplement);
				faskes.search = function() {
					var data = this.getRegulerData();
					data['command'] = "search";
					data['is_bridging_with_pcare'] = $("#is_bridging_with_pcare").val();
					data['no_bpjs'] = $("#<?php echo $this->action; ?>_no_bpjs").val();
					data['jenis_rujuk_vertikal'] = $("#jenis_rujuk_vertikal").val();
					data['kondisi_khusus_kategori'] = $("#kondisi_khusus_kategori").val();
					data['kondisi_khusus_spesialis'] = $("#kondisi_khusus_spesialis").val();
					data['spesialis_spesialis'] = $("#spesialis_spesialis").val();
					data['spesialis_subspesialis'] = $("#spesialis_subspesialis").val();
					data['spesialis_sarana'] = $("#spesialis_sarana").val();
					data['tanggal_rencana_berkunjung'] = $("#tanggal_rencana_berkunjung").val();
					showLoading();
					$.post(
						"",
						data,
						function(response) {
							var json = JSON.parse(response);
							if (json == null) {
								dismissLoading();
								return;
							}
							$("#faskes_list").html(json.html);
							dismissLoading();
						}
					);
				};
				faskes.select = function(row_num) {
					var kode_ppk_rujukan = $("#faskes_list tr:eq(" + row_num + ") td:eq(11)").text();
					var ppk_rujukan = $("#faskes_list tr:eq(" + row_num + ") td:eq(1)").text();
					var jenis_rujuk_vertikal = $("#jenis_rujuk_vertikal").val();
					var kondisi_khusus_kategori = $("#kondisi_khusus_kategori").val();
					var kondisi_khusus_kategori_label = $("#kondisi_khusus_kategori option:selected").text();
					var kondisi_khusus_spesialis = $("#kondisi_khusus_spesialis").val();
					var kondisi_khusus_spesialis_label = $("#kondisi_khusus_spesialis option:selected").text();
					var kondisi_khusus_alasan = $("#kondisi_khusus_alasan").val();
					var spesialis_spesialis = $("#spesialis_spesialis").val();
					var spesialis_spesialis_label = $("#spesialis_spesialis option:selected").text();
					var spesialis_subspesialis = $("#spesialis_subspesialis").val();
					var spesialis_subspesialis_label = $("#spesialis_subspesialis option:selected").text();
					var spesialis_sarana = $("#spesialis_sarana").val();
					var spesialis_sarana_label = $("#spesialis_sarana option:selected").text();
					var tanggal_rencana_berkunjung = $("#tanggal_rencana_berkunjung").val();
					var jadwal = $("#faskes_list tr:eq(" + row_num + ") td:eq(10)").text();

					$("#<?php echo $this->action; ?>_jenis_rujuk_vertikal").val(jenis_rujuk_vertikal);
					$("#<?php echo $this->action; ?>_kode_kondisi_khusus_kategori").val(kondisi_khusus_kategori);
					$("#<?php echo $this->action; ?>_nama_kondisi_khusus_kategori").val(kondisi_khusus_kategori_label);
					$("#<?php echo $this->action; ?>_kode_kondisi_khusus_spesialis").val(kondisi_khusus_spesialis);
					$("#<?php echo $this->action; ?>_nama_kondisi_khusus_spesialis").val(kondisi_khusus_spesialis_label);
					$("#<?php echo $this->action; ?>_kondisi_khusus_alasan").val(kondisi_khusus_alasan);
					$("#<?php echo $this->action; ?>_kode_spesialis_spesialis").val(spesialis_spesialis);
					$("#<?php echo $this->action; ?>_nama_spesialis_spesialis").val(spesialis_spesialis_label);
					$("#<?php echo $this->action; ?>_kode_spesialis_subspesialis").val(spesialis_subspesialis);
					$("#<?php echo $this->action; ?>_nama_spesialis_subspesialis").val(spesialis_subspesialis_label);
					$("#<?php echo $this->action; ?>_kode_spesialis_sarana").val(spesialis_sarana);
					$("#<?php echo $this->action; ?>_nama_spesialis_sarana").val(spesialis_sarana_label);

					$("#<?php echo $this->action; ?>_kode_ppk_rujukan").val(kode_ppk_rujukan);
					$("#<?php echo $this->action; ?>_ppk_rujukan").val(ppk_rujukan);
					if (jenis_rujuk_vertikal == "Kondisi Khusus") {
						if (kondisi_khusus_kategori == "THA" || kondisi_khusus_kategori == "HEM")
							$("#<?php echo $this->action; ?>_spesialis_subspesialis").val(kondisi_khusus_kategori_label + " / " + kondisi_khusus_spesialis_label);
						else
							$("#<?php echo $this->action; ?>_spesialis_subspesialis").val(kondisi_khusus_kategori_label);
						$("#<?php echo $this->action; ?>_catatan").val(kondisi_khusus_alasan);
					} else if (jenis_rujuk_vertikal == "Spesialis") {
						$("#<?php echo $this->action; ?>_spesialis_subspesialis").val(spesialis_spesialis_label + " / " + spesialis_subspesialis_label);
						$("#<?php echo $this->action; ?>_catatan").val(spesialis_sarana_label);
					}
					$("#<?php echo $this->action; ?>_tanggal_rencana_berkunjung").val(tanggal_rencana_berkunjung);
					$("#<?php echo $this->action; ?>_jadwal").val(jadwal);

					$("#rujukan_modal").smodal('hide');
				};
				$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_status_horizontal").hide();
				$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_kode_tacc").hide();
				$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_nama_tacc").hide();
				$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_alasan_tacc").hide();	
				$("#jenis_rujuk_vertikal").trigger("change");
				$("#spesialis_spesialis").trigger("change");
				$("#faskes_list").html("<tr><td colspan='12'><center>Data Faskes Rujukan Belum Ditampilkan</center></td></tr>");

				$("#<?php echo $this->action; ?>_ppk_rujukan").on("change", function() {
					var nama_ppk_rujukan = $(this).val();
					var data =  <?php echo $this->action; ?>.getRegulerData();
					data['command'] = "get_ppk_spesialis_option";
					data['nama_ppk_rujukan'] = nama_ppk_rujukan;
					if (selected_spesialis_subspesialis != "")
						data['selected_ppk_spesialis'] = selected_spesialis_subspesialis;
					$.post(
						"",
						data,
						function(response) {
							var json = JSON.parse(response);
							if (json == null) return;
							$("#<?php echo $this->action; ?>_spesialis_subspesialis").html(json.html);
						}
					);
				});
			});
		</script>
		<?php
	}
	
	public function superCommand($super_command) {
		if (isset($_POST['super_command']) && isset($_POST['command'])) {
			if (isset($_POST['is_bridging_with_pcare']) && $_POST['is_bridging_with_pcare'] == 1) {
				if ($_POST['super_command'] == "pcare_kunjungan") {
					if ($_POST['command'] == "add_kunjungan") {
			        	$no_kartu = $_POST['no_bpjs'];
			        	$tgl_daftar = "";
			        	$kode_poli = "";
			        	$keluhan = $_POST['keluhan'];
			        	$kode_sadar = $_POST['kode_kesadaran'];
			        	$sistole = floatval($_POST['sistole']);
			        	$diastole = floatval($_POST['diastole']);
			        	$berat_badan = floatval($_POST['berat_badan']);
			        	$tinggi_badan = floatval($_POST['tinggi_badan']);
			        	$respiratory_rate = floatval($_POST['rr']);
			        	$heart_rate = floatval($_POST['nadi']);
			        	$lingkar_perut = floatval($_POST['lingkar_perut']);
			        	$terapi = $_POST['terapi_non_obat'];
			        	$kode_status_pulang = $_POST['kode_status_pulang'];
			        	$tanggal_pulang = date_format(date_create($_POST['tanggal_pulang']), "d-m-Y");
			        	$kode_dokter = $_POST['id_dokter'];
			        	$kode_diagnosa_1 = $_POST['kode_icd'];
			        	$kode_diagnosa_2 = $_POST['kode_icd_sekunder'] == "" ? null : $_POST['kode_icd_sekunder'];
			        	$kode_diagnosa_3 = null;
			        	$kode_poli_rujuk_internal = null;
			        	$tanggal_estimasi_rujuk = date_format(date_create($_POST['tanggal_rencana_berkunjung']), "d-m-Y");
			        	$kode_ppk = $_POST['kode_ppk_rujukan'];
			        	$khusus = null;
						$subspesialis = null;
			        	$kode_tacc = $_POST['kode_tacc'];
			        	$alasan_tacc = $_POST['alasan_tacc'] == "" ? null : $_POST['alasan_tacc'];

			        	$jenis_rujuk_vertikal = $_POST['jenis_rujuk_vertikal'];
			        	$khusus_kode_khusus = $_POST['kode_kondisi_khusus_kategori'];
						$khusus_kode_subspesialis = $_POST['kode_kondisi_khusus_spesialis'];
						$khusus_catatan = $_POST['kondisi_khusus_alasan'];
						$subspesialis_kode_subspesialis = $_POST['kode_spesialis_subspesialis'];
						$subspesialis_kode_sarana = $_POST['kode_spesialis_sarana'] == 0 ? null : $_POST['kode_spesialis_sarana'];

						if ($jenis_rujuk_vertikal == "Kondisi Khusus") {
							$khusus = array(
								'kdKhusus' 			=> $khusus_kode_khusus,
								'kdSubSpesialis'	=> $khusus_kode_subspesialis,
								'catatan'			=> $khusus_catatan
							);
						} else if ($jenis_rujuk_vertikal == "Spesialis") {
							$subspesialis = array(
								'kdSubSpesialis1'	=> $subspesialis_kode_subspesialis,
								'kdSarana'			=> $subspesialis_kode_sarana
							);
						}

						$anamnesa = $_POST['anamnesa'];
						$alergi_makanan = $_POST['makanan'];
						$alergi_udara = $_POST['udara'];
						$alergi_obat = $_POST['obat_obatan'];
						$kode_prognosa = $_POST['prognosa'];
						$terapi_obat = $_POST['terapi_obat'];
						$terapi_non_obat = $_POST['terapi_non_obat'];
						$bmhp = $_POST['bmhp'];
						$suhu = $_POST['suhu'];

			        	$row = $this->db->get_row("
							SELECT DATE(tanggal) tanggal, bpjs_kode_poli 
							FROM smis_rg_layananpasien 
							WHERE id = '" . $_POST['noreg_pasien'] . "'
						");
						if ($row != null) {
							$tgl_daftar = date_format(date_create($row->tanggal), "d-m-Y");
							$kode_poli = $row->bpjs_kode_poli;
						}

			        	require_once("medical_record/class/pcare/PCareKunjungan.php");
			        	$pcare = new PCareKunjungan();
			            $pcare->setPCareAuthorization();
			            $data_response = $pcare->addKunjungan(
				            null,
				            $no_kartu,
				            $tgl_daftar,
				            $kode_poli,
				            $keluhan,
				            $kode_sadar,
				            $sistole,
				            $diastole,
				            $berat_badan,
				            $tinggi_badan,
				            $respiratory_rate,
				            $heart_rate,
				            $lingkar_perut,
				            $terapi,
				            $kode_status_pulang,
				            $tanggal_pulang,
				            $kode_dokter,
				            $kode_diagnosa_1,
				            $kode_diagnosa_2,
				            $kode_diagnosa_3,
				            $kode_poli_rujuk_internal,
				            $tanggal_estimasi_rujuk,
				            $kode_ppk,
				            $subspesialis,
				            $khusus,
				            $kode_tacc,
				            $alasan_tacc,
				            $anamnesa,
							$alergi_makanan,
							$alergi_udara,
							$alergi_obat,
							$kode_prognosa,
							$terapi_obat,
							$terapi_non_obat,
							$bmhp,
							$suhu
			            );
			            echo json_encode($data_response);
						return;
			        } else if ($_POST['command'] == "edit_kunjungan") {
			        	$no_kunjungan_pcare = $_POST['no_kunjungan_pcare'];
			        	$no_kartu = $_POST['no_bpjs'];
			        	$tgl_daftar = "";
			        	$kode_poli = "";
			        	$keluhan = $_POST['keluhan'];
			        	$kode_sadar = $_POST['kode_kesadaran'];
			        	$sistole = floatval($_POST['sistole']);
			        	$diastole = floatval($_POST['diastole']);
			        	$berat_badan = floatval($_POST['berat_badan']);
			        	$tinggi_badan = floatval($_POST['tinggi_badan']);
			        	$respiratory_rate = floatval($_POST['rr']);
			        	$heart_rate = floatval($_POST['nadi']);
			        	$lingkar_perut = floatval($_POST['lingkar_perut']);
			        	$terapi = $_POST['terapi_non_obat'];
			        	$kode_status_pulang = $_POST['kode_status_pulang'];
			        	$tanggal_pulang = date_format(date_create($_POST['tanggal_pulang']), "d-m-Y");
			        	$kode_dokter = $_POST['id_dokter'];
			        	$kode_diagnosa_1 = $_POST['kode_icd'];
			        	$kode_diagnosa_2 = $_POST['kode_icd_sekunder'] == "" ? null : $_POST['kode_icd_sekunder'];
			        	$kode_diagnosa_3 = null;
			        	$kode_poli_rujuk_internal = null;
			        	$tanggal_estimasi_rujuk = date_format(date_create($_POST['tanggal_rencana_berkunjung']), "d-m-Y");
			        	$kode_ppk = $_POST['kode_ppk_rujukan'];
			        	$khusus = null;
						$subspesialis = null;
			        	$kode_tacc = $_POST['kode_tacc'];
			        	$alasan_tacc = $_POST['alasan_tacc'] == "" ? null : $_POST['alasan_tacc'];

			        	$jenis_rujuk_vertikal = $_POST['jenis_rujuk_vertikal'];
			        	$khusus_kode_khusus = $_POST['kode_kondisi_khusus_kategori'];
						$khusus_kode_subspesialis = $_POST['kode_kondisi_khusus_spesialis'];
						$khusus_catatan = $_POST['kondisi_khusus_alasan'];
						$subspesialis_kode_subspesialis = $_POST['kode_spesialis_subspesialis'];
						$subspesialis_kode_sarana = $_POST['kode_spesialis_sarana'] == 0 ? null : $_POST['kode_spesialis_sarana'];

						if ($jenis_rujuk_vertikal == "Kondisi Khusus") {
							$khusus = array(
								'kdKhusus' 			=> $khusus_kode_khusus,
								'kdSubSpesialis'	=> $khusus_kode_subspesialis,
								'catatan'			=> $khusus_catatan
							);
						} else if ($jenis_rujuk_vertikal == "Spesialis") {
							$subspesialis = array(
								'kdSubSpesialis1'	=> $subspesialis_kode_subspesialis,
								'kdSarana'			=> $subspesialis_kode_sarana
							);
						}

						$anamnesa = $_POST['anamnesa'];
						$alergi_makanan = $_POST['makanan'];
						$alergi_udara = $_POST['udara'];
						$alergi_obat = $_POST['obat_obatan'];
						$kode_prognosa = $_POST['prognosa'];
						$terapi_obat = $_POST['terapi_obat'];
						$terapi_non_obat = $_POST['terapi_non_obat'];
						$bmhp = $_POST['bmhp'];
						$suhu = $_POST['suhu'];

			        	$row = $this->db->get_row("
							SELECT DATE(tanggal) tanggal, bpjs_kode_poli 
							FROM smis_rg_layananpasien 
							WHERE id = '" . $_POST['noreg_pasien'] . "'
						");
						if ($row != null) {
							$tgl_daftar = date_format(date_create($row->tanggal), "d-m-Y");
							$kode_poli = $row->bpjs_kode_poli;
						}

			        	require_once("medical_record/class/pcare/PCareKunjungan.php");
			        	$pcare = new PCareKunjungan();
			            $pcare->setPCareAuthorization();
			            $data_response = $pcare->editKunjungan(
				            $no_kunjungan_pcare,
				            $no_kartu,
				            $tgl_daftar,
				            $kode_poli,
				            $keluhan,
				            $kode_sadar,
				            $sistole,
				            $diastole,
				            $berat_badan,
				            $tinggi_badan,
				            $respiratory_rate,
				            $heart_rate,
				            $lingkar_perut,
				            $terapi,
				            $kode_status_pulang,
				            $tanggal_pulang,
				            $kode_dokter,
				            $kode_diagnosa_1,
				            $kode_diagnosa_2,
				            $kode_diagnosa_3,
				            $kode_poli_rujuk_internal,
				            $tanggal_estimasi_rujuk,
				            $kode_ppk,
				            $subspesialis,
				            $khusus,
				            $kode_tacc,
				            $alasan_tacc,
				            $anamnesa,
							$alergi_makanan,
							$alergi_udara,
							$alergi_obat,
							$kode_prognosa,
							$terapi_obat,
							$terapi_non_obat,
							$bmhp,
							$suhu
			            );
			            echo json_encode($data_response);
						return;
			        } else if ($_POST['command'] == "delete_kunjungan") {
			        	$no_kunjungan_pcare = $_POST['no_kunjungan_pcare'];

			        	require_once("medical_record/class/pcare/PCareKunjungan.php");
			        	$pcare = new PCareKunjungan();
			            $pcare->setPCareAuthorization();
			            $data_response = $pcare->deleteKunjungan($no_kunjungan_pcare);
			            echo json_encode($data_response);
						return;
			        }
				}
				if ($_POST['super_command'] == "pcare_icd") {
			        require_once("medical_record/class/pcare/PCareDiagnosa.php");
					if ($_POST['command'] == "get_pcare_diagnosa") {
						$kode_icd = $_POST['kode_icd'];
						$nama_icd = "";
						$non_spesialis = "";
						$pcare = new PCareDiagnosa();
			            $pcare->setPCareAuthorization();
			            $data_response = $pcare->getListData($kode_icd, 0, 1);
			            $code = $data_response['metaData']['code'];
			            $message = $data_response['metaData']['message'];
			            $data = $data_response['response']['list'];
			            if (count($data) > 0) {
			            	foreach ($data as $d)
			            		if ($d['kdDiag'] == $kode_icd) {
			            			$nama_icd = $d['nmDiag'];	
									$non_spesialis = $d['nonSpesialis'] == true ? 1 : 0;
			            			break;
			            		}
			            }
			            $data = array(
			            	'nama_diagnosa' => $nama_icd,
							'non_spesialis' => $non_spesialis
			            );
			            echo json_encode($data);
			            return;
					}
				}
				if ($_POST['super_command'] == "mr_icd" || $_POST['super_command'] == "mr_icd_sekunder" || $_POST['super_command'] == "pcare_alasan_tacc") {
			        require_once("medical_record/class/pcare/PCareDiagnosa.php");
					if ($_POST['command'] == "list") {            
			            $response_package = new ResponsePackage();
			            $number           = (isset($_POST['number']) && $_POST['number'] != "") ? $_POST['number'] : 0;
			            $n_number         = $number;
			            $max              = isset($_POST['max']) ? $_POST['max'] : "10";     
			            $kriteria         = $_POST['kriteria'];
			            if ($kriteria == "")
			            	$kriteria = "0";
			            $pcare            = new PCareDiagnosa();
			            $pcare->setPCareAuthorization();
			            $data_response    = $pcare->getListData($kriteria, $number, $max);
			            $total            = $data_response['response']['count'];
			            $code             = $data_response['metaData']['code'];
			            $message          = $data_response['metaData']['message'];
			            $max_page         = ceil($total / $max);
			            if ($n_number >= $max_page && $n_number != 0) {
			                $n_number       = $max_page - 1;
			            }
			            $page             = $n_number;
			            $data             = $data_response['response']['list'];
			            $max_page         = $max_page;
			            $list             = "";
			            $nomor            = 1 + $max * $number;
			            $index 			  = 0;
			            foreach ($data as $d) {
							$nonSpesialis = $d['nonSpesialis'] == 1 ? "Non-Spesialis" : "Spesialis";
			                $list         .=    "<tr>" .
			                                        "<td>" . $nomor++ . "</td>" .
			                                        "<td>" . $d['kdDiag'] . "</td>" .
			                                        "<td>" . $d['nmDiag'] . "</td>" .
													"<td>" . $nonSpesialis . "</td>" .
			                                        "<td class='noprint'>" .
			                                        	"<div class='btn-group noprint'>" .
			                                        		"<a href='#' onclick=' " . $_POST['super_command'] . ".select(" . $index++ . ") ' data-content='Pilih' data-toggle='popover' class='input btn btn-info '>" .
			                                        			"<i class='fa fa-check'></i>" .
			                                        		"</a>" . 
			                                        	"</div>" . 
			                                        "</td>" .
			                                    "</tr>";
			            }
			            $pagination = new Pagination('','', $number, 3, $_POST['super_command'] . ".paginate(this)", $max_page);
			            $content = array(
			                'list'          => $list,
			                'pagination'    => "",
			                'number'        => $page,
			                'number_p'      => $number,
			                'total'         => $total,
			                'max_page'      => $max_page,
			                'max'           => $max
			            );
			            $response_package->setContent($content);
			            if ($code == 200)
			                $response_package->setStatus(ResponsePackage::$STATUS_OK);
			            else {
			                $response_package->setStatus(ResponsePackage::$STATUS_FAIL);
			                $response_package->setAlertContent("Proses Pengambilan Data Gagal : " . $code, $message, ResponsePackage::$TIPE_DANGER);
			                $response_package->setAlertVisible(true);
			            }
			            echo json_encode($response_package->getPackage());
			        }
					return;
				} else if ($_POST['super_command'] == "mr_dokter") {
			        require_once("medical_record/class/pcare/PCareDokter.php");
					if ($_POST['command'] == "list") {            
			            $response_package = new ResponsePackage();
			            $number           = (isset($_POST['number']) && $_POST['number'] != "") ? $_POST['number'] : 0;
			            $n_number         = $number;
			            $max              = 10000;
			            $pcare            = new PCareDokter();
			            $pcare->setPCareAuthorization();
			            $data_response    = $pcare->getListData($number, $max);
			            $total            = $data_response['response']['count'];
			            $code             = $data_response['metaData']['code'];
			            $message          = $data_response['metaData']['message'];
			            $max_page         = ceil($total / $max);
			            if ($n_number >= $max_page && $n_number != 0) {
			                $n_number       = $max_page - 1;
			            }
			            $page             = $n_number;
			            $data             = $data_response['response']['list'];
			            $max_page         = $max_page;
			            $list             = "";
			            $nomor            = 1 + $max * $number;
			            $index 			  = 0;
			            foreach ($data as $d) {
			                $list         .=    "<tr>" .
			                                        "<td>" . $nomor++ . "</td>" .
			                                        "<td>" . $d['kdDokter'] . "</td>" .
			                                        "<td>" . $d['nmDokter'] . "</td>" .
			                                        "<td class='noprint'>" .
			                                        	"<div class='btn-group noprint'>" .
			                                        		"<a href='#' onclick=' mr_dokter.select(" . $index++ . ") ' data-content='Pilih' data-toggle='popover'class='input btn btn-info '>" .
			                                        			"<i class='fa fa-check'></i>" .
			                                        		"</a>" . 
			                                        	"</div>" . 
			                                        "</td>" .
			                                    "</tr>";
			            }
			            $pagination = new Pagination('','', $number, 3, "mr_dokter.paginate(this)", $max_page);
			            $content = array(
			                'list'          => $list,
			                'pagination'    => $pagination->getHtml(),
			                'number'        => $page,
			                'number_p'      => $number,
			                'total'         => $total,
			                'max_page'      => $max_page,
			                'max'           => $max
			            );
			            $response_package->setContent($content);
			            if ($code == 200)
			                $response_package->setStatus(ResponsePackage::$STATUS_OK);
			            else {
			                $response_package->setStatus(ResponsePackage::$STATUS_FAIL);
			                $response_package->setAlertContent("Proses Pengambilan Data Gagal : " . $code, $message, ResponsePackage::$TIPE_DANGER);
			                $response_package->setAlertVisible(true);
			            }
			            echo json_encode($response_package->getPackage());
			        }
					return;
				} else if ($_POST['super_command'] == "pcare_kategori_subspesialis") {
					if ($_POST['command'] == "get_subspesialis") {
						$kategori = $_POST['kategori'];
			            $html = "";
			            $data_subspesialis = array();
			            if ($kategori == "THA" || $kategori == "HEM") {
		            		$data_subspesialis[] = array(
		            			'kdSubSpesialis' 	=> "3",
		            			'nmSubSpesialis'	=> "PENYAKIT DALAM"
		            		);
		            		$data_subspesialis[] = array(
		            			'kdSubSpesialis' 	=> "8",
		            			'nmSubSpesialis'	=> "HEMATOLOGI - ONKOLOGI MEDIK"
		            		);
		            		$data_subspesialis[] = array(
		            			'kdSubSpesialis' 	=> "8",
		            			'nmSubSpesialis'	=> "HEMATOLOGI - ONKOLOGI MEDIK"
		            		);
		            		$data_subspesialis[] = array(
		            			'kdSubSpesialis' 	=> "26",
		            			'nmSubSpesialis'	=> "ANAK"
		            		);
		            		$data_subspesialis[] = array(
		            			'kdSubSpesialis' 	=> "30",
		            			'nmSubSpesialis'	=> "ANAK HEMATOLOGI ONKOLOGI"
		            		);
			            }
			            if (count($data_subspesialis) > 0) {
			            	$data_number = 1;
			            	foreach ($data_subspesialis as $ds) {
				            	$html .= "<option data-type='value' data-if='0' data-selected='' data-number='" . $data_number . "' value='" . $ds['kdSubSpesialis'] . "'>" . $ds['nmSubSpesialis'] . "</option>";	
				            	$data_number++;
			            	}
			            }
			            $data = array(
			            	'html' => $html,
			            	'code'		=> $code,
			            	'message'	=> $message
			            );
			            echo json_encode($data);
			            return;
					}
				} else if ($_POST['super_command'] == "pcare_spesialis_subspesialis") {
					require_once("medical_record/class/pcare/PCareSpesialisSubspesialis.php");
					if ($_POST['command'] == "get_subspesialis") {
						$spesialis = $_POST['spesialis'];
			            $html = "";
			            $pcare = new PCareSpesialisSubspesialis();
			            $pcare->setPCareAuthorization();
			            $data_response = $pcare->getListData($spesialis);
			            $data_subspesialis = $data_response['response']['list'];
			            $code = $data_response['metaData']['code'];
			            $message = $data_response['metaData']['message'];
			            if (count($data_subspesialis) > 0) {
			            	$data_number = 1;
			            	foreach ($data_subspesialis as $ds) {
				            	$html .= "<option data-type='value' data-if='0' data-selected='' data-number='" . $data_number . "' value='" . $ds['kdSubSpesialis'] . "'>" . $ds['nmSubSpesialis'] . "</option>";	
				            	$data_number++;
			            	}
			            }
			            $data = array(
			            	'html' => $html,
			            	'code'		=> $code,
			            	'message'	=> $message
			            );
			            echo json_encode($data);
			            return;
					}
				} else if ($_POST['super_command'] == "faskes") {
					require_once("medical_record/class/pcare/PCareSpesialisFaskesRujukanKhusus.php");
					if ($_POST['command'] == "search") {
						$no_bpjs = $_POST['no_bpjs'];
						$jenis_rujuk_vertikal = $_POST['jenis_rujuk_vertikal'];
						$kondisi_khusus_kategori = $_POST['kondisi_khusus_kategori'];
						$kondisi_khusus_spesialis = $_POST['kondisi_khusus_spesialis'];
						$spesialis_spesialis = $_POST['spesialis_spesialis'];
						$spesialis_subspesialis = $_POST['spesialis_subspesialis'];
						$spesialis_sarana = $_POST['spesialis_sarana'];
						$tanggal_rencana_berkunjung = $_POST['tanggal_rencana_berkunjung'];
			            
			            $data_faskes = array();
			            $code = "";
			            $message = "";
			            $response_message = "";
			            if ($jenis_rujuk_vertikal == "Kondisi Khusus") {
			            	$pcare = new PCareSpesialisFaskesRujukanKhusus();
					        $pcare->setPCareAuthorization();
			            	if ($kondisi_khusus_kategori == "THA" || $kondisi_khusus_kategori == "HEM") {
					            $data_response = $pcare->getListDataKhususTH($tanggal_rencana_berkunjung, $no_bpjs, $kondisi_khusus_kategori, $kondisi_khusus_spesialis);
					            if (array_key_exists('list', $data_response['response']))
						        	$data_faskes = $data_response['response']['list'];
						        else if (count($data_response['response']) > 0) {
						        	$response_message = "";
						        	foreach ($data_response['response'] as $dr) {
						        		$field = $data_response['response'][0]['field'];
						        		$field_part = preg_split('/(?=[A-Z])/', $field);
						        		$field = "";
						        		foreach ($field_part as $fp)
						        			$field .= ucwords($fp) . " ";
						        		$field = rtrim($field);
										$message = $data_response['response'][0]['message'];
										$response_message .= $field . " " . $message . ", ";
									}
									$response_message = rtrim($response_message, ", ");
						        } else
						        	$response_message = $data_response['response'];
						        $code = $data_response['metaData']['code'];
				            	$message = $data_response['metaData']['message'];
			            	} else {
					            $data_response = $pcare->getListDataKhususNonTH($tanggal_rencana_berkunjung, $no_bpjs, $kondisi_khusus_kategori);
					            if (array_key_exists('list', $data_response['response']))
						        	$data_faskes = $data_response['response']['list'];
						        else if (count($data_response['response']) > 0) {
						        	$response_message = "";
						        	foreach ($data_response['response'] as $dr) {
						        		$field = $data_response['response'][0]['field'];
						        		$field_part = preg_split('/(?=[A-Z])/', $field);
						        		$field = "";
						        		foreach ($field_part as $fp)
						        			$field .= ucwords($fp) . " ";
						        		$field = rtrim($field);
										$message = $data_response['response'][0]['message'];
										$response_message .= $field . " " . $message . ", ";
									}
									$response_message = rtrim($response_message, ", ");
						        } else
						        	$response_message = $data_response['response'];
						        $code = $data_response['metaData']['code'];
				            	$message = $data_response['metaData']['message'];
			            	}
			            } else if ($jenis_rujuk_vertikal == "Spesialis") {
			            	$pcare = new PCareSpesialisFaskesRujukanKhusus();
					        $pcare->setPCareAuthorization();
					        $data_response = $pcare->getListDataSpesialis($tanggal_rencana_berkunjung, $spesialis_subspesialis, $spesialis_sarana);
					        if (array_key_exists('list', $data_response['response']))
					        	$data_faskes = $data_response['response']['list'];
					        else if (count($data_response['response']) > 0) {
					        	$response_message = "";
					        	foreach ($data_response['response'] as $dr) {
					        		$field = $data_response['response'][0]['field'];
					        		$field_part = preg_split('/(?=[A-Z])/', $field);
					        		$field = "";
					        		foreach ($field_part as $fp)
					        			$field .= ucwords($fp) . " ";
					        		$field = rtrim($field);
									$message = $data_response['response'][0]['message'];
									$response_message .= $field . " " . $message . ", ";
								}
								$response_message = rtrim($response_message, ", ");
					        } else
					        	$response_message = $data_response['response'];
					        $code = $data_response['metaData']['code'];
			            	$message = $data_response['metaData']['message'];
			            }
			            $html = "";
			            if (count($data_faskes) > 0) {
			            	$nomor = 1;
			            	foreach ($data_faskes as $df) {
				            	$html 	.= "<tr>";
				            	$html 		.= "<td>" . $nomor . "</td>";
				            	$html 		.= "<td>" . $df['nmppk'] . "</td>";
				            	$html 		.= "<td>" . $df['kelas'] . "</td>";
				            	$html 		.= "<td>" . $df['nmkc'] . "</td>";
				            	$html 		.= "<td>" . $df['alamatPpk'] . "</td>";
				            	$html 		.= "<td>" . $df['telpPpk'] . "</td>";
				            	$html 		.= "<td>" . $df['distance'] . "</td>";
				            	$html 		.= "<td>" . $df['jmlRujuk'] . "</td>";
				            	$html 		.= "<td>" . $df['kapasitas'] . "</td>";
				            	$html 		.= "<td>" . $df['persentase'] . "</td>";
				            	$html 		.= "<td>" . $df['jadwal'] . "</td>";
				            	$html 		.= "<td style='display: none;'>" . $df['kdppk'] . "</td>";
				            	$html 		.= "<td class='noprint'>";
			                    $html 			.= "<div class='btn-group noprint'>";
			                    $html 				.= "<a href='#' onclick=' faskes.select(" . ($nomor - 1) . ") ' data-content='Pilih' data-toggle='popover'class='input btn btn-info '>";
			                    $html 					.= "<i class='fa fa-check'></i>";
			                    $html 				.= "</a>";
			                    $html 			.= "</div>";
			                    $html 		.= "</td>";
				            	$html 	.= "</tr>";
				            	$nomor++;
			            	}
			            } else {
			            	$html = "<tr><td colspan='12'><center>" . $response_message . "</center></td></tr>";
			            	if ($response_message == null)
			            		$html = "<tr><td colspan='12'><center>-</center></td></tr>";
			            }
			            $data = array(
			            	'html'  	=> $html,
			            	'code'		=> $code,
			            	'message'	=> $message
			            );
			            echo json_encode($data);
			            return;
					}
				}
			} else {
				if ($_POST['super_command'] == "pcare_tacc") {
					$data_tacc = array(
		            	array(
		            		'kdTacc'		=> 0,
		            		'nmTacc'		=> "Tanpa TACC",
		            		'alasanTacc'	=> "",
		            		"tipe"			=> "text",
		            		"disableAlasan"	=> 1
		            	),
		            	array(
		            		'kdTacc'		=> "1",
		            		'nmTacc'		=> "Time",
		            		'alasanTacc'	=> "
		            			<option data-type='value' data-if='0' data-selected='' data-number='1' value='< 3 Hari'>< 3 Hari</option>
		            			<option data-type='value' data-if='0' data-selected='' data-number='2' value='>= 3 - 7 Hari'>>= 3 - 7 Hari</option>
		            			<option data-type='value' data-if='0' data-selected='' data-number='3' value='>= 7 Hari'>>= 7 Hari</option>
		            		",
		            		"tipe"			=> "select",
		            		"disableAlasan"	=> 0
		            	),
		            	array(
		            		'kdTacc'		=> "2",
		            		'nmTacc'		=> "Age",
		            		'alasanTacc'	=> "
		            			<option data-type='value' data-if='0' data-selected='' data-number='1' value='< 1 Bulan'>< 1 Bulan</option>
		            			<option data-type='value' data-if='0' data-selected='' data-number='2' value='>= 1 Bulan s/d < 12 Bulan'>>= 1 Bulan s/d < 12 Bulan</option>
		            			<option data-type='value' data-if='0' data-selected='' data-number='3' value='>= 1 Tahun s/d < 5 Tahun'>>= 1 Tahun s/d < 5 Tahun</option>
		            			<option data-type='value' data-if='0' data-selected='' data-number='4' value='>= 5 Tahun s/d < 12 Tahun'>>= 5 Tahun s/d < 12 Tahun</option>
		            			<option data-type='value' data-if='0' data-selected='' data-number='5' value='>= 12 Tahun s/d < 55 Tahun'>>= 12 Tahun s/d < 55 Tahun</option>
		            			<option data-type='value' data-if='0' data-selected='' data-number='6' value='>= 55 Tahun'>>= 55 Tahun</option>
		            		",
		            		"tipe"			=> "select",
		            		"disableAlasan"	=> 0
		            	),
		            	array(
		            		'kdTacc'		=> "3",
		            		'nmTacc'		=> "Complication",
		            		'alasanTacc'	=> "",
		            		"tipe"			=> "text",
		            		"disableAlasan"	=> 1
		            	),
		            	array(
		            		'kdTacc'		=> "4",
		            		'nmTacc'		=> "Comorbidity",
		            		'alasanTacc'	=> "
		            			<option data-type='value' data-if='0' data-selected='' data-number='1' value='< 3 Hari'>< 3 Hari</option>
		            			<option data-type='value' data-if='0' data-selected='' data-number='2' value='>= 3 - 7 Hari'>>= 3 - 7 Hari</option>
		            			<option data-type='value' data-if='0' data-selected='' data-number='3' value='>= 7 Hari'>>= 7 Hari</option>
		            		",
		            		"tipe"			=> "select",
		            		"disableAlasan"	=> 0
		            	)
		            );
					if ($_POST['command'] == "list") {            
			            $response_package = new ResponsePackage();
			            $number           = (isset($_POST['number']) && $_POST['number'] != "") ? $_POST['number'] : 0;
			            $n_number         = $number;
			            $max              = 10000;
			            $total            = 5;
			            $max_page         = ceil($total / $max);
			            if ($n_number >= $max_page && $n_number != 0) {
			                $n_number       = $max_page - 1;
			            }
			            $page             = $n_number;
			            $max_page         = $max_page;
			            $list             = "";
			            $nomor            = 1 + $max * $number;
			            $index 			  = 0;
			            foreach ($data_tacc as $dt) {
			                $list         .=    "<tr>" .
			                                        "<td>" . $nomor++ . "</td>" .
			                                        "<td>" . $dt['kdTacc'] . "</td>" .
			                                        "<td>" . $dt['nmTacc'] . "</td>" .
			                                        "<td style='display: none;'>" . $dt['alasanTacc'] . "</td>" .
			                                        "<td style='display: none;'>" . $dt['tipe'] . "</td>" .
			                                        "<td style='display: none;'>" . $dt['disableAlasan'] . "</td>" .
			                                        "<td class='noprint'>" .
			                                        	"<div class='btn-group noprint'>" .
			                                        		"<a href='#' onclick=' pcare_tacc.select(" . $index++ . ") ' data-content='Pilih' data-toggle='popover'class='input btn btn-info '>" .
			                                        			"<i class='fa fa-check'></i>" .
			                                        		"</a>" . 
			                                        	"</div>" . 
			                                        "</td>" .
			                                    "</tr>";
			            }
			            $content = array(
			                'list'          => $list,
			                'pagination'    => "",
			                'number'        => $page,
			                'number_p'      => $number,
			                'total'         => $total,
			                'max_page'      => $max_page,
			                'max'           => $max
			            );
			            $response_package->setContent($content);
			            $response_package->setStatus(ResponsePackage::$STATUS_OK);
			            echo json_encode($response_package->getPackage());
			        } else if ($_POST['command'] == "get_option_alasan_tacc") {
			        	$nama_tacc = $_POST['nama_tacc'];
			            $html = "";
			            foreach ($data_tacc as $dt) {
			            	if ($dt['nmTacc'] == $nama_tacc) {
			            		$html = $dt['alasanTacc'];
			            		break;
			            	}
			            }
			            $data = array(
			            	'html' => $html
			            );
			            echo json_encode($data);
			        }
					return;
				}
			}
		}			

		$array=array ('No.','Kode TACC',"Nama TACC" );
		$tacc_table = new Table ($array);
		$tacc_table->setName ( "pcare_tacc" );
		$tacc_table->setModel ( Table::$SELECT );
		$tacc_table->setFooterVisible(false);
		$tacc_adapter = new SimpleAdapter ();
		$tacc_dbtable = new DBTable ( $this->db, "smis_mr_diagnosa" );
		$tacc_responder = new DBResponder($tacc_dbtable, $tacc_table, $tacc_adapter) ;
		
		/* PASIEN */
		$aname=array ('Nama','NRM',"No Reg" );
		$ptable = new Table ( $aname);
		$ptable->setName ( "mr_pasien" );
		$ptable->setModel ( Table::$SELECT );
		$padapter = new SimpleAdapter ();
		$padapter->add ( "Nama", "nama_pasien" );
		$padapter->add ( "NRM", "nrm", "digit8" );
		$padapter->add ( "No Reg", "id" );
		$presponder = new ServiceResponder ( $this->db, $ptable, $padapter, "get_registered" );
		
		$array=array ("Kode",'DTD','Nama',"Sebab" );
		$muitable = new Table ( $array);
		if ($this->is_jkn_member == 1 && $this->is_bridging_with_pcare == 1) {
			$array=array ("Nomor", "Kode Diagnosa", "Nama Diagnosa", "Spesialis / Non-Spesialis");
			require_once("medical_record/class/table/CustomChooserTable.php");
			$muitable = new CustomChooserTable( $array );
		}
		$muitable->setModel ( Table::$SELECT );
		$muitable->setName ( "mr_icd" );
		$madapter = new SimpleAdapter ();
		$madapter->add ( "Nama", "nama" );
		$madapter->add ( "Kode", "icd" );
		$madapter->add ( "DTD", "dtd" );
		$madapter->add ( "Sebab", "sebab" );
		$dbtable = new DBTable ( $this->db, "smis_mr_icd" );
		$mresponder = new DBResponder ( $dbtable, $muitable, $madapter );

		$array=array ("Kode",'DTD','Nama',"Sebab" );
		$msuitable = new Table ( $array);
		if ($this->is_jkn_member == 1 && $this->is_bridging_with_pcare == 1) {
			$array = array("Nomor", "Kode Diagnosa", "Nama Diagnosa", "Spesialis / Non-Spesialis");	
			require_once("medical_record/class/table/CustomChooserTable.php");
			$msuitable = new CustomChooserTable( $array );
		}
		$msuitable->setModel ( Table::$SELECT );
		$msuitable->setName ( "mr_icd_sekunder" );
		$msadapter = new SimpleAdapter ();
		$msadapter->add ( "Nama", "nama" );
		$msadapter->add ( "Kode", "icd" );
		$msadapter->add ( "DTD", "dtd" );
		$msadapter->add ( "Sebab", "sebab" );
		$dbtable = new DBTable ( $this->db, "smis_mr_icd" );
		$msresponder = new DBResponder ( $dbtable, $msuitable, $msadapter );
		
		$array=array ("Kode",'DTD','Nama',"Sebab" );
		$muitable = new Table ( $array);
		$muitable->setModel ( Table::$SELECT );
		$muitable->setName ( "mr_diagnosa_icd" );
		$madapter = new SimpleAdapter ();
		$madapter->add ( "Nama", "nama" );
		$madapter->add ( "Kode", "icd" );
		$madapter->add ( "DTD", "dtd" );
		$madapter->add ( "Sebab", "sebab" );
		$dbtable = new DBTable ( $this->db, "smis_mr_icd" );
		$mr_mresponder = new DBResponder ( $dbtable, $muitable, $madapter );

		$array=array ("Kode",'DTD','Nama',"Sebab" );
		$pcare_alasan_tacc_table = new Table ( $array);
		if ($this->is_jkn_member == 1 && $this->is_bridging_with_pcare == 1) {
			$array=array ("Nomor", "Kode Diagnosa", "Nama Diagnosa", "Spesialis / Non-Spesialis");
			require_once("medical_record/class/table/CustomChooserTable.php");
			$pcare_alasan_tacc_table = new CustomChooserTable( $array );
		}
		$pcare_alasan_tacc_table->setModel ( Table::$SELECT );
		$pcare_alasan_tacc_table->setName ( "pcare_alasan_tacc" );
		$pcare_alasan_tacc_adapter = new SimpleAdapter ();
		$pcare_alasan_tacc_adapter->add ( "Nama", "nama" );
		$pcare_alasan_tacc_adapter->add ( "Kode", "icd" );
		$pcare_alasan_tacc_adapter->add ( "DTD", "dtd" );
		$pcare_alasan_tacc_adapter->add ( "Sebab", "sebab" );
		$dbtable = new DBTable ( $this->db, "smis_mr_icd" );
		$pcare_alasan_tacc_responder = new DBResponder ( $dbtable, $pcare_alasan_tacc_table, $pcare_alasan_tacc_adapter );

		$array = array("No.", "No. Resep", "Tanggal", "Dokter");
		$terapi_obat_table = new Table($array);
		$terapi_obat_table->setModel ( Table::$SELECT );
		$terapi_obat_table->setName ( "terapi_obat" );
		$terapi_obat_adapter = new SimpleAdapter(true, "No.");
		$terapi_obat_adapter->add ( "No. Resep", "nomor_resep" );
		$terapi_obat_adapter->add ( "Tanggal", "tanggal", "date d-m-Y, H:i" );
		$terapi_obat_adapter->add ( "Dokter", "nama_dokter" );
		$dbtable = new DBTable( $this->db, "smis_dfm_penjualan_resep" );
		require_once("medical_record/class/responder/TerapiObatDBResponder.php");
		$terapi_obat_dbresponder = new TerapiObatDBResponder( $dbtable, $terapi_obat_table, $terapi_obat_adapter );
		
		$super = new SuperCommand ();
		$super->addResponder ( "pcare_tacc", $tacc_responder );
		$super->addResponder ( "terapi_obat", $terapi_obat_dbresponder );
		
		if ($this->is_jkn_member == 1 && $this->is_bridging_with_pcare == 1) {
			$array=array ('Nomor','Kode Dokter','Nama Dokter');
			$dktable = new Table ($array);
			$dktable->setName ( "mr_dokter" );
			$dktable->setModel ( Table::$SELECT );
			$dktable->setFooterVisible(false);
			$dkadapter = new SimpleAdapter ();
			$dkadapter->add ( "Jabatan", "nama_jabatan" );
			$dkadapter->add ( "Nama", "nama" );
			$dkadapter->add ( "NIP", "nip" );
			$dkresponder = new EmployeeResponder($this->db, $dktable, $dkadapter, "dokter") ;
			$super->addResponder ( "mr_dokter", $dkresponder );
		} else {
			require_once("hrd/class/responder/EmployeeChooserResponder.php");
			$dkresponder = new EmployeeChooserResponder($this->db, "mr_dokter", "dokter");
			$super->addResponder("mr_dokter", $dkresponder);
		}

		$super->addResponder ( "mr_pasien", $presponder );
		$super->addResponder ( "mr_icd", $mresponder );
		$super->addResponder ( "mr_icd_sekunder", $msresponder );
		$super->addResponder ( "mr_diagnosa_icd", $mr_mresponder );
		$super->addResponder ( "pcare_alasan_tacc", $pcare_alasan_tacc_responder );
		$init = $super->initialize ();
		if ($init != null) {
			echo $init;
			return;
		}
	}
}

?>