<?php
require_once ('smis-framework/smis/template/ModulTemplate.php');
require_once ("smis-base/smis-include-service-consumer.php");
require_once ('smis-libs-hrd/EmployeeResponder.php');

class LaporanSuntikKBTemplate extends ModulTemplate {
	protected $db;
	protected $polislug;
	protected $page;
	protected $protoslug;
	protected $protoname;
	protected $protoimplement;
	protected $action;
	protected $dbtable;
	protected $uitable;
	protected $noreg_pasien;
	protected $nama_pasien;
	protected $nrm_pasien;
	protected $no_bpjs;

	public function __construct(
		$db, 
		$noreg = "", 
		$nrm = "", 
		$nama = "",
		$no_bpjs = "",
		$alamat_pasien = "",
		$polislug = "",
		$page = "medical_record", 
		$action = "lap_suntik_kb", 
		$protoslug = "", 
		$protoname = "", 
		$protoimplement = ""
	) {
		$this->db = $db;
		$this->noreg_pasien = $noreg;
		$this->nrm_pasien = $nrm;
		$this->nama_pasien = $nama;
		$this->no_bpjs = $no_bpjs;
		$this->alamat_pasien = $alamat_pasien;
		$this->polislug = $polislug;
		$this->dbtable = new DBTable ( $this->db, "smis_mr_suntik_kb" );
		$this->page = $page;
		$this->protoslug = $protoslug;
		$this->protoimplement = $protoimplement;
		$this->protoname = $protoname;
		$this->action = $action;
		$this->dbtable->addCustomKriteria ( "noreg_pasien", "='" . $noreg . "'" );
		$this->dbtable->addCustomKriteria ( "ruangan", "='" . $polislug . "'" );
		$this->uitable = new Table( 
			array ("No. Reg.", "NRM", "No. BPJS", "Nama Pasien", "Alamat", "Jenis KB"), 
			"Maternal - Neonatal " . ($this->polislug == "all" ? "" : ucfirst ( $this->protoname )), 
			null, 
			true 
		);
		$this->uitable->setName ( $action );
	}
    
	public function command($command) {
		if ($_POST['command'] == "save") {
			$noreg_pasien = $_POST['noreg_pasien'];
			$ruangan = $_POST['ruangan'];
			$row = $this->db->get_row("
				SELECT *
				FROM smis_mr_suntik_kb 
				WHERE prop = '' AND noreg_pasien = '" . $noreg_pasien . "' AND ruangan = '" . $ruangan . "'
			");
			if ($row != null)
				$_POST['id'] = $row->id;
		}

        require_once ("smis-base/smis-include-duplicate.php");
		$adapter = new SimpleAdapter ();
		$adapter->add ( "No. Reg.", "noreg_pasien" );
		$adapter->add ( "NRM", "nrm_pasien", "digit6" );
		$adapter->add ( "No. BPJS", "no_bpjs" );
		$adapter->add ( "Nama Pasien", "nama_pasien" );
		$adapter->add ( "Alamat", "alamat_pasien" );
		$adapter->add ( "Jenis KB", "jenis_kb" );
		$dbres = new DuplicateResponder ( $this->dbtable, $this->uitable, $adapter );
		$dbres->setDuplicate(false,"");
        $dbres->setAutonomous(getSettings($this->db,"smis_autonomous_id",""));
        $data = $dbres->command ( $_POST ['command'] );
		echo json_encode ( $data );
		return;
	}
    
	public function phpPreLoad() {
		$the_row = array ();
		$the_row ['tanggal'] = date ( "Y-m-d" );
        $the_row ['noreg_pasien'] = $this->noreg_pasien;
        $the_row ['nrm_pasien'] = $this->nrm_pasien;
        $the_row ['no_bpjs'] = $this->no_bpjs;
        $the_row ['alamat_pasien'] = $this->alamat_pasien;
        $the_row ['dokter'] = "";
        $the_row ['perawat'] = "";
        $the_row ['jenis_kb'] = "";
        $the_row ['id'] = "";
		
		$row = $this->db->get_row("
			SELECT *
			FROM smis_mr_suntik_kb
			WHERE prop = '' AND noreg_pasien = '" . $this->noreg_pasien . "'
		");
		if ($row != null) {
			$the_row ['tanggal'] = $row->tanggal;
	        $the_row ['dokter'] = $row->dokter;
	        $the_row ['perawat'] = $row->perawat;
	        $the_row ['jenis_kb'] = $row->jenis_kb;
			$the_row ["id"] = $row->id;
		}
				
		$this->uitable->addModal ( "nama_pasien", "hidden", "", $this->nama_pasien, "n", null, true );
		$this->uitable->addModal ( "nrm_pasien", "hidden", "", $this->nrm_pasien, "n", null, true );
		$this->uitable->addModal ( "noreg_pasien", "hidden", "", $this->noreg_pasien, "n", null, true );
        $this->uitable->addModal ( "no_bpjs", "hidden", "", $this->no_bpjs, "n", null, true );
        $this->uitable->addModal ( "alamat_pasien", "hidden", "", $this->alamat_pasien, "n", null, true );
        $this->uitable->addModal ( "ruangan", "hidden", "", $this->polislug, "n", null, true );
		$this->uitable->addModal ( "id", "hidden", "", $the_row ['id'] );
		$this->uitable->addModal ( "tanggal", "date", "Tanggal", $the_row ['tanggal'] );
		$jenis_kb_option = new OptionBuilder();
		if ($the_row ['jenis_kb'] == "KB 3 Bulan")
			$jenis_kb_option->add("KB 3 Bulan", "KB 3 Bulan", "1");
		else
			$jenis_kb_option->add("KB 3 Bulan", "KB 3 Bulan");
		if ($the_row ['jenis_kb'] == "IUD")
			$jenis_kb_option->add("IUD", "IUD", "1");
		else
			$jenis_kb_option->add("IUD", "IUD");
		if ($the_row ['jenis_kb'] == "IMPLANT")
			$jenis_kb_option->add("IMPLANT", "IMPLANT", "1");
		else
			$jenis_kb_option->add("IMPLANT", "IMPLANT");
		$this->uitable->addModal ( "jenis_kb", "select", "Jenis KB", $jenis_kb_option->getContent() );
		$this->uitable->addModal ( "dokter", "chooser-".$this->action."-lskb_dokter-Dokter", "Dokter", $the_row ['dokter'], "n", null, true );
		$this->uitable->addModal ( "perawat", "chooser-".$this->action."-lskb_perawat-Perawat", "Perawat", $the_row ['perawat'], "n", null, true );
			
		$modal = $this->uitable->getModal ();
		$modal->setTitle ( "Laporan Suntik KB" );
		$modal->setAlwaysShow ( true );
		echo "<div class='hide'>" . $this->uitable->getHtml () . "</div>";
		echo $modal->joinFooterAndForm ()->getHtml ();
	}
    
	public function jsLoader() {
		echo addJS ( "framework/bootstrap/js/bootstrap-datepicker.js" );
		echo addJS ( "framework/smis/js/table_action.js" );
		
		loadLibrary ( "smis-libs-function-javascript" );
	}
    
	public function cssLoader() {
		echo addCSS ( "framework/bootstrap/css/datepicker.css" );
	}
    
	public function cssPreLoad() {
		?>
		<style type="text/css">
		#<?php echo $this->action;?>_add_form_form>div { clear: both; width: 100%;}
		#<?php echo $this->action;?>_add_form_form>div label { width: 250px;}
		</style>
		<?php
	}
	
	/* when it's star build */
	public function jsPreLoad() {
		?>
		<script type="text/javascript">
		var <?php echo $this->action; ?>;
		var lskb_pasien;
		var lskb_noreg = "<?php echo $this->noreg_pasien; ?>";
		var lskb_nama_pasien = "<?php echo $this->nama_pasien; ?>";
		var lskb_nrm_pasien = "<?php echo $this->nrm_pasien; ?>";
		var lskb_polislug = "<?php echo $this->polislug; ?>";
		var lskb_the_page = "<?php echo $this->page; ?>";
		var lskb_the_protoslug = "<?php echo $this->protoslug; ?>";
		var lskb_the_protoname = "<?php echo $this->protoname; ?>";
		var lskb_the_protoimplement = "<?php echo $this->protoimplement; ?>";
		var lskb_prefix = "<?php echo $this->action; ?>";
		var lskb_dokter;
		var lskb_perawat;
		
		$(document).ready(function() {			
			$(".mydate").datepicker();			
			var column=new Array(
				"id","tanggal", "ruangan",
				"nama_pasien","noreg_pasien","nrm_pasien","no_bpjs", "alamat_pasien",
				"dokter", "perawat", "jenis_kb"
			);
			<?php echo $this->action; ?> = new TableAction("<?php echo $this->action; ?>", lskb_the_page, "<?php echo $this->action; ?>", column);
			<?php echo $this->action; ?>.setPrototipe(lskb_the_protoname, lskb_the_protoslug, lskb_the_protoimplement);
			<?php echo $this->action; ?>.getRegulerData = function() {
				var reg_data = {	
					page : this.page,
					action : this.action,
					super_command : this.super_command,
					prototype_name : this.prototype_name,
					prototype_slug : this.prototype_slug,
					prototype_implement : this.prototype_implement,
					polislug : lskb_polislug,
					noreg_pasien : lskb_noreg,
					nama_pasien : lskb_nama_pasien,
					nrm_pasien : lskb_nrm_pasien
				};
				return reg_data;
			};
			<?php echo $this->action . ".clear=function(){return;};"; ?>
			lskb_dokter = new TableAction("lskb_dokter", lskb_the_page, lskb_prefix, new Array());
			lskb_dokter.setSuperCommand("lskb_dokter");
			lskb_dokter.setPrototipe(lskb_the_protoname, lskb_the_protoslug, lskb_the_protoimplement);
			lskb_dokter.selected = function(json) {
				$("#" + lskb_prefix +"_dokter").val(json.nama);
			};
			lskb_perawat = new TableAction("lskb_perawat", lskb_the_page, lskb_prefix, new Array());
			lskb_perawat.setSuperCommand("lskb_perawat");
			lskb_perawat.setPrototipe(lskb_the_protoname, lskb_the_protoslug, lskb_the_protoimplement);
			lskb_perawat.selected = function(json) {
				$("#" + lskb_prefix +"_perawat").val(json.nama);
			};
		});
		</script>
<?php
	}
    
	public function superCommand($super_command) {
		$super = new SuperCommand ();
		if ($super_command=="lskb_dokter") {
            $eadapt = new SimpleAdapter ();
            $eadapt->add ( "Jabatan", "nama_jabatan" );
            $eadapt->add ( "Nama", "nama" );
            $eadapt->add ( "NIP", "nip" );
            $head_karyawan = array ('Nama','Jabatan',"NIP");
            $dktable = new Table ( $head_karyawan, "", NULL, true );
            $dktable->setName ( $super_command );
            $dktable->setModel ( Table::$SELECT );
            $employee = new EmployeeResponder ( $this->db, $dktable, $eadapt, "dokter" );
            $super->addResponder ( $super_command, $employee );
        }
        if ($super_command=="lskb_perawat") {
            $eadapt = new SimpleAdapter ();
            $eadapt->add ( "Jabatan", "nama_jabatan" );
            $eadapt->add ( "Nama", "nama" );
            $eadapt->add ( "NIP", "nip" );
            $head_karyawan = array ('Nama','Jabatan',"NIP");
            $dktable = new Table ( $head_karyawan, "", NULL, true );
            $dktable->setName ( $super_command );
            $dktable->setModel ( Table::$SELECT );
            $employee = new EmployeeResponder ( $this->db, $dktable, $eadapt, "perawat" );
            $super->addResponder ( $super_command, $employee );
        }
        
		$init = $super->initialize ();
		if ($init != null) {
			echo $init;
			return;
		}
	}
}

?>