<?php
require_once 'smis-framework/smis/template/ModulTemplate.php';
require_once ("smis-base/smis-include-service-consumer.php");
require_once "medical_record/class/service/RuanganService.php";
require_once 'smis-libs-hrd/EmployeeResponder.php';
class LaporanRL310Template extends ModulTemplate {
	protected $db;
	protected $polislug;
	protected $page;
	protected $protoslug;
	protected $protoname;
	protected $protoimplement;
	protected $action;
	protected $dbtable;
	protected $uitable;
	protected $noreg_pasien;
	protected $nama_pasien;
	protected $nrm_pasien;
	protected $alamat;
	protected $umur;
	protected $jk;
	protected $ruang_asal;
	protected $id_antrian;
	public function __construct($db, $polislug = "all", $noreg = "", $nrm = "", $nama = "", $alamat = "", $umur = "", $jk = "0", $id_antrian = "0", $ruang_asal = "", $page = "medical_record", $action = "lap_gigimulut", $protoslug = "", $protoname = "", $protoimplement = "") {
		$this->db = $db;
		$this->noreg_pasien = $noreg;
		$this->id_antrian = $id_antrian;
		
		$this->nama_pasien = $nama;
		$this->nrm_pasien = $nrm;
		$this->alamat = $alamat;
		$this->umur = $umur;
		$this->jk = $jk;
		$this->ruang_asal = $ruang_asal;
		$this->polislug = $polislug;
		$this->dbtable = new DBTable ( $this->db, "smis_mr_pkhusus" );
		$this->page = $page;
		$this->protoslug = $protoslug;
		$this->protoimplement = $protoimplement;
		$this->protoname = $protoname;
		$this->action = $action;
		if ($polislug != "all")
			$this->dbtable->addCustomKriteria ( "ruangan", "='" . $polislug . "'" );
		if ($noreg != "")
			$this->dbtable->addCustomKriteria ( "noreg_pasien", "='" . $noreg . "'" );
		$head=array ('NRM',"Pasien","No Register" );
		$this->uitable = new Table ($head , " Indikator " . ($this->polislug == "all" ? "" : ucfirst ( $this->protoname )), NULL, true );
		$this->uitable->setName ( $action );
		
		if ($this->page == "medical_record" && $this->action == "lap_operasi") {
			$this->uitable->setAddButtonEnable ( false );
			$this->uitable->setDelButtonEnable ( false );
		}
	}
	
	
	
	public function command($command) {
		$adapter = new SimpleAdapter ();
		$adapter->add ( "Pasien", "nama_pasien" );
		$adapter->add ( "NRM", "nrm_pasien", "digit8" );
		$adapter->add ( "No Register", "noreg_pasien", "digit8" );
		$dbres = new DBResponder ( $this->dbtable, $this->uitable, $adapter );
		$data = $dbres->command ( $_POST ['command'] );
		echo json_encode ( $data );
		return;
	}
	public function phpPreLoad() {
		
		if ($this->noreg_pasien != "") {
			$this->uitable->addModal ( "nama_pasien", "hidden", "", $this->nama_pasien, "n", null, true );
			$this->uitable->addModal ( "nrm_pasien", "hidden", "", $this->nrm_pasien, "n", null, true );
			$this->uitable->addModal ( "noreg_pasien", "hidden", "", $this->noreg_pasien, "n", null, true );
			$this->uitable->addModal ( "alamat", "hidden", "", $this->alamat, "n", null, true );
			$this->uitable->addModal ( "jk", "hidden", "", $this->jk, "n", null, true );
			$this->uitable->addModal ( "umur", "hidden", "", $this->umur, "n", null, true );
			$this->uitable->addModal ( "ruang_asal", "hidden", "", $this->ruang_asal, "n", null, true );
		} else {
			$this->uitable->addModal ( "nama_pasien", "chooser-" . $this->action . "-rl310_pasien", "Pasien", $this->nama_pasien, "n", null, true );
			$this->uitable->addModal ( "nrm_pasien", "text", "NRM", $this->nrm_pasien, "n", null, true );
			$this->uitable->addModal ( "noreg_pasien", "text", "No Reg", $this->noreg_pasien, "n", null, true );
		}
		if ($this->polislug == "all"){
			$service = new RuanganService ( $this->db );
			$service->execute ();
			$ruangan = $service->getContent ();
			$this->uitable->addModal ( "ruangan", "select", "Asal Ruangan", $ruangan );
		}else{
			$this->uitable->addModal ( "ruangan", "hidden", "", $this->polislug, "n", null, true );
		}
		$the_row = array ();
		$the_row ['eeg'] 				= "";
		$the_row ['ekg']				= "";
		$the_row ['emg'] 				= "";
		$the_row ['ecg'] 				= "";
		$the_row ['endoskopi'] 			= "";
		$the_row ['hemodialisa'] 		= "";
		$the_row ['densometri_tulang'] 	= "";
		$the_row ['koreksi_fraktur'] 	= "";
		$the_row ['pungsi'] 			= "";
		$the_row ['spirometri'] 		= "";
		$the_row ['tes_kulit'] 			= "";
		$the_row ['topometri'] 			= "";
		$the_row ['tredmil'] 			= "";
		$the_row ['akupuntur'] 			= "";
		$the_row ['hiperbarik'] 		= "";
		$the_row ['herbal'] 			= "";
		$the_row ['lain'] 				= "";
		$the_row ["id"] 				= "";
		$the_row ['tanggal'] 			= date ( "Y-m-d" );
		
		$exist ['noreg_pasien'] = $this->noreg_pasien;
		$exist ['nama_pasien'] = $this->nama_pasien;
		$exist ['nrm_pasien'] = $this->nrm_pasien;
		$exist ['ruangan'] = $this->polislug;
		if ($this->dbtable->is_exist ( $exist )) {
			$row = $this->dbtable->select ( $exist );
			$the_row ['eeg'] 				= $row->eeg;
			$the_row ['ekg']				= $row->ekg;
			$the_row ['emg'] 				= $row->emg;
			$the_row ['ecg'] 				= $row->ecg;
			$the_row ['endoskopi'] 			= $row->endoskopi;
			$the_row ['hemodialisa'] 		= $row->hemodialisa;
			$the_row ['densometri_tulang']  = $row->densometri_tulang;
			$the_row ['pungsi'] 			= $row->pungsi;
			$the_row ['spirometri'] 		= $row->spirometri;
			$the_row ['tes_kulit'] 			= $row->tes_kulit;
			$the_row ['topometri'] 			= $row->topometri;
			$the_row ['tredmil'] 			= $row->tredmil;
			$the_row ['akupuntur'] 			= $row->akupuntur;
			$the_row ['hiperbarik'] 		= $row->hiperbarik;
			$the_row ['herbal'] 			= $row->herbal;
			$the_row ['lain'] 				= $row->lain;
			$the_row ['koreksi_fraktur'] 	= $row->koreksi_fraktur;
			$the_row ["id"] 				= $row->id;
			$the_row ['tanggal'] 			= $row->tanggal;
		} else {
			$exist ['umur'] = $this->umur;
			$exist ['jk'] = $this->jk;
			$exist ['alamat'] = $this->alamat;
			$exist ['noreg_pasien'] = $this->noreg_pasien;
			$exist ['nrm_pasien'] = $this->nrm_pasien;
			$exist ['nama_pasien'] = $this->nama_pasien;
			$exist ['tanggal'] = date ( "Y-m-d" );
			$this->dbtable->insert ( $exist );
			$the_row ["id"] = $this->dbtable->get_inserted_id ();
		}
				
		$this->uitable->addModal ( "id", "hidden", "", $the_row ['id'] );
		$this->uitable->addModal ( "tanggal", "date", "Tanggal", $the_row ['tanggal'] ,"y",null,false,null,false,"eeg");
		$this->uitable->addModal ( "eeg", "checkbox", "Elektro Encephalografi (EEG)", $the_row ['eeg'] ,"y",null,false,null,false,"ekg");
		$this->uitable->addModal ( "ekg", "checkbox", "Elektro Kardiographi (EKG)", $the_row ['ekg'] ,"y",null,false,null,false,"emg");
		$this->uitable->addModal ( "emg", "checkbox", "Elektro Myographi (EMG)", $the_row ['emg'] ,"y",null,false,null,false,"ecg");
		$this->uitable->addModal ( "ecg", "checkbox", "Echo Cardiographi (ECG)", $the_row ['ecg'] ,"y",null,false,null,false,"endoskopi");
		$this->uitable->addModal ( "endoskopi", "checkbox", "Endoskopi", $the_row ['endoskopi'] ,"y",null,false,null,false,"hemodialisa");
		$this->uitable->addModal ( "hemodialisa", "checkbox", "Hemodialisa", $the_row ['hemodialisa'] ,"y",null,false,null,false,"densometri_tulang");
		$this->uitable->addModal ( "densometri_tulang", "checkbox", "Densometri Tulang", $the_row ['densometri_tulang'] ,"y",null,false,null,false,"koreksi_fraktur");
		$this->uitable->addModal ( "koreksi_fraktur", "checkbox", "Koreksi Fraktur/Dislokasi non Bedah", $the_row ['koreksi_fraktur'] ,"y",null,false,null,false,"pungsi");
		$this->uitable->addModal ( "pungsi", "checkbox", "Pungsi", $the_row ['pungsi'] ,"y",null,false,null,false,"spirometri");
		$this->uitable->addModal ( "spirometri", "checkbox", "Spirometri", $the_row ['spirometri'] ,"y",null,false,null,false,"topometri");
		$this->uitable->addModal ( "tes_kulit", "checkbox", "Tes Kulit/Alergi/Histamin", $the_row ['tes_kulit'] ,"y",null,false,null,false,"orthodonti");
		$this->uitable->addModal ( "topometri", "checkbox", "Topometri", $the_row ['topometri'] ,"y",null,false,null,false,"tredmil");
		$this->uitable->addModal ( "tredmil", "checkbox", "Tredmill/ Exercise Test", $the_row ['tredmil'] ,"y",null,false,null,false,"akupuntur");
		$this->uitable->addModal ( "akupuntur", "checkbox", "Akupuntur", $the_row ['akupuntur'] ,"y",null,false,null,false,"hiperbarik");
		$this->uitable->addModal ( "hiperbarik", "checkbox", "Hiperbarik", $the_row ['hiperbarik'],"y",null,false,null,true,"herbal" );
		$this->uitable->addModal ( "herbal", "checkbox", "Herbal / jamu", $the_row ['herbal'],"y",null,false,null,false,"lain");
		$this->uitable->addModal ( "lain", "checkbox", "Lain-Lain", $the_row ['lain'],"y",null,false,null,false,"save");
		
		$modal = $this->uitable->getModal ();
		$modal->setTitle ( "Laporan RL 3.10 - Pelayanan Khusus" );
		if ($this->page == "medical_record" && $this->action == "iklin") {
			echo $this->uitable->getHtml ();
		} else {
			echo "<div class='hide'>" . $this->uitable->getHtml () . "</div>";
			$modal->setAlwaysShow ( true );
		}
		echo $modal->joinFooterAndForm ()->getHtml ();
	}
	public function jsLoader() {
		echo addJS ( "framework/bootstrap/js/bootstrap-datepicker.js" );
		echo addJS ( "framework/smis/js/table_action.js" );
		loadLibrary ( "smis-libs-function-javascript" );
	}
	
	public function cssLoader() {
		echo addCSS ( "framework/bootstrap/css/datepicker.css" );
	}
	
	public function cssPreLoad() {
		?>
		<style type="text/css">
				#<?php echo $this->action;?>_add_form_form>div {clear: both; width: 100%;}
				#<?php echo $this->action; ?>_add_form_form>div label { width: 250px; }
		</style>
		<?php
	}
	
	/* when it's star build */
	public function jsPreLoad() {
		?>
		<script type="text/javascript">
		var <?php echo $this->action; ?>;
		var rl310_pasien;
		var rl310_noreg="<?php echo $this->noreg_pasien; ?>";
		var rl310_nama_pasien="<?php echo $this->nama_pasien; ?>";
		var rl310_nrm_pasien="<?php echo $this->nrm_pasien; ?>";
		var rl310_polislug="<?php echo $this->polislug; ?>";
		var rl310_the_page="<?php echo $this->page; ?>";
		var rl310_the_protoslug="<?php echo $this->protoslug; ?>";
		var rl310_the_protoname="<?php echo $this->protoname; ?>";
		var rl310_the_protoimplement="<?php echo $this->protoimplement; ?>";
		var rl310_id_antrian="<?php echo $this->id_antrian; ?>";
		var rl310_action="<?php echo $this->action; ?>";
		$(document).ready(function() {
			$('.mydate').datepicker();
			rl310_pasien=new TableAction("rl310_pasien",rl310_the_page,rl310_action,new Array());
			rl310_pasien.setSuperCommand("rl310_pasien");
			rl310_pasien.setPrototipe(rl310_the_protoname,rl310_the_protoslug,rl310_the_protoimplement);
			rl310_pasien.selected=function(json){
				var nama=json.nama_pasien;
				var nrm=json.nrm;
				var noreg=json.id;		
				$("#"+rl310_action+"_nama_pasien").val(nama);
				$("#"+rl310_action+"_nrm_pasien").val(nrm);
				$("#"+rl310_action+"_noreg_pasien").val(noreg);
			};
			
			var column=new Array(
					"id","tanggal","ruangan",
					'eeg','ekg','emg','ecg','endoskopi','hemodialisa',
					'densometri_tulang','koreksi_fraktur','pungsi',
					'spirometri','tes_kulit','topometri','tredmil','akupuntur',
					'hiperbarik','herbal','lain'
					);
			<?php echo $this->action; ?>=new TableAction("<?php echo $this->action; ?>",rl310_the_page,"<?php echo $this->action; ?>",column);
			<?php echo $this->action; ?>.setPrototipe(rl310_the_protoname,rl310_the_protoslug,rl310_the_protoimplement);
			<?php echo $this->action; ?>.getRegulerData=function(){
				var reg_data={	
						page:this.page,
						action:this.action,
						super_command:this.super_command,
						prototype_name:this.prototype_name,
						prototype_slug:this.prototype_slug,
						prototype_implement:this.prototype_implement,
						polislug:rl310_polislug,
						noreg_pasien:rl310_noreg,
						nama_pasien:rl310_nama_pasien,
						nrm_pasien:rl310_nrm_pasien,
						id_antrian:rl310_id_antrian
						};
				return reg_data;
			};

			<?php echo $this->action; ?>.setNextEnter();
			<?php echo $this->action; ?>.setEnableAutofocus(true);
			<?php
		
			if ($this->page == "medical_record" && $this->action == "iklin") {
				echo $this->action;
				?>.view();<?php
			} else {
				echo $this->action . ".clear=function(){return;};";
			}
			?>
		});
		</script>
<?php
	}
	public function superCommand($super_command) {
		/* PASIEN */
		$super = new SuperCommand ();
		
		$phead=array ('Nama','NRM',"No Reg" );
		$ptable = new Table ( $phead, "", NULL, true );
		$ptable->setName ( "rl310_pasien" );
		$ptable->setModel ( Table::$SELECT );
		$padapter = new SimpleAdapter ();
		$padapter->add ( "Nama", "nama_pasien" );
		$padapter->add ( "NRM", "nrm", "digit8" );
		$padapter->add ( "No Reg", "id" );
		$presponder = new ServiceResponder ( $this->db, $ptable, $padapter, "get_registered" );		
		$super->addResponder ( "rl310_pasien", $presponder );
		$init = $super->initialize ();
		if ($init != null) {
			echo $init;
			return;
		}
	}
}

?>