<?php
require_once ('smis-framework/smis/template/ModulTemplate.php');
require_once ("smis-base/smis-include-service-consumer.php");
require_once ('smis-libs-hrd/EmployeeResponder.php');

class LaporanMaternalNeonatalTemplate extends ModulTemplate {
	protected $db;
	protected $polislug;
	protected $page;
	protected $protoslug;
	protected $protoname;
	protected $protoimplement;
	protected $action;
	protected $dbtable;
	protected $uitable;
	protected $noreg_pasien;
	protected $nama_pasien;
	protected $nrm_pasien;
	protected $no_bpjs;

	public function __construct(
		$db, 
		$noreg = "", 
		$nrm = "", 
		$nama = "",
		$no_bpjs = "",
		$alamat_pasien = "",
		$polislug = "",
		$page = "medical_record", 
		$action = "lap_maternal_neonatal", 
		$protoslug = "", 
		$protoname = "", 
		$protoimplement = ""
	) {
		$this->db = $db;
		$this->noreg_pasien = $noreg;
		$this->nrm_pasien = $nrm;
		$this->nama_pasien = $nama;
		$this->no_bpjs = $no_bpjs;
		$this->alamat_pasien = $alamat_pasien;
		$this->polislug = $polislug;
		$this->dbtable = new DBTable ( $this->db, "smis_mr_maternal_neonatal" );
		$this->page = $page;
		$this->protoslug = $protoslug;
		$this->protoimplement = $protoimplement;
		$this->protoname = $protoname;
		$this->action = $action;
		$this->dbtable->addCustomKriteria ( "noreg_pasien", "='" . $noreg . "'" );
		$this->dbtable->addCustomKriteria ( "ruangan", "='" . $polislug . "'" );
		$this->uitable = new Table( 
			array ("No. Reg.", "NRM", "No. BPJS", "Nama Pasien", "Alamat", "Status"), 
			"Maternal - Neonatal " . ($this->polislug == "all" ? "" : ucfirst ( $this->protoname )), 
			null, 
			true 
		);
		$this->uitable->setName ( $action );
	}
    
	public function command($command) {
		if ($_POST['command'] == "save") {
			$noreg_pasien = $_POST['noreg_pasien'];
			$ruangan = $_POST['ruangan'];
			$row = $this->db->get_row("
				SELECT *
				FROM smis_mr_maternal_neonatal 
				WHERE prop = '' AND noreg_pasien = '" . $noreg_pasien . "' AND ruangan = '" . $ruangan . "'
			");
			if ($row != null)
				$_POST['id'] = $row->id;
		}

        require_once ("smis-base/smis-include-duplicate.php");
		$adapter = new SimpleAdapter ();
		$adapter->add ( "No. Reg.", "noreg_pasien" );
		$adapter->add ( "NRM", "nrm_pasien", "digit6" );
		$adapter->add ( "No. BPJS", "no_bpjs" );
		$adapter->add ( "Nama Pasien", "nama_pasien" );
		$adapter->add ( "Alamat", "alamat_pasien" );
		$adapter->add ( "Status", "status" );
		$dbres = new DuplicateResponder ( $this->dbtable, $this->uitable, $adapter );
		$dbres->setDuplicate(false,"");
        $dbres->setAutonomous(getSettings($this->db,"smis_autonomous_id",""));
        $data = $dbres->command ( $_POST ['command'] );
		echo json_encode ( $data );
		return;
	}
    
	public function phpPreLoad() {
		$the_row = array ();
		$the_row ['tanggal'] = date ( "Y-m-d" );
        $the_row ['noreg_pasien'] = $this->noreg_pasien;
        $the_row ['nrm_pasien'] = $this->nrm_pasien;
        $the_row ['no_bpjs'] = $this->no_bpjs;
        $the_row ['alamat_pasien'] = $this->alamat_pasien;
        $the_row ['status'] = "";
        $the_row ['tenaga_medis'] = "";
        $the_row ['jenis_layanan'] = "";
        $the_row ['biaya'] = 0;
		
		$row = $this->db->get_row("
			SELECT *
			FROM smis_mr_maternal_neonatal
			WHERE prop = '' AND noreg_pasien = '" . $this->noreg_pasien . "'
		");
		if ($row != null) {
			$the_row ['tanggal'] = $row->tanggal;
            $the_row ['status'] = $row->status;
	        $the_row ['tenaga_medis'] = $row->tenaga_medis;
	        $the_row ['jenis_layanan'] = $row->jenis_layanan;
	        $the_row ['biaya'] = $row->biaya;          
			$the_row ["id"] = $row->id;
		}
				
		$this->uitable->addModal ( "nama_pasien", "hidden", "", $this->nama_pasien, "n", null, true );
		$this->uitable->addModal ( "nrm_pasien", "hidden", "", $this->nrm_pasien, "n", null, true );
		$this->uitable->addModal ( "noreg_pasien", "hidden", "", $this->noreg_pasien, "n", null, true );
        $this->uitable->addModal ( "no_bpjs", "hidden", "", $this->no_bpjs, "n", null, true );
        $this->uitable->addModal ( "alamat_pasien", "hidden", "", $this->alamat_pasien, "n", null, true );
        $this->uitable->addModal ( "ruangan", "hidden", "", $this->polislug, "n", null, true );
		$this->uitable->addModal ( "id", "hidden", "", $the_row ['id'] );
		$this->uitable->addModal ( "tanggal", "date", "Tanggal", $the_row ['tanggal'] );
		$status_option = new OptionBuilder();
		if ($the_row ['status'] == "P")
			$status_option->add("P", "P", "1");
		else
			$status_option->add("P", "P");
		if ($the_row ['status'] == "I")
			$status_option->add("I", "I", "1");
		else
			$status_option->add("I", "I");
		if ($the_row ['status'] == "S")
			$status_option->add("S", "S", "1");
		else
			$status_option->add("S", "S");
		if ($the_row ['status'] == "A")
			$status_option->add("A", "A", "1");
		else
			$status_option->add("A", "A");
		$this->uitable->addModal ( "status", "select", "Status", $status_option->getContent() );
		$this->uitable->addModal ( "tenaga_medis", "chooser-".$this->action."-lmn_tenaga_medis-Tenaga Medis", "Tenaga Medis", $the_row ['tenaga_medis'], "n", null, true );
		$jenis_layanan_option = new OptionBuilder();
		if ($the_row ['jenis_layanan'] == "ANC 1")
			$jenis_layanan_option->add("ANC 1", "ANC 1", "1");
		else
			$jenis_layanan_option->add("ANC 1", "ANC 1");
		if ($the_row ['jenis_layanan'] == "ANC 2")
			$jenis_layanan_option->add("ANC 2", "ANC 2", "1");
		else
			$jenis_layanan_option->add("ANC 2", "ANC 2");
		if ($the_row ['jenis_layanan'] == "ANC 3")
			$jenis_layanan_option->add("ANC 3", "ANC 3", "1");
		else
			$jenis_layanan_option->add("ANC 3", "ANC 3");
        $this->uitable->addModal ( "jenis_layanan", "select", "Jenis Layanan", $jenis_layanan_option->getContent() );
        $this->uitable->addModal ( "biaya", "money", "Biaya", $the_row ['biaya'] );
			
		$modal = $this->uitable->getModal ();
		$modal->setTitle ( "Laporan Maternal - Neonatal" );
		$modal->setAlwaysShow ( true );
		echo "<div class='hide'>" . $this->uitable->getHtml () . "</div>";
		echo $modal->joinFooterAndForm ()->getHtml ();
	}
    
	public function jsLoader() {
		echo addJS ( "framework/bootstrap/js/bootstrap-datepicker.js" );
		echo addJS ( "framework/smis/js/table_action.js" );
		
		loadLibrary ( "smis-libs-function-javascript" );
	}
    
	public function cssLoader() {
		echo addCSS ( "framework/bootstrap/css/datepicker.css" );
	}
    
	public function cssPreLoad() {
		?>
		<style type="text/css">
		#<?php echo $this->action;?>_add_form_form>div { clear: both; width: 100%;}
		#<?php echo $this->action;?>_add_form_form>div label { width: 250px;}
		</style>
		<?php
	}
	
	/* when it's star build */
	public function jsPreLoad() {
		?>
		<script type="text/javascript">
		var <?php echo $this->action; ?>;
		var lmn_pasien;
		var lmn_noreg = "<?php echo $this->noreg_pasien; ?>";
		var lmn_nama_pasien = "<?php echo $this->nama_pasien; ?>";
		var lmn_nrm_pasien = "<?php echo $this->nrm_pasien; ?>";
		var lmn_polislug = "<?php echo $this->polislug; ?>";
		var lmn_the_page = "<?php echo $this->page; ?>";
		var lmn_the_protoslug = "<?php echo $this->protoslug; ?>";
		var lmn_the_protoname = "<?php echo $this->protoname; ?>";
		var lmn_the_protoimplement = "<?php echo $this->protoimplement; ?>";
		var lmn_prefix = "<?php echo $this->action; ?>";
		var lmn_tenaga_medis;	
		
		$(document).ready(function() {			
			$(".mydate").datepicker();			
			var column=new Array(
				"id","tanggal", "ruangan",
				"nama_pasien","noreg_pasien","nrm_pasien","no_bpjs", "alamat_pasien",
				"status", "tenaga_medis", "jenis_layanan", "biaya"
			);
			<?php echo $this->action; ?> = new TableAction("<?php echo $this->action; ?>", lmn_the_page, "<?php echo $this->action; ?>", column);
			<?php echo $this->action; ?>.setPrototipe(lmn_the_protoname, lmn_the_protoslug, lmn_the_protoimplement);
			<?php echo $this->action; ?>.getRegulerData = function() {
				var reg_data = {	
					page : this.page,
					action : this.action,
					super_command : this.super_command,
					prototype_name : this.prototype_name,
					prototype_slug : this.prototype_slug,
					prototype_implement : this.prototype_implement,
					polislug : lmn_polislug,
					noreg_pasien : lmn_noreg,
					nama_pasien : lmn_nama_pasien,
					nrm_pasien : lmn_nrm_pasien
				};
				return reg_data;
			};
			<?php echo $this->action . ".clear=function(){return;};"; ?>
			lmn_tenaga_medis = new TableAction("lmn_tenaga_medis", lmn_the_page, lmn_prefix, new Array());
			lmn_tenaga_medis.setSuperCommand("lmn_tenaga_medis");
			lmn_tenaga_medis.setPrototipe(lmn_the_protoname, lmn_the_protoslug, lmn_the_protoimplement);
			lmn_tenaga_medis.selected = function(json) {
				$("#" + lmn_prefix +"_tenaga_medis").val(json.nama);
			};
		});
		</script>
<?php
	}
    
	public function superCommand($super_command) {
		$super = new SuperCommand ();
		if ($super_command=="lmn_tenaga_medis") {
            $eadapt = new SimpleAdapter ();
            $eadapt->add ( "Jabatan", "nama_jabatan" );
            $eadapt->add ( "Nama", "nama" );
            $eadapt->add ( "NIP", "nip" );
            $head_karyawan = array ('Nama','Jabatan',"NIP");
            $dktable = new Table ( $head_karyawan, "", NULL, true );
            $dktable->setName ( $super_command );
            $dktable->setModel ( Table::$SELECT );
            $employee = new EmployeeResponder ( $this->db, $dktable, $eadapt, "dokter" );
            $super->addResponder ( $super_command, $employee );
        }
        
		$init = $super->initialize ();
		if ($init != null) {
			echo $init;
			return;
		}
	}
}

?>