<?php
require_once 'smis-framework/smis/template/ModulTemplate.php';
require_once ("smis-base/smis-include-service-consumer.php");

class ImunisasiBayiTemplate extends ModulTemplate {
	protected $db;
	protected $mode;
	protected $polislug;
	protected $page;
	protected $protoslug;
	protected $protoname;
	protected $protoimplement;
	protected $action;
	protected $dbtable;
	protected $uitable;
	protected $noreg_pasien;
    protected $nrm_pasien;
	protected $nama_pasien;
	protected $jk;
    protected $tempat_lahir;
    protected $tanggal_lahir;
    protected $nama_ibu;
    
	public function __construct(
        $db,  
        $noreg = "", 
        $nrm = "", 
        $nama = "",
        $polislug = "",
        $page = "medical_record", 
        $action = "lap_imunisasi_bayi",
        $protoslug = "", 
        $protoname = "", 
        $protoimplement = ""
    ) {
		$this->db = $db;
		$this->polislug = $polislug;
		$this->page = $page;
		$this->protoslug = $protoslug;
		$this->protoimplement = $protoimplement;
		$this->protoname = $protoname;
		$this->action = $action;

		$this->noreg_pasien = $noreg;
        $this->nrm_pasien = $nrm;
        $this->nama_pasien = $nama;
        
        $this->dbtable = new DBTable($this->db, "smis_mr_imunisasi_bayi");
        $this->dbtable->addCustomKriteria ( "noreg_pasien", "='" . $noreg . "'" );
        $this->dbtable->addCustomKriteria ( "ruangan", "='" . $polislug . "'" );

		/// Get TTL : 
        $this->tempat_lahir = "";
        $this->tanggal_lahir = "";
        $this->nama_ibu = "";
		$this->jk = "";
		$row = $this->db->get_row("
			SELECT 
				b.tempat_lahir, b.tgl_lahir, b.ibu, b.kelamin
			FROM 
				smis_rg_layananpasien a LEFT JOIN smis_rg_patient b ON a.nrm = b.nrm
			WHERE 
				a.id = '" . $noreg . "'
		");
		if ($row != null) {
            $this->tempat_lahir = $row->tempat_lahir;
            $this->tanggal_lahir = $row->tgl_lahir;
			$this->nama_ibu = $row->ibu;
			$this->jk = $row->kelamin;
		}
		
		$columns = array("No.", "Tanggal", "Berat Badan", "Imunisasi ke-", "Jenis Imunisasi");
		$this->uitable = new Table (
            $columns , 
            "Imunisasi Bayi " . ucfirst($this->protoname),
            null, 
            true 
        );
		$this->uitable->setName ( $action );
		$this->uitable->setReloadButtonEnable(false);
		$this->uitable->setPrintButtonEnable(false);
	}
	public function command($command) {
        require_once "smis-base/smis-include-duplicate.php";
		$adapter = new SimpleAdapter(true, "No.");
        $adapter->add("Tanggal", "tanggal", "date d-m-Y");
        $adapter->add("Berat Badan", "berat_badan");
        $adapter->add("Imunisasi ke-", "imunisasi_ke");
        $adapter->add("Jenis Imunisasi", "jenis_imunisasi");
		$dbres = new DuplicateResponder($this->dbtable, $this->uitable, $adapter);
		$dbres->setDuplicate(false, "");
        $dbres->setAutonomous(getSettings($this->db, "smis_autonomous_id",""));
        $data = $dbres->command ( $_POST ['command'] );
		echo json_encode ( $data );
		return;
	}
	public function phpPreLoad() {		
		$this->uitable->addModal("id", "hidden", "", "");
        $this->uitable->addModal("nama_pasien", "hidden", "", $this->nama_pasien, "n", null, true);
        $this->uitable->addModal("nrm_pasien", "hidden", "", $this->nrm_pasien, "n", null, true);
        $this->uitable->addModal("noreg_pasien", "hidden", "", $this->noreg_pasien, "n", null, true);
        $this->uitable->addModal("jk", "hidden", "", $this->jk, "n", null, true);
		$this->uitable->addModal("ruangan", "hidden", "", $this->polislug, "n", null, true);
		$this->uitable->addModal("tempat_lahir", "hidden", "", $this->tempat_lahir, "n", null, true);
		$this->uitable->addModal("tanggal_lahir", "hidden", "", $this->tanggal_lahir, "n", null, true);

        $this->uitable->addModal("nama_ibu", "text", "Nama Ibu", $this->nama_ibu, "n");
        $this->uitable->addModal("no_ktp_ibu", "text", "No. KTP Ibu", "", "n");
        $this->uitable->addModal("berat_badan", "text", "Berat Badan", "", "n");
        $imunisasi_ke_option = new OptionBuilder();
        $imunisasi_ke_option->add("I", "I", "1");
        $imunisasi_ke_option->add("II", "II");
        $imunisasi_ke_option->add("III", "III");
        $this->uitable->addModal("imunisasi_ke", "select", "Imunisasi ke-", $imunisasi_ke_option->getContent());
        $jenis_imunisasi_option = new OptionBuilder();
        $jenis_imunisasi_option->add("BCG", "BCG", "1");
        $jenis_imunisasi_option->add("POLIO 1", "POLIO 1");
        $jenis_imunisasi_option->add("POLIO 2", "POLIO 2");
        $jenis_imunisasi_option->add("POLIO 3", "POLIO 3");
        $jenis_imunisasi_option->add("POLIO 4", "POLIO 4");
        $jenis_imunisasi_option->add("DPT HB Hib 1", "DPT HB Hib 1");
        $jenis_imunisasi_option->add("DPT HB Hib 2", "DPT HB Hib 2");
        $jenis_imunisasi_option->add("DPT HB Hib 3", "DPT HB Hib 3");
        $jenis_imunisasi_option->add("Campak", "Campak");
        $jenis_imunisasi_option->add("HBO", "HBO");
        $this->uitable->addModal("jenis_imunisasi", "select", "Jenis Imunisasi", $jenis_imunisasi_option->getContent());
        $this->uitable->addModal("tanggal", "date", "Tanggal Imunisasi", date("Y-m-d"), "n");
        $this->uitable->addModal("origin", "text", "Tempat", getSettings($this->db, "smis_autonomous_id", ""), "n", null, true);
		
		$modal = $this->uitable->getModal ();
		$modal->setComponentSize(Modal::$MEDIUM);
        $modal->setTitle("Imunisasi Bayi");
        
		echo $this->uitable->getHtml ();
		echo $modal->getHtml ();
	}
	public function jsLoader() {
		echo addJS ( "framework/bootstrap/js/bootstrap-datepicker.js" );
		echo addJS ( "framework/smis/js/table_action.js" );
		loadLibrary ( "smis-libs-function-javascript" );
	}
	public function cssLoader() {
		echo addCSS ( "framework/bootstrap/css/datepicker.css" );
	}
	
	/* when it's star build */
	public function jsPreLoad() {
		?>
		<script type="text/javascript">
			var <?php echo $this->action; ?>;
            var ib_noreg="<?php echo $this->noreg_pasien; ?>";
			var ib_nama_pasien="<?php echo $this->nama_pasien; ?>";
			var ib_nrm_pasien="<?php echo $this->nrm_pasien; ?>";
			var ib_polislug="<?php echo $this->polislug; ?>";
			var ib_the_page="<?php echo $this->page; ?>";
			var ib_the_protoslug="<?php echo $this->protoslug; ?>";
			var ib_the_protoname="<?php echo $this->protoname; ?>";
			var ib_the_protoimplement="<?php echo $this->protoimplement; ?>";
			$(document).ready(function() {
				$(".mydate").datepicker();
				
				var column = new Array(
					"id", "tanggal", 
                    "noreg_pasien", "nrm_pasien", "nama_pasien", "jk", "tempat_lahir", "tanggal_lahir", "berat_badan", "nama_ibu", "no_ktp_ibu", 
                    "imunisasi_ke", "jenis_imunisasi",
                    "ruangan"
				);
				<?php echo $this->action; ?>=new TableAction(
                    "<?php echo $this->action; ?>",
                    ib_the_page,
                    "<?php echo $this->action; ?>",
                    column
                );
				<?php echo $this->action; ?>.setPrototipe(ib_the_protoname, ib_the_protoslug, ib_the_protoimplement);
				<?php echo $this->action; ?>.setEnableAutofocus(true);
				<?php echo $this->action; ?>.setNextEnter();
				<?php echo $this->action; ?>.getRegulerData=function(){
					var reg_data = {	
                        page                : this.page,
                        action              : this.action,
                        super_command       : this.super_command,
                        prototype_name      : this.prototype_name,
                        prototype_slug      : this.prototype_slug,
                        prototype_implement : this.prototype_implement,
                        polislug            : ib_polislug,
                        noreg_pasien        : ib_noreg,
                        nama_pasien         : ib_nama_pasien,
                        nrm_pasien          : ib_nrm_pasien,
                        jk                  : $("#<?php echo $this->action; ?>_jk").val()
					};
					return reg_data;
				};
				<?php echo $this->action; ?>.view();
			});
		</script>
		<?php
	}
}

?>