<?php 

class DiagnosaTable extends Table{
	private $polislug;
	private $noreg;
	public function __construct($polislug,$noreg,$header,$title="",$content=NULL,$action=true){
		parent::__construct($header,$title,$content,$action);
		$this->polislug=$polislug;
		$this->noreg=$noreg;
	}
	
	public function getBodyContent() {
		$content = "";
		if ($this->content!=NULL) {
			foreach ($this->content as $d) {
				$content .= "<tr>";
				foreach ($this->header as $h) {
					$content .= "<td>" . $d[$h] . "</td>";
				}
				if ($this->is_action) {
					$content .= "<td>" . $this->getFilteredContentButton($d['id'], $d['no_kunjungan_pcare'], $d['status_pulang'])->getHtml() . "</td>";
				}
				$content .= "</tr>";
			}
		}
		return $content;
	}

	public function getFilteredContentButton($id, $no_kunjungan_pcare, $status_pulang){
		$btngrup=null;
		if($this->current_data['Ruangan']==$this->polislug && $this->current_data['Noreg']*1==$this->noreg){
			$this->setDelButtonEnable(true);
			$btngrup=parent::getContentButton($id);
		}else{
			$this->setDelButtonEnable(false);
			$btngrup=parent::getContentButton($id);
		}

		if ($btngrup != null && $no_kunjungan_pcare != null && $no_kunjungan_pcare != "" && trim($status_pulang) == "Rujuk Vertikal") {
			$btn = new Button("", "", "Cetak Surat Rujukan");
			$btn->setAction($this->action . ".cetak_surat_rujukan('" . $id . "')");
			$btn->setClass("btn-inverse");
			$btn->setAtribute("data-content='Cetak Surat Rujukan' data-toggle='popover'");
			$btn->setIcon("fa fa-print");
			$btn->setIsButton(Button::$ICONIC);
			$btngrup->addElement($btn);
		}

		// $btngrup->add("show", "Show", "", $this->name.".show('".$id."')", "btn-primary", "","fa fa-eye");
		return $btngrup;
	}
	
}

?>