<?php 

class MorbiditasResponder extends DBReport{
    
    private $carabayar;
    public function setCarabayar($carabayar){
        $this->carabayar=$carabayar;
        return $this;
    }
    
    public function excel(){
        $this->dbtable->addCustomKriteria(null," DATE(tanggal)>='".$_POST['from_date']."' ");
        $this->dbtable->addCustomKriteria(null," DATE(tanggal)<='".$_POST['to_date']."' ");
        $this->dbtable->setMaximum($_POST['max']);
        $data=$this->dbtable->view("",0);
        
        $fix=$this->adapter->getContent($data['data']);
        
        require_once ("smis-libs-out/php-excel/PHPExcel.php");
        $file = new PHPExcel ();
        $file->getProperties ()->setCreator ( "SMIS" );
        $file->getProperties ()->setLastModifiedBy ( "SMIS" );
        $file->getProperties ()->setTitle ( "Laporan Morbiditas" );
        $file->getProperties ()->setSubject ( "Laporan Morbiditas" );
        $file->getProperties ()->setDescription ( "Laporan Morbiditas" );
        $file->getProperties ()->setKeywords ( "Laporan Morbiditas" );
        $file->getProperties ()->setCategory ( "Laporan Morbiditas" );
        $sheet = $file->getActiveSheet ();
        $no=1;
        
        
         
        $sheet->getColumnDimension("A")->setAutoSize(true);
        $sheet->mergeCells("A1:A2")->setCellValue("A1","No.");
        $sheet->mergeCells("B1:B2")->setCellValue("B1","Diagnosa");
        $sheet->mergeCells("C1:D1")->setCellValue("C1","Kunjungan Baru");
        $sheet->mergeCells("E1:F1")->setCellValue("E1","Kunjungan Lama");
        $sheet->mergeCells("G1:H1")->setCellValue("G1","Jenis Kasus");
        $end=PHPExcel_Cell::stringFromColumnIndex(9+count($this->carabayar) - 2);
        $sheet->mergeCells("I1:".$end."1")->setCellValue("I1","Jenis Pasien");
        
        $sheet->setCellValue("C2","Laki");
        $sheet->setCellValue("D2","Perempuan");
        $sheet->setCellValue("E2","Laki");
        $sheet->setCellValue("F2","Perempuan");
        $sheet->setCellValue("G2","Baru");
        $sheet->setCellValue("H2","Lama");
        
        $no=1;
        foreach($this->carabayar as $x=>$y ){
            $huruf=PHPExcel_Cell::stringFromColumnIndex(9+$no - 2);
            $no++;
            $sheet->setCellValue($huruf."2",$y);
        }
        
        $sheet  ->getStyle('A1:'.$huruf.'2')
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet  ->getStyle('A1:'.$huruf.'2')
                ->getFont()
                ->setBold(true);
        
        $no=2;
        foreach($fix as $o){
            $no++;
            $sheet->setCellValue("A".$no,$o['No']);
            $sheet->setCellValue("B".$no,$o['Diagnosa']);
            $sheet->setCellValue("C".$no,$o['L']);
            $sheet->setCellValue("D".$no,$o['P']);
            $sheet->setCellValue("E".$no,$o['L1']);
            $sheet->setCellValue("F".$no,$o['P1']);
            $sheet->setCellValue("G".$no,$o['Baru']);
            $sheet->setCellValue("H".$no,$o['Lama']);
            
            $index=1;
            foreach($this->carabayar as $x=>$y ){
                $huruf=PHPExcel_Cell::stringFromColumnIndex(9+$index - 2);
                $index++;
                $sheet->setCellValue($huruf.$no,$o[$y]);
            }
        }
        $sheet->getColumnDimension("B")->setAutoSize(true);
        $sheet->getColumnDimension("D")->setAutoSize(true);
        $sheet->getColumnDimension("F")->setAutoSize(true);
        
        $thin = array ();
        $thin['borders']=array();
        $thin['borders']['allborders']=array();
        $thin['borders']['allborders']['style']=PHPExcel_Style_Border::BORDER_DASHDOT ;
        $sheet  ->getStyle ( 'A1:'.$huruf.$no )->applyFromArray ($thin);
        $sheet  ->getStyle('A'.$no.':'.$huruf.(9+$index-2))
                ->getFont()
                ->setBold(true);
        
        header ( 'Content-Type: application/vnd.ms-excel' );
        header ( 'Content-Disposition: attachment;filename="Data Morbiditas.xls"' );
        header ( 'Cache-Control: max-age=0' );
        $writer = PHPExcel_IOFactory::createWriter ( $file, 'Excel5' );
        $writer->save ( 'php://output' );
		return;
    }
    
}

?>