<?php

class LaporanPersalinanResponder extends DBResponder {
    public function excel() {
        $this->dbtable->setShowAll(true);
        $data=$this->dbtable->view("",0);
        $fix=$this->adapter->getContent($data['data']);
        
        require_once ("smis-libs-out/php-excel/PHPExcel.php");
        $file = new PHPExcel ();
        $file->getProperties ()->setCreator ( "PT. Inovasi Ide Utama" );
        $file->getProperties ()->setLastModifiedBy ( "Administrator" );
        $file->getProperties ()->setTitle ( "Lap Persalinan" );
        $file->getProperties ()->setSubject ( "Lap Persalinan" );
        $file->getProperties ()->setDescription ( "Lap Persalinan Generated by System" );
        $file->getProperties ()->setKeywords ( "Lap Persalinan" );
        $file->getProperties ()->setCategory ( "Lap Persalinan" );
        
        $sheet = $file->getActiveSheet ();
        $i = 1;
        $sheet->mergeCells("A".$i.":Z".$i)->setCellValue("A".$i,"Laporan Persalinan Tenaga Kesehatan");
        $sheet->getStyle("A".$i.":Z".$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A".$i)->getFont()->setBold(true);
        $i++;
        $sheet->mergeCells("A".$i.":Z".$i)->setCellValue("A".$i,"(IKHTISAR PERSALINAN)");
        $sheet->getStyle("A".$i.":Z".$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A".$i)->getFont()->setBold(true);
        $i++;
        $dari = ArrayAdapter::dateFormat("date d M Y", $_POST['dari']);
        $sampai = ArrayAdapter::dateFormat("date d M Y", $_POST['sampai']);
        $sheet->mergeCells("A".$i.":Z".$i)->setCellValue("A".$i, $dari.' - '.$sampai);
        $sheet->getStyle("A".$i.":Z".$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A".$i)->getFont()->setBold(true);
        $i += 2;
        
        $border_start = $i;
        $ipd = $i+2;
        $sheet->mergeCells("A".$i.":A".$ipd)->setCellValue("A".$i,"No");
        $sheet->mergeCells("B".$i.":B".$ipd)->setCellValue("B".$i,"Tanggal");
        $sheet->mergeCells("C".$i.":C".$ipd)->setCellValue("C".$i,"Nama Pasien");
        $sheet->mergeCells("D".$i.":D".$ipd)->setCellValue("D".$i,"NRM Pasien");
        $sheet->mergeCells("E".$i.":E".$ipd)->setCellValue("E".$i,"Noreg Pasien");
        $sheet->mergeCells("F".$i.":F".$ipd)->setCellValue("F".$i,"Alamat");
        $sheet->mergeCells("G".$i.":G".$ipd)->setCellValue("G".$i,"Umur");
        $sheet->mergeCells("H".$i.":H".$ipd)->setCellValue("H".$i,"Hamil");
        $sheet->mergeCells("I".$i.":I".$ipd)->setCellValue("I".$i,"Umur Kehamilan");
        $sheet->mergeCells("J".$i.":L".$i)->setCellValue("J".$i,"Letak Janin");
        $sheet->mergeCells("M".$i.":R".$i)->setCellValue("M".$i,"Metode Persalinan");
        $sheet->mergeCells("S".$i.":X".$i)->setCellValue("S".$i,"Bayi");
        $sheet->mergeCells("Y".$i.":Y".$ipd)->setCellValue("Y".$i,"Ibu Mati 42 Hari");
        $sheet->mergeCells("Z".$i.":Z".$ipd)->setCellValue("Z".$i,"Rujukan");
        $sheet->getStyle("A".$i.":Z".$ipd)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A".$i.":Z".$ipd)->getFont()->setBold(true);
        $i++;
        
        $ips = $i+1;
        $sheet->mergeCells("J".$i.":J".$ips)->setCellValue("J".$i,"Kep");
        $sheet->mergeCells("K".$i.":K".$ips)->setCellValue("K".$i,"SU");
        $sheet->mergeCells("L".$i.":L".$ips)->setCellValue("L".$i,"Lin");
        $sheet->mergeCells("M".$i.":M".$ips)->setCellValue("M".$i,"Spt");
        $sheet->mergeCells("N".$i.":N".$ips)->setCellValue("N".$i,"VE");
        $sheet->mergeCells("O".$i.":O".$ips)->setCellValue("O".$i,"SC");
        $sheet->mergeCells("P".$i.":P".$ips)->setCellValue("P".$i,"Forcep");
        $sheet->mergeCells("Q".$i.":Q".$ips)->setCellValue("Q".$i,"Oksitosin");
        $sheet->mergeCells("R".$i.":R".$ips)->setCellValue("R".$i,"Amniotomi");
        $sheet->mergeCells("S".$i.":S".$ips)->setCellValue("S".$i,"Lahir Hidup");
        $sheet->mergeCells("T".$i.":T".$ips)->setCellValue("T".$i,"L");
        $sheet->mergeCells("U".$i.":U".$ips)->setCellValue("U".$i,"P");
        $sheet->mergeCells("V".$i.":V".$ips)->setCellValue("V".$i,"Kembar");
        $sheet->mergeCells("W".$i.":X".$i)->setCellValue("W".$i,"Mati");
        $i++;
        
        $sheet->mergeCells("W".$i.":W".$i)->setCellValue("W".$i,"< 7 Hari");
        $sheet->mergeCells("X".$i.":X".$i)->setCellValue("X".$i,"> 7 Hari");
        $i++;
        foreach(range("A","Z") as $columnID) {
            $sheet->getColumnDimension($columnID)->setAutoSize(true);
        }
        
        for($a = 0; $a < sizeof($fix); $a++) {
            $sheet->setCellValue("A".$i, $fix[$a]['no']);
            $sheet->setCellValue("B".$i, $fix[$a]['tanggal']);
            $sheet->setCellValue("C".$i, $fix[$a]['nama_pasien']);
            $sheet->setCellValue("D".$i, $fix[$a]['nrm_pasien']);
            $sheet->setCellValue("E".$i, $fix[$a]['noreg_pasien']);
            $sheet->setCellValue("F".$i, $fix[$a]['alamat']);
            $sheet->setCellValue("G".$i, $fix[$a]['umur_pasien']);
            $sheet->setCellValue("H".$i, $fix[$a]['hamil_ke']);
            $sheet->setCellValue("I".$i, $fix[$a]['umur_kehamilan']);
            $sheet->setCellValue("J".$i, $fix[$a]['letak_janin_kep']);
            $sheet->setCellValue("K".$i, $fix[$a]['letak_janin_su']);
            $sheet->setCellValue("L".$i, $fix[$a]['letak_janin_lin']);
            $sheet->setCellValue("M".$i, $fix[$a]['metode_spt']);
            $sheet->setCellValue("N".$i, $fix[$a]['metode_ve']);
            $sheet->setCellValue("O".$i, $fix[$a]['metode_sc']);
            $sheet->setCellValue("P".$i, $fix[$a]['metode_forcep']);
            $sheet->setCellValue("Q".$i, $fix[$a]['metode_oksitosin']);
            $sheet->setCellValue("R".$i, $fix[$a]['metode_amniotomi']);
            $sheet->setCellValue("S".$i, $fix[$a]['bayi_lahir_hidup']);
            $sheet->setCellValue("T".$i, $fix[$a]['bayi_lk']);
            $sheet->setCellValue("U".$i, $fix[$a]['bayi_pr']);
            $sheet->setCellValue("V".$i, $fix[$a]['bayi_kembar']);
            $sheet->setCellValue("W".$i, $fix[$a]['bayi_mati_krg_7_hr']);
            $sheet->setCellValue("X".$i, $fix[$a]['bayi_mati_lbh_7_hr']);
            $sheet->setCellValue("Y".$i, $fix[$a]['ibu_mati']);
            $sheet->setCellValue("Z".$i, $fix[$a]['rujukan']);
            $i++;
        }
        $border_end = $i - 1;
        
        $thin = array ();
        $thin['borders']=array();
        $thin['borders']['allborders']=array();
        $thin['borders']['allborders']['style']=PHPExcel_Style_Border::BORDER_THIN ;
        $sheet  ->getStyle ( "A".$border_start.":Z".$border_end )->applyFromArray ($thin);
        
        header ( 'Content-Type: application/vnd.ms-excel' );
        header ( 'Content-Disposition: attachment;filename="Laporan Persalinan.xls"' );
        header ( 'Cache-Control: max-age=0' );
        $writer = PHPExcel_IOFactory::createWriter ( $file, 'Excel5' );
        $writer->save ( 'php://output' );
		return;
    }
}

?>