<?php 

class LapKunjunganPasienReport extends DBReport{
	
    public function command($command){
        if($command=="get_total_id"){
            $pack=new ResponsePackage();
            $pack->setStatus(ResponsePackage::$STATUS_OK);
            $result=$this->getTotalBackup();
            $pack->setContent($result);
            return $pack->getPackage();
        }else if($command=="backup_current_id"){
            $pack=new ResponsePackage();
            $pack->setStatus(ResponsePackage::$STATUS_OK);
            $result=$this->getBackupCurrent();
            $pack->setContent($result);
            return $pack->getPackage();
        }else{
            return parent::command($command);
        }
    }

    public function fetchDiagram(){
        global $db;
        $kriteria=$_POST['kriteria'];        
        $this->dbtable = new DBTable($db,"smis_rg_layananpasien");
        $this->dbtable->setView($this->getView().$this->diagram_query);		
		$this->dbtable->setGroupBy(true,$this->getDiagramGrOup());
		$this->dbtable->setShowAll(true);
		if($this->timegroup)
		$this->dbtable->setOrder($this->getOrder());
		$ddiagram=$this->dbtable->view($kriteria, 0);
		$data=$ddiagram['data'];
		$diagram=$this->diagram_adapter->getContent($data);
		return array("data"=>$diagram,"debug"=>$ddiagram);
	}
    
    public function getTotalBackup(){
        $filter      = "";
        $origin_data = getSettings($this->getDBTable()->get_db(),"smis-reg-lap-laporan_pasien_daftar-backup-slug","");
        if($origin_data!=""){
            $filter .= " AND origin = '".$origin_data."' ";
        }
        $query = "SELECT count(*) as total 
                 FROM smis_rg_vregister 
                 WHERE id NOT IN (
                     SELECT id FROM smis_rg_vregisterb
                 ) ".$filter."  AND prop!='del' ";
        $total = $this->getDBTable()->get_db()->get_var($query);
        return $total;
    }
    
    public function getBackupCurrent(){
        $filter      = "";
        $origin_data = getSettings($this->getDBTable()->get_db(),"smis-reg-lap-laporan_pasien_daftar-backup-slug","");
        if($origin_data!=""){
            $filter .= " AND origin = '".$origin_data."' ";
        }
        $query = "SELECT * 
                 FROM smis_rg_vregister 
                 WHERE id NOT IN (
                     SELECT id FROM smis_rg_vregisterb
                 )  ".$filter." AND prop!='del' LIMIT 0,1";
        $x     = (array)$this->getDBTable()->get_db()->get_row($query);
        $this->dbtable->insert($x);
        return $x;
    }
    
    
	public function excel(){
        global $db;
		require_once "smis-libs-out/php-excel/PHPExcel.php";
		$file = new PHPExcel ();
		$file->getProperties ()->setCreator ( "Kunjungan Pasien" );
		$file->getProperties ()->setLastModifiedBy ( "Kunjungan Pasien Rumah Sakit" );
		$file->getProperties ()->setTitle ( "Data Kunjungan Pasien" );
		$file->getProperties ()->setSubject ( "Data Kunjungan Pasien" );
		$file->getProperties ()->setDescription ( "Data Kunjungan Pasien" );
		$file->getProperties ()->setKeywords ( "Kunjungan Pasien " );
		$file->getProperties ()->setCategory ( "Kunjungan Pasien" );
		
		$fillcabang=array();
		$fillcabang['borders']=array();
		$fillcabang['borders']['allborders']=array();
		$fillcabang['borders']['allborders']['style']=PHPExcel_Style_Border::BORDER_THIN ;
		
		$file->setActiveSheetIndex ( 0 );
		$sheet = $file->getActiveSheet ( 0 );
		$sheet->setTitle ("Detail Pasien");
        
		$this->getDBTable()->setDebuggable(true);
		$this->getDBTable()->setShowAll(true);
		$this->getDBTable()->setFetchMethode(DBTable::$OBJECT_FETCH);
        $this->getDBTable()->setOrder(" tanggal ASC ");
        $this->setDebuggable(true);
		$package=$this->view("","0");
		
        $pasien = array();
		$list=$package['dbtable']['data'];
        
        $index=1;
        $objDrawing = new PHPExcel_Worksheet_Drawing();
        $objDrawing->setName('logo_img');
        $objDrawing->setDescription('logo_img');
        $objDrawing->setPath(getLogo());
        $objDrawing->setCoordinates('A'.$index);
        $objDrawing->setOffsetX(20); 
        $objDrawing->setOffsetY(5);
        $objDrawing->setWidth(70); 
        $objDrawing->setHeight(70);
        $objDrawing->setWorksheet($sheet);
        
        $sheet->setCellValue("C".$index, getSettings($db,"smis_autonomous_title",""));
        $sheet->getStyle("C".$index)->getFont()->setBold(true)->setSize(14);
        $index++;
        $sheet->setCellValue("C".$index, getSettings($db,"smis_autonomous_address",""));
        $sheet->getStyle("C".$index)->getFont()->setBold(true);
        $index++;
        $sheet->setCellValue("C".$index, getSettings($db,"smis_autonomous_contact",""));
        $sheet->getStyle("C".$index)->getFont()->setBold(true);
        $index += 3;
		
        $border_start = $index;
        $a_w = mb_strwidth("No.") + 5;
		$sheet->setCellValue ( "A" . $index, "No.");
        $b_w = mb_strwidth("Nama") + 5;
        $sheet->setCellValue ( "B" . $index, "Nama" );
        $c_w = mb_strwidth("NRM") + 5;
        $sheet->setCellValue ( "C" . $index, "NRM" );
        $d_w = mb_strwidth("No. BPJS") + 5;
        $sheet->setCellValue ( "D" . $index, "No. BPJS" );
        $e_w = mb_strwidth("L/P") + 5;
        $sheet->setCellValue ( "E" . $index, "L/P" );
        $f_w = mb_strwidth("Tanggal") + 5;
        $sheet->setCellValue ( "F" . $index, "Tanggal" );
        $g_w = mb_strwidth("Alamat") + 5;
        $sheet->setCellValue ( "G" . $index, "Alamat" );
        $h_w = mb_strwidth("Kecamatan") + 5;
		$sheet->setCellValue ( "H" . $index, "Kecamatan" );
        $i_w = mb_strwidth("Cara Bayar") + 5;
        $sheet->setCellValue ( "I" . $index, "Cara Bayar" );        
        $j_w = mb_strwidth("PPK") + 5;
        $sheet->setCellValue ( "J" . $index, "PPK");

        $k_w = mb_strwidth("No. Telp") + 5;
        $sheet->setCellValue ( "K" . $index, "No. Telp");
        $l_w = mb_strwidth("Jenis Kunjungan") + 5;
        $sheet->setCellValue ( "L" . $index, "Jenis Kunjungan");
        $m_w = mb_strwidth("Ruangan") + 5;
        $sheet->setCellValue ( "M" . $index, "Ruangan");

        $n_w = mb_strwidth("Dokter Rawat Jalan") + 5;
        $sheet->setCellValue ( "N" . $index, "Dokter Rawat Jalan");
        $o_w = mb_strwidth("Nama Diagnosa") + 5;
        $sheet->setCellValue ( "O" . $index, "Nama Diagnosa");
        $p_w = mb_strwidth("Jenis Diagnosa") + 5;
        $sheet->setCellValue ( "P" . $index, "Jenis Diagnosa");
        $q_w = mb_strwidth("Dirujuk ke Poli") + 5;
        $sheet->setCellValue ( "Q" . $index, "Dirujuk ke Poli");
        $r_w = mb_strwidth("Dirujuk ke RS") + 5;
        $sheet->setCellValue ( "R" . $index, "Dirujuk ke RS");

        $s_w = mb_strwidth("Pulang") + 5;
        $sheet->setCellValue ( "S" . $index, "Pulang");
        $t_w = mb_strwidth("Perusahaan") + 5;
        $sheet->setCellValue ( "T" . $index, "Perusahaan");
        $u_w = mb_strwidth("Asuransi") + 5;
        $sheet->setCellValue ( "U" . $index, "Asuransi");
        $v_w = mb_strwidth("Asal Data") + 5;
        $sheet->setCellValue ( "V" . $index, "Asal Data");
        
		$no=0;
		$sheet->getStyle ( "A".$index.":AB".$index)->getFont ()->setBold ( true );
		foreach($list as $x){
			$no++;
			$index++;
            if (mb_strwidth($no.".") + 5 > $a_w)
                $a_w = mb_strwidth($no.".") + 5;
			$sheet->setCellValue ( "A" . $index, $no."." );
            if (mb_strwidth($x->nama) + 5 > $b_w)
                $b_w = mb_strwidth($x->nama) + 5;
            $sheet->setCellValue ( "B" . $index, $x->nama );
            if (mb_strwidth($x->nrm) + 5 > $c_w)
                $c_w = mb_strwidth($x->nrm) + 5;
            $sheet->setCellValue ( "C" . $index, $x->nrm==''?"":"'".$x->nrm );
            if (mb_strwidth($x->no_bpjs) + 5 > $d_w)
                $d_w = mb_strwidth($x->no_bpjs) + 5;
            $sheet->setCellValue ( "D" . $index, $x->no_bpjs==''?"":"'".$x->no_bpjs );
            if (mb_strwidth($x->kelamin) + 5 > $e_w)
                $e_w = mb_strwidth($x->kelamin) + 5;
            $sheet->setCellValue ( "E" . $index, $x->kelamin );
            if (mb_strwidth(ArrayAdapter::format("date d M Y H:i",$x->tanggal)) + 5 > $f_w)
                $f_w = mb_strwidth(ArrayAdapter::format("date d M Y H:i",$x->tanggal)) + 5;
            $sheet->setCellValue ( "F" . $index, ArrayAdapter::format("date d M Y H:i",$x->tanggal)  );
            if (mb_strwidth($x->alamat) + 5 > $g_w)
                $g_w = mb_strwidth($x->alamat) + 5;
            $sheet->setCellValue ( "G" . $index, $x->alamat );
            if (mb_strwidth($x->nama_kecamatan) + 5 > $h_w)
                $h_w = mb_strwidth($x->nama_kecamatan) + 5;
			$sheet->setCellValue ( "H" . $index, $x->nama_kecamatan );
            if (mb_strwidth($x->carabayar) + 5 > $i_w)
                $i_w = mb_strwidth($x->carabayar) + 5;
            $sheet->setCellValue ( "I" . $index, $x->carabayar );
            if (mb_strwidth($x->ppk_bpjs) + 5 > $j_w)
                $j_w = mb_strwidth($x->ppk_bpjs) + 5;
            $sheet->setCellValue ( "J" . $index, $x->ppk_bpjs );

            if (mb_strwidth($x->telpon_pasien) + 5 > $k_w)
                $k_w = mb_strwidth($x->telpon_pasien) + 5;
            $sheet->setCellValue ( "K" . $index, $x->telpon_pasien );
            if (mb_strwidth($x->jenis_kunjungan) + 5 > $l_w)
                $l_w = mb_strwidth($x->jenis_kunjungan) + 5;
            $sheet->setCellValue ( "L" . $index, $x->jenis_kunjungan );
            if (mb_strwidth(ArrayAdapter::format("unslug", $x->jenislayanan)) + 5 > $m_w)
                $m_w = mb_strwidth(ArrayAdapter::format("unslug", $x->jenislayanan)) + 5;
            $sheet->setCellValue ( "M" . $index, ArrayAdapter::format("unslug", $x->jenislayanan) );

            if (mb_strwidth($x->nama_dokter) + 5 > $n_w)
                $n_w = mb_strwidth($x->nama_dokter) + 5;
            $sheet->setCellValue ( "N" . $index, $x->nama_dokter );
            if (mb_strwidth($x->nama_icd) + 5 > $o_w)
                $o_w = mb_strwidth($x->nama_icd) + 5;
            $sheet->setCellValue ( "O" . $index, $x->nama_icd );
            if (mb_strwidth($x->non_spesialis) + 5 > $p_w)
                $p_w = mb_strwidth($x->non_spesialis) + 5;
            $sheet->setCellValue ( "P" . $index, $x->non_spesialis );
            if (mb_strwidth($x->spesialis_subspesialis) + 5 > $q_w)
                $q_w = mb_strwidth($x->spesialis_subspesialis) + 5;
            $sheet->setCellValue ( "Q" . $index, $x->spesialis_subspesialis );
            if (mb_strwidth($x->ppk_rujukan) + 5 > $r_w)
                $r_w = mb_strwidth($x->ppk_rujukan) + 5;
            $sheet->setCellValue ( "R" . $index, $x->ppk_rujukan );

            if (mb_strwidth($x->carapulang) + 5 > $s_w)
                $s_w = mb_strwidth($x->carapulang) + 5;
            $sheet->setCellValue ( "S" . $index, $x->carapulang );
            if (mb_strwidth($x->nama_perusahaan) + 5 > $t_w)
                $t_w = mb_strwidth($x->nama_perusahaan) + 5;
            $sheet->setCellValue ( "T" . $index, $x->nama_perusahaan );
            if (mb_strwidth($x->nama_asuransi) + 5 > $u_w)
                $u_w = mb_strwidth($x->nama_asuransi) + 5;
            $sheet->setCellValue ( "U" . $index, $x->nama_asuransi );
            if (mb_strwidth(ArrayAdapter::format("unslug",$x->origin)) + 5 > $v_w)
                $v_w = mb_strwidth(ArrayAdapter::format("unslug",$x->origin)) + 5;
            $sheet->setCellValue ( "V" . $index, ArrayAdapter::format("unslug",$x->origin) );



            if(!isset($pasien[$x->nrm])){
                $pasien[$x->nrm]=array();
                $pasien[$x->nrm]['nrm']         = "'".$x->nrm;
                $pasien[$x->nrm]['nama']        = $x->nama;
                $pasien[$x->nrm]['alamat']      = $x->alamat;
                $pasien[$x->nrm]['provinsi']    = $x->nama_provinsi;
                $pasien[$x->nrm]['kabupaten']   = $x->nama_kabupaten;
                $pasien[$x->nrm]['kecamatan']   = $x->nama_kecamatan;
                $pasien[$x->nrm]['kelurahan']   = $x->nama_kelurahan;
                $pasien[$x->nrm]['telpon_pasien']      = $x->telpon_pasien;
                $pasien[$x->nrm]['kelamin']     = $x->kelamin ;
                $pasien[$x->nrm]['jumlah']      = 0;
            }
            $pasien[$x->nrm]['jumlah']++;
		}
		$sheet->getStyle ( 'A'.$border_start.':V' . $index )->applyFromArray ( $fillcabang );
        $sheet->getColumnDimension("A")->setWidth($a_w);
        $sheet->getColumnDimension("B")->setWidth($b_w);
        $sheet->getColumnDimension("C")->setWidth($c_w);
        $sheet->getColumnDimension("D")->setWidth($d_w);
        $sheet->getColumnDimension("E")->setWidth($e_w);
        $sheet->getColumnDimension("F")->setWidth($f_w);
        $sheet->getColumnDimension("G")->setWidth($g_w);
        $sheet->getColumnDimension("H")->setWidth($h_w);
        $sheet->getColumnDimension("I")->setWidth($i_w);
        $sheet->getColumnDimension("J")->setWidth($j_w);
        $sheet->getColumnDimension("K")->setWidth($k_w);
        $sheet->getColumnDimension("L")->setWidth($l_w);
        $sheet->getColumnDimension("M")->setWidth($m_w);
        $sheet->getColumnDimension("N")->setWidth($n_w);
        $sheet->getColumnDimension("O")->setWidth($o_w);
        $sheet->getColumnDimension("P")->setWidth($p_w);
        $sheet->getColumnDimension("Q")->setWidth($q_w);
        $sheet->getColumnDimension("R")->setWidth($r_w);
        $sheet->getColumnDimension("S")->setWidth($s_w);
        $sheet->getColumnDimension("T")->setWidth($t_w);
        $sheet->getColumnDimension("U")->setWidth($u_w);
        $sheet->getColumnDimension("V")->setWidth($v_w);
		
        $no=0;
        $index=1;
		$file->createSheet(NULL,1);
		$file->setActiveSheetIndex(1);
		$sheet = $file->getActiveSheet(1);
        
        $objDrawing = new PHPExcel_Worksheet_Drawing();
        $objDrawing->setName('logo_img');
        $objDrawing->setDescription('logo_img');
        $objDrawing->setPath(getLogo());
        $objDrawing->setCoordinates('A'.$index);
        $objDrawing->setOffsetX(20); 
        $objDrawing->setOffsetY(5);
        $objDrawing->setWidth(70); 
        $objDrawing->setHeight(70);
        $objDrawing->setWorksheet($sheet);
        
        $sheet->setCellValue("C".$index, getSettings($db,"smis_autonomous_title",""));
        $sheet->getStyle("C".$index)->getFont()->setBold(true)->setSize(14);
        $index++;
        $sheet->setCellValue("C".$index, getSettings($db,"smis_autonomous_address",""));
        $sheet->getStyle("C".$index)->getFont()->setBold(true);
        $index++;
        $sheet->setCellValue("C".$index, getSettings($db,"smis_autonomous_contact",""));
        $sheet->getStyle("C".$index)->getFont()->setBold(true);
        $index += 3;
        
        $border_start = $index;
        $sheet->setTitle ("Jumlah Kunjungan");
		$sheet->setCellValue ( "A" . $index, "No.");
        $sheet->setCellValue ( "B" . $index, "NRM" );
        $sheet->setCellValue ( "C" . $index, "NAMA" );
		$sheet->setCellValue ( "D" . $index, "ALAMAT" );
		$sheet->setCellValue ( "E" . $index, "PROVINSI" );
		$sheet->setCellValue ( "F" . $index, "KABUPATEN" );
		$sheet->setCellValue ( "G" . $index, "KECAMATAN" );
		$sheet->setCellValue ( "H" . $index, "KELURAHAN" );
        $sheet->setCellValue ( "I" . $index, "L/P" );
        $sheet->setCellValue ( "J" . $index, "NO TELP" );
		$sheet->setCellValue ( "K" . $index, "JUMLAH" );
        $sheet->getStyle ( "A".$index.":K".$index)->getFont ()->setBold ( true );
        foreach($pasien as $x){
            $no++;
            $index++;
            $sheet->setCellValue ( "A" . $index, $no."." );
            $sheet->setCellValue ( "B" . $index, $x['nrm'] );
            $sheet->setCellValue ( "C" . $index, $x['nama'] );
			$sheet->setCellValue ( "D" . $index, $x['alamat'] );
			$sheet->setCellValue ( "E" . $index, $x['provinsi'] );
			$sheet->setCellValue ( "F" . $index, $x['kabupaten'] );
			$sheet->setCellValue ( "G" . $index, $x['kecamatan'] );
			$sheet->setCellValue ( "H" . $index, $x['kelurahan'] );
            $sheet->setCellValue ( "I" . $index, $x['kelamin'] );
            $sheet->setCellValue ( "J" . $index, $x['telpon_pasien'] );
			$sheet->setCellValue ( "K" . $index, $x['jumlah'] );
        }
        $sheet->getStyle ( 'A'.$border_start.':K' . $index )->applyFromArray ( $fillcabang );
        
        /*
		$list=$package['ddiagram']['data'];
		$file->createSheet ( NULL, 2 );
		$file->setActiveSheetIndex ( 2 );
		$sheet = $file->getActiveSheet ( 2 );
        $index=1;
		$no=0;
        
        $objDrawing = new PHPExcel_Worksheet_Drawing();
        $objDrawing->setName('logo_img');
        $objDrawing->setDescription('logo_img');
        $objDrawing->setPath(getLogo());
        $objDrawing->setCoordinates('A'.$index);
        $objDrawing->setOffsetX(20); 
        $objDrawing->setOffsetY(5);
        $objDrawing->setWidth(70); 
        $objDrawing->setHeight(70);
        $objDrawing->setWorksheet($sheet);
        
        $sheet->setCellValue("C".$index, getSettings($db,"smis_autonomous_title",""));
        $sheet->getStyle("C".$index)->getFont()->setBold(true)->setSize(14);
        $index++;
        $sheet->setCellValue("C".$index, getSettings($db,"smis_autonomous_address",""));
        $sheet->getStyle("C".$index)->getFont()->setBold(true);
        $index++;
        $sheet->setCellValue("C".$index, getSettings($db,"smis_autonomous_contact",""));
        $sheet->getStyle("C".$index)->getFont()->setBold(true);
        $index += 3;
        
        $border_start = $index;
		$sheet->setTitle ("Resume Pasien");
		$sheet->setCellValue ( "A" . $index, "No.");
		$sheet->setCellValue ( "B" . $index, "NAMA" );
		$sheet->setCellValue ( "C" . $index, "JUMLAH" );
		
		$sheet->getStyle ( "A".$index.":C".$index)->getFont ()->setBold ( true );
		foreach($list as $x){
			$no++;
			$index++;
			$sheet->setCellValue ( "A" . $index, $no."." );
			$sheet->setCellValue ( "B" . $index, $x->nama );
			$sheet->setCellValue ( "C" . $index, $x->jumlah );
		}
		$sheet->getStyle ( 'A'.$border_start.':C' . $index )->applyFromArray ( $fillcabang );
		*/
		header ( 'Content-Type: application/vnd.ms-excel' );
		header ( 'Content-Disposition: attachment;filename="Data Kunjungan Pasien.xls"' );
		header ( 'Cache-Control: max-age=0' );
		$writer = PHPExcel_IOFactory::createWriter ( $file, 'Excel5' );
		$writer->save ( 'php://output' );
	}
	
}

?>