<?php

class LapIndeksPenyakitResponder extends DBResponder {
    public function excel() {
        $this->dbtable->setShowAll(true);
        $data=$this->dbtable->view("",0);
        $fix=$this->adapter->getContent($data['data']);
        
        require_once ("smis-libs-out/php-excel/PHPExcel.php");
        $file = new PHPExcel ();
        $file->getProperties ()->setCreator ( "PT. Inovasi Ide Utama" );
        $file->getProperties ()->setLastModifiedBy ( "Administrator" );
        $file->getProperties ()->setTitle ( "Morbiditas" );
        $file->getProperties ()->setSubject ( "Morbiditas" );
        $file->getProperties ()->setDescription ( "Morbiditas Generated by System" );
        $file->getProperties ()->setKeywords ( "Morbiditas" );
        $file->getProperties ()->setCategory ( "Morbiditas" );
        
        $sheet = $file->getActiveSheet ();
        $i = 1;
        
        $objDrawing = new PHPExcel_Worksheet_Drawing();
        $objDrawing->setName('logo_img');
        $objDrawing->setDescription('logo_img');
        $objDrawing->setPath(getLogoNonInterlaced());
        $objDrawing->setCoordinates('A'.$i);
        $objDrawing->setOffsetX(20); 
        $objDrawing->setOffsetY(5);
        $objDrawing->setWidth(100); 
        $objDrawing->setHeight(100);
        $objDrawing->setWorksheet($sheet);
        $i++;
        
        $sheet->setCellValue("C".$i, getSettings($db,"smis_autonomous_title"));
        $sheet->getStyle("C".$i)->getFont()->setBold(true)->setSize(14);
        $i++;
        $sheet->setCellValue("C".$i, getSettings($db,"smis_autonomous_address"));
        $sheet->getStyle("C".$i)->getFont()->setBold(true)->setSize(14);
        $i++;
        $sheet->setCellValue("C".$i, getSettings($db,"smis_autonomous_contact"));
        $sheet->getStyle("C".$i)->getFont()->setBold(true)->setSize(14);
        $i += 3;
        $sheet->mergeCells("A".$i.":AD".$i)->setCellValue("A".$i,"LAPORAN INDEKS PENYAKIT");
        $sheet->getStyle("A".$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A".$i)->getFont()->setBold(true)->setSize(14);
        $i++;
        $sheet->mergeCells("A".$i.":AD".$i)->setCellValue("A".$i, strtoupper(ArrayAdapter::dateFormat("date d M Y", $_POST['dari']))." - ".strtoupper(ArrayAdapter::dateFormat("date d M Y", $_POST['sampai'])));
        $sheet->getStyle("A".$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A".$i)->getFont()->setBold(true);
        $i += 3;
        
        $border_start = $i;
        $sheet->setCellValue("A".$i, "No.");
        $sheet->setCellValue("B".$i, "Tanggal");
        $sheet->setCellValue("C".$i, "NRM");
        $sheet->setCellValue("D".$i, "Nama Pasien");
        $sheet->setCellValue("E".$i, "Alamat");
        $sheet->setCellValue("F".$i, "Tgl Lahir");
        $sheet->setCellValue("G".$i, "Ruangan");
        $sheet->setCellValue("H".$i, "Masuk");
        $sheet->setCellValue("I".$i, "Keluar");
        $sheet->setCellValue("J".$i, "Lama Dirawat");
        $sheet->setCellValue("K".$i, "L");
        $sheet->setCellValue("L".$i, "P");
        $sheet->setCellValue("M".$i, "0 - 28 HR");
        $sheet->setCellValue("N".$i, "28 HR - 1 TH");
        $sheet->setCellValue("O".$i, "1-4 TH");
        $sheet->setCellValue("P".$i, "5-14 TH");
        $sheet->setCellValue("Q".$i, "15-24 TH");
        $sheet->setCellValue("R".$i, "25-44 TH");
        $sheet->setCellValue("S".$i, "45-59 TH");
        $sheet->setCellValue("T".$i, "60-64 TH");
        $sheet->setCellValue("U".$i, "65 TH+");
        $sheet->setCellValue("V".$i, "Diagnosa");
        $sheet->setCellValue("W".$i, "Kelas");
        $sheet->setCellValue("X".$i, "Dipulangkan Mati <=48 Jam");
        $sheet->setCellValue("Y".$i, "Dipulangkan Mati >48 Jam");
        $sheet->setCellValue("Z".$i, "Pulang Paksa");
        $sheet->setCellValue("AA".$i, "Kabur");
        $sheet->setCellValue("AB".$i, "Rujuk RS Lain");
        $sheet->setCellValue("AC".$i, "Dikembalikan ke Perujuk");
        $sheet->setCellValue("AD".$i, "Dipulangkan Hidup");
        $sheet->getStyle("A".$i.":AD".$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A".$i.":AD".$i)->getFont()->setBold(true);
        $i++;
        
        for($a = 0; $a < sizeof($fix); $a++) {
            $sheet->setCellValue("A".$i, $fix[$a]['No.']);
            $sheet->setCellValue("B".$i, $fix[$a]['Tanggal']);
            $sheet->setCellValue("C".$i, $fix[$a]['NRM']);
            $sheet->setCellValue("D".$i, $fix[$a]['Nama Pasien']);
            $sheet->setCellValue("E".$i, $fix[$a]['Alamat']);
            $sheet->setCellValue("F".$i, $fix[$a]['Tgl Lahir']);
            $sheet->setCellValue("G".$i, $fix[$a]['Ruangan']);
            $sheet->setCellValue("H".$i, $fix[$a]['Masuk']);
            $sheet->setCellValue("I".$i, $fix[$a]['Keluar']);
            $sheet->setCellValue("J".$i, $fix[$a]['Lama Dirawat']);
            if($fix[$a]['L'] != "") {
                $sheet->setCellValue("K".$i, "1");
            }
            if($fix[$a]['P'] != "") {
                $sheet->setCellValue("L".$i, "1");
            }
            if($fix[$a]['0 - 28 HR'] != "") {
                $sheet->setCellValue("M".$i, "1");
            }
            if($fix[$a]['28 HR - 1 TH'] != "") {
                $sheet->setCellValue("N".$i, "1");
            }
            if($fix[$a]['1-4 TH'] != "") {
                $sheet->setCellValue("O".$i, "1");
            }
            if($fix[$a]['5-14 TH'] != "") {
                $sheet->setCellValue("P".$i, "1");
            }
            if($fix[$a]['15-24 TH'] != "") {
                $sheet->setCellValue("Q".$i, "1");
            }
            if($fix[$a]['25-44 TH'] != "") {
                $sheet->setCellValue("R".$i, "1");
            }
            if($fix[$a]['45-59 TH'] != "") {
                $sheet->setCellValue("S".$i, "1");
            }
            if($fix[$a]['60-64 TH'] != "") {
                $sheet->setCellValue("T".$i, "1");
            }
            if($fix[$a]['65 TH+'] != "") {
                $sheet->setCellValue("U".$i, "1");
            }
            $sheet->setCellValue("V".$i, $fix[$a]['Diagnosa']);
            $sheet->setCellValue("W".$i, $fix[$a]['Kelas']);
            if($fix[$a]['Dipulangkan Mati <=48 Jam'] != "") {
                $sheet->setCellValue("X".$i, "1");
            }
            if($fix[$a]['Dipulangkan Mati >48 Jam'] != "") {
                $sheet->setCellValue("Y".$i, "1");
            }
            if($fix[$a]['Pulang Paksa'] != "") {
                $sheet->setCellValue("Z".$i, "1");
            }
            if($fix[$a]['Kabur'] != "") {
                $sheet->setCellValue("AA".$i, "1");
            }
            if($fix[$a]['Rujuk RS Lain'] != "") {
                $sheet->setCellValue("AB".$i, "1");
            }
            if($fix[$a]['Dikembalikan ke Perujuk'] != "") {
                $sheet->setCellValue("AC".$i, "1");
            }
            if($fix[$a]['Dipulangkan Hidup'] != "") {
                $sheet->setCellValue("AD".$i, "1");
            }
            $sheet->getStyle("A".$i.":AD".$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $i++;
        }
        
        $border_end = $i-1;
        $thin = array ();
        $thin['borders']=array();
        $thin['borders']['allborders']=array();
        $thin['borders']['allborders']['style']=PHPExcel_Style_Border::BORDER_THIN ;
        $sheet  ->getStyle ( "A".$border_start.":AD".$border_end )->applyFromArray ($thin);
        
        $filename = "Laporan Indeks Penyakit ".strtoupper(ArrayAdapter::dateFormat("date d M Y", $_POST['dari']))." - ".strtoupper(ArrayAdapter::dateFormat("date d M Y", $_POST['sampai'])).".xls";
        header ( 'Content-Type: application/vnd.ms-excel' );
        header ( 'Content-Disposition: attachment;filename="'.$filename.'"' );
        header ( 'Cache-Control: max-age=0' );
        $writer = PHPExcel_IOFactory::createWriter ( $file, 'Excel5' );
        $writer->save ( 'php://output' );
		return;
    }
}

?>