<?php
	require_once("registration/class/pcare/PCare.php");

	class PCareObat extends PCare {
		private $no_kunjungan_pcare;
		private $kd_obat_sk;
		private $racikan;
		private $kdracikan;
		private $obat_dpho;
		private $kd_obat;
		private $signa1;
		private $signa2;
		private $jml_obat;
		private $jml_permintaan;
		private $nmobat_nondpho;

		public function getListObatDPHO($criteria, $start, $limit) {
			$this->execute("/obat/dpho/" . $criteria . "/" . $start . "/" . $limit, "GET");
	        $result = $this->getResponse();
	        $data = json_decode($result, true);
	        return $data;
		}

		public function addObat(
			$kd_obat_sk,
			$no_kunjungan_pcare,
			$racikan,
			$kdracikan,
			$obat_dpho,
			$kd_obat,
			$signa1,
			$signa2,
			$jml_obat,
			$jml_permintaan,
			$nmobat_nondpho
		) {
			$this->kd_obat_sk = $kd_obat_sk;
			$this->no_kunjungan_pcare = $no_kunjungan_pcare;
			$this->racikan = $racikan;
			$this->kdracikan = $kdracikan;
			$this->obat_dpho = $obat_dpho;
			$this->kd_obat = $kd_obat;
			$this->signa1 = $signa1;
			$this->signa2 = $signa2;
			$this->jml_obat = $jml_obat;
			$this->jml_permintaan = $jml_permintaan;
			$this->nmobat_nondpho = $nmobat_nondpho;

			$data_obat = $this->getDataObat();
			$this->execute("obat/kunjungan", "POST", $data_obat);
			$response  = $this->getResponse();
			$arr_response = json_decode($response, true);
			$msg = "";
			if ($arr_response != null) {
				$message = $arr_response["metaData"]['message'];
				if ($message == "CREATED") {
					$response = new ResponsePackage();
					$response->setStatus(ResponsePackage::$STATUS_OK);
					$response->setAlertVisible(true);
					$response->setAlertContent("Obat PCare Berhasil Ditambahkan", $msg);
					$content = array(
						'message'   => $message,
						'code'      => $arr_response["metaData"]['code']
					);
					$response->setContent($content);
					return $response->getPackage();
				} else {
					if ($arr_response["response"] == null) {
						$msg = $message;
					} else if (is_array($arr_response["response"])) {
						$field = $arr_response["response"][0]['field'];
						$msg = $arr_response["response"][0]['message'];
						$msg = $field . " " . $msg;
					} else {
						$msg = $arr_response["response"];
					}
					$response = new ResponsePackage();
					$response->setStatus(ResponsePackage::$STATUS_OK);
					$response->setAlertVisible(true);
					$response->setAlertContent("Pesan dari Server PCare", $msg);
					$content = array(
						'message'       => "FAILED"
					);
					$response->setContent($content);
					return $response->getPackage();
				}
			} else {
				$response = new ResponsePackage();
				$response->setStatus(ResponsePackage::$STATUS_OK);
				$response->setAlertVisible(true);
				$response->setAlertContent("Error Komunikasi dengan Server PCare", $this->getError());
				$content = array(
					'message'       => "FAILED"
				);
				$response->setContent($content);
				return $response->getPackage();
			}
		}

		private function getDataObat() {
			$data = array();
			$data['kdObatSK'] 		= $this->kd_obat_sk;
			$data['noKunjungan'] 	= $this->no_kunjungan_pcare;
			$data['racikan'] 		= $this->racikan;
			$data['kdRacikan'] 		= $this->kdRacikan;
			$data['obatDPHO'] 		= $this->obat_dpho;
			$data['kdObat'] 		= $this->kd_obat;
			$data['signa1'] 		= $this->signa1;
			$data['signa2'] 		= $this->signa2;
			$data['jml_obat'] 		= $this->jml_obat;
			$data['jml_permintaan']	= $this->jml_permintaan;
			$data['nmObatNonDPHO'] 	= $this->nmobat_nondpho;
			return $data;
		}
	}
?>