<?php
    require_once("registration/class/pcare/PCare.php");

    class PCareKunjungan extends PCare {
        private $no_kunjungan;
        private $no_kartu;
        private $tanggal_daftar;
        private $kode_poli;
        private $keluhan;
        private $kode_sadar;
        private $sistole;
        private $diastole;
        private $berat_badan;
        private $tinggi_badan;
        private $respiratory_rate;
        private $heart_rate;
        private $lingkar_perut;
        private $terapi;
        private $kode_status_pulang;
        private $tanggal_pulang;
        private $kode_dokter;
        private $kode_diagnosa_1;
        private $kode_diagnosa_2;
        private $kode_diagnosa_3;
        private $kode_poli_rujuk_internal;
        private $tanggal_estimasi_rujuk;
        private $kode_ppk;
        private $subspesialis;
        private $khusus;
        private $kode_tacc;
        private $alasan_tacc;
        private $anamnesa;
        private $alergi_makanan;
        private $alergi_udara;
        private $alergi_obat;
        private $kode_prognosa;
        private $terapi_obat;
        private $terapi_non_obat;
        private $bmhp;
        private $suhu;

        public function addKunjungan(
            $no_kunjungan,
            $no_kartu,
            $tanggal_daftar,
            $kode_poli,
            $keluhan,
            $kode_sadar,
            $sistole,
            $diastole,
            $berat_badan,
            $tinggi_badan,
            $respiratory_rate,
            $heart_rate,
            $lingkar_perut,
            $terapi,
            $kode_status_pulang,
            $tanggal_pulang,
            $kode_dokter,
            $kode_diagnosa_1,
            $kode_diagnosa_2,
            $kode_diagnosa_3,
            $kode_poli_rujuk_internal,
            $tanggal_estimasi_rujuk,
            $kode_ppk,
            $subspesialis,
            $khusus,
            $kode_tacc,
            $alasan_tacc,
            $anamnesa,
            $alergi_makanan,
            $alergi_udara,
            $alergi_obat,
            $kode_prognosa,
            $terapi_obat,
            $terapi_non_obat,
            $bmhp,
            $suhu
        ) {
            $this->no_kunjungan = $no_kunjungan;
            $this->no_kartu = $no_kartu;
            $this->tanggal_daftar = $tanggal_daftar;
            $this->kode_poli = $kode_poli;
            $this->keluhan = $keluhan;
            $this->kode_sadar = $kode_sadar;
            $this->sistole = $sistole;
            $this->diastole = $diastole;
            $this->berat_badan = $berat_badan;
            $this->tinggi_badan = $tinggi_badan;
            $this->respiratory_rate = $respiratory_rate;
            $this->heart_rate = $heart_rate;
            $this->lingkar_perut = $lingkar_perut;
            $this->terapi = $terapi;
            $this->kode_status_pulang = $kode_status_pulang;
            $this->tanggal_pulang = $tanggal_pulang;
            $this->kode_dokter = $kode_dokter;
            $this->kode_diagnosa_1 = $kode_diagnosa_1;
            $this->kode_diagnosa_2 = $kode_diagnosa_2;
            $this->kode_diagnosa_3 = $kode_diagnosa_3;
            $this->kode_poli_rujuk_internal = $kode_poli_rujuk_internal;
            $this->tanggal_estimasi_rujuk = $tanggal_estimasi_rujuk;
            $this->kode_ppk = $kode_ppk;
            $this->subspesialis = $subspesialis;
            $this->khusus = $khusus;
            $this->kode_tacc = $kode_tacc == null || $kode_tacc == "" ? 0 : $kode_tacc;
            if ($this->kode_status_pulang == 4) {
                $this->kode_tacc = -1;
            }
            $this->alasan_tacc = $alasan_tacc;
            $this->anamnesa = $anamnesa;
            $this->alergi_makanan = $alergi_makanan;
            $this->alergi_udara = $alergi_udara;
            $this->alergi_obat = $alergi_obat;
            $this->kode_prognosa = $kode_prognosa;
            $this->terapi_obat = $terapi_obat;
            $this->terapi_non_obat = $terapi_non_obat;
            $this->bmhp = $bmhp;
            $this->suhu = $suhu;

            $data_kunjungan = $this->getDataKunjungan();
            $this->execute("kunjungan/V1", "POST", $data_kunjungan);
            $response  = $this->getResponse();
            $arr_response = json_decode($response, true);
            $msg = "";
            if ($arr_response != null) {
                $message = $arr_response["metaData"]['message'];
                $code = $arr_response["metaData"]['code'];
                if ($code == 201) {
                    $this->no_kunjungan = $arr_response["response"][0]['message'];
                    $response = new ResponsePackage();
                    $response->setStatus(ResponsePackage::$STATUS_OK);
                    $response->setAlertVisible(true);
                    $response->setAlertContent("Kunjungan PCare Telah Berhasil Dibuat dengan No. Kunjungan : " . $this->no_kunjungan, $msg);
                    $content = array(
                        'message'       => $message,
                        'no_kunjungan'  => $this->no_kunjungan
                    );
                    $response->setContent($content);
                    return $response->getPackage();
                }else{
                    if ($arr_response["response"] == null) {
                        $msg = $message;
                    } else if(is_array($arr_response["response"]) ){
                        $field = $arr_response["response"][0]['field'];
                        $msg = $arr_response["response"][0]['message'];
                        $msg = $field . " " . $msg;    
                    }else{
                        $msg = $arr_response["response"];
                    }
                    $response = new ResponsePackage();
                    $response->setStatus(ResponsePackage::$STATUS_OK);
                    $response->setAlertVisible(true);
                    $response->setAlertContent("Pesan dari Server PCare", $msg);
                    $content = array(
                        'message'       => "FAILED"
                    );
                    $response->setContent($content);
                    return $response->getPackage();
                }
            } else {
                $response = new ResponsePackage();
                $response->setStatus(ResponsePackage::$STATUS_OK);
                $response->setAlertVisible(true);
                $response->setAlertContent("Error Komunikasi dengan Server PCare", $this->getError());
                $content = array(
                    'message'       => "FAILED"
                );
                $response->setContent($content);
                return $response->getPackage();
            }
        }

        public function editKunjungan(
            $no_kunjungan,
            $no_kartu,
            $tanggal_daftar,
            $kode_poli,
            $keluhan,
            $kode_sadar,
            $sistole,
            $diastole,
            $berat_badan,
            $tinggi_badan,
            $respiratory_rate,
            $heart_rate,
            $lingkar_perut,
            $terapi,
            $kode_status_pulang,
            $tanggal_pulang,
            $kode_dokter,
            $kode_diagnosa_1,
            $kode_diagnosa_2,
            $kode_diagnosa_3,
            $kode_poli_rujuk_internal,
            $tanggal_estimasi_rujuk,
            $kode_ppk,
            $subspesialis,
            $khusus,
            $kode_tacc,
            $alasan_tacc,
            $anamnesa,
            $alergi_makanan,
            $alergi_udara,
            $alergi_obat,
            $kode_prognosa,
            $terapi_obat,
            $terapi_non_obat,
            $bmhp,
            $suhu
        ) {
            $this->no_kunjungan = $no_kunjungan;
            $this->no_kartu = $no_kartu;
            $this->tanggal_daftar = $tanggal_daftar;
            $this->kode_poli = $kode_poli;
            $this->keluhan = $keluhan;
            $this->kode_sadar = $kode_sadar;
            $this->sistole = $sistole;
            $this->diastole = $diastole;
            $this->berat_badan = $berat_badan;
            $this->tinggi_badan = $tinggi_badan;
            $this->respiratory_rate = $respiratory_rate;
            $this->heart_rate = $heart_rate;
            $this->lingkar_perut = $lingkar_perut;
            $this->terapi = $terapi;
            $this->kode_status_pulang = $kode_status_pulang;
            $this->tanggal_pulang = $tanggal_pulang;
            $this->kode_dokter = $kode_dokter;
            $this->kode_diagnosa_1 = $kode_diagnosa_1;
            $this->kode_diagnosa_2 = $kode_diagnosa_2;
            $this->kode_diagnosa_3 = $kode_diagnosa_3;
            $this->kode_poli_rujuk_internal = $kode_poli_rujuk_internal;
            $this->tanggal_estimasi_rujuk = $tanggal_estimasi_rujuk;
            $this->kode_ppk = $kode_ppk;
            $this->subspesialis = $subspesialis;
            $this->khusus = $khusus;
            $this->kode_tacc = $kode_tacc == null || $kode_tacc == "" ? 0 : $kode_tacc;
            if ($this->kode_status_pulang == 4) {
                $this->kode_tacc = -1;
            }
            $this->alasan_tacc = $alasan_tacc;
            $this->anamnesa = $anamnesa;
            $this->alergi_makanan = $alergi_makanan;
            $this->alergi_udara = $alergi_udara;
            $this->alergi_obat = $alergi_obat;
            $this->kode_prognosa = $kode_prognosa;
            $this->terapi_obat = $terapi_obat;
            $this->terapi_non_obat = $terapi_non_obat;
            $this->bmhp = $bmhp;
            $this->suhu = $suhu;

            $data_kunjungan = $this->getDataKunjungan();
            $this->execute("kunjungan/V1", "PUT", $data_kunjungan);
            $response  = $this->getResponse();
            $arr_response = json_decode($response, true);
            $msg = "";
            if ($arr_response != null) {
                $message = $arr_response["metaData"]['message'];
                $code = $arr_response["metaData"]['code'];
                if ($code == 200) {
                    $response = new ResponsePackage();
                    $response->setStatus(ResponsePackage::$STATUS_OK);
                    $response->setAlertVisible(true);
                    $response->setAlertContent("Kunjungan PCare Berhasil Diperbarui", $msg);
                    $content = array(
                        'message'   => $message,
                        'code'      => $arr_response["metaData"]['code']
                    );
                    $response->setContent($content);
                    return $response->getPackage();
                }else{
                    if ($arr_response["response"] == null) {
                        $msg = $message;
                    } else if(is_array($arr_response["response"]) ){
                        $field = $arr_response["response"][0]['field'];
                        $msg = $arr_response["response"][0]['message'];
                        $msg = $field . " " . $msg;    
                    }else{
                        $msg = $arr_response["response"];
                    }
                    $response = new ResponsePackage();
                    $response->setStatus(ResponsePackage::$STATUS_OK);
                    $response->setAlertVisible(true);
                    $response->setAlertContent("Pesan dari Server PCare", $msg);
                    $content = array(
                        'message'       => "FAILED"
                    );
                    $response->setContent($content);
                    return $response->getPackage();
                }
            } else {
                $response = new ResponsePackage();
                $response->setStatus(ResponsePackage::$STATUS_OK);
                $response->setAlertVisible(true);
                $response->setAlertContent("Error Komunikasi dengan Server PCare", $this->getError());
                $content = array(
                    'message'       => "FAILED"
                );
                $response->setContent($content);
                return $response->getPackage();
            }
        }

        public function deleteKunjungan($no_kunjungan) {
            $this->execute("kunjungan/" . $no_kunjungan, "DELETE");
            $response  = $this->getResponse();
            $arr_response = json_decode($response, true);
            $msg = "";
            if ($arr_response != null) {
                $message = $arr_response["metaData"]['message'];
                $code = $arr_response["metaData"]['code'];
                if ($code == 200) {
                    $response = new ResponsePackage();
                    $response->setStatus(ResponsePackage::$STATUS_OK);
                    $response->setAlertVisible(true);
                    $response->setAlertContent("Kunjungan PCare Berhasil Dihapus", $msg);
                    $content = array(
                        'message'   => $message,
                        'code'      => $arr_response["metaData"]['code']
                    );
                    $response->setContent($content);
                    return $response->getPackage();
                }else{
                    if ($arr_response["response"] == null) {
                        $msg = $message;
                    } else if(is_array($arr_response["response"]) ){
                        $field = $arr_response["response"][0]['field'];
                        $msg = $arr_response["response"][0]['message'];
                        $msg = $field . " " . $msg;    
                    }else{
                        $msg = $arr_response["response"];
                    }
                    $response = new ResponsePackage();
                    $response->setStatus(ResponsePackage::$STATUS_OK);
                    $response->setAlertVisible(true);
                    $response->setAlertContent("Pesan dari Server PCare", $msg);
                    $content = array(
                        'message'       => "FAILED"
                    );
                    $response->setContent($content);
                    return $response->getPackage();
                }
            } else {
                $response = new ResponsePackage();
                $response->setStatus(ResponsePackage::$STATUS_OK);
                $response->setAlertVisible(true);
                $response->setAlertContent("Error Komunikasi dengan Server PCare", $this->getError());
                $content = array(
                    'message'       => "FAILED"
                );
                $response->setContent($content);
                return $response->getPackage();
            }
        }

        private function getDataKunjungan() {
            $data                           = array();
            $data['noKunjungan']            = $this->no_kunjungan;
            $data['noKartu']                = $this->no_kartu;
            $data['tglDaftar']              = $this->tanggal_daftar;
            $data['kdPoli']                 = $this->kode_poli;
            $data['keluhan']                = $this->keluhan;
            $data['kdSadar']                = $this->kode_sadar;
            $data['sistole']                = $this->sistole;
            $data['diastole']               = $this->diastole;
            $data['beratBadan']             = $this->berat_badan;
            $data['tinggiBadan']            = $this->tinggi_badan;
            $data['respRate']               = $this->respiratory_rate;
            $data['heartRate']              = $this->heart_rate;
            $data['lingkarPerut']           = $this->lingkar_perut;
            $data['terapi']                 = $this->terapi;
            $data['kdStatusPulang']         = $this->kode_status_pulang;
            $data['tglPulang']              = $this->tanggal_pulang;
            $data['kdDokter']               = $this->kode_dokter;
            $data['kdDiag1']                = $this->kode_diagnosa_1;
            $data['kdDiag2']                = $this->kode_diagnosa_2;
            $data['kdDiag3']                = $this->kode_diagnosa_3;
            $data['kdPoliRujukInternal']    = $this->kode_poli_rujuk_internal;
            $data['kdTacc']                 = $this->kode_tacc;
            $data['alasanTacc']             = $this->alasan_tacc;
            $data['anamnesa']               = $this->anamnesa;
            $data['alergiMakan']            = $this->alergi_makanan;
            $data['alergiUdara']            = $this->alergi_udara;
            $data['alergiObat']             = $this->alergi_obat;
            $data['kdPrognosa']             = $this->kode_prognosa;
            $data['terapiObat']             = $this->terapi_obat;
            $data['terapiNonObat']          = $this->terapi_non_obat;
            $data['bmhp']                   = $this->bmhp;
            $data['suhu']                   = $this->suhu;

            if ($this->kode_status_pulang == "4" || $this->kode_status_pulang == "6") {
                /// Jika Status Pulang : Rujuk Vertikal / Rujuk Horizontal
                $data['rujukLanjut']            = array(
                    'tglEstRujuk'   => $this->tanggal_estimasi_rujuk,
                    'kdppk'         => $this->kode_ppk,
                    'subSpesialis'  => $this->subspesialis,
                    'khusus'        => $this->khusus
                );
            }
            
            return $data;
        }
        
    }
?>