<?php

class LapRujukanAdapter extends ArrayAdapter {
    private $arr = array();
    private $spesialistik = 0;
    private $nonspesialistik = 0;
    private $jumlah = 0;
    
    public function adapt($d) {
        $this->number++;
        $a = array();
        
        $a['no']                = $this->number;
        $a['id']                = $d->id;
        $a['tanggal']           = self::format("date d M Y", $d->tanggal);
        $a['no_kartu_peserta']  = $d->no_bpjs;
        $a['nama_peserta']      = $d->nama_pasien;
        $a['diagnosa']          = $d->diagnosa;
        $a['dirujuk']           = $d->dirujuk;
        $a['spesialistik']      = $d->rujukan_spesialistik == 1 ? "<center>v</center>" : "<center>-</center>";
        $a['non_spesialistik']  = $d->rujukan_nonspesialistik == 1 ? "<center>v</center>" : "<center>-</center>";
        $a['alasan']            = $d->alasan_rujukan_nonspesialistik;
        
        $this->jumlah ++;
        $this->spesialistik = $this->spesialistik + $d->rujukan_spesialistik;
        $this->non_spesialistik = $this->non_spesialistik + $d->rujukan_nonspesialistik;
        
        return $a;
    }
    
    public function getContent($data) {
        $result = parent::getContent ( $data );
		$last_data = array ();
		$last_data ['tanggal'] 			    = "<center><strong>JUMLAH</strong></center>";
        $last_data ['no_kartu_peserta'] 	= "<center><strong>".$this->jumlah."</strong></center>";
        $last_data ['spesialistik']  	    = "<center><strong>".$this->spesialistik."</strong></center>";
        $last_data ['non_spesialistik']     = "<center><strong>".$this->non_spesialistik."</strong></center>";
        $result [] = $last_data;
        return $result;
    }
}

?>