<?php
/**
 * this is handling about element where used for patient management
 * @author goblooge
 *
 */

global $db;
require_once "smis-base/smis-include-service-consumer.php";
$header  = array ('No.',"Ruangan",'Cara Bayar','Jenis Kunjungan',"Jenis Pasien",'Perusahaan','Asuransi',"Total Tarif" );
$uitable = new Table ( $header, "Tarif Pendaftaran", NULL, true );
$uitable->setName ( "tarif_pendaftaran" );

if (isset ( $_POST ['command'] )) {
    $adapter = new SimpleAdapter();
    $adapter ->setUseNumber(true,"No.","back.");
	$adapter->add ( "Ruangan", "ruangan","unslug" );
	$adapter->add ( "Jenis Kunjungan", "jenis_kunjungan" );
	$adapter->add ( "Jenis Pasien", "jenis_pasien","trivial_0_Baru_Lama" );
    $adapter->add ( "Perusahaan", "nama_perusahaan" );
    $adapter->add ( "Asuransi", "nama_asuransi" );
    $adapter->add ( "Total Tarif", "total_tarif","money Rp." );
    $adapter->add ( "Cara Bayar", "carabayar","unslug" );
	
    $dbtable=new DBTable($db,"smis_mjm_tarif_pendaftaran");
	$dbtable->setFetchMethode ( DBTable::$ARRAY_FETCH );
	$dbres = new DBResponder ( $dbtable, $uitable, $adapter,$duplicate );
	$data = $dbres->command ( $_POST ['command'] );
	echo json_encode ( $data );
	return;
}

$jenis_pasien = new OptionBuilder();
$jenis_pasien ->add("Baru",0);
$jenis_pasien ->add("Lama",1);

$kunjungan = new OptionBuilder();
$kunjungan->add("Kunjungan Sakit","Kunjungan Sakit","0");
$kunjungan->add("Kunjungan Sehat","Kunjungan Sehat","0");
$kunjungan->add("SKS","SKS","0");

$serv = new ServiceConsumer($db,"get_jenis_kunjungan",NULL,"registration");
$serv ->execute();
$result = $serv ->getContent();
$kunjungan = new OptionBuilder();
foreach($result as $x){
    $kunjungan ->add($x['nama'],$x['nama']);
}


$serv = new ServiceConsumer($db,"get_carabayar",NULL,"registration");
$serv ->execute();
$result = $serv ->getContent();
$carabayar = new OptionBuilder();
$carabayar ->add("","",1);
foreach($result as $x){
    $carabayar ->add($x['nama'],$x['slug']);
}

$serv = new ServiceConsumer($db,"get_all_perusahaan",NULL,"registration");
$serv ->execute();
$result = $serv ->getContent();
$perusahaan = new OptionBuilder();
$perusahaan ->add("","",1);
foreach($result as $x){
    $perusahaan ->add($x['nama'],$x['id']);
}

$serv = new ServiceConsumer($db,"get_all_asuransi",NULL,"registration");
$serv ->execute();
$result = $serv ->getContent();
$asuransi = new OptionBuilder();
$asuransi ->add("","",1);
foreach($result as $x){
    $asuransi ->add($x['nama'],$x['id']);
}

$urjip=new ServiceConsumer($db, "get_urjip",array());
$urjip->setCached(true,"get_urjip");
$urjip->setMode(ServiceConsumer::$MULTIPLE_MODE);
$urjip->execute();
$content=$urjip->getContent();
$ruangan = array();
$ruangan[] = array(
    "name"=>"",
    "value"=>"",
    "default"=>1
);
foreach ($content as $autonomous=>$ruang){
    foreach($ruang as $nama_ruang=>$jip){
        $option			 	 = array();
        $option['value'] 	 = $nama_ruang;
        if(isset($jip['name'])){
            $option['name']	 = $jip['name'];
        }else{
            $option['name']	 = ArrayAdapter::format("unslug", $nama_ruang);
        }
        $ruangan[]			 = $option;
    }
}

$uitable->addModal ( "id", "hidden", "", "" );
$uitable->addModal ( "ruangan", "select", "Ruangan", $ruangan);
$uitable->addModal ( "carabayar", "select", "Cara Bayar", $carabayar ->getContent() );
$uitable->addModal ( "jenis_kunjungan", "select", "Jenis Kunjungan", $kunjungan->getContent() );
$uitable->addModal ( "jenis_pasien", "select", "Jenis Pasien", $jenis_pasien->getContent() );
$uitable->addModal ( "id_perusahaan", "select", "Perusahaan", $perusahaan->getContent() );
$uitable->addModal ( "id_asuransi", "select", "Asuransi", $asuransi->getContent() );
$uitable->addModal ( "jasa_operator", "money", "Jasa Operator", "" );
$uitable->addModal ( "biaya_kartu", "money", "Biaya Kartu", "" );
$uitable->addModal ( "jasa_rs", "money", "Jasa RS", "" );
$uitable->addModal ( "total_tarif", "money", "Total Tarif", "","y",null,true );

$modal = $uitable->getModal ();
$modal->setTitle ( "Tarif Pendafttaran" );
$modal->setComponentSize(Modal::$MEDIUM);
echo $uitable->getHtml ();
echo $modal->getHtml ();
echo addJS ( "framework/smis/js/table_action.js" );
?>
<script type="text/javascript">
var tarif_pendaftaran;
//var employee;
$(document).ready(function(){
	$('[data-toggle="popover"]').popover({trigger: 'hover','placement': 'top'});
	var column = new Array("id","ruangan","carabayar","jenis_kunjungan","jenis_pasien","id_perusahaan","id_asuransi","jasa_operator","biaya_kartu","jasa_rs","total_tarif",);
	tarif_pendaftaran = new TableAction("tarif_pendaftaran","manajemen","tarif_pendaftaran",column);
    tarif_pendaftaran.addSaveData = function(x){
        x['nama_perusahaan'] = $("#tarif_pendaftaran_id_perusahaan option:selected").text();
        x['nama_asuransi'] = $("#tarif_pendaftaran_id_asuransi option:selected").text();
        return x;
    };

    $("#tarif_pendaftaran_carabayar").on("click",function(){
        if($(this).val()=="perusahaan"){
            $("#tarif_pendaftaran_id_asuransi").prop('disabled',true);
            $("#tarif_pendaftaran_id_asuransi").val("");
            $("#tarif_pendaftaran_id_perusahaan").prop('disabled',false);
        }else if($(this).val()=="asuransi" || $(this).val()=="bpjs"){
            $("#tarif_pendaftaran_id_perusahaan").prop('disabled',true);
            $("#tarif_pendaftaran_id_perusahaan").val("");
            $("#tarif_pendaftaran_id_asuransi").prop('disabled',false);
        }else{
            $("#tarif_pendaftaran_id_asuransi").prop('disabled',true);
            $("#tarif_pendaftaran_id_asuransi").val("");
            $("#tarif_pendaftaran_id_perusahaan").prop('disabled',true);
            $("#tarif_pendaftaran_id_perusahaan").val("");
        }
    });

    $("#tarif_pendaftaran_jasa_operator, #tarif_pendaftaran_biaya_kartu, #tarif_pendaftaran_jasa_rs").on("change",function(){
        let jasa_operator = getMoney("#tarif_pendaftaran_jasa_operator");
        let biaya_kartu = getMoney("#tarif_pendaftaran_biaya_kartu");
        let jasa_rs = getMoney("#tarif_pendaftaran_jasa_rs");
        let total_tarif = jasa_operator + biaya_kartu + jasa_rs;
        setMoney("#tarif_pendaftaran_total_tarif",total_tarif);
    });

    tarif_pendaftaran.edit=function (id){
	var self		= this;
    var json_obj	= new Array();
	showLoading();	
	var edit_data	= this.getEditData(id);
	$.post('',edit_data,function(res){		
		var json	= getContent(res);
		if(json==null) return;
		for(var i=0;i<self.column.length;i++){
			if($.inArray(self.column[i],self.noclear)!=-1 && !self.edit_clear_for_no_clear){
				continue;
			}
            var name	= self.column[i];
			var the_id	= "#"+self.prefix+"_"+name;
            if( name in self.json_column && self.json_column.length>0){
				/** this function handling if there is a column that part of another column */
                var json_grup_name=self.json_column[name];
                if(json[json_grup_name]==""){
                    continue;
                }
                if(!(json_grup_name in json_obj)){
				    json_obj[json_grup_name]=$.parseJSON(json[json_grup_name]);
                }
                smis_edit(the_id,json_obj[json_grup_name][""+name]);    
            }else{
                /** this function handling reguler column **/
                smis_edit(the_id,json[""+name]);    
            }
		}
		dismissLoading();
		self.disabledOnEdit(self.column_disabled_on_edit);
        self.show_form();
        $("#tarif_pendaftaran_carabayar").trigger("click");
	});
	return this;
};
    
    tarif_pendaftaran.view();
});
</script>
