<?php
/**
 * this class used for print header of Laboratory Reporting
 * this use to maintain that header always fits with all system
 * 
 * @copyright Nurul Huda <goblooge@gmail.com>
 * @author goblooge
 * @license LGPL
 * @since 14 Nov 2014
 */

global $db;

$nama_konsultan = getSettings ( $db, "laboratory-konsultan-nama", "" );
$id_konsultan = getSettings ( $db, "laboratory-konsultan-id", "" );
$title = getSettings ( $db, "smis_autonomous_title", "" );
$logo = getLogo ();
$adress = getSettings ( $db, "smis_autonomous_address", "" );

$utk = ": <t id='untuk' class='untuk'><font  class='label label-important utk_rm' id='utk_rm'>Rekam Medis</font>";
$utk .= " <font class='label label-success utk_dokter' id='utk_dokter'>Pasien</font>";
$utk .= " <font class='label  utk_asuransi' id='utk_asuransi'>IKS</font><t>";
$utk .= " <font class='label label-important utk_lab' id='utk_lab'>Laboratory</font><t>";

$tp = new TablePrint ( "pheader" );
$tp	->setTableClass ( "pheader" )
	->setMaxWidth ( false )
	->addColumn ( "<img src='" . $logo . "' />", 1, 2, null, "header_logo" )
	->addColumn ( $title, 5, 1, null, "autonomous_title" )
	->commit ( "title" );
$tp	->addColumn ( $adress, 5, 1, null, "autonomous_address" )
	->commit ( "title" );

$tp	->addColumn ( "Nama", 1, 1, null, null, "phttl" )
	->addColumn ( "", 1, 1, null, "ph_nama" )
	->addColumn ( "Ibu Kandung", 1, 1, null, null, "phttl" )
	->addColumn ( "", 1, 1, null, "ph_ibu" )
	->addColumn ( "NRM", 1, 1, null, null, "phttl" )
	->addColumn ( "", 1, 1, null, "ph_nrm" )
	->commit ( "header" );

$tp	->addColumn ( "Alamat", 1, 1, null, null, "phttl" )
   	->addColumn ( "", 1, 1, null, "ph_alamat" )
   	->addColumn ( "Umur", 1, 1, null, null, "phttl" )
   	->addColumn ( "", 1, 1, null, "ph_umur" )
   	->addColumn ( "Konsultan", 1, 1, null, null, "phttl" )
   	->addColumn ( "", 1, 1, null, "ph_konsultan" )
	->commit ( "header" );

$tp	->addColumn ( "Pengirim", 1, 1, null, null, "phttl" )
	->addColumn ( "", 1, 1, null, "ph_pengirim" )
	->addColumn ( "L/P", 1, 1, null, null, "phttl" )
	->addColumn ( "", 1, 1, null, "ph_jk" )
	->addColumn ( "Ruang-Kelas", 1, 1, null, null, "phttl" )
	->addColumn ( "", 1, 1, null, "ph_rkls" )
	->commit ( "header" );

$tp	->addColumn ( "No Lab", 1, 1, null, null, "phttl" )
	->addColumn ( "", 1, 1, null, "ph_nolab" )
	->addColumn ( "Noreg", 1, 1, null, null, "phttl" )
	->addColumn ( "", 1, 1, null, "ph_noreg" )
	->addColumn ( "Cetakan Untuk", 1, 1, null, null, "phttl" )
	->addColumn ( $utk, 1, 1, null, "ph_untuk" )
	->commit ( "header" );

$tp	->addColumn ( "Diagnosa / Ket. Klinis", 1, 1, null, null, "phttl" )
	->addColumn ( "", 10, 1, null, "ph_diagnosa" )
	->commit ( "header" );

echo "<div id='print_header' class='hide'>" . $tp->getHtml () . "</div>";

$utk = ": <t id='untuk' class='untuk'><font  class='label label-important utk_rm' id='g_utk_rm'>Rekam Medis</font>";
$utk .= " <font class='label label-success utk_dokter' id='g_utk_dokter'>Pasien</font>";
$utk .= " <font class='label  utk_asuransi' id='g_utk_asuransi'>IKS</font><t>";
$utk .= " <font class='label label-important utk_lab' id='g_utk_lab'>Laboratory</font><t>";

$tp = new TablePrint ( "pheader" );
$tp	->setTableClass ( "pheader" )
	->setMaxWidth ( false )
	->addColumn ( "<img src='" . $logo . "' />", 1, 2, null, "header_logo" )
	->addColumn ( $title, 5, 1, null, "autonomous_title" )
	->commit ( "title" );
$tp	->addColumn ( $adress, 5, 1, null, "autonomous_address" )
	->commit ( "title" );

$tp	->addColumn ( "Nama", 1, 1, null, null, "phttl pbig" )
	->addColumn ( "", 1, 1, null, "phg_nama","pbig" )
	->addColumn ( "Ibu Kandung", 1, 1, null, null, "phttl pbig" )
	->addColumn ( "", 1, 1, null, "phg_ibu","pbig" )
	->commit("header");

$tp	->addColumn ( "NRM", 1, 1, null, null, "phttl pbig" )
	->addColumn ( "", 1, 1, null, "phg_nrm","pbig" )
	->addColumn ( "Noreg", 1, 1, null, null, "phttl pbig" )
	->addColumn ( "", 1, 1, null, "phg_noreg","pbig" )
	->commit ( "header" );

$tp	->addColumn ( "Alamat", 1, 1, null, null, "phttl pbig" )
	->addColumn ( "", 1, 1, null, "phg_alamat","pbig" )
	->addColumn ( "Umur", 1, 1, null, null, "phttl pbig" )
	->addColumn ( "", 1, 1, null, "phg_umur","pbig" )
	->commit("header");
	
$tp	->addColumn ( "Pengirim", 1, 1, null, null, "phttl pbig" )
	->addColumn ( "", 1, 1, null, "phg_pengirim","pbig" )
	->addColumn ( "Konsultan", 1, 1, null, null, "phttl pbig" )
	->addColumn ( "", 1, 1, null, "phg_konsultan","pbig" )
	->commit ( "header" );

$tp	->addColumn ( "L/P", 1, 1, null, null, "phttl pbig" )
	->addColumn ( "", 1, 1, null, "phg_jk","pbig" )
	->addColumn ( "Ruang-Kelas", 1, 1, null, null, "phttl pbig" )
	->addColumn ( "", 1, 1, null, "phg_rkls","pbig" )
	->commit ( "header" );

$tp	->addColumn ( "No Lab", 1, 1, null, null, "phttl pbig" )
	->addColumn ( "", 1, 1, null, "phg_nolab","pbig" )
	->addColumn ( "Cetakan Untuk", 1, 1, null, null, "phttl pbig" )
	->addColumn ( $utk, 1, 1, null, "phg_untuk","pbig" )
	->commit ( "header" );

$tp	->addColumn ( "Diagnosa / Ket. Klinis", 1, 1, null, null, "phttl" )
->addColumn ( "", 10, 1, null, "phg_diagnosa" )
->commit ( "header" );


echo "<div id='print_header_gabungan' class='hide'>" . $tp->getHtml () . "</div>";

?>
<style type="text/css">
	.pbig{ font-size:13px !important;}

	#pheader{ margin-left:10px;}
	#header_container {	padding-bottom: 15px;}
	#header_logo {	text-align: right;}
	#header_logo img { height: 100px; width: auto; margin: 0;}
	#autonomous_title { padding-top:30px !important; font-weight: 800; color: green; text-align: center; text-transform:uppercase; vertical-align: text-center; padding-left:20px !important;}
	#autonomous_address {color: black; text-align: center; padding-left:20px !important; border-bottom:dashed 1px #7777; padding-bottom:30px !important;}
	<?php 
		$hsize=getSettings($db, "laboratory-header-size", "35");
		$shsize=getSettings($db, "laboratory-sheader-size", "25");
		echo "#autonomous_title {font-size:".$hsize."px !important;}";
		echo "#autonomous_address {font-size:".$shsize."px !important;}";
		?>
	#header_info>div>div>div:nth-child(2) { font-weight: 800; text-transform: uppercase; }
	#header_info>div>div>div { min-height: 10px; }
	#header_info>div { margin: 0px; padding: 0px;}
	.pheader { width: 100%; margin-bottom: 5px;}
	.pheader tr td,#pheader tr th { border: none; margin: 0; padding: 0; font-size:11px;}
	
	.phttl { font-weight: 800;}
	@media print { 
		.untuk .label {font-size:13px !important;}
		.untuk .utk_asuransi {margin-left:-10px !important;}
		.untuk .utk_dokter {margin-left:-7px !important;}
		.untuk .utk_rm {margin-left:-4px !important;}
		.untuk .utk_lab {margin-left:-15px !important;}
		#untuk , #autonomous_title { -webkit-print-color-adjust: exact; }
		#autonomous_title { color: green !important; }
		#utk_rm, #g_utk_rm { color: red !important; }
		#utk_dokter,#g_utk_dokter { color: green !important; }
		#utk_asuransi,#g_utk_asuransi { color: blue !important;}
		#utk_lab,#g_utk_lab{ color: black !important;}
	}
</style>

<?php 
   /**
    * another way to draw that header was using rows 
    * span to create ad div with rowspan effect of bootsrap
    * 
	* $nama=new RowSpan("nama");
	* $nama->addSpan("Nama",3)->addSpan(": Sutikno ",9,1,"ph_nama");
	* $alamat=new RowSpan("nama");
	* $alamat->addSpan("Alamat",3)->addSpan(": Lamongan",9,1,"ph_alamat");
	* $pengirim=new RowSpan("pengirim");
	* $pengirim->addSpan("Pengirim",3)->addSpan(": Buinono ",9,1,"ph_pengirim");
	* $no_lab=new RowSpan("nolab");
	* $no_lab->addSpan("No Lab",3)->addSpan(": 6327863782",9,1,"ph_nolab");
	* $one=new RowSpan();
	* $one	->setDivEnable(true,true,true)
	* 		->addSpan($nama,0,RowSpan::$TYPE_COMPONENT)
	* 		->addSpan($alamat,0,RowSpan::$TYPE_COMPONENT)
	* 		->addSpan($pengirim,0,RowSpan::$TYPE_COMPONENT)
	* 		->addSpan($no_lab,0,RowSpan::$TYPE_COMPONENT);
	* $ibu=new RowSpan("ibu");
	* $ibu	->addSpan("Ibu",3)
	* 		->addSpan(": Munawaroh ",9,1,"ph_ibu");
	* $umur=new RowSpan("umur");
	* $umur->addSpan("Umur",3)
	* 		->addSpan(": 22 Tahun",9,1,"ph_umur");
	* $jk=new RowSpan("jk");
	* $jk->addSpan("L/P",3)->addSpan(": P ",9,1,"ph_jk");
	* $noreg=new RowSpan("noreg");
	* $noreg->addSpan("No Reg",3)->addSpan(": 0009",9,1,"ph_noreg");
	* $two=new RowSpan();
	* $two	->setDivEnable(true,true,true)
	* 		->addSpan($ibu,0,RowSpan::$TYPE_COMPONENT)
	* 		->addSpan($umur,0,RowSpan::$TYPE_COMPONENT)
	* 		->addSpan($jk,0,RowSpan::$TYPE_COMPONENT)
	* 		->addSpan($noreg,0,RowSpan::$TYPE_COMPONENT);
	* $nrm=new RowSpan("nrm");
	* $nrm->addSpan("NRM",3)->addSpan(": 0003",9,1,"ph_nrm");
	* $ruang=new RowSpan("ruang");
	* $ruang->addSpan("Ruang-Kelas",3)->addSpan(": Melati/Kelas III",9,1,"ph_rkls");
	* $kelas=new RowSpan("kelas");
	* $kelas	->addSpan("Konsultan",3)
	* 			->addSpan(": ".$nama_konsultan,9,1,"ph_nkonsultan");
	* $konsultan=new RowSpan("konsultan");
	* $konsultan	->addSpan("Untuk",3)
	* 				->addSpan(": ".$utk,9);
	* $three=new RowSpan();
	* $three	->setDivEnable(true,true,true)
	* 			->addSpan($nrm,0,RowSpan::$TYPE_COMPONENT)
	* 			->addSpan($kelas,0,RowSpan::$TYPE_COMPONENT)
	* 			->addSpan($ruang,0,RowSpan::$TYPE_COMPONENT)
	* 			->addSpan($konsultan,0,RowSpan::$TYPE_COMPONENT);
	* $detil=new RowSpan("header_info");
	* $detil	->addSpan($one,4,RowSpan::$TYPE_COMPONENT)
	* 			->addSpan($two,4,RowSpan::$TYPE_COMPONENT)
	* 			->addSpan($three,4,RowSpan::$TYPE_COMPONENT);
	* 			$header_title=new RowSpan();
	* $header_title->setDivEnable(true,true,false)
	* 				->addSpan(getSettings($db, "smis_autonomous_title", ""),0,RowSpan::$TYPE_HTML,"autonomous_title")
	* 				->addSpan(getSettings($db, "smis_autonomous_address", ""),0,RowSpan::$TYPE_HTML,"autonomous_address");
	* $header_logo=new RowSpan();
	* $logo=getSettings($db, "smis_autonomous_logo", "");
	* if($logo=="") $logo="smis-base/smis-logo.png";
	* else $logo=get_fileurl($logo);
	* $header_logo	->setDivEnable(true,true,true)
	* 				->addSpan("<img src='".$logo."' />");
	* $heder_container=new RowSpan("header_container");
	* $heder_container	->setDivEnable(false,false,false)
	* 					->addSpan($header_logo,1,RowSpan::$TYPE_COMPONENT,"header_logo")
	* 					->addSpan($header_title,11,RowSpan::$TYPE_COMPONENT,"header_title");
	* $hasil_print_header=new RowSpan("hasil_print_header","");
	* $hasil_print_header	->setDivEnable(true,false,true)
	* 						->addSpan($heder_container,0,RowSpan::$TYPE_COMPONENT)
	* 						->addSpan($detil,0,RowSpan::$TYPE_COMPONENT);
	* echo "<div id='print_header'>".$hasil_print_header->getHtml()."</div>";
	*/
?>
