<?php 

require_once "registration/class/pcare/PCare.php";

class MCUPCare extends PCare{
    public function deleteMCU($lab){

        $nokunjungan = $lab->nokunjungan;
        $kdmcu = $lab->kdmcu;
        

        global $db;
        $this->execute("/MCU/".$kdmcu."/kunjungan/".$nokunjungan,"DELETE");
        $result = $this->getResponse();
        $json = json_decode($result,true);
        $finalresult = array();
        if($json!=null){
            $code = $json["metaData"]['message'];
            if($code=="OK"){   
                $finalresult = array(
                    "success"=>1,
                    "message" =>  $code
                );                
            }else{
                $finalresult = array(
                    "success"=>0,
                    "message" => $code
                );
            }
        }else{
            $finalresult = array(
                "success"=>0,
                "message" => $this->getError()
            );
        }
        return $finalresult;
    }

    public function addMCU($lab){
        global $db;

        $nokunjungan = $lab->nokunjungan;
        $kdmcu = $lab->kdmcu==""?"0":$lab->kdmcu;
        $tgl = explode("-",$lab->tanggal);
        $tglPelayanan = $tgl[2]."-".$tgl[1]."-".$tgl[0];
        $hasilx = json_decode($lab->hasil,true);

        $tekananDarahSistole = 0;
        $tekananDarahDiastole = 0;
        if($nokunjungan==""){
            $query = "SELECT * FROM smis_mr_diagnosa WHERE noreg_pasien =  '".$lab->noreg_pasien."' AND prop!='del' ORDER BY id DESC";
            $diagnosa = $db->get_row($query);
            $nokunjungan = $diagnosa->no_kunjungan_pcare;
            $tekananDarahDiastole=$diagnosa->sistole;
            $tekananDarahSistole=$diagnosa->diastole;
        }
        $hasil = array();
        $hasil['darahRutinHemo'] = 0;
        $hasil['darahRutinLeu'] = 0;
        $hasil['darahRutinErit'] = 0;
        $hasil['darahRutinLaju'] = 0;
        $hasil['darahRutinHema'] = 0;
        $hasil['darahRutinTrom'] = 0;
        $hasil['lemakDarahHDL'] = 0;
        $hasil['lemakDarahLDL'] = 0;
        $hasil['lemakDarahChol'] = 0;
        $hasil['lemakDarahTrigli'] = 0;
        $hasil['gulaDarahSewaktu'] = 0;
        $hasil['gulaDarahPuasa'] = 0;
        $hasil['gulaDarahPostPrandial'] = 0;
        $hasil['gulaDarahHbA1c'] = 0;
        $hasil['fungsiHatiSGOT'] = 0;
        $hasil['fungsiHatiSGPT'] = 0;
        $hasil['fungsiHatiGamma'] = 0;
        $hasil['fungsiHatiProtKual'] = 0;
        $hasil['fungsiHatiAlbumin'] = 0;
        $hasil['fungsiGinjalCrea'] = 0;
        $hasil['fungsiGinjalUreum'] = 0;
        $hasil['fungsiGinjalAsam'] = 0;

        $detect = array();
        $r = $db->get_result("SELECT slug,bpjs FROM smis_lab_hasil");
        foreach($r as $d){
            $detect[$d->slug]=$d->bpjs; 
        }

        foreach($hasilx as $key=>$val){
            if($val!="" && $val!="0"){
                $bpjs = trim($detect[$key]);
                if($bpjs!=""){
                    $hasil[$bpjs]=doubleval($val);
                }
            }
        }

        $request = array(
            "kdMCU"=> intval($kdmcu),
            "noKunjungan"=> $nokunjungan,
            "kdProvider"=> $this->ppk_pelayanan,
            "tglPelayanan"=> $tglPelayanan,
            "tekananDarahSistole"=> intval($tekananDarahSistole),
            "tekananDarahDiastole"=> intval($tekananDarahDiastole),
            "radiologiFoto"=> null,
            
            "darahRutinHemo"=> intval($hasil['darahRutinHemo']),
            "darahRutinLeu"=> intval($hasil['darahRutinLeu']),
            "darahRutinErit"=> intval($hasil['darahRutinErit']),
            "darahRutinLaju"=> intval($hasil['darahRutinLaju']),
            "darahRutinHema"=> intval($hasil['darahRutinHema']),
            "darahRutinTrom"=> intval($hasil['darahRutinTrom']),
            "lemakDarahHDL"=> intval($hasil['lemakDarahHDL']),
            "lemakDarahLDL"=> intval($hasil['lemakDarahLDL']),
            "lemakDarahChol"=> intval($hasil['lemakDarahChol']),
            "lemakDarahTrigli"=> intval($hasil['lemakDarahTrigli']),
            "gulaDarahSewaktu"=> intval($hasil['gulaDarahSewaktu']),
            "gulaDarahPuasa"=> intval($hasil['gulaDarahPuasa']),
            "gulaDarahPostPrandial"=> intval($hasil['gulaDarahPostPrandial']),
            "gulaDarahHbA1c"=> intval($hasil['gulaDarahHbA1c']),
            "fungsiHatiSGOT"=> intval($hasil['fungsiHatiSGOT']),
            "fungsiHatiSGPT"=> intval($hasil['fungsiHatiSGPT']),
            "fungsiHatiGamma"=> intval($hasil['fungsiHatiGamma']),
            "fungsiHatiProtKual"=> intval($hasil['fungsiHatiProtKual']),
            "fungsiHatiAlbumin"=> intval($hasil['fungsiHatiAlbumin']),
            "fungsiGinjalCrea"=> intval($hasil['fungsiGinjalCrea']),
            "fungsiGinjalUreum"=> intval($hasil['fungsiGinjalUreum']),
            "fungsiGinjalAsam"=> intval($hasil['fungsiGinjalAsam']),

            "fungsiJantungABI"=> 0,
            "fungsiJantungEKG"=> null,
            "fungsiJantungEcho"=> null,
            "funduskopi"=> null,
            "pemeriksaanLain"=> null,
            "keterangan"=> null
        );

        

        $methode = "POST";
        if(intval($kdmcu)!=0){
            $methode = "PUT";
        }

        
        $this->execute("/MCU",$methode,$request);
        $result = $this->getResponse();
        $json = json_decode($result,true);        
        $finalresult = array();

        global $querylog;
        $querylog->addMessage("JSON ".json_encode($json));
        if($json!=null){
            $code = strtoupper($json['metaData']['code']);
            if($code==201 || $code==200){   
                $finalresult = array(
                    "success"=>1,
                    "message" =>$code
                );
                $kdmcu = $json['response']['message'];
            
                if($methode=="POST"){
                    $query = "UPDATE smis_lab_pesanan SET kdmcu='".$kdmcu."', nokunjungan='".$nokunjungan."' WHERE id='".$lab->id."' ";
                    $db->query($query);    
                }
                
            }else{
                $finalresult = array(
                    "success"=>0,
                    "message" => $code
                );
            }
        }else{
            $finalresult = array(
                "success"=>0,
                "message" => $this->getError()
            );
        }
        return $finalresult;
    }
}