<?php
/**
 * this used for viewing the history of payment
 * this page automatically filter the bank payment
 * 
 * @version     : 5.0.0
 * @since       : 14 May 2015
 * @author      : Nurul Huda
 * @copyright   : goblooge@gmail.com
 * @license     : LGPLv3
 * @database    : smis_ksr_bayar
 * */
global $db;
$header=array ("ID","No Kwitansi",'Tanggal',"Ruangan","Carabayar","Nama","Noreg","NRM",'Nilai',"Bank","Tambahan Bank","Tambahan Cash",'Keterangan',"Operator","Asal Data" );

$uitable = new Table ( $header, "", NULL, true );
$head="<tr><td colspan='20' style='text-align:center'><strong >Laporan Pembayaran Bank Pasien</strong></td></tr>";
$uitable->addHeader("before", $head);
$head="<tr><td colspan='20' style='text-align:center'><strong id='tgl_lap_bank_print'></strong></td></tr>";
$uitable->addHeader("before", $head);
$uitable->setFooterVisible(false);
$uitable->setName ( "lap_bank" );

$uitable->setEditButtonEnable(false);
$uitable->setAddButtonEnable(false);
$uitable->setDelButtonEnable(false);

$button = new Button("","bank_push_akunting","Post");
$button->setClass("btn-primary");
$button->setIcon("fa fa-upload");
$button->setIsButton(Button::$ICONIC_TEXT);
$button->setAction("lap_bank.post_to_all()");
$uitable->addContentButton("push_to_accounting",$button);

if (isset ( $_POST ['command'] )) {
	require_once 'kasir/class/adapter/LapBankAdapter.php';
	require_once 'kasir/class/responder/LaporanBankResponder.php';
	$adapter = new LapBankAdapter ();
	$adapter->add ( "ID", "id","only-digit8");
	$adapter->add ( "No Kwitansi", "no_kwitansi");	
	$adapter->add ( "Nama", "nama_pasien");
	$adapter->add ( "NRM", "nrm_pasien","digit6");
	$adapter->add ( "Noreg", "noreg_pasien","digit6");		
	$adapter->add ( "Ruangan", "ruangan","unslug");
	$adapter->add ( "Carabayar", "carabayar","unslug");
	$adapter->add ( "Tanggal", "waktu", "date d M Y H:i" );
	$adapter->add ( "Nilai", "nilai", "money Rp." );
	$adapter->add ( "Operator", "operator" );
	$adapter->add ( "Keterangan", "keterangan" );
	$adapter->add ( "Asal Data", "unit_kerja");
	
	$dbtable = new DBTable ( $db, "smis_ksr_bayar" );
	$dbtable->setFetchMethode ( DBTable::$ARRAY_FETCH );
	$dbtable->addCustomKriteria ( "metode", "='bank'" );	
	$dbres = new LaporanBankResponder ( $dbtable, $uitable, $adapter );
	if($dbres->isView()){
		if($_POST['dari']!="")
			$dbtable->addCustomKriteria(null, " waktu>='".$_POST['dari']."' ");
		if($_POST['sampai']!="")
			$dbtable->addCustomKriteria(null, " waktu<'".$_POST['sampai']."' ");
        if($_POST['filter_origin']!="")		
            $dbtable->addCustomKriteria("unit_kerja", " ='".$_POST['filter_origin']."' ");
		$dbtable->setShowAll(true);
	}
	$data = $dbres->command ( $_POST ['command'] );
	if($data!=NULL)
		echo json_encode ( $data );
	return;
}

global $user;
global $db;
require_once 'smis-base/smis-include-service-consumer.php';
$serv = new ServiceConsumer($db,"get_all_unit_kerja",array("username"=>$user->getUsername()),"hrd");
$serv->execute();
$content = $serv->getContent();

$uitable->addModal ( "dari", "datetime", "Dari", "" );
$uitable->addModal ( "sampai", "datetime", "Sampai", "" );
$uitable->addModal ( "filter_origin", "select", "Unit Kerja",$content );
$form=$uitable->getModal ()->getForm();

$cari=new Button("", "", "Search");
$cari->setIsButton(Button::$ICONIC);
$cari->setIcon("fa fa-search");
$cari->setClass("btn-primary");
$cari->setAction("lap_bank.view()");
$cari->addAtribute("data-content","Search...");
$cari->addAtribute("data-toggle","popover");

$excel=new Button("", "", "Search");
$excel->setIsButton(Button::$ICONIC);
$excel->setIcon("fa fa-file-excel-o");
$excel->setClass("btn-primary");
$excel->setAction("lap_bank.excel()");
$excel->addAtribute("data-content","Print Excel");
$excel->addAtribute("data-toggle","popover");

$print=new Button("", "", "Search");
$print->setIsButton(Button::$ICONIC);
$print->setIcon("fa fa-print");
$print->setClass("btn-primary");
$print->setAction("lap_bank.print()");
$print->addAtribute("data-content","Print ");
$print->addAtribute("data-toggle","popover");

$form->addElement("",$cari);
$form->addElement("",$print);
$form->addElement("",$excel);
$form->addElement("",$button);

echo $form->getHtml ();
echo $uitable->getHtml ();
echo addJS ( "framework/bootstrap/js/bootstrap-datetimepicker.js" );
echo addCSS ( "framework/bootstrap/css/bootstrap-datetimepicker.css" );
echo addJS ( "kasir/resource/js/lap_bank.js" ,false);
?>
