<?php 
global $db;
global $user;
require_once "smis-libs-class/MasterTemplate.php";
require_once "smis-libs-class/MasterSlaveTemplate.php";
require_once "kasir/class/responder/PengeluaranHarianDBResponder.php";
$operator   = new OptionBuilder();
$query      = "SELECT DISTINCT operator FROM smis_ksr_pengeluaran_harian ";
$result     = $db->get_result($query);
$operator   ->addSingle("",1);
foreach($result as $r){
    $operator ->addSingle($r->operator);
}

$master  = new MasterSlaveTemplate($db,"smis_ksr_pengeluaran_harian","kasir","pengeluaran_harian");
$responder = new PengeluaranHarianDBResponder($master->getDBtable(),$master->getUItable(),$master->getAdapter());
$master ->setDBresponder($responder);
$master  ->getUItable()
         ->addModal("dari","date","Dari","")
         ->addModal("sampai","date","Sampai","")
         ->addModal("s_operator","select","Operator",$operator ->getContent());
$form = $master  ->getForm();
$master  ->getUItable()->clearContent();

$search = new Button("","","");
$search ->addClass("btn btn-primary");
$search ->setIcon("fa fa-search");
$search ->setIsButton(Button::$ICONIC_TEXT);
$search ->setAction("pengeluaran_harian.view()");

$excel = new Button("","","");
$excel ->addClass("btn btn-primary");
$excel ->setIcon("fa fa-file-excel-o");
$excel ->setIsButton(Button::$ICONIC_TEXT);
$excel ->setAction("pengeluaran_harian.excel()");

$form ->addElement("",$search);
$form ->addElement("",$excel);


$master  ->addRegulerData("dari","dari","id-value");
$master  ->addRegulerData("sampai","sampai","id-value");
$master  ->addRegulerData("s_operator","s_operator","id-value");

$master  ->getUItable()->setHeader(array("No.","Pengeluaran","Tanggal","Jumlah","Keterangan","Operator"));
$master  ->getAdapter()->setUseNumber(true,"No.","back.");
$master  ->getAdapter()->add("Pengeluaran","nama_pengeluaran");
$master  ->getAdapter()->add("Tanggal","tanggal","date d M Y");
$master  ->getAdapter()->add("Jumlah","jumlah","money Rp.");
$master  ->getAdapter()->add("Keterangan","keterangan");
$master  ->getAdapter()->add("Operator","operator");

$master  ->getUItable()->addModal("id","hidden","","");
$master  ->getUItable()->addModal("nama_pengeluaran","text","Pengeluaran","");
$master  ->getUItable()->addModal("jumlah","money","Jumlah","");
$master  ->getUItable()->addModal("tanggal","date","Tanggal","");
$master  ->getUItable()->addModal("keterangan","textarea","Keterangan","");
$master  ->getUItable()->addModal("operator","text","Operator",$user->getNameOnly(),"n",null,true);
$master  ->setDateEnable(true);
$master  ->setAutoReload(true);
$master  ->setModalTitle("Pengeluaran Harian");

if($master->getDBResponder()->isView() || $master->getDBResponder()->isExcel() ){
    $dbtable = $master->getDBtable();
    if(isset($_POST['dari']) && $_POST['dari']!=""){
        $dbtable->addCustomKriteria(NULL," tanggal >= '".$_POST['dari']."' ");
    }
    if(isset($_POST['sampai']) && $_POST['sampai']!=""){
        $dbtable->addCustomKriteria(NULL," tanggal <= '".$_POST['sampai']."' ");
    }
    if(isset($_POST['s_operator']) && $_POST['s_operator']!=""){
        $dbtable->addCustomKriteria(NULL," operator <= '".$_POST['s_operator']."' ");
    }
}

$master  ->initialize();