<?php
function base_urlx($atRoot = FALSE, $atCore = FALSE, $parse = FALSE)
{
    return SMIS_BASE_URL;
}

class SuratSehatTable extends Table{
    public function getPrintedElement($p,$f){
        global $db;
        $name    = getSettings($db,"smis_autonomous_title","");
        $address = getSettings($db,"smis_autonomous_address","");
        $phone   = getSettings($db,"smis_autonomous_contact","");
        $town    = getSettings($db,"smis_autonomous_town","");
        $tanggal = ArrayAdapter::dateFormat("date d M Y",$p->tanggal);

        $fe = file_exists("suratsehat/qr-".$p->id.".png");
        $url = base_urlx()."/suratsehat/ss-".$p->id.".html";
        if(!$fe){
            require_once "smis-libs-out/phpqrcode/qrlib.php";
            QRcode::png($url, "suratsehat/qr-".$p->id.".png", QR_ECLEVEL_Q,4,2);
        }

        $noreg_pasien = $p->noreg_pasien;
        $dbt = new DBTable($db,"smis_rg_layananpasien");
        $px = $dbt->select($noreg_pasien);
        $uk = $px->unit_kerja;

        $faskes = new DBTable($db,"smis_rg_faskes");
        $fk = $faskes->select(array("unitkerja"=>$uk));

        $name = $fk->nama;
        $address = $fk->alamat;
        $phone = $fk->telpon;

        $logo    = "<img style='width:50px !important;' src='".base_urlx()."/".getLogo()."' />";
        $table   = new TablePrint("table_surat_sehat");
        $table   ->setDefaultBootrapClass(false);
        $table   ->setMaxWidth(false);
        
        /*$table   ->addSpace(1,1);
        $table   ->addColumn("Surat Keterangan Kesehatan",4,1,"body",null,"sshb sshg sshc sshu");
        $table   ->addSpace(1,1);
        $table	 ->addColumn("Medical Certificate",4,1,"body",null,"sshb sshg sshc");
        $table   ->addColumn("Dokter / <i>Doctor</i> : ".$p->nama_dokter,4,1,null,null,"sshb sshm sshc sshborder");
        $table   ->addColumn("No. ".$p->nomor,1,1,"body",null,"sshb sshm sshc");
        $table   ->addSpace(5,1,"body");
        $table   ->addSpace(1,1)
                 ->addColumn("Nama / <i>Name</i>",2,1)
                 ->addColumn(":",1,1)
                 ->addColumn($p->nama_pasien,1,1,"body");
        $table   ->addSpace(1,1)
                 ->addColumn("Umur / <i>Age</i>",2,1)
                 ->addColumn(":",1,1)
                 ->addColumn($p->umur,1,1,"body");
        $table   ->addSpace(1,1)
                 ->addColumn("Alamat / <i>Address</i>",2,1)
                 ->addColumn(":",1,1)
                 ->addColumn($p->alamat,1,1,"body");
        $table   ->addColumn("dan secara fisik diagnostik ternyata : <strong>".($p->kondisi=="0"?"Sehat":"Tidak Sehat")."</strong> untuk ".$p->untuk,5,1,"body");
        $table   ->addColumn("and phisically diagnostic that <strong>".($p->kondisi=="0"?"Healthy":"Un Healthy")."</strong> for ",5,1,"body",null,"sshi");
        $table   ->addSpace(5,1,"body");

        $table   ->addColumn("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -",5,1,"body");
        */
        $table   ->addColumn($logo,1,4)
                 ->addColumn("Klinik",4,1,"body",null,"sshb sshg sshl");
        $table   ->addColumn($name,4,1,"body",null,"sshb sshg sshl");
        $table   ->addColumn($address,4,1,"body",null,"sshl");
        $table   ->addColumn($phone.".",4,1,"body",null,"sshl");

        $table   ->addColumn("Dokter / <i>Doctor</i> : ".$p->nama_dokter,4,1,null,null,"sshb sshm sshc sshborder");
        $table   ->addColumn("No. ".$p->nomor,1,1,"body",null,"sshb sshm sshc");
       
        $header  = $table->getHtml();
        
        $table   ->addSpace(5,1,"body");
        $table   ->addColumn("Surat Keterangan Kesehatan",5,1,"body",null,"sshb sshg sshc sshu");
        $table   ->addColumn("Medical Certificate",5,1,"body",null,"sshb sshg sshc"); 
        $table   ->addColumn("yang bertanda tangan dibawah ini Dokter sendiri, dengan mengingat",5,1,"body");
        $table   ->addColumn("I, a Doctor Who sign below, in remembrance ",5,1,"body",null,"sshi");
        $table   ->addSpace(5,1,"body");
        $table   ->addColumn("sumpah ketika menerima jabatan, telah memeriksa dengan teliti seorang : ",5,1,"body");
        $table   ->addColumn("of vow when received the title, has examined that below person : ",5,1,"body",null,"sshi");
        $table   ->addSpace(5,1,"body");
        $table   ->addSpace(1,1)
                 ->addColumn("Nama / <i>Name</i>",2,1)
                 ->addColumn(":",1,1)
                 ->addColumn($p->nama_pasien,1,1,"body");
        $table   ->addSpace(1,1)
                 ->addColumn("Umur / <i>Age</i>",2,1)
                 ->addColumn(":",1,1)
                 ->addColumn($p->umur,1,1,"body");
        $table   ->addSpace(1,1)
                 ->addColumn("Alamat / <i>Address</i>",2,1)
                 ->addColumn(":",1,1)
                 ->addColumn($p->alamat,1,1,"body");
        $table   ->addColumn("dan secara fisik diagnostik ternyata : <strong>".($p->kondisi=="0"?"Sehat":"Tidak Sehat")."</strong> untuk ".$p->untuk,5,1,"body");
        $table   ->addColumn("and phisically diagnostic that <strong>".($p->kondisi=="0"?"Healthy":"Un Healthy")."</strong> for ",5,1,"body",null,"sshi");
        $table   ->addSpace(5,1,"body");
        $table   ->addColumn("demikian surat keterangan ini dibuat untuk dapat dipergunakan seperlunya.",5,1,"body");
        $table   ->addColumn("this certificate is made to be use accordingly.",5,1,"body",null,"sshi");

        $table   ->addSpace(3,1)
                 ->addColumn($town.", ".$tanggal,2,1,"body",null,"sshc");
        $table   ->addSpace(3,1)
                ->addColumn(" Nama / <i>Name</i> ",2,1,"body",null," sshc");

        $table   ->addSpace(3,1);
        $table   ->addColumn("<img src='".base_urlx()."/suratsehat/qr-".$p->id.".png' >",2,1,"body",null," sshc");        
        $table   ->addColumn("Catatan/<i>Note</i>",2,1,null,null,"sshl")
                 ->addSpace(1,1)
                 ->addColumn("<u>( ".$p->nama_dokter." )</u>",2,1,"body",null,"sshc");
        $table   ->addColumn("- Tinggi Badan / <i>Height</i> : ".$p->tinggi." cm",2,1,null,null,"sshl")
                 ->addSpace(1,1)
                 ->addColumn("Dokter Pemeriksa",2,1,"body",null,"sshc");
        $table   ->addColumn("- Berat Badan / <i>Weight</i> : ".$p->berat." Kg",2,1,null,null,"sshl")
                 ->addSpace(1,1)
                 ->addColumn($url,2,3,"body",null,"sshc");
        $table   ->addColumn("- Golongan Darah / <i>Blood Type</i> : ".$p->gol_darah,2,1,null,null,"sshl")
                 ->addSpace(1,1,"body",null,"sshl");
        $table   ->addColumn("- T.D : ".$p->td,2,1,null,null,"sshl")
                 ->addSpace(1,1,"body",null,"sshl");

        $table   ->addColumn("<div class='ctrl_1'>&nbsp;</div>",1,1);
        $table   ->addColumn("<div class='ctrl_2'>&nbsp;</div>",1,1);
        $table   ->addColumn("<div class='ctrl_3'>&nbsp;</div>",1,1);
        $table   ->addColumn("<div class='ctrl_4'>&nbsp;</div>",1,1);
        $table   ->addColumn("<div class='ctrl_5'>&nbsp;</div>",1,1,"body");
        $table   ->addSpace(5,1,"body");

        $html = $this->generateHtmlSuratSakit($p,$header);
        file_put_contents("suratsehat/ss-".$p->id.".html", $html."<style>".file_get_contents("kasir/resource/css/print-ss.css")."</style>");
        return   $table->getHtml();
    }


    public function generateHtmlSuratSakit($p,$header){
        $table =  new TablePrint("table_surat_sehat");
        $table->addColumn("<h5>Status Dokumen</h5>","1","1")->commit("title");
        $table->addColumn("<h5 class='success'>VALID</h5>","1","1")->commit("title");

        $table->addColumn("<h5>No. Surat</h5>","1","1")->commit("title");
        $table->addColumn("<h5>".$p->nomor."</h5>","1","1")->commit("title");

        $table->addColumn("<h5>Tanggal</h5>","1","1")->commit("title");
        $table->addColumn("<h5>".ArrayAdapter::dateFormat("date d M Y",$p->tanggal)."</h5>","1","1")->commit("title");

        $table->addColumn("<h5>Nama</h5>","1","1")->commit("title");
        $table->addColumn("<h5>".$p->nama_pasien."</h5>","1","1")->commit("title");

        $table->addColumn("<h5>Secara Fisik Diagnostik Ternyata : <strong>".($p->kondisi=="0"?"Sehat":"Tidak Sehat")."</strong> untuk ".$p->untuk,"1","1")->commit("title");
       
        $table->addColumn("<h5>Dokter</h5>","1","1")->commit("title");
        $table->addColumn("<h5>".$p->nama_dokter."</h5>","1","1")->commit("title");

        return $header."<img  id='checked' src='".base_urlx()."/kasir/resource/image/check.png' style='clear:both;'/>".$table->getHtml();
    }
}
