<?php 
function base_urlx($atRoot = FALSE, $atCore = FALSE, $parse = FALSE)
{
    return SMIS_BASE_URL;
}

class SuratSakitTable extends Table{
    
    public function getPrintedElement($p,$f){
        global $db;
        $fe = file_exists("suratsakit/qr-".$p->id.".png");
        $url = base_urlx()."/suratsakit/ss-".$p->id.".html";
        //if(!$fe){
            require_once "smis-libs-out/phpqrcode/qrlib.php";
            QRcode::png($url, "suratsakit/qr-".$p->id.".png", QR_ECLEVEL_Q,4,2);
        //}
        $noreg_pasien = $p->noreg_pasien;
        $dbt = new DBTable($db,"smis_rg_layananpasien");
        $px = $dbt->select($noreg_pasien);
        $uk = $px->unit_kerja;

        $faskes = new DBTable($db,"smis_rg_faskes");
        $fk = $faskes->select(array("unitkerja"=>$uk));

        $name    = getSettings($db,"smis_autonomous_title","");
        $address = getSettings($db,"smis_autonomous_address","");
        $phone   = getSettings($db,"smis_autonomous_contact","");
        $town    = getSettings($db,"smis_autonomous_town","");


        $logo    = "<img src='".base_urlx()."/".getLogo()."' />";
        $table   = new TablePrint("table_surat_sakit");
        $table   ->setDefaultBootrapClass(false);
        $table   ->setMaxWidth(false);
        $table   ->addColumn($logo,1,3)
                 ->addColumn($fk->nama,4,1,"body",null,"ssb ssg ssl");

        $table   ->addColumn($fk->alamat,4,1,"body",null,"ssl");
        $table   ->addColumn($fk->telpon.".",4,1,"body",null,"ssl");
        $header  = $table->getHtml();

        $table   = new TablePrint("table_surat_sakit");
        $table   ->setDefaultBootrapClass(false);
        $table   ->setMaxWidth(false);
        $table   ->addColumn("No. ".$p->nomor,5,1,"body",null,"ssb ssm ssc");
        $table   ->addColumn("SURAT KETERANGAN",5,1,"body",null,"ssb ssg ssc ssu");
        $table   ->addColumn("MEDICAL CERTIFICATE",5,1,"body",null,"ssb ssg ssc");
        $table   ->addSpace(5,1,"body");
        $table   ->addColumn("Menerangakan dengan sesungguhnya bahwa",5,1,"body");
        $table   ->addColumn("This is to certify that ",5,1,"body",null,"ssi");
        $table   ->addSpace(5,1,"body");
        $table   ->addColumn("Nama / <i>Name</i>",3,1)
                 ->addColumn(":",1,1)
                 ->addColumn($p->nama_pasien,1,1,"body");
        $table   ->addColumn("Umur / <i>Age</i>",3,1)
                 ->addColumn(":",1,1)
                 ->addColumn($p->umur,1,1,"body");
        $table   ->addColumn("Jenis Kelamin / <i>Gender</i>",3,1)
                 ->addColumn(":",1,1)
                 ->addColumn($p->jk=="0"?"L":"P",1,1,"body");
        $table   ->addColumn("Perusahaan / <i>Company</i>",3,1)
                 ->addColumn(":",1,1)
                 ->addColumn($p->perusahaan,1,1,"body");
        $table   ->addColumn("Nomor Pesereta / <i>Member ID</i>",3,1)
                 ->addColumn(":",1,1)
                 ->addColumn($p->nrm_pasien,1,1,"body");
        $tanggal = ArrayAdapter::dateFormat("date d M Y",$p->tanggal);
        $table   ->addColumn("Pada tanggal ".$tanggal." dilakukan pemeriksaan kesehatan dari orang",5,1,"body");
        $table   ->addColumn("On the ".$tanggal." Has done medical examination to the above ",5,1,"body",null,"ssi");
        $table   ->addColumn("tersebut diatas dengan hasilnya",3,1)
                 ->addColumn(":",2,1,"body");
        $table   ->addColumn("mentioned person with result as follows",3,1,null,"ssi")
                 ->addColumn(":",2,1,"body");
        if($p->kondisi=="0"){
            $table   ->addColumn("Baik",5,1,"body",null,"sspl");
            $table   ->addColumn("Good",5,1,"body",null,"ssi sspl");
        }else{
            $p->selama = $p->selama+1;
            loadLibrary("smis-libs-function-math");
            $table   ->addColumn("Perlu istirahat selama ".$p->selama." Hari ( ".numbertell($p->selama)." Hari)",5,1,"body",null,"sspl");
            $table   ->addColumn("Need Medical Leave",5,1,"body",null,"ssi sspl");
            $dari    = ArrayAdapter::dateFormat("date d M Y",$p->dari);
            $sampai  = ArrayAdapter::dateFormat("date d M Y",$p->sampai);
            $table   ->addColumn("Hari sejak tanggal ".$dari." s/d ".$sampai,5,1,"body",null,"sspl");
            $table   ->addColumn("Day(s) since",5,1,"body",null,"ssi sspl");                
        }        
                 
        $table   ->addColumn("Demikianlah untuk diketahui adanya.",3,1)
                 ->addColumn($town.", ".$tanggal,2,1,"body",null,"ssc");
        $table   ->addColumn("Please be advised accordingly",3,1,null,"ssi")
                 ->addColumn("Dokter / <i>Doctor</i>",2,1,"body",null,"ssc");
        
        //$table   ->addColumn("<div class='ctrl_1'>&nbsp;</div>",1,1);
        //$table   ->addColumn("<div class='ctrl_2'>&nbsp;</div>",1,1);
        //$table   ->addColumn("<div class='ctrl_3'>&nbsp;</div>",1,1);
        //$table   ->addColumn("<div class='ctrl_4'>&nbsp;</div>",1,1);
        //$table   ->addColumn("<div class='ctrl_5'>&nbsp;</div>",1,1,"body");

        $table   ->addSpace(3,1);
        $table   ->addColumn("<img src='".base_urlx()."/suratsakit/qr-".$p->id.".png' >",2,1,"body",null," ssc");

        $table   ->addSpace(5,1,"body");
        $table   ->addSpace(3,1)
                 ->addColumn("( ".$p->nama_dokter." )",2,1,"body",null," ssc");
        $table   ->addSpace(3,1)
                 ->addColumn(" Nama / <i>Name</i> ",2,1,"body",null," ssc");
        $table   ->addColumn($url,5,1,"body",null," ssr");
        
        $html = $this->generateHtmlSuratSakit($p,$header);
        //$html = "LABUBU";
        file_put_contents("suratsakit/ss-".$p->id.".html", $html."<style>".file_get_contents("kasir/resource/css/print-ss.css")."</style>");
        //file_put_contents("suratsakit/ss-".$p->id.".html", $html."<style>".file_get_contents("kasir/resource/css/print-ss.css")."</style>");
        return   $header.$table->getHtml();
    }

    public function generateHtmlSuratSakit($p,$header){
        global $db;

        $table =  new TablePrint("table_surat_sakit");
        $table->addColumn("<h5 class='judul'>Status Dokumen</h5>","1","1")->commit("title");
        $table->addColumn("<h5 class='success'>VALID</h5>","1","1")->commit("title");

        $table->addColumn("<h5 class='judul'>No. Surat</h5>","1","1")->commit("title");
        $table->addColumn("<h5>".$p->nomor."</h5>","1","1")->commit("title");

        $table->addColumn("<h5 class='judul'>Tanggal</h5>","1","1")->commit("title");
        $table->addColumn("<h5>".ArrayAdapter::dateFormat("date d M Y",$p->tanggal)."</h5>","1","1")->commit("title");

        $table->addColumn("<h5 class='judul'>Nama</h5>","1","1")->commit("title");
        $table->addColumn("<h5>".$p->nama_pasien."</h5>","1","1")->commit("title");


        $dari    = ArrayAdapter::dateFormat("date d M Y",$p->dari);
        $sampai  = ArrayAdapter::dateFormat("date d M Y",$p->sampai);
        loadLibrary("smis-libs-function-math");
        $table->addColumn("<h5 class='judul'>Perlu istirahat selama ".$p->jumlah." Hari ( ".numbertell($p->jumlah)." Hari)</h5>","1","1")->commit("title");
        $table->addColumn("<h5>Hari sejak tanggal ".$dari." s/d ".$sampai."</h5>","1","1")->commit("title");

        $table->addColumn("<h5 class='judul'>Dokter</h5>","1","1")->commit("title");
        $table->addColumn("<h5>".$p->nama_dokter."</h5>","1","1")->commit("title");

        return $header."<img id='checked' src='".base_urlx()."/kasir/resource/image/check.png' style='clear:both;'/>".$table->getHtml();
    }
    
}

?>