<?php 
class PengeluaranHarianDBResponder extends DBResponder{


    public function excel(){
        global $db;
        $dbtablne = $this->getDBTable();
        $dbtablne ->setShowAll(true);
        $data = $dbtablne->view("",0);
        $list=$data['data'];

        require_once ("smis-libs-out/php-excel/PHPExcel.php");
        
        $fillcabang = array ();
        $fillcabang['fill']=array();
        $fillcabang['fill']['type']=PHPExcel_Style_Fill::FILL_SOLID;
        $fillcabang['fill']['color']=array();
        $fillcabang['fill']['color']['rgb']='AFAFAF';
        
        $bottom['borders']=array();
        $bottom['borders']['bottom']=array();
        $bottom['borders']['bottom']['style']=PHPExcel_Style_Border::BORDER_THIN ;
        
        $border['borders']=array();
        $border['borders']['allborders']=array();
        $border['borders']['allborders']['style']=PHPExcel_Style_Border::BORDER_THIN ;
        
        $center = array();
        $center ['alignment']=array();
        $center ['alignment']['horizontal']=PHPExcel_Style_Alignment::HORIZONTAL_CENTER;
        
        $topalign = array();
        $topalign ['alignment']=array();
        $topalign ['alignment']['vertical']=PHPExcel_Style_Alignment::VERTICAL_TOP;
        
        
        $file = new PHPExcel ();
        $sheet = $file->getActiveSheet ();
        
        /*header*/
        $sheet->mergeCells("B1:D1")->setCellValue("B1","LAPORAN PENGELUARAN HARIAN");
        $sheet->getStyle("B1")->getFont()->setBold(true);
        $sheet->getStyle("B1")->applyFromArray($center);

        $sheet->mergeCells("B2:D2")->setCellValue("B2","UNIT ".getSettings($db,"smis_autonomous_title",""));
        $sheet->getStyle("B2")->getFont()->setBold(true);
        $sheet->getStyle("B2")->applyFromArray($center);

        $sheet->mergeCells("B3:D3")->setCellValue("B3","Tanggal : ".ArrayAdapter::format("date d m Y",$_POST['dari'])." - ".ArrayAdapter::format("date d m Y",$_POST['sampai']));
        $sheet->getStyle("B3")->getFont()->setBold(true);
        $sheet->getStyle("B3")->applyFromArray($center);


        /*content*/
        $sheet->setCellValue("A5","No.");
        $sheet->setCellValue("B5","Pengeluaran");
        $sheet->setCellValue("C5","Tanggal");
        $sheet->setCellValue("D5","Jumlah");
        $sheet->setCellValue("E5","Keterangan");
        $sheet->getStyle("A5:E5")->getFont()->setBold(true);
        $sheet->getStyle("A5:E5")->applyFromArray($center);

        $nomor=1;
        $position=6;
        foreach($list as $x){
            $sheet->setCellValue("A".$position,$nomor.".");
            $sheet->setCellValue("B".$position,$x->nama_pengeluaran);
            $sheet->setCellValue("C".$position,ArrayAdapter::format("date d M Y",$x->tanggal));
            $sheet->setCellValue("D".$position,$x->jumlah);
            $sheet->setCellValue("E".$position,$x->keterangan);
            $nomor++;
            $position++;
        }

        //$objPHPExcel->getActiveSheet()->getStyle("A1")->getNumberFor‌​mat()->setFormatCode‌​("#,##0.00");
        $sheet->getStyle("D6:F".($position-1) )->getNumberFormat()->setFormatCode("#,##0.00");
        $sheet->getStyle("A5:E".($position-1))->applyFromArray($border);

        $sheet->getColumnDimension("A")->setAutoSize(true);
        $sheet->getColumnDimension("B")->setAutoSize(true);
        $sheet->getColumnDimension("C")->setAutoSize(true);
        $sheet->getColumnDimension("D")->setAutoSize(true);
        $sheet->getColumnDimension("E")->setAutoSize(true);
        

        $gdImage = imagecreatefromjpeg(getLogoNonInterlaced());
        // Add a drawing to the worksheetecho date('H:i:s') . " Add a drawing to the worksheet\n";
        $objDrawing = new PHPExcel_Worksheet_MemoryDrawing();
        $objDrawing->setName('');
        $objDrawing->setDescription('');
        $objDrawing->setImageResource($gdImage);
        $objDrawing->setRenderingFunction(PHPExcel_Worksheet_MemoryDrawing::RENDERING_JPEG);
        $objDrawing->setMimeType(PHPExcel_Worksheet_MemoryDrawing::MIMETYPE_DEFAULT);
        $objDrawing->setHeight(50);
        $objDrawing->setCoordinates('E1');
        $objDrawing->setWorksheet($sheet);

        header ( 'Content-Type: application/vnd.ms-excel' );
        header ( 'Content-Disposition: attachment;filename="Laporan Pengeluaran Harian.xls"' );
        header ( 'Cache-Control: max-age=0' );
        $writer = PHPExcel_IOFactory::createWriter ( $file, 'Excel5' );
        $writer->save ( 'php://output' );
    }

}