<?php 
class LaporanPendapatanPasienUmumResponder extends DBResponder{

    public function excel(){
        global $user;
		include 'smis-libs-out/php-excel/PHPExcel.php';
		$date_range = ArrayAdapter::format("date d M Y",$_POST['dari'])." - ".ArrayAdapter::format("date d M Y",$_POST['sampai']);
		$kriteria = isset($_POST['kriteria'])?$_POST['kriteria']:""; 
		$number	  = (isset($_POST['number']) && $_POST['number']!="")?$_POST['number']:0;
		$this->dbtable->setShowAll(true);
		$this->dbtable->setFetchMethode(DBTable::$OBJECT_FETCH);

        
		$d		      = $this->dbtable->view($kriteria,$number);
		$start_number = $page*$max;
		$this->adapter->setNumber($start_number);
		$data=$d['data'];
		$objPHPExcel  = new PHPExcel();
		$properties   = $objPHPExcel->getProperties();
		$properties->setCreator($user->getNameOnly());
		$properties->setLastModifiedBy($user->getNameOnly());
		$properties->setTitle("Laporan Pendapatan Pasien Umum");
		$properties->setSubject("Laporan Pendapatan Pasien Umum");
		$properties->setDescription("Laporan Pendapatan Pasien Umum ".$date_range);		
		$sheet = $objPHPExcel->setActiveSheetIndex(0);
		$sheet->setTitle ( "Laporan Pendapatan Pasien Umum");
		$sheet->mergeCells('A1:Z1')->setCellValue("A1","Laporan  Pendapatan Pasien Umum - Klinik Casa Medical ".ArrayAdapter::format("unslug",$_POST['origin']))->getStyle ( "A1")->getFont ()->setBold ( true );
		$sheet->mergeCells('A2:Z2')->setCellValue("A2",$date_range)->getStyle ( "A2")->getFont ()->setBold ( true );
		$sheet->mergeCells('A3:Z3')->setCellValue("A3","");
		$sheet->getStyle('A1:A2')->getAlignment()->applyFromArray(
				array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,)
        );        
		$sheet->SetCellValue('A4', 'No')->getStyle ( "A4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('B4', 'Tanggal')->getStyle ( "B4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('C4', 'Tanggal Bayar')->getStyle ( "C4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('D4', 'No. Reg.')->getStyle ( "D4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('E4', 'NRM')->getStyle ( "E4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('F4', 'No. Tunai')->getStyle ( "F4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('G4', 'No. Bank')->getStyle ( "G4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('H4', 'Nama Pasien')->getStyle ( "H4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('I4', 'Dokter')->getStyle ( "I4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('J4', 'Tarif Konsul')->getStyle ( "J4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('K4', 'Jasa Konsul Klinik')->getStyle ( "K4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('L4', 'Jasa Dokter Konsul')->getStyle ( "L4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('M4', 'Tarif Tindakan Dokter')->getStyle ( "M4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('N4', 'Jasa Klinik')->getStyle ( "N4")->getFont ()->setBold ( true );
        $sheet->SetCellValue('O4', 'Jasa Tindakan Dokter')->getStyle ( "O4")->getFont ()->setBold ( true );
        $sheet->SetCellValue('P4', 'Nama Tindakan')->getStyle ( "P4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('Q4', 'Administrasi')->getStyle ( "Q4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('R4', 'Obat')->getStyle ( "R4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('S4', 'SKS')->getStyle ( "S4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('T4', 'Cyclo Inj')->getStyle ( "T4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('U4', 'Laboratory')->getStyle ( "U4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('V4', 'Total')->getStyle ( "V4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('W4', 'Tunai')->getStyle ( "W4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('X4', 'Bank')->getStyle ( "X4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('Y4', 'Keterangan')->getStyle ( "Y4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('Z4', 'Unit Kerja')->getStyle ( "Z4")->getFont ()->setBold ( true );
		$sheet->SetCellValue('AA4', 'Operator')->getStyle ( "AA4")->getFont ()->setBold ( true );
		
		$ROWS_NUMBER=5;
        $TOTAL_NILAI=0;
        $number = 0;
		foreach($data as $one){
            $number++;
			$sheet->SetCellValue('A'.$ROWS_NUMBER, $number.".");
			$sheet->SetCellValue('B'.$ROWS_NUMBER, ArrayAdapter::format("date d M Y H:i:s", $one->tanggal));
			$sheet->SetCellValue('C'.$ROWS_NUMBER, ArrayAdapter::format("date d M Y H:i:s", $one->tgl_bayar));
			
            $sheet->SetCellValue('D'.$ROWS_NUMBER, $one->noreg_pasien);
            $sheet->SetCellValue('E'.$ROWS_NUMBER, $one->nrm_pasien);
			$sheet->SetCellValue('F'.$ROWS_NUMBER, $one->no_tunai);
			$sheet->SetCellValue('G'.$ROWS_NUMBER, $one->no_bank);
            $sheet->SetCellValue('H'.$ROWS_NUMBER, $one->nama_pasien);
            $sheet->SetCellValue('I'.$ROWS_NUMBER, $one->nama_dokter);
            $sheet->SetCellValue('J'.$ROWS_NUMBER, $one->konsul_dokter);
            $sheet->SetCellValue('K'.$ROWS_NUMBER, $one->konsul_dokter*0.3);
            $sheet->SetCellValue('L'.$ROWS_NUMBER, $one->konsul_dokter*0.7);
            $sheet->SetCellValue('M'.$ROWS_NUMBER, $one->tindakan_dokter);
            $sheet->SetCellValue('N'.$ROWS_NUMBER, $one->tindakan_dokter_operator*0.4+$one->jasa_sarana);
            $sheet->SetCellValue('O'.$ROWS_NUMBER, $one->tindakan_dokter_operator*0.6);
            $sheet->SetCellValue('P'.$ROWS_NUMBER, $one->nama_tindakan);
            $sheet->SetCellValue('Q'.$ROWS_NUMBER, $one->administrasi);
            $sheet->SetCellValue('R'.$ROWS_NUMBER, $one->obat);
            $sheet->SetCellValue('S'.$ROWS_NUMBER, $one->sks);
            $sheet->SetCellValue('T'.$ROWS_NUMBER, $one->cyclo_inj);
            $sheet->SetCellValue('U'.$ROWS_NUMBER, $one->laboratory);
			$sheet->SetCellValue('V'.$ROWS_NUMBER, $one->total_tagihan);
			$sheet->SetCellValue('W'.$ROWS_NUMBER, $one->tunai);
			$sheet->SetCellValue('X'.$ROWS_NUMBER, $one->bank);
			$sheet->SetCellValue('Y'.$ROWS_NUMBER, "");
			$sheet->SetCellValue('Z'.$ROWS_NUMBER, $one->unit_kerja);
			$sheet->SetCellValue('AA'.$ROWS_NUMBER, $one->operator);

			$ROWS_NUMBER++;
			$TOTAL_NILAI+=$one->nilai;
        }
        

        $sheet->SetCellValue('A'.$ROWS_NUMBER, "TOTAL");
		$sheet->SetCellValue('J'.$ROWS_NUMBER, "=sum(J5:J".($ROWS_NUMBER-1).")");
		$sheet->SetCellValue('K'.$ROWS_NUMBER, "=sum(K5:K".($ROWS_NUMBER-1).")");
        $sheet->SetCellValue('L'.$ROWS_NUMBER, "=sum(L5:L".($ROWS_NUMBER-1).")");
        $sheet->SetCellValue('M'.$ROWS_NUMBER, "=sum(M5:M".($ROWS_NUMBER-1).")");
        $sheet->SetCellValue('N'.$ROWS_NUMBER, "=sum(N5:N".($ROWS_NUMBER-1).")");
        $sheet->SetCellValue('O'.$ROWS_NUMBER, "=sum(O5:O".($ROWS_NUMBER-1).")");

        $sheet->SetCellValue('Q'.$ROWS_NUMBER, "=sum(Q5:Q".($ROWS_NUMBER-1).")");
        $sheet->SetCellValue('R'.$ROWS_NUMBER, "=sum(R5:R".($ROWS_NUMBER-1).")");
        $sheet->SetCellValue('S'.$ROWS_NUMBER, "=sum(S5:S".($ROWS_NUMBER-1).")");
		$sheet->SetCellValue('T'.$ROWS_NUMBER, "=sum(T5:T".($ROWS_NUMBER-1).")");
		$sheet->SetCellValue('U'.$ROWS_NUMBER, "=sum(U5:U".($ROWS_NUMBER-1).")");
		$sheet->SetCellValue('V'.$ROWS_NUMBER, "=sum(V5:V".($ROWS_NUMBER-1).")");
		$sheet->SetCellValue('W'.$ROWS_NUMBER, "=sum(W5:W".($ROWS_NUMBER-1).")");
		$sheet->SetCellValue('X'.$ROWS_NUMBER, "=sum(X5:X".($ROWS_NUMBER-1).")");
        $sheet->getStyle( "A".$ROWS_NUMBER.":Z".$ROWS_NUMBER)->getFont ()->setBold(true);

        $sheet->getStyle("K5:O".$ROWS_NUMBER)->getNumberFormat()->setFormatCode('#,##0');
        $sheet->getStyle("Q5:W".$ROWS_NUMBER)->getNumberFormat()->setFormatCode('#,##0');      
		$sheet->getStyle('A4:AA'.$ROWS_NUMBER)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
		
		$sheet->getColumnDimension("A")->setAutoSize(true);
		$sheet->getColumnDimension("B")->setAutoSize(true);
		$sheet->getColumnDimension("C")->setAutoSize(true);
		$sheet->getColumnDimension("D")->setAutoSize(true);
		$sheet->getColumnDimension("E")->setAutoSize(true);
		$sheet->getColumnDimension("F")->setAutoSize(true);
		$sheet->getColumnDimension("G")->setAutoSize(true);
		$sheet->getColumnDimension("H")->setAutoSize(true);
		$sheet->getColumnDimension("I")->setAutoSize(true);
		$sheet->getColumnDimension("J")->setAutoSize(true);
        $sheet->getColumnDimension("K")->setAutoSize(true);
        $sheet->getColumnDimension("L")->setAutoSize(true);
        $sheet->getColumnDimension("M")->setAutoSize(true);
        $sheet->getColumnDimension("N")->setAutoSize(true);
        $sheet->getColumnDimension("O")->setAutoSize(true);
        $sheet->getColumnDimension("P")->setAutoSize(true);
		$sheet->getColumnDimension("Q")->setAutoSize(true);
		$sheet->getColumnDimension("R")->setAutoSize(true);
		$sheet->getColumnDimension("S")->setAutoSize(true);
		$sheet->getColumnDimension("T")->setAutoSize(true);
		$sheet->getColumnDimension("U")->setAutoSize(true);
		$sheet->getColumnDimension("V")->setAutoSize(true);
		$sheet->getColumnDimension("W")->setAutoSize(true);
		$sheet->getColumnDimension("X")->setAutoSize(true);
		$sheet->getColumnDimension("Y")->setAutoSize(true);
		$sheet->getColumnDimension("Z")->setAutoSize(true);
		$sheet->getColumnDimension("AA")->setAutoSize(true);
		$filename = "Laporan Pendapatan Pasien Umum";
		if($_POST['origin']!=""){
			$filename.=" ".$_POST['origin']." ";
		}else{
			$filename.=" Semua ";
		}
		$filename.=" ".$date_range." ";
		$filename.=" ".$user->getNameOnly();
		
		header ( 'Content-Type: application/vnd.ms-excel' );
		header ( 'Content-Disposition: attachment;filename="'.$filename.'.xls"' );
		header ( 'Cache-Control: max-age=0' );
		$writer = PHPExcel_IOFactory::createWriter ( $objPHPExcel, 'Excel5' );
		$writer->save ( 'php://output' );		
		return NULL;
    }

}