<?php

/**
 * this class using for counting the resume
 * this one is Old MOde use Resume Instead 
 * @author goblooge
 *
 */

class TotalResume {
	private $form;
	private $end_form;
	private $table;
	private $selesai;
	private $noreg_pasien;
	private $nrm_pasien;
	private $nama_pasien;
	private $simple_report;
	private $inap;
	public function __construct($total, $jaspel, $noreg, $nama, $nrm, $inap, $layanan, $bill_per_bagian) {
		$this->noreg_pasien = $noreg;
		$this->nrm_pasien = $nrm;
		$this->nama_pasien = $nama;
		$this->inap=$inap;
		
		$jaspel = 0.1 * $jaspel; // perhitungan jaspel
		if($inap=="0" ) $jaspel=0;
		$this->selesai = 1;
		
		global $db;
		$query = "SELECT SUM(nilai) as total from smis_ksr_bayar WHERE noreg_pasien='" . $noreg . "' AND prop!='del'";
		$total_dibayar = $db->get_var ( $query );
		$sisa_bayar = $total + $jaspel - $total_dibayar;
		
		$tagihan = new Text ( 'total_tagihan', 'total_tagihan', ArrayAdapter::format ( "only-money", $total ) );
		$tjaspel = new Text ( 'total_jaspel', 'total_jaspel', ArrayAdapter::format ( "only-money", $jaspel ) );
		$tagjas = new Text ( 'total_tagjas', 'total_tagjas', ArrayAdapter::format ( "only-money", $total + $jaspel ) );
		$dibayar = new Text ( 'total_dibayar', 'total_dibayar', ArrayAdapter::format ( "only-money", $total_dibayar ) );
		$sisa = new Text ( 'sisa_dibayar', 'sisa_dibayar', ArrayAdapter::format ( "only-money", $sisa_bayar ) );
		
		
		$tagihan->setDisabled ( true );
		$dibayar->setDisabled ( true );
		$sisa->setDisabled ( true );
		$tagjas->setDisabled ( true );
		$tjaspel->setDisabled ( true );
		
		$form = new Form ( "form_student", "", "Resume" );
		$form->addElement ( "Tagihan", $tagihan );
		$form->addElement ( "Jaspel (10%)", $tjaspel );
		$form->addElement ( "Total", $tagjas );
		$form->addElement ( "Dibayar", $dibayar );
		$form->addElement ( "Sisa", $sisa );
		
		$var=getSettings($this->db, "smis-rs-abrevation", "RS");
		
		$nokwitansi = strtoupper ( $var."-" . date ( 'dmy-his' ) . "-" . substr ( md5 ( $this->nama_pasien . $this->noreg_pasien . date ( 'dmyhis' ) ), 1, 4 ) );
		$this->createReporting ( $bill_per_bagian, $total, $jaspel, $total_dibayar, $sisa_bayar, $nokwitansi );
		$this->createStatusKeluar ( $layanan, $noreg );
		
		$hitung = new Button ( 'select', 'Hitung', 'Hitung' );
		$hitung->setClass ( "btn-primary" )
			   ->setIcon("fa fa-calculator")
			   ->setAction ( "hitung_ulang()" )
			   ->setIsButton(Button::$ICONIC);
		
		$kwitansi = new Button ( 'cetak_kwitansi', '', 'Kwitansi' );
		$kwitansi->setClass ( "btn-primary" )
				 ->setIsButton ( Button::$ICONIC_TEXT)
				 ->setIcon ( "fa fa-print" )
				 ->setAction ( "kwitansi('" . $nokwitansi . "')" );
		
		$tgh_lengkap = new Button ( 'cetak_lengkap', '', 'Tagihan' );
		$tgh_lengkap->setClass ( "btn-primary" )
					->setIsButton ( Button::$ICONIC_TEXT)
					->setIcon ( "fa fa-book" )
					->setAction ( "cetak_lengkap(0)" );
					
		
		$btgroup=new ButtonGroup("");
		$btgroup->addButton($hitung)
				->addButton($kwitansi)
				->addButton($tgh_lengkap);
		
		
		$form->addElement ( "", $btgroup );
		
		$this->form = $form;
		
		loadLibrary("smis-libs-function-medical");
		$carapulang = new Select ( "carapulang", "carapulang", medical_carapulang() );
		$dibayar = new Text ( 'total_dibayar', 'total_dibayar', ArrayAdapter::format ( "only-money", $total_dibayar ) );
		$pulang = new Button ( 'select', 'Pulang', 'Pulang' );
		$pulang->setClass ( "btn-primary" );
		$pulang->setIcon(" fa fa-sign-out");
		$pulang->setAction ( "pasien_pulang('" . $sisa_bayar . "','" . $this->selesai . "','" . $noreg . "')" );
		$pulang->setIsButton(Button::$ICONIC_TEXT);
		
		$ksr_check_manual=getSettings($db, "cashier-out-check-manual", "0");
		$var_checkbox_manual="";
		$var_checkbox_manual_name="";
		if($ksr_check_manual=="0"){
			$var_checkbox_manual=new Hidden("cashier_out_checkbox_manual", "", "0");
		}else{
			$var_checkbox_manual_name=" Cek Keuangan ";
			$option=new OptionBuilder();
			$option->add("Cek Pelunasan Terlebih Dahulu (Belum Lunas Tidak Bisa Pulang Kecuali Kabur) ","0","1");
			$option->add("Gratis atau Boleh Pulang Walau Belum Lunas ","1","0");
			$var_checkbox_manual=new Select("cashier_out_checkbox_manual", "Gratis", $option->getContent());
		}
		
		$end_form = new Form ( "form_student", "", "" );
		$end_form->addElement ( $var_checkbox_manual_name, $var_checkbox_manual);
		$end_form->addElement ( "Pulang", $carapulang );
		$end_form->addElement ( "", $pulang );
		$this->end_form = $end_form;
	}
	
	public function createReporting($bill_per_bagian, $tagihan, $jaspel, $dibayar, $sisa_bayar, $nokwitansi) {
		global $db;
		$name=strtoupper(getSettings($db, "smis_autonomous_title", "Safethree MIS"));
		
		$tbl = new TablePrint ( "kwitansi_report" );
		$tbl->setMaxWidth ( false );
		$tbl->addTableClass ( "" );
		$tbl->addColumn ( "<p style='text-align:center;'>".$name."</p>", 2, 1 );
		$tbl->commit ( "title" );
		$tbl->addColumn ( "<strong style='float:left;'>Tanggal</strong>", 1, 1 );
		$tbl->addColumn ( "<font style='float:left;'>" . ArrayAdapter::format ( "date d M Y H:i", date ( "Y-m-d H:i:s" ) ) . "</font>", 1, 1 );
		$tbl->commit ( "title" );
		$tbl->addColumn ( "<strong style='float:left;'>No. Kwitansi</strong>", 1, 1 );
		$tbl->addColumn ( "<small style='float:left;font-weight:200;'>" . $nokwitansi . "</small>", 1, 1 );
		$tbl->commit ( "title" );
		$tbl->addColumn ( "<strong>NAMA</strong>", 1, 1 );
		$tbl->addColumn ( $this->nama_pasien, 1, 1 );
		$tbl->commit ( "header" );
		$tbl->addColumn ( "<strong>NRM</strong>", 1, 1 );
		$tbl->addColumn ( ArrayAdapter::format ( "digit8", $this->nrm_pasien ), 1, 1 );
		$tbl->commit ( "header" );
		$tbl->addColumn ( "<strong>No Registrasi</strong>", 1, 1 );
		$tbl->addColumn ( ArrayAdapter::format ( "digit8", $this->noreg_pasien ), 1, 1 );
		$tbl->commit ( "header" );
		$tbl->addColumn ( "<strong>Layanan</strong>", 1, 1 );
		$tbl->addColumn ( "<strong>Biaya</strong>", 1, 1 );
		$tbl->commit ( "header" );
		foreach ( $bill_per_bagian as $name => $nilai ) {
			if ($nilai == 0)
				continue;
			$tbl->addColumn ( ucwords ( strtolower ( ArrayAdapter::format ( "unslug", $name ) ) ), 1, 1 );
			$tbl->addColumn ( ArrayAdapter::format ( "money Rp.", $nilai ), 1, 1 );
			$tbl->commit ( "body" );
		}
		$tbl->addColumn ( "Jasa Pelayanan", 1, 1 );
		$tbl->addColumn ( ArrayAdapter::format ( "money Rp.", $jaspel ), 1, 1 );
		$tbl->commit ( "body" );
		$tbl->addColumn ( "<strong>Total</strong>", 1, 1 );
		$tbl->addColumn ( ArrayAdapter::format ( "money Rp.", $tagihan + $jaspel ), 1, 1 );
		$tbl->commit ( "body" );
		$tbl->addColumn ( "<strong>Dibayar</strong>", 1, 1 );
		$tbl->addColumn ( ArrayAdapter::format ( "money Rp.", $dibayar ), 1, 1 );
		$tbl->commit ( "body" );
		if ($sisa_bayar != 0) {
			$tbl->addColumn ( "<strong>Sisa Bayar</strong>", 1, 1 );
			$tbl->addColumn ( ArrayAdapter::format ( "money Rp.", $sisa_bayar ), 1, 1 );
			$tbl->commit ( "body" );
		} else {
			$tbl->addColumn ( "<strong>LUNAS</strong>", 2, 1 );
			$tbl->commit ( "body" );
		}
		global $user;
		$tbl->addColumn ( "Petugas : " . $user->getNameOnly () . "", 2, 1 );
		$tbl->commit ( "body" );
		$this->simple_report = "<div id='kwitansi_tagihan' class='hide'>" . $tbl->getHtml () . "</div>";
	}
	
	public function createStatusKeluar($layanan, $noreg) {
		$table = new TablePrint ( "Selesai" );
		$table->setMaxWidth ( false );
		$table->addTableClass ( "table table-bordered table-hover table-condensed " );
		$table->addColumn ( "Ruangan", 1, 1 );
		$table->addColumn ( "Satus", 1, 1 );
		$table->addColumn ( "Aksi", 1, 1 );
		$table->commit ( "title" );
		foreach ( $layanan as $autnomous => $status ) {
			$btn = new Button ( "", "", "Kembalikan" );
			$btn->setClass ( "btn-primary" )
				->setIcon("fa fa-sign-in")
				->setIsButton(Button::$ICONIC_TEXT)
				->setAction ( "buka_kembali(this,'" . $autnomous . "','" . $noreg . "')" );
			$stat = "<a href='#'>Belum Selesai</a>";
			$aksi = "";
			if ($status ['selesai'] == "1") {
				$stat = $status ['cara_keluar'];
				if ($status ['reverse'] != "0")
					$aksi = $btn->getHtml ();
			} else {
				$this->selesai = 0;
			}
			$table->addColumn ( ArrayAdapter::format ( "unslug", $autnomous ), 1, 1 );
			$table->addColumn ( $stat, 1, 1 );
			$table->addColumn ( $aksi, 1, 1 );
			$table->commit ( "body" );
		}
		$this->table = $table;
	}
	public function getHtml() {
		return $this->form->getHtml ()."<div class='line clear'></div>".$this->end_form->getHtml () ."<div class='line clear'></div>". "<div class='clear'></div>" . $this->table->getHtml () . "<div class='clear'></div>" . $this->simple_report . "<div class='clear'></div>" ;
	}
}

?>