<?php

/**
 * digunakan untuk melakukan manajemen 
 * data lembur karyawan. setiap kali karyawan lembur
 * dapat diketahui dan ditulis dengan menu ini.
 * yang mana nantinya setiap gaji lembur karyawan 
 * akan di simpan disini dan ditampilkan sebagai tambahan 
 * gaji di akhir bulan.
 * 
 * @author 		: Nurul Huda
 * @copyright 	: goblooge@gmail.com
 * @license 	: LGPLv2
 * @database 	: - smis_hrd_employee
 * 				  - smis_hrd_lembur
 * @since		: 14 Mei 2015
 * @version		: 1.0.0
 * 
 * */

global $db;
require_once 'smis-libs-class/MasterSlaveTemplate.php';
loadLibrary("smis-libs-function-time");

$header		= array ("Nama","Alamat",'L/P','Pendidikan','Struktural' );
$dbtable	= new DBTable($db, "smis_hrd_employee");
$dktable 	= new Table ( $header );
$dktable	->setName ( "lembur_employee" );
$dktable	->setModel ( Table::$SELECT );
$dkadapter  = new SimpleAdapter ();
$dkadapter	->add ( "Nama", "nama" )
			->add ( "Alamat", "alamat" )
			->add ( "L/P", "jk","trivial_0_L_P" )
			->add ( "Pendidikan", "pendidikan")
			->add ( "Struktural", "struktural" );
$lembur_employee = new DBResponder($dbtable, $dktable, $dkadapter);
$is_nilai_jam	 = getSettings($db,"hrd-employee-nilai-lembur-non-jam","0")=="0";

$header  = array ('No.',"Nama","Keterangan","Dari","Sampai","Jam","Total");
if($is_nilai_jam){
	$header  = array ('No.',"Nama","Keterangan","Dari","Sampai","Jam","Nilai Per Jam","Total");	
}
$pemreg  = new MasterSlaveTemplate($db, "smis_hrd_lembur", "hrd", "lembur");
$pemreg  ->setDateEnable(true);
$uitable = $pemreg->getUItable();
$uitable ->setPrintButtonEnable(false)
		 ->setReloadButtonEnable(false)
		 ->setName("lembur");
$pemreg  ->getDBtable()->setOrder(" tanggal DESC ");
$pemreg  ->setUITable($uitable);
if($pemreg->getDBResponder()->isView() && $_POST['super_command']==""){
	$dbtable = $pemreg	->getDBtable();
	if(isset($_POST['id_pegawai']) && $_POST['id_pegawai']!="" && $_POST['nama_pegawai']){
		$dbtable ->addCustomKriteria("id_pegawai", "='".$_POST['id_pegawai']."'");
	}
	if(isset($_POST['dari_filter']) && $_POST['dari_filter']!="" ){
		$dbtable->addCustomKriteria(" tanggal >=", "'".$_POST['dari_filter']."'");  
	}
	if(isset($_POST['sampai_filter']) && $_POST['sampai_filter']!="" ){
		$dbtable->addCustomKriteria(" tanggal <", "'".$_POST['sampai_filter']."'");  
	}
	if(isset($_POST['status_filter']) && $_POST['status_filter']!="" ){
		$dbtable->addCustomKriteria(" status_acc ", "='".$_POST['status_filter']."'");  
	}
}


if($pemreg->getDBResponder()->isSave() ){
	$dari		= $_POST['dari'];
	$sampai		= $_POST['sampai'];
	$nilai		= $_POST['nilai'];
	$menit		= minute_different ($sampai, $dari);
	$durasi		= 0;
	$bulatkan	= getSettings($db, "hrd-employee-hitung-lembur", "jam");
	if($bulatkan=="floor-jam"){
		$durasi = floor($menit/60);
	}else if($bulatkan=="ceil-jam"){
		$durasi = ceil($menit/60);
	}else if($bulatkan=="jam"){
		$durasi = round($menit/60);
	}else{
		$durasi = round($menit/60,2);
	}
	$total  = $durasi*$nilai;
	$pemreg->getDBResponder()->addColumnFixValue("jam", $durasi);
	if($is_nilai_jam){
		$pemreg->getDBResponder()->addColumnFixValue("total", $total);
	}else{
		$pemreg->getDBResponder()->addColumnFixValue("total", $_POST['nilai']);
	}
}

$status_acc = new OptionBuilder();
$status_acc ->add("Diajukan Karyawan","-2","1")
			->add("Di Setujui Kepala Ruangan","-1")
			->add("Di Setujui Personalia","0");

$status_flt = new OptionBuilder();
$status_flt ->add("Diajukan Karyawan","-2")
			->add("Di Setujui Kepala Ruangan","-1")
			->add("Di Setujui Personalia")
			->add("","","1");

$pemreg	 ->addFlag("id_pegawai", "Pilih Pegawai Dahulu", "Silakan Pilih Pegawai Dahulu")
		 ->addNoClear("id_pegawai")
		 ->addNoClear("nama_pegawai")
		 ->addNoClear("pendidikan")
		 ->addNoClear("struktural")
         ->addNoClear("rumus")
		 ->addNoClear("dari_filter")
         ->addNoClear("sampai_filter")
		 ->addNoClear("status_filter")
		 ->addNoClear("ruangan_pegawai")
		 ->setDateTimeEnable(true)
		 ->getUItable()
		 ->addModal ("dari_filter", "date", "Dari", "")
         ->addModal ("sampai_filter", "date", "Sampai", "")
		 ->addModal ("status_filter", "select", "Status", $status_flt->getContent())
		 ->addModal ("id_pegawai", "hidden", "", "")
		 ->addModal ("nama_pegawai", "chooser-lembur-lembur_employee", "Nama", "")
		 ->addModal ("pendidikan", "text", "Pendidikan", "","n",null,true)
		 ->addModal ("struktural", "text", "Struktural", "","n",null,true)
		 ->addModal ("ruangan_pegawai", "text", "Ruangan", "","n",null,true)
         ->addModal ("rumus_lembur", "hidden", "", "","",null,true);
         
$pemreg ->getForm();
$pemreg ->getUItable()
		 ->setHeader($header)
		 ->addModal ("id", "hidden", "", "")
		 ->addModal ("tanggal", "date", "Tanggal", date("Y-m-d"))
		 ->addModal ("dari", "datetime", "Dari", date("Y-m-d H:i"))
		 ->addModal ("sampai", "datetime", "Sampai", date("Y-m-d H:i"))
		 ->addModal ("keterangan", "textarea", "Keterangan", "")
		 ->addModal ("status_acc", "select", "Status", $status_acc->getContent(),"n")
         ->addModal ("nilai", "money", "Nilai", getSettings($db, "hrd-employee-nilai-lembur", "10000"));

if($pemreg->getDBResponder()->isPreload() && getSettings($db, "hrd-mode-lembur-rumus", "0")=="1"){
    
    $dbtable = new DBTable ( $db, "smis_hrd_rumus_lembur" );
	$dbtable ->setShowAll ( true )
			 ->setOrder ( "nama ASC" );
    $data 	 = $dbtable->view ( "", 0 );
    $job 	 = new SelectAdapter("nama", "id");
    $rumus 	 = $job->getContent ( $data ['data'] );
    $rumus[] = array("name"=>"","value"=>"");
    
    $pemreg ->getUItable()
            ->addModal ( "id_rumus", "select", "Rumus", $rumus)
            ->addModal ( "rumus", "hidden", "", "")
            ->addModal ( "kalkulasi", "hidden", "", "");
}


$adapter = $pemreg->getAdapter();
$adapter ->setUseNumber(true, "No.","back.");
$adapter ->add("Jam", "jam")
		 ->add("Tanggal", "tanggal","date d M Y")
		 ->add("Keterangan", "keterangan")
		 ->add("Nilai Per Jam", "nilai","money Rp.")
		 ->add("Total", "total","money Rp.")
		 ->add("Nama", "nama_pegawai")
		 ->add("Dari", "dari","date d M Y H:i")
		 ->add("Sampai", "sampai","date d M Y H:i");
$pemreg  ->getSuperCommand()
         ->addResponder("lembur_employee", $lembur_employee);
$pemreg  ->addSuperCommand("lembur_employee", array())
		 ->addSuperCommandArray("lembur_employee", "id_pegawai", "id")
		 ->addSuperCommandArray("lembur_employee", "nama_pegawai", "nama")
		 ->addSuperCommandArray("lembur_employee", "struktural", "struktural")
		 ->addSuperCommandArray("lembur_employee", "pendidikan", "pendidikan")
		 ->addSuperCommandArray("lembur_employee", "rumus_lembur", "rumus_lembur")
		 ->addSuperCommandArray("lembur_employee", "ruangan_pegawai", "ruangan_pegawai") 	
		 ->addSuperCommandArray("lembur_employee", "smis_action_js", "lembur.view();","smis_action_js")
		 ->addRegulerData("id_pegawai", "id_pegawai","id-value")
		 ->addRegulerData("ruangan_pegawai", "ruangan_pegawai","id-value")
         ->addRegulerData("dari_filter", "dari_filter","id-value")
         ->addRegulerData("sampai_filter", "sampai_filter","id-value")
		 ->addRegulerData("status_filter", "status_filter","id-value")
		 ->addRegulerData("nama_pegawai", "nama_pegawai","id-value")
		 ->getModal()
		 ->setTitle("Lembur Karyawan");
$pemreg ->addResouce("js","hrd/resource/js/lembur.js");
$pemreg ->initialize();
?>