<?php

/**
 * digunakan oleh karyawan yang login sehingga bisa untuk mengajukan lembur
 * yang mana pengajuan lembur ini nantinya akan di acc oleh kepala ruangan 
 * dan akan pula di acc oleh petugas HRD
 * 
 * @author 		: Nurul Huda
 * @copyright 	: goblooge@gmail.com
 * @license 	: LGPLv2
 * @database 	: - smis_hrd_employee
 * 				  - smis_hrd_lembur
 * @since		: 03 Agustus 2018
 * @version		: 1.0.0
 * 
 * */

global $db;
global $user;

require_once 'smis-libs-class/MasterSlaveTemplate.php';
loadLibrary("smis-libs-function-time");

$is_nilai_jam  	= getSettings($db,"hrd-employee-nilai-lembur-non-jam","0")=="0";
$header  		= array ('No.',"Nama","Keterangan","Dari","Sampai","Jam","Total");
if($is_nilai_jam){
	$header  	= array ('No.',"Nama","Keterangan","Dari","Sampai","Jam");	
}
$pemreg     = new MasterSlaveTemplate($db, "smis_hrd_lembur", "hrd", "pengajuan_lembur");
$pemreg     ->setDateEnable(true);
$uitable    = $pemreg->getUItable();
$uitable    ->setPrintButtonEnable(false)
            ->setReloadButtonEnable(false)
            ->setName("pengajuan_lembur");
$pemreg     ->getDBtable()->setOrder(" tanggal DESC ");
$pemreg     ->setUITable($uitable);
if($pemreg  ->getDBResponder()->isView() && $_POST['super_command']==""){
	$pemreg	->getDBtable()
			->addCustomKriteria("id_pegawai", "='".$_POST['id_pegawai']."'");
}

if($pemreg->getDBResponder()->isSave()){
	$dari		= $_POST['dari'];
	$sampai		= $_POST['sampai'];
	$nilai		= $_POST['nilai'];
	$menit		= minute_different ($sampai, $dari);
	$durasi		= 0;
	$bulatkan	= getSettings($db, "hrd-employee-hitung-lembur", "jam");
	if($bulatkan=="floor-jam"){
		$durasi = floor($menit/60);
	}else if($bulatkan=="ceil-jam"){
		$durasi = ceil($menit/60);
	}else if($bulatkan=="jam"){
		$durasi = round($menit/60);
	}else{
		$durasi = round($menit/60,2);
	}
	$total  = $durasi*$nilai;
	$pemreg->getDBResponder()->addColumnFixValue("jam", $durasi);
	if($is_nilai_jam){
		$pemreg->getDBResponder()->addColumnFixValue("total", $total);
	}else{
		$pemreg->getDBResponder()->addColumnFixValue("total", $_POST['nilai']);
	}
}

$id_pegawai     = "";
$nama_pegawai   = "";
$pendidikan     = "";
$struktural     = "";
$rumus_lembur   = "";
$ruangan   		= "";
if($pemreg->getDBResponder()->isPreload() && $_POST['super_command']==""){
    $username = $user->getUsername();
    $dbtable  = new DBTable($db,"smis_hrd_employee");
    $cur_user = $dbtable->select(array("usname"=>$username));
    $id_pegawai     = $cur_user->id;
    $nama_pegawai   = $cur_user->nama;
    $pendidikan     = $cur_user->pendidikan;
    $struktural     = $cur_user->struktural;
	$rumus_lembur   = $cur_user->rumus_lembur;
	$ruangan   		= $cur_user->ruangan_pegawai;
}

$status_acc = new OptionBuilder();
$status_acc ->add("Diajukan Karyawan","-2","1");
$status_acc ->add("Di Setujui Kepala Ruangan","-1");
$status_acc ->add("Di Setujui Personalia","0");

$pemreg  ->addFlag("id_pegawai", "Pilih Pegawai Dahulu", "Silakan Pilih Pegawai Dahulu")
		 ->addNoClear("id_pegawai")
		 ->addNoClear("nama_pegawai")
		 ->addNoClear("pendidikan")
		 ->addNoClear("struktural")
		 ->addNoClear("rumus")
		 ->addNoClear("ruangan_pegawai")
		 ->setDateTimeEnable(true)
		 ->getUItable()
		 ->addModal("id_pegawai", "hidden", "", $id_pegawai)
		 ->addModal("nama_pegawai", "text", "Nama", $nama_pegawai,"n",null,true)
		 ->addModal("pendidikan", "text", "Pendidikan", $pendidikan,"n",null,true)
		 ->addModal("struktural", "text", "Struktural", $struktural,"n",null,true)
         	 ->addModal("ruangan_pegawai", "text", "Ruangan", $ruangan,"n",null,true)
		 ->addModal("rumus_lembur", "hidden", "", $rumus_lembur,"",null,true);
         
$pemreg ->getForm();
$pemreg ->getUItable()
		 ->setHeader($header)
		 ->addModal ( "id", "hidden", "", "")
		 ->addModal ( "tanggal", "date", "Tanggal", date("Y-m-d"))
		 ->addModal ( "dari", "datetime", "Dari", date("Y-m-d H:i"))
		 ->addModal ( "sampai", "datetime", "Sampai", date("Y-m-d H:i"))
		 ->addModal ( "keterangan", "textarea", "Keterangan", "")
		 ->addModal ( "status_acc", "select", "Status", $status_acc->getContent(),"n",null,true)
         	 ->addModal ( "nilai", "hidden", "", getSettings($db, "hrd-employee-nilai-lembur", "0"));

if($pemreg->getDBResponder()->isPreload() && getSettings($db, "hrd-mode-lembur-rumus", "0")=="1"){    
    $dbtable = new DBTable ( $db, "smis_hrd_rumus_lembur" );
    $dbtable ->setShowAll ( true )
             ->setOrder ( "nama ASC" );
    $data    = $dbtable->view ( "", 0 );
    $job     = new SelectAdapter("nama", "id");
    $rumus   = $job->getContent ( $data ['data'] );
    $rumus[] = array("name"=>"","value"=>"");
    
    $pemreg ->getUItable()
            ->addModal ( "id_rumus", "select", "Rumus", $rumus)
            ->addModal ( "rumus", "hidden", "", "")
            ->addModal ( "kalkulasi", "hidden", "", "");
}

$adapter = $pemreg->getAdapter();
$adapter ->setUseNumber(true, "No.","back.");
$adapter ->add("Jam", "jam")
	->add("Tanggal", "tanggal","date d M Y")
	->add("Keterangan", "keterangan")
	->add("Total", "total","money Rp.")
	->add("Dari", "dari","date d M Y H:i")
	->add("Sampai", "sampai","date d M Y H:i");
$pemreg  ->addRegulerData("id_pegawai", "id_pegawai","id-value")
	->addRegulerData("nama_pegawai", "nama_pegawai","id-value")
	->addRegulerData("ruangan_pegawai", "ruangan_pegawai","id-value")
	->getModal()
	->setTitle("Lembur Karyawan");
$pemreg  ->addResouce("js","hrd/resource/js/pengajuan_lembur.js");
$pemreg  ->initialize();
?>