<?php

/**
 * digunakan untuk melakukan penggajian yang
 * menggunakan metode seperti yang ada di master gaji
 * sehingga data master gaji memiliki komponen
 * yang berbeda-beda antara satu dengan yang lainya
 * 
 * @author 		: Nurul Huda
 * @copyright 	: goblooge@gmail.com
 * @license 	: LGPLv2
 * @database 	: - smis_hrd_gaji
 *                - smis_hrd_salary
 * 				  - smis_hrd_employee
 * @since		: 23 Sept 2017
 * @version		: 1.0.0
 * 
 * */

global $db;
/* for handle external data/handling employee detail */
if (isset ( $_POST ['super_command'] ) && $_POST ['super_command'] == 'auto_salary_employee') {
	$uitable = new Table ( array ('Number','Nama'), "", NULL, true );
	$uitable->setName ( "auto_salary_employee" );
	$uitable->setModel ( Table::$SELECT );
    if (isset ( $_POST ['command'] )) {
		$adapter = new SimpleAdapter ();
		$adapter->add("Number","nip");
		$adapter->add("Nama","nama");		
		$column = array ('id','nip','nama' );
		$dbtable = new DBTable ( $db, "smis_hrd_employee", $column );
		$dbres = new DBResponder ( $dbtable, $uitable, $adapter );
		$data = $dbres->command ( $_POST ['command'] );
		echo json_encode ( $data );
		return;
	}
	echo $uitable->getHtml ();
	return;
}

if (isset ( $_POST ['super_command'] ) && $_POST ['super_command'] == 'auto_salary_periode') {
	$uitable = new Table ( array ('Tanggal','Periode','Template'), "", NULL, true );
	$uitable->setName ( "auto_salary_periode" );
	$uitable->setModel ( Table::$SELECT );
    if (isset ( $_POST ['command'] )) {
		$adapter = new SimpleAdapter ();
		$adapter->add("Tanggal","tanggal","date d M Y");
		$adapter->add("Periode","periode");
		$adapter->add("Template","template");
		$column = array ('tanggal','id','periode','template' );
		$dbtable = new DBTable ( $db, "smis_hrd_periode_gaji", $column );
		$dbres = new DBResponder ( $dbtable, $uitable, $adapter );
		$data = $dbres->command ( $_POST ['command'] );
		echo json_encode ( $data );
		return;
	}
	echo $uitable->getHtml ();
	return;
}
$template=isset($_POST['template'])?$_POST['template']:"";
if($template==""){
    $query="SELECT template FROM smis_hrd_periode_gaji WHERE id='".$_POST['id_periode']."' ";
    $template=$db->get_var($query);
}

$dbtable=new DBTable($db,"smis_hrd_gaji");
$dbtable->setOrder(" urutan ASC ",true);
$dbtable->setShowAll(true);
$dbtable->addCustomKriteria(" template "," ='".$template."'");
$data=$dbtable->view("",0);
$list=$data['data'];
$header=array ("No.",'Nama',"NIP","Golongan" );
foreach( $list as $x ){
    if($x->nilai!="-1")
        $header[]=$x->nama;
}

require_once "hrd/class/table/AutoSalaryTable.php";
$uitable = new AutoSalaryTable ( $header, "&nbsp;", NULL, true );
$uitable->setName ( "auto_salary" );
$uitable->setPrintElementButtonEnable(true);
$uitable->setExcelButtonEnable(true);
$uitable->setReloadButtonEnable(false);

if (isset ( $_POST ['command'] )) {
    require_once "hrd/class/responder/AutoSalaryResponder.php";
    $adapter = new SummaryAdapter();
    $adapter ->setUseNumber(true,"No.","back.")
             ->add("Nama","nama_employee")
             ->add("NIP","nip_employee")
             ->add("Golongan","golongan_employee");    
    $last_elmt      = "";
    foreach( $list as $x ){
        $format     = ($x->jenis==0?"money Rp.":"number");
        $adapter ->add($x->nama,$x->slug,$format);
        $last_elmt  = $x;
    }
    
    $adapter ->addFixValue("Nama","<strong>TOTAL</strong>")
             ->addSummary($last_elmt->nama,$last_elmt->slug,"money Rp.");
    $dbtable = new DBTable($db,"smis_hrd_salary");
    $dbtable->addCustomKriteria("id_periode","='".$_POST['id_periode']."'");
    if(isset($_POST['f_golongan']) && $_POST['f_golongan']!="" ){
        $dbtable->addCustomKriteria(" golongan_employee ","='".$_POST['f_golongan']."'");
    }
    $dbtable->setOrder($_POST['urutan'],true);
    $dbres   = new AutoSalaryResponder($dbtable,$uitable,$adapter);
    $dbres->setTemplate($list);
    $uitable->setTemplate($list);
    
    $data    = $dbres->command($_POST['command']);
    if($data!=null){
        echo  json_encode($data);        
    }
    return;
}

$asc = new OptionBuilder();
$asc ->add("Nama ASC"," nama_employee ASC ")
     ->add("Nama DESC"," nama_employee DESC ")
     ->add("Golongan ASC"," golongan_employee ASC ")
     ->add("Golongan DESC"," golongan_employee DESC ")
     ->add("NIP ASC"," nip_employee ASC ")
     ->add("NIP DESC"," nip_employee DESC ");

require_once "hrd/function/get_all_golongan.php";
$golongan   = get_all_golongan($db);

$id_periode = (isset($_POST['id_periode'])?$_POST['id_periode']:"");
$uitable ->addModal("id_periode","hidden","",$id_periode)
         ->addModal("periode","text","Periode","","n",null,true)
         ->addModal("tanggal","date","Tanggal","","n",null,true)
         ->addModal("template","text","Template","","n",null,true)
         ->addModal("dari","date","Dari","","n",null,true)
         ->addModal("sampai","date","Sampai","","n",null,true)
         ->addModal("urutan","select","Urutkan",$asc->getContent(),"n",null,false)
         ->addModal("f_golongan","select","Golongan",$golongan,"n",null,false);
$form       = $uitable->getModal()->setTitle("Detail Periode Gaji")->getForm();
$uitable ->clearContent();
$uitable ->addModal("id","hidden","","")
         ->addModal("id_employee","hidden","","")
         ->addModal("nama_employee","chooser-auto_salary-auto_salary_employee-Pegawai","Nama","")
         ->addModal("nip_employee","text","NIP","")
         ->addModal("golongan_employee","text","Golongan","");
$array_inputan = array();
foreach($list as $x){
    if($x->nilai!="0")
        continue;
    $type            = ($x->jenis=="0"?"money":"text");
    $uitable->addModal($x->slug,$type,$x->nama,"0");
    $array_inputan[] = $x->slug;
}

$hidden=new Hidden("auto_salary_item","",json_encode($array_inputan));

$back = new Button("","","");
$back ->setIcon("fa fa-backward")
      ->setClass("btn btn-primary")
      ->setAction("auto_salary.back_to_periode()")
      ->setIsButton(Button::$ICONIC);
$uitable->addFooterButton($back);

echo $form      ->getHtml();
echo $uitable   ->getHtml();
echo $uitable   ->getModal()
                ->setTitle("Penggajian")
                ->setComponentSize(Modal::$MEDIUM)->getHtml ();
echo $hidden    ->getHtml();

echo addJS  ("framework/smis/js/table_action.js");
echo addJS  ("hrd/resource/js/auto_salary.js",false);
echo addCSS ("hrd/resource/css/auto_salary.css",false);

?>