<?php
global $db;
require_once "smis-base/smis-include-service-consumer.php";
require_once 'smis-libs-class/MasterSlaveTemplate.php';
require_once "hrd/class/responder/DataAreaLainDBResponder.php";

if(isset($_POST['super_command']) && $_POST['super_command']=="total"){
    $dari    = $_POST['dari'];
    $sampai  = $_POST['sampai'];
    $dbtable = new DBTable($db,"smis_hrd_jadwal_dinas");
    $qv = "SELECT smis_hrd_jadwal_dinas.*, smis_hrd_employee.id as id_karyawan FROM smis_hrd_jadwal_dinas LEFT JOIN smis_hrd_employee ON smis_hrd_jadwal_dinas.nik = smis_hrd_employee.nip ";
    $qc = "SELECT count(*) FROM smis_hrd_jadwal_dinas ";
    $dbtable ->setUseWhereforView(true);
    $dbtable ->setPreferredQuery(true,$qv,$qc);
    $dbtable ->addCustomKriteria(" tanggal >= ","'".$_POST['dari']."'");
    $dbtable ->addCustomKriteria(" tanggal <= ","'".$_POST['sampai']."'");
    $dbtable ->setShowAll(true);
    $data    = $dbtable ->view("","0");
    $list    = $data['data'];
    $response = new ResponsePackage();
    $response ->setStatus(ResponsePackage::$STATUS_OK);
    $response ->setContent($list);
    echo json_encode($response ->getPackage());
    return;
}

if(isset($_POST['super_command']) && $_POST['super_command']=="satuan"){
    $id =  $_POST['id'];
    $nik =  $_POST['nik'];
    $id_karyawan =  $_POST['id_karyawan'];
    $nama_karyawan =  $_POST['nama_karyawan'];
    $unit =  $_POST['unit'];
    $tanggal =  $_POST['tanggal'];
    $shift_1 =  $_POST['shift_1'];
    $shift_2 =  $_POST['shift_2'];
    $jadwal_masuk_shift_1 =  $_POST['jadwal_masuk_shift_1'];
    $jadwal_keluar_shift_1 =  $_POST['jadwal_keluar_shift_1'];
    $jadwal_masuk_shift_2 =  $_POST['jadwal_masuk_shift_2'];
    $jadwal_keluar_shift_2 =  $_POST['jadwal_keluar_shift_2'];
    
    $finger  = new DBTable($db,"smis_hrd_fingerprint");
    $finger ->addCustomKriteria(" tanggal "," = '".$tanggal."' ");
    $finger ->addCustomKriteria(" nip_karyawan "," = '".$nik."' ");
    $finger ->setOrder(" mode ASC ",true);
    $data = $finger ->view("","0");
    $list = $data['data'];

    global $querylog;
    

    require_once "hrd/function/hour_to_minute.php";
    $shif_1_masuk = hour_to_minute($jadwal_masuk_shift_1);
    $shif_1_keluar = hour_to_minute($jadwal_keluar_shift_1);
    $shif_2_masuk = hour_to_minute($jadwal_masuk_shift_2);
    $shif_2_keluar = hour_to_minute($jadwal_keluar_shift_2);
    
    $x_shift_1_masuk = null;
    $x_shift_1_keluar = null;
    $x_shift_2_masuk = null;
    $x_shift_2_keluar = null;    


    $value_shift_1_masuk = null;
    $value_shift_1_keluar = null;
    $value_shift_2_masuk = null;
    $value_shift_2_keluar = null;    

    
    foreach($list as $x){
        if($x->mode==1){

            //masuk shift 1
            $cur_time = hour_to_minute($x->jam);

            $selisih = $shif_1_masuk-$cur_time; //harusnya positif yang bener
            if(abs($selisih)<120){
                if($value_shift_1_masuk==null || $value_shift_1_masuk<$selisih){
                    $value_shift_1_masuk = $selisih;
                    $x_shift_1_masuk = $x;
                }
            }

            //masuk shift 2
            $selisih = $shif_2_masuk-$cur_time; //harusnya positif yang bener
            if(abs($selisih)<120){                
                if($value_shift_2_masuk==null || $value_shift_2_masuk<$selisih){
                    $value_shift_2_masuk = $selisih;
                    $x_shift_2_masuk = $x;
                }
            }
            
        }else{
            //keluar shift 1
            $cur_time = hour_to_minute($x->jam);
            $selisih = $cur_time-$shif_1_keluar; //harusnya positif yang bener
            if(abs($selisih)<120){
                if($value_shift_1_keluar==null || $value_shift_1_keluar<$selisih){
                    $value_shift_1_keluar = $selisih;
                    $x_shift_1_keluar = $x;
                }
            }

            //keluar shift 2
            $selisih = $cur_time-$shif_2_keluar; //harusnya positif yang bener
            if(abs($selisih)<120){
                if($value_shift_2_keluar==null || $value_shift_2_keluar<$selisih){
                    $value_shift_2_keluar = $selisih;
                    $x_shift_2_keluar = $x;
                }
            }

        }

    }

   

    $dbtable = new DBTable($db,"smis_hrd_absensi");
    /**shift 1 */
    $shift_1 = array(
        "id_karyawan"       => $id_karyawan,
        "nama_karyawan"     => $nama_karyawan,
        "nama_shift"        => $shift_1,
        "id_jadwal_dinas"   => $id,
        "tanggal"           => $tanggal,
        "unit_kerja"        => $unit,
        "nik"               => $nik,
        "shift_ke"          =>1,
        "jadwal_masuk"      => $jadwal_masuk_shift_1,
        "jadwal_keluar"     => $jadwal_keluar_shift_1
    );

    $querylog->addMessage("Shift 1 Masuk ".json_encode($x_shift_1_masuk));
    if($x_shift_1_masuk!=null){
        $shift_1['real_masuk'] = $x_shift_1_masuk->jam;
        $shift_1['id_fingerprint_masuk'] = $x_shift_1_masuk->id;
        $selisih = hour_to_minute($x_shift_1_masuk->jam)-$shif_1_masuk;
        if($selisih>0){
            $shift_1['telat'] = $selisih;
        }
    }

    $querylog->addMessage("Shift 1 Kelaur ".json_encode($x_shift_1_keluar));    
    if($x_shift_1_keluar!=null){
        $shift_1['real_keluar'] = $tanggal." ".$x_shift_1_keluar->jam;
        $shift_1['id_fingerprint_keluar'] = $x_shift_1_keluar->id;
        $selisih = $shif_1_keluar-hour_to_minute($x_shift_1_keluar->jam);
        if($selisih>0){
            $shift_1['mendahului'] = $selisih;
        }else{
            $shift_1['lebih_jam'] = abs($selisih);
        }
    }


    $key = array(
        "id_karyawan"       => $id_karyawan,
        "tanggal"           => $tanggal,
        "shift_ke"          => 1
    );
    $dbtable ->insertOrUpdate($shift_1,$key);

    /**shift 2 */
    $shift_2 = array(
        "id_karyawan"       => $id_karyawan,
        "nama_karyawan"     => $nama_karyawan,
        "nama_shift"        => $shift_2,
        "id_jadwal_dinas"   => $id,
        "tanggal"           => $tanggal,
        "unit_kerja"        => $unit,
        "nik"               => $nik,
        "shift_ke"          =>2,
        "jadwal_masuk"      => $jadwal_masuk_shift_2,
        "jadwal_keluar"     => $jadwal_keluar_shift_2
    );

    $querylog->addMessage("Shift 2 Masuk ".json_encode($x_shift_2_masuk));    
    if($x_shift_2_masuk!=null){
        $shift_2['real_masuk'] = $x_shift_2_masuk->jam;
        $shift_2['id_fingerprint_masuk'] = $x_shift_2_masuk->id;
        $selisih = hour_to_minute($x_shift_2_masuk->jam)-$shif_2_masuk;
        if($selisih>0){
            $shift_2['telat'] = $selisih;
        }
    }

    $querylog->addMessage("Shift 2 Keluar ".json_encode($x_shift_2_keluar));    
    if($x_shift_2_keluar!=null){
        $shift_2['real_keluar'] = $x_shift_2_keluar->jam;
        $shift_2['id_fingerprint_keluar'] = $x_shift_2_keluar->id;
        $selisih = $shif_2_keluar-hour_to_minute($x_shift_2_keluar->jam);
        if($selisih>0){
            $shift_2['mendahului'] = $selisih;
        }else{
            $shift_2['lebih_jam'] = abs($selisih);
        }
    }

    $key = array(
        "id_karyawan"       => $id_karyawan,
        "tanggal"           => $tanggal,
        "shift_ke"          => 2
    );
    $dbtable ->insertOrUpdate($shift_2,$key);

    $query = "  UPDATE smis_hrd_absensi LEFT JOIN smis_hrd_shift ON smis_hrd_absensi.nama_shift = smis_hrd_shift.nama 
                SET smis_hrd_absensi.id_shift = smis_hrd_shift.id
                WHERE smis_hrd_absensi.id_jadwal_dinas='".$id."' ";
    $db->query($query);

    $response = new ResponsePackage();
    $response ->setStatus(ResponsePackage::$STATUS_OK);
    $response ->setContent(1);
    echo json_encode($response ->getPackage());
    return;
}



$btn=new Button("","","Cari Absensi");
$btn->setClass(" btn-inverse");
$btn->setAction("compare.view()");
$btn->setIcon(" icon-white icon-search");
$btn->setIsButton(Button::$ICONIC_TEXT);

$excel=new Button("","","Excel");
$excel->setClass(" btn-inverse");
$excel->setAction("compare.excel()");
$excel->setIcon(" fa fa-file-excel-o");
$excel->setIsButton(Button::$ICONIC_TEXT);

$compare=new Button("","","Compare");
$compare->setClass(" btn-inverse");
$compare->setAction("compare.rekaptotal()");
$compare->setIcon(" fa fa-circle-o-notch");
$compare->setIsButton(Button::$ICONIC_TEXT);



$header=array ('No.',"Tanggal","Pegawai","Unit Kerja","Shift","Jadwal Masuk","Jadwal Keluar","Aktual Masuk","Aktual Keluar","Telat","Mendahului","Lebih Jam","Keterangan");
$pemreg=new MasterSlaveTemplate($db, "smis_hrd_absensi", "hrd", "compare");


require_once "smis-libs-class/ExcelImporter.php";
require_once "hrd/class/responder/CompareDBResponder.php";
$dbres = new CompareDBResponder($pemreg->getDBTable(),$pemreg->getUItable(),$pemreg->getAdapter());
$pemreg ->setDBresponder($dbres);


if($dbres->isSave()){
    require_once "hrd/function/hour_to_minute.php";
    $selisih_masuk = hour_to_minute($_POST['real_masuk'])-hour_to_minute($_POST['jadwal_masuk']);
    $selisih_keluar = hour_to_minute($_POST['jadwal_keluar'])-hour_to_minute($_POST['real_keluar']);
   
    if($selisih_masuk>0){
        $dbres->addColumnFixValue("telat",$selisih_masuk);
    }else{
        $dbres->addColumnFixValue("telat",0);
    }

    if($selisih_keluar>0){
        $dbres->addColumnFixValue("mendahului",$selisih_keluar);
        $dbres->addColumnFixValue("lebih_jam",0);
    }else{
        $dbres->addColumnFixValue("mendahului",0);
        $dbres->addColumnFixValue("lebih_jam",abs($selisih_keluar));
    }
    
}

$pemreg ->setDateEnable(true);
$pemreg->setTimeEnable(true);
$pemreg->setDateTimeEnable(true);

$uitable=$pemreg->getUItable();
$uitable->setHeader($header);
$pemreg->setDateEnable(true);
$pemreg->setTimeEnable(true);
$uitable->setReloadButtonEnable(false);
$uitable->setPrintButtonEnable(false);
$uitable->setAction(true);
$uitable->setName("compare");
$pemreg->setUITable($uitable);

if( $pemreg ->getDBResponder() ->isView() || $_POST['command']=="excel" ){
	$pemreg	->getDBtable()
            ->setOrder(" DATE(tanggal) ASC ",true);
    if($_POST['s_dari']!=""){
        $pemreg	->getDBtable()
                ->addCustomKriteria(null, " tanggal >= '".$_POST['s_dari']."'");
    }
    if($_POST['s_sampai']!=""){
        $pemreg	->getDBtable()
                ->addCustomKriteria(null, " tanggal <= '".$_POST['s_sampai']."'");
    }
    if($_POST['s_nama_karyawan']!="" && $_POST['s_id_karyawan']!=""){
        $pemreg	->getDBtable()
                ->addCustomKriteria(null, " id_karyawan = '".$_POST['s_id_karyawan']."'");
    }
    if($_POST['s_kondisi']!=""){
        if($_POST['s_kondisi']=="lengkap"){
            /*$pemreg	->getDBtable()
                    ->addCustomKriteria(null, "( 
                            (jadwal_masuk != '00:00:00' AND jadwal_keluar != '00:00:00')
                            OR 
                            ( 
                                        (jadwal_masuk = '00:00:00' OR jadwal_keluar = '00:00:00') 
                                    AND (real_masuk = '00:00:00'  AND real_keluar = '00:00:00') 
                            ) 
                    
                    )");*/
                    $pemreg	->getDBtable()
                            ->addCustomKriteria(null, " jadwal_masuk != '00:00:00'");
                    $pemreg	->getDBtable()
                            ->addCustomKriteria(null, " jadwal_keluar != '00:00:00'");
                    $pemreg	->getDBtable()
                            ->addCustomKriteria(null, " real_masuk != '00:00:00'");
                    $pemreg	->getDBtable()
                            ->addCustomKriteria(null, " real_keluar != '00:00:00'");
        }else{
            $pemreg	->getDBtable()
                    ->addCustomKriteria(null, " ( 
                            (jadwal_masuk != '00:00:00' OR jadwal_keluar != '00:00:00') 
                        AND (real_masuk = '00:00:00'  AND real_keluar = '00:00:00') 
                    ) ");
        }
        
    }
}

$kondisi = new OptionBuilder();
$kondisi ->add("","",1);
$kondisi ->add("Lengkap","lengkap");
$kondisi ->add("Tidak Lengkap","tidak_lengkap");

require_once "hrd/function/get_all_unit_kerja.php";
$unit_kerja      = get_all_unit_kerja($db);

if($pemreg->getDBResponder()->isPreload()){

    $ket = new OptionBuilder();
    $ket->addSingle("SPT");
    $ket->addSingle("I");
    $ket->addSingle("A");
    $ket->addSingle("MC");
    $ket->addSingle("MCk");
    
    $pemreg  ->getUItable()
            ->addModal("s_unit_kerja","select","Unit Kerja",$unit_kerja )
            ->addModal("s_dari","date","Dari","")
            ->addModal("s_sampai","date","Sampai","")         
            ->addModal("s_nama_karyawan","chooser-compare-employee-Pegawai","Pegawai","")
            ->addModal("s_id_karyawan","hidden","","")
            ->addModal("s_kondisi","select","Kondisi",$kondisi->getContent());
    $form=$pemreg  ->getForm();
    $form->addElement("",$btn);
    $form->addElement("",$compare);
    $form->addElement("",$excel);
    $pemreg  ->getUItable()->clearContent();
    $pemreg  ->getUItable()
            ->addModal("id","hidden","","")
            ->addModal("tanggal","date","Tanggal","","n",null,true)
            ->addModal("nama_karyawan","text","Nama Karyawan","","n",null,true)
            ->addModal("unit_kerja","text","unit_kerja","","n",null,true)
            ->addModal("jadwal_masuk","time","Jadwal Masuk","","n",null,true)
            ->addModal("jadwal_keluar","time","Jadwal Keluar","","n",null,true)
            ->addModal("real_masuk","time","Real Masuk","")
            ->addModal("real_keluar","time","Real Keluar","")
            ->addModal("keterangan","select","Keterangan",$ket->getContent());
}

$pemreg  ->getUItable();
$pemreg->setModalTitle("Data Hasil Import Jadwal");
$pemreg->setModalComponentSize(Modal::$MEDIUM);
$adapter = $pemreg->getAdapter();

$adapter ->setUseNumber(true,"No.","back.");
$adapter ->add("Pegawai","nama_karyawan");
$adapter ->add("Unit Kerja","unit_kerja");
$adapter ->add("Shift","nama_shift");
$adapter ->add("No. Shift","shift_ke");
$adapter ->add("Jadwal Masuk","jadwal_masuk","date H:i");
$adapter ->add("Jadwal Keluar","jadwal_keluar","date H:i");
$adapter ->add("Aktual Masuk","real_masuk","date H:i");
$adapter ->add("Aktual Keluar","real_keluar","date H:i");
$adapter ->add("Telat","telat","back Menit");
$adapter ->add("Mendahului","mendahului","back Menit");
$adapter ->add("Lebih Jam","lebih_jam","back Menit");
$adapter ->add("Keterangan","keterangan");
$adapter ->add("NIK","nik");
$adapter ->add("Tanggal","tanggal","date d M Y");
$adapter ->add("Shift 1","shift_1");
$adapter ->add("Shift 2","shift_2");

$pemreg->addResouce("js","hrd/resource/js/compare.js","after",false);
$pemreg->addViewData("s_dari","s_dari");
$pemreg->addViewData("s_sampai","s_sampai");
$pemreg->addViewData("s_unit_kerja","s_unit_kerja");
$pemreg->addViewData("s_nama_karyawan","s_nama_karyawan");
$pemreg->addViewData("s_id_karyawan","s_id_karyawan");
$pemreg->addViewData("s_kondisi","s_kondisi");

$pemreg->setAutoReload(true);

/*karyawan */
$dbtable  = new DBTable($db,"smis_hrd_employee");
$uitable  = new Table(array('No.','Nama','NIK'));
$uitable  ->setName("employee");
$uitable  ->setModel(Table::$SELECT);

$adapter = new SimpleAdapter();
$adapter ->setUseNumber(true,"No.","back.")
        ->add("Nama","nama")
        ->add("NIK","nik");

$dbresponder =  new DBResponder($dbtable,$uitable,$adapter);
$pemreg  ->addSuperCommandResponder("employee",$dbresponder)
         ->addSuperCommandArray("employee","s_nama_karyawan","nama")
         ->addSuperCommandArray("employee","s_id_karyawan","id");
$pemreg->addResouce("js","base-js/smis-base-loading.js","before",true);
$pemreg->addResouce("js","compare/resource/js/compare.js","after",false);
$pemreg->initialize();

if($pemreg->getDBResponder()->isPreload() && $_POST['super_command']==""){
    $close=new Button("", "", "Batal");
    $close	->addClass("btn-primary")
            ->setIsButton(Button::$ICONIC_TEXT)
            ->setIcon("fa fa-close")
            ->setAction("compare.batal()");
    $load=new LoadingBar("rekap_compare_bar", "");
    $modal=new Modal("rekap_compare_modal", "", "Processing...");
    $modal	->addHTML($load->getHtml(),"after")
            ->addFooter($close);
    echo $modal->getHtml();
}