<?php
    
	
	require_once 'smis-framework/smis/api/SettingsBuilder.php';
	global $db;	
	$smis = new SettingsBuilder ( $db, "hrd_settings", "hrd", "settings","Pengaturan Personalia" );
	$smis->setShowDescription ( true );
	$smis->setTabulatorMode ( Tabulator::$LANDSCAPE_RIGHT );
    
    $smis->addTabs ( "print", "Print Out","fa fa-print" );
    if($smis->isGroup("print")){
        $smis->addItem ( "print", new SettingsItem ( $db, "hrd-css-print-auto-salary", "CSS Auto Salary", "", "textarea", "gunakan .salary_one, .salary_logo, .salary_two, .salary_name, .salary_address" ) );
    }
    
    $smis->addTabs ( "duplicate", "Duplikasi","fa fa-cloud-upload" );
	if($smis->isGroup("duplicate")){
        $smis->addItem ( "duplicate", new SettingsItem ( $db, "hrd-job-duplicate", "Aktifkan Duplikasi Database HRD Job", "0", "text", "0 - Tidak Aktif, 1. Auto Duplicate , 2. Manual Duplicate" ) );
        $smis->addItem ( "duplicate", new SettingsItem ( $db, "hrd-pendidikan-duplicate", "Aktifkan Duplikasi Database HRD Pendidikan", "0", "text", "0 - Tidak Aktif, 1. Auto Duplicate , 2. Manual Duplicate" ) );
        $smis->addItem ( "duplicate", new SettingsItem ( $db, "hrd-employee-duplicate", "Aktifkan Duplikasi Database HRD Employee", "0", "text", "0 - Tidak Aktif, 1. Auto Duplicate , 2. Manual Duplicate" ) );
        $smis->addItem ( "duplicate", new SettingsItem ( $db, "hrd-job-duplicate", "Aktifkan Duplikasi Database HRD Job", "0", "text", "0 - Tidak Aktif, 1. Auto Duplicate , 2. Manual Duplicate" ) );
        $smis->addItem ( "duplicate", new SettingsItem ( $db, "hrd-pendidikan-duplicate", "Aktifkan Duplikasi Database HRD Pendidikan", "0", "text", "0 - Tidak Aktif, 1. Auto Duplicate , 2. Manual Duplicate" ) );
        $smis->addItem ( "duplicate", new SettingsItem ( $db, "hrd-employee-duplicate", "Aktifkan Duplikasi Database HRD Employee", "0", "text", "0 - Tidak Aktif, 1. Auto Duplicate , 2. Manual Duplicate" ) );
    }
    
    $smis->addTabs ( "data_induk", "Tampilan Data Induk","fa fa-database" );	
    if($smis->isGroup("data_induk")){
        $list=getAllFileInDir("hrd/resource/php/data_induk/",false,true);
        foreach($list as $x){
            $x=str_replace(".php","",$x);
            $xname=ArrayAdapter::slugFormat("unslug-ucword",$x);
            $smis->addItem ( "data_induk", new SettingsItem ( $db, "hrd-ui-data-induk-".$x, $xname, "1", "checkbox", "pengaktifan menu $xname" ) );
        }
    }
    
	$smis->addTabs ( "kepegawaian", "Kepegawaian","fa fa-users" );	
    if($smis->isGroup("kepegawaian")){
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-grup-gaji", "Grup Gaji", "", "checkbox", "Grup Gaji" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-nidn", "Tampilkan NIDN", "", "checkbox", "Tampilkan NIDN dalam Menu Pegawai" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-gaji-pokok", "Tampilkan Gaji Pokok", "", "checkbox", "Tampilkan Gaji Pokok" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-jasa-pelayanan", "Tampilkan Jasa Pelayanan", "", "checkbox", "Tampilkan Jasa Pelayanan" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-tunjangan-struktural", "Tampilkan Tunjangan Struktural", "", "checkbox", "Tampilkan Tunjangan Struktural" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-tunjangan-fungsional", "Tampilkan Tunjangan Fungsional", "", "checkbox", "Tampilkan Tunjangan Fungsional" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-tunjangan-golongan", "Tampilkan Tunjangan Golongan", "", "checkbox", "Tampilkan Tunjangan Golongan" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-tunjangan-pengabdian", "Tampilkan Tunjangan Pengabdian", "", "checkbox", "Tampilkan Tunjangan Pengabdian" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-tunjangan-jabatan", "Tampilkan Tunjangan Jabatan", "", "checkbox", "Tampilkan Tunjangan Jabatan" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-tunjangan-pendidikan", "Tampilkan Tunjangan Pendidikan", "", "checkbox", "Tampilkan Tunjangan Pendidikan" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-tunjangan-pasutri", "Tampilkan Tunjangan Suami / Istri", "", "checkbox", "Tampilkan Tunjangan Suami / Istri" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-tunjangan-anak", "Tampilkan Tunjangan Anak", "", "checkbox", "Tampilkan Tunjangan Anak" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-tunjangan-kehadiran", "Tampilkan Tunjangan Absensi dan Kehadiran", "", "checkbox", "Tampilkan Tunjangan Absensi dan Kehadiran" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-uang-makan", "Tampilkan Uang Makan", "", "checkbox", "Tampilkan Uang Makan" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-uang-transportasi", "Tampilkan Uang Transportasi", "", "checkbox", "Tampilkan Uang Transportasi" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-dana-pensiun", "Tampilkan Dana Pensiun", "", "checkbox", "Tampilkan Dana Pensiun" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-insentif", "Tampilkan Dana Insentif", "", "checkbox", "Tampilkan Dana Insentif" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-bpjs-kesehatan", "Tampilkan Dana BPJS Kesehatan", "", "checkbox", "Tampilkan Dana BPJS Kesehatan" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-bpjs-ketenagakerjaan", "Tampilkan BPJS Ketenaga Kerjaan", "", "checkbox", "Tampilkan BPJS Ketenagakerjaan" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-lain", "Tampilkan Lain-Lain", "", "checkbox", "Tampilkan Lain-Lain" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-upah-operasi", "Tampilkan Upah Operasi", "", "checkbox", "Tampilkan Upah Operasi" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-upah-perujuk", "Tampilkan Upah Perujuk", "", "checkbox", "Tampilkan Upah Perujuk" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-upah-duduk", "Tampilkan Upah Duduk", "", "checkbox", "Tampilkan Upah Duduk" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-upah-pasien", "Tampilkan Upah Pasien", "", "checkbox", "Tampilkan Upah Pasien" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-rumus-lembur", "Tampilkan Rumus Lembur", "", "checkbox", "Tampilkan Rumus Lembur" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-uang-hadir-pagi", "Tampilkan Untuk Uang Hadir Pagi", "", "checkbox", "Tampilkan Untuk Uang Hadir Pagi" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-uang-hadir-siang", "Tampilkan Untuk Uang Hadir Siang", "", "checkbox", "Tampilkan Untuk Uang Hadir Siang" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-uang-hadir-malam", "Tampilkan Untuk Uang Hadir Malam", "", "checkbox", "Tampilkan Untuk Uang Hadir Malam" ) );
        $smis->addItem ( "kepegawaian", new SettingsItem ( $db, "hrd-employee-max-kontrak-limit", "Maksimum Durasi Kontrak", "60", "text", "Maksimum Durasi Kontrak" ) );
    }
    
    $smis->addTabs ( "ui_kepegawaian", "UI Kepegawaian","fa fa-desktop" );
    if($smis->isGroup("ui_kepegawaian")){
        $list=getAllFileInDir("hrd/resource/php/kepegawaian/",false,true);
        foreach($list as $x){
            $x=str_replace(".php","",$x);
            $xname=ArrayAdapter::slugFormat("unslug-ucword",$x);
            $smis->addItem ( "ui_kepegawaian", new SettingsItem ( $db, "hrd-ui-kepegawaian-".$x, $xname, "0", "checkbox", "pengaktifan menu $xname" ) );
        }
    }	
    
    $smis->addTabs ( "perhitungan", "Perhitungan","fa fa-calculator" );
    if($smis->isGroup("perhitungan")){
        require_once 'smis-base/smis-include-service-consumer.php';
        $set=new ServiceConsumer($db,"get_jenis_patient",NULL,"registration");
        $set->execute();
        $content=$set->getContent();
        foreach($content as $x=>$y){
            $smis->addItem ( "perhitungan", new SettingsItem ( $db, "hrd-bonus-kunjungan-pasien-".$y['value'], "Bonus Pasien ".$y['name'], "", "money", "Nilai Uang Per Kunjunga Pasien ".$y['name'] ) );
        }  
        $smis->addItem ( "perhitungan", new SettingsItem ( $db, "smis-hrd-max-lock", "Penguncian Operasi Pasien", "50", "text", "Maksimum Penguncian Operasi Pasien ") );
    }
    
    $smis->addTabs ( "laboratory", "Laboratory","fa fa-flask" );
    if($smis->isGroup("laboratory")){
        $smis->addItem ( "laboratory", new SettingsItem ( $db, "smis-hrd-target-lab-umum", "Target Minimal Pasien Umum", "0", "money", "Minimum Target Pasien Umum Pendapatan Lab") );
        $smis->addItem ( "laboratory", new SettingsItem ( $db, "smis-hrd-persen-target-lab-umum", "Nilai Persentase Target Lab Umum", "0", "text", "Nilai Persentase Target Lab Umum") );
        $smis->addItem ( "laboratory", new SettingsItem ( $db, "smis-hrd-persen-kelebihan-lab-umum", "Nilai Persentase Kelebihan Target Lab Umum", "0", "text", "Nilai Persentase Kelebihan Target Lab Umum") );
        $smis->addItem ( "laboratory", new SettingsItem ( $db, "smis-hrd-target-lab-bpjs", "Target Minimal Pasien BPJS", "0", "money", "Minimum Target Pasien Umum Pendapatan Lab") );
        $smis->addItem ( "laboratory", new SettingsItem ( $db, "smis-hrd-persen-target-lab-bpjs", "Nilai Persentase Target Lab BPJS", "0", "text", "Nilai Persentase Target Lab BPJS") );
        $smis->addItem ( "laboratory", new SettingsItem ( $db, "smis-hrd-persen-kelebihan-lab-bpjs", "Nilai Persentase Kelebihan Target Lab BPJS", "0", "text", "Nilai Persentase Kelebihan Target Lab BPJS") );
    }
    
    $smis->addTabs ( "dokter", "Dokter","fa fa-user-md" );
    if($smis->isGroup("dokter")){
        $smis->addItem ( "dokter", new SettingsItem ( $db, "smis-hrd-lab-dokter-umum", "Persentase Dokter Umum", "0", "text", "Persentase Bagi Hasil Lab untuk Dokter Umum") );
        $smis->addItem ( "dokter", new SettingsItem ( $db, "smis-hrd-lab-dokter-spesialis", "Persentase Dokter Spesiali", "0", "text", "Persentase Bagi Hasil Lab untuk Dokter Spesialis") );
    }
    
    $smis->addTabs ( "perawat", "Perawat","fa fa-user" );
    if($smis->isGroup("perawat")){
        $smis->addItem ( "perawat", new SettingsItem ( $db, "smis-hrd-persen-perawat-umum", "Persentase Bagi Hasil Perawat Pasien Umum", "0", "text", "Persentase Bagi Hasil Perawat Pasien Umum") );
        $smis->addItem ( "perawat", new SettingsItem ( $db, "smis-hrd-poin-pertama-perawat-umum", "Point Pertama Perawat Umum", "0", "text", "Poin Pertama jika Mencapai Target Pasien Umum") );
        $smis->addItem ( "perawat", new SettingsItem ( $db, "smis-hrd-target-pertama-perawat-umum", "Nilai Maksimum Target Pertama Pasien Umum", "0", "money", "Nilai Maksimum Pertama Pasien Umum") );
        $smis->addItem ( "perawat", new SettingsItem ( $db, "smis-hrd-poin-berikutnya-perawat-umum", "Point Berikutnya Perawat Umum", "0", "text", "Poin Berikutnya jika Mencapai Target Pasien Umum") );
        $smis->addItem ( "perawat", new SettingsItem ( $db, "smis-hrd-target-berikutnya-perawat-umum", "Nilai Target Berikutnya Pasien Umum", "0", "money", "Nilai Berikutnya Pasien Umum") );
        
        $smis->addItem ( "perawat", new SettingsItem ( $db, "smis-hrd-persen-perawat-bpjs", "Persentase Bagi Hasil Perawat Pasien BPJS", "0", "text", "Persentase Bagi Hasil Perawat Pasien BPJS") );
        $smis->addItem ( "perawat", new SettingsItem ( $db, "smis-hrd-poin-pertama-perawat-bpjs", "Point Pertama Perawat BPJS", "0", "text", "Poin Pertama jika Mencapai Target Pasien BPJS") );
        $smis->addItem ( "perawat", new SettingsItem ( $db, "smis-hrd-target-pertama-perawat-bpjs", "Nilai Maksimum Target Pertama Pasien BPJS", "0", "money", "Nilai Maksimum Pertama Pasien BPJS") );
        $smis->addItem ( "perawat", new SettingsItem ( $db, "smis-hrd-poin-berikutnya-perawat-bpjs", "Point Berikutnya Perawat BPJS", "0", "text", "Poin Berikutnya jika Mencapai Target Pasien BPJS") );
        $smis->addItem ( "perawat", new SettingsItem ( $db, "smis-hrd-target-berikutnya-perawat-bpjs", "Nilai Target Berikutnya Pasien BPJS", "0", "money", "Nilai Berikutnya Pasien BPJS") );
        
    }
    
    $smis->addTabs ( "administrator", "Administrator","fa fa-ticket" );
    if($smis->isGroup("administrator")){
        $smis->addItem ( "administrator", new SettingsItem ( $db, "smis-hrd-target-admin-umum", "Target Minimal Pasien Umum", "0", "money", "Minimum Target Pasien Umum Pendapatan Admin") );
        $smis->addItem ( "administrator", new SettingsItem ( $db, "smis-hrd-persen-target-admin-umum", "Nilai Persentase Target Lab Umum", "0", "text", "Nilai Persentase Target Admin Umum") );
        $smis->addItem ( "administrator", new SettingsItem ( $db, "smis-hrd-persen-kelebihan-admin-umum", "Nilai Persentase Kelebihan Target Lab Umum", "0", "text", "Nilai Persentase Kelebihan Target Admin Umum") );
        $smis->addItem ( "administrator", new SettingsItem ( $db, "smis-hrd-target-admin-bpjs", "Target Minimal Pasien BPJS", "0", "money", "Minimum Target Pasien Umum Pendapatan Admin") );
        $smis->addItem ( "administrator", new SettingsItem ( $db, "smis-hrd-persen-target-admin-bpjs", "Nilai Persentase Target Lab BPJS", "0", "text", "Nilai Persentase Target Admin BPJS") );
        $smis->addItem ( "administrator", new SettingsItem ( $db, "smis-hrd-persen-kelebihan-admin-bpjs", "Nilai Persentase Kelebihan Target Lab BPJS", "0", "text", "Nilai Persentase Kelebihan Target Admin BPJS") );
    }
    
    $smis->addTabs ( "ob", "Office Boy","fa fa-bath" );
    if($smis->isGroup("ob")){
        $smis->addItem ( "ob", new SettingsItem ( $db, "smis-hrd-target-ob", "Target Minimal Office Boy", "0", "money", "Minimum Target Pendapatan Kamar untuk Office Boy") );
        $smis->addItem ( "ob", new SettingsItem ( $db, "smis-hrd-persen-target-ob", "Nilai Persentase Target Office Boy", "0", "text", "Nilai Persentase Target Office Boy") );
        $smis->addItem ( "ob", new SettingsItem ( $db, "smis-hrd-persen-kelebihan-ob", "Nilai Persentase Kelebihan Target Office Boy", "0", "text", "Nilai Persentase Kelebihan Target Office Boy") );
    }
    
    $smis->addTabs ( "ruangan", "Ruangan","fa fa-university" );
    if($smis->isGroup("ruangan")){
        $smis->addItem ( "ruangan", new SettingsItem ( $db, "hrd-slug-kamar-operasi", "Slug Kamar Operasi", "", "text", "Slug dari Kamar Operasi" ) );
        $smis->addItem ( "ruangan", new SettingsItem ( $db, "hrd-slug-area-kamar-operasi", "Area Kamar Operasi", "", "text", "Nama Area Kamar Operasi (gresik,lamongan,dll)" ) );
        $smis->addItem ( "ruangan", new SettingsItem ( $db, "hrd-slug-igd", "Slug IGD", "", "text", "Slug dari IGD" ) );
    }
    
    $smis->addTabs ( "lembur", "Lembur","fa fa-money" );
	if($smis->isGroup("lembur")){
        $op=new OptionBuilder();
        $op->add("Bulatkan Ke Bawah Sampai Jam ","floor-jam","1");
        $op->add("Bulatkan Ke Atas Sampai Jam ","ceil-jam","1");
        $op->add("Bulatkan Sampai Jam (0.5 Keatas dianggap 1) ","jam","1");
        $op->add("Bulatkan Kebawah Sampai Menit (2 Digit di belakang Koma) ","menit");
    
        $smis->addItem ( "lembur", new SettingsItem ( $db, "hrd-mode-lembur-rumus", "Aktifkan Rumus pada Perhitungan Lembur", "0", "checkbox", "jika di centang, maka perhitungan lembur akan mengikuti rumus" ) );
        $smis->addItem ( "lembur", new SettingsItem ( $db, "hrd-employee-nilai-lembur", "Nilai Per Jam Lembur", "0", "money", "Nilai Lembur Per Jam" ) );
        $smis->addItem ( "lembur", new SettingsItem ( $db, "hrd-employee-hitung-lembur", "Perhitungan Lembur", $op->getContent(), "select", "Perhitungan Lembur" ) );
    }
    
    $smis->setPartialLoad(true);
    $response = $smis->init ();
?>