<?php

class MantanDBResponder extends DBResponder{

    public function excel(){
        $this->dbtable->setShowAll(true);
        $this->dbtable->setOrder(" nama_jabatan  ASC ",true);
        $data = $this->dbtable->view("",0);
        $fix  = $data['data'];

        require_once ("smis-libs-out/php-excel/PHPExcel.php");
        $file  = new PHPExcel ();
        $sheet = $file->getActiveSheet ();
        
        $row   = 1;
        $sheet->mergeCells("A".$row.":H".$row);
        $sheet->getStyle('A'.$row.':'.'H'.$row)->getFont()->setBold(true);
        $sheet->getStyle('A'.$row.':'.'H'.$row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->setCellValue("A".$row, "Laporan Karyawan Keluar - PT. Casa Medical Utama");
        $row++;
        
        $sheet->mergeCells("A".$row.":H".$row);
        $sheet->getStyle('A'.$row.':'.'H'.$row)->getFont()->setBold(true);
        $sheet->getStyle('A'.$row.':'.'H'.$row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->setCellValue("A".$row, "Periode : ".ArrayAdapter::format("date d M Y",$_POST['dari'])." s/d ".ArrayAdapter::format("date d M Y",$_POST['sampai']));
        $row += 2;
        
        $sheet->setCellValue("A".$row, "No.");
        $sheet->setCellValue("B".$row, "Nama dan ID");
        $sheet->setCellValue("C".$row, "Unit Kerja");
        $sheet->setCellValue("D".$row, "Jabatan");
        $sheet->setCellValue("E".$row, "Tgl. Bergabung");
        $sheet->setCellValue("F".$row, "Masa Kerja");
        $sheet->setCellValue("G".$row, "Status Karyawan");
        $sheet->setCellValue("H".$row, "Tgl. Keluar");

        $sheet->getStyle('A'.$row.':'.'H'.$row)->getFont()->setBold(true);
        $sheet->getStyle('A'.$row.':'.'H'.$row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $row++;
        
        $cur_jbt = "-";
        loadLibrary("smis-libs-function-time");
        $no = 1;
        foreach($fix as $x) {
            if($cur_jbt!=trim($x->nama_jabatan)){
                $sheet->mergeCells("A".$row.":H".$row);
                $sheet->setCellValue("A".$row, $x->nama_jabatan);
                $cur_jbt = $x->nama_jabatan;
                $sheet->getStyle('A'.$row.':'.'H'.$row)->getFont()->setBold(true);
                $row++;
            }
            
            $masker = day_diff($x->tanggal_masuk,$x->tanggal_keluar);

            $sheet->setCellValue("A".$row, $no.". ");
            $sheet->getStyle('A'.$row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
            $sheet->setCellValue("B".$row, $x->nama." /#".$x->nip);
            $sheet->setCellValue("C".$row, $x->unit_kerja);
            $sheet->setCellValue("D".$row, $x->nama_jabatan);
            $sheet->setCellValue("E".$row, ArrayAdapter::format("date d M Y",$x->tanggal_masuk));
            $sheet->setCellValue("F".$row, $masker);
            $sheet->setCellValue("G".$row, $x->tenaga);
            $sheet->setCellValue("H".$row, ArrayAdapter::format("date d M Y",$x->tanggal_permanen));           
            $row++;
            $no++;
        }
        
        foreach(range('A','H') as $columnID) {
            $sheet->getColumnDimension($columnID)->setAutoSize(true);
        }

        $sheet->getStyle("A1:H".($row-1) ) ->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
        
        header ( 'Content-Type: application/vnd.ms-excel' );
        header ( 'Content-Disposition: attachment;filename="LAPORAN KARYAWAN KELUAR.xls"' );
        header ( 'Cache-Control: max-age=0' );
        $writer = PHPExcel_IOFactory::createWriter ( $file, 'Excel5' );
        $writer->save ( 'php://output' );
		return;
    }

}