<?php 

class JadwalDBResponder extends DBResponder{


    public function excel(){
        $this->dbtable->setShowAll(true);
        $this->dbtable->setFetchMethode(DBTable::$ARRAY_FETCH);
        $view   = $this->dbtable->view("",0);
        $list_d = $view['data'];
        require_once ("smis-libs-out/php-excel/PHPExcel.php");
        $file   = new PHPExcel ();
        $sheet  = $file->getActiveSheet();


        /*start - BLOCK UNTUK BORDER*/
        $thick = array ();
        $thick['borders']=array();
        $thick['borders']['allborders']=array();
        $thick['borders']['allborders']['style']=PHPExcel_Style_Border::BORDER_THIN ;
 

        $sheet ->setCellValue("A1","NIK");
        $sheet ->setCellValue("B1","TANGGAL");
        $sheet ->setCellValue("C1","SHIFT 1");
        $sheet ->setCellValue("D1","SHIFT 2");
        $sheet->getStyle ( 'A1:D1' )->applyFromArray ($thick);

        $sheet ->mergeCells("F1:G1");
        $sheet ->setCellValue("F1","TABEL KODE SHIFT");
        global $db;
        $tbale = new DBTable($db,"smis_hrd_shift");
        $tbale->setShowAll(true);
        $ft = $tbale->view("","0");
        $list = $ft['data'];

        $line =  1;
        foreach($list as $u){
            $line++;
            $sheet ->setCellValue("F".$line,$u->nama);
            if($u->deskripsi==""){
                $sheet ->setCellValue("G".$line,substr($u->t_start,0,5)." - ".substr($u->t_end,0,5));
            }else{
                $sheet ->setCellValue("G".$line,$u->deskripsi);
            }
        }
        $sheet->getStyle ( 'F1:G'.$line )->applyFromArray ($thick);
        

        $backgroound['fill']=array();
        $backgroound['fill']['type']=PHPExcel_Style_Fill::FILL_SOLID;
        $backgroound['fill']['color']=array();
        $backgroound['fill']['color']['rgb']='00FFFF';
        $sheet->getStyle ( 'A1:D1' )->applyFromArray ($backgroound);

        $filename = "Format Import Jadwal Dinas";
        
        header ( 'Content-Type: application/vnd.ms-excel' );
        header ( 'Content-Disposition: attachment;filename="'.$filename.'.xls"' );
        header ( 'Cache-Control: max-age=0' );
        $writer = PHPExcel_IOFactory::createWriter ( $file, 'Excel5' );
        $writer->save ( 'php://output' );
    }


    /* @var ExcelImporter */
    private $importer;
    
    public function command($command){
        if($command=="import_proceed"){
            $pack=new ResponsePackage();
            $pack->setStatus(ResponsePackage::$STATUS_OK);
            $content=$this->import_proceed();
            $pack->setContent("");
            $pack->setWarning(true,"Import Done"," Total Data ".$content." Imported");
            return $pack->getPackage();
        }else if($command=="detach_import"){
            $pack=new ResponsePackage();
            $pack->setStatus(ResponsePackage::$STATUS_OK);
            $content=$this->detach_import();
            $pack->setContent("");
            $pack->setWarning(true,"Detach Done"," Total Data ".$content." Detached");
            return $pack->getPackage();
        }else{
            return parent::command($command);
        }
    }
    
    /**
     * @brief remove the imported data
     * @return  null
     */
    private function detach_import(){
        $id=$_POST['id'];
        $db=$this->getDBTable()->get_db();
        $query="SELECT count(*) as total FROM smis_hrd_jadwal_dinas WHERE id_import='".$id."'";
        $total=$db->get_var($query);
        $query="DELETE FROM smis_hrd_jadwal_dinas WHERE id_import='".$id."'";
        $db->query($query);
        return $total;
    }
    
    /**
     * @brief importing processs
     * @return  int total data imported
     */
    private function import_proceed(){
        $id=$_POST['id'];
        $row=$this->dbtable->select($id);
        $this->importer->setFilePath($row->file);
        if($row->max_memory!=""){
            ini_set('memory_limit',$row->max_memory);
        }
        if($row->max_time*1>0){
            ini_set('max_execution_time',$row->max_time);
        }
        
        $column_map=array();
        $column_map[0]="nik";
        $column_map[1]="tanggal";
        $column_map[2]="shift_1";
        $column_map[3]="shift_2";
        
        $this->importer->addKey("nik");
        $this->importer->addKey("tanggal");
        
        $this->importer->addSetup(0,2,$column_map,null);
        $this->importer->addFixValue("id_import",$row->id);
        $total = $this->importer->execute();
        
        $query = "  UPDATE smis_hrd_jadwal_dinas LEFT JOIN smis_hrd_shift 
                    ON   smis_hrd_jadwal_dinas.shift_1 = smis_hrd_shift.nama
                    SET smis_hrd_jadwal_dinas.jadwal_masuk_shift_1 = smis_hrd_shift.t_start,
                    smis_hrd_jadwal_dinas.jadwal_keluar_shift_1 = smis_hrd_shift.t_end
                    WHERE smis_hrd_jadwal_dinas.id_import = '".$row->id."' ";
        $this->dbtable->get_db()->query($query);

        $query = "  UPDATE smis_hrd_jadwal_dinas LEFT JOIN smis_hrd_shift 
                    ON   smis_hrd_jadwal_dinas.shift_2 = smis_hrd_shift.nama
                    SET smis_hrd_jadwal_dinas.jadwal_masuk_shift_2 = smis_hrd_shift.t_start,
                    smis_hrd_jadwal_dinas.jadwal_keluar_shift_2 = smis_hrd_shift.t_end
                    WHERE smis_hrd_jadwal_dinas.id_import = '".$row->id."' ";
        $this->dbtable->get_db()->query($query);

        $query = "  UPDATE smis_hrd_jadwal_dinas LEFT JOIN smis_hrd_employee 
                    ON   smis_hrd_jadwal_dinas.nik = smis_hrd_employee.nip
                    SET smis_hrd_jadwal_dinas.nama_karyawan = smis_hrd_employee.nama,
                    smis_hrd_jadwal_dinas.unit = smis_hrd_employee.unit_kerja
                    WHERE smis_hrd_jadwal_dinas.id_import = '".$row->id."' ";
        $this->dbtable->get_db()->query($query);


        return $total;
    }
    
    public function postToArray(){
        $result=parent::postToArray();
        if(isset($result['file'])){
            $this->importer->setFilePath($result['file']);
            $sheet=$this->importer->countSheet();
            $result['sheets']=$sheet;    
        }
        return $result;
    }
    
    public function setImporter(ExcelImporter $importer){
        $this->importer=$importer;
        return $this;
    }

    public function pdf_element(){
        $this->getDBTable()->setShowAll(true);
        $list = $this->getDBTable()->view("","0");
        $data = $list['data'];
        global $db;
        $hrd        = new DBTable($db,"smis_vhrd_employee");
        $employee   = $hrd ->select(array("nama"=>$_POST['nama_filter']));
        $jabatan    = $employee->nama_jabatan;
        $nama       = $employee->nama;
        $periode    = ArrayAdapter::format("date d M Y",$_POST['dari_filter'])." - ".ArrayAdapter::format("date d M Y",$_POST['sampai_filter']);

        $tp = new TablePrint("jadwal_karyawan");
 
        
        $tp ->addColumn("<h1>JADWAL DINAS</h1>",8,1);
        $tp ->commit("title");
        
        $tp ->addColumn("<h2>".$nama."</h2>",8,1);
        $tp ->commit("title");

        $tp ->addColumn("<h3>".$jabatan."</h3>",8,1);
        $tp ->commit("title");

        $tp ->addColumn("<h4>".$periode."</h4>",8,1);
        $tp ->commit("title");

        $tp ->addColumn("<strong>No.</strong>",1,3);
        $tp ->addColumn("<strong>Tanggal</strong>",1,3);
        $tp ->addColumn("<strong>Shift I</strong>",3,1);
        $tp ->addColumn("<strong>Shift II</strong>",3,1);
        $tp ->commit("header");

        $tp ->addColumn("<strong>Shift</strong>",1,2);
        $tp ->addColumn("<strong>Jam</strong>",2,1);
        $tp ->addColumn("<strong>Shift</strong>",1,2);
        $tp ->addColumn("<strong>Jam</strong>",2,1);
        $tp ->commit("header");

        $tp ->addColumn("<strong>Masuk</strong>",1,1);
        $tp ->addColumn("<strong>Pulang</strong>",1,1);
        $tp ->addColumn("<strong>Masuk</strong>",1,1);
        $tp ->addColumn("<strong>Pulang</strong>",1,1);
        $tp ->commit("header");

        $no = 0;
        foreach($data as $x){
            $no++;
            $tp ->addColumn($no.".",1,1);
            $tp ->addColumn(ArrayAdapter::format("date d M Y",$x->tanggal),1,1);
            $tp ->addColumn($x->shift_1,1,1);
            $tp ->addColumn(substr($x->jadwal_masuk_shift_1,0,5),1,1);
            $tp ->addColumn(substr($x->jadwal_keluar_shift_1,0,5),1,1);

            $tp ->addColumn($x->shift_2,1,1);
            $tp ->addColumn(substr($x->jadwal_masuk_shift_2,0,5),1,1);
            $tp ->addColumn(substr($x->jadwal_keluar_shift_2,0,5),1,1);
            $tp ->commit("body");
        }

        require_once "smis-libs-out/mpdf-7.1.0/vendor/autoload.php";
        $mpdf = new \Mpdf\Mpdf();
        
        $tphtml = $tp->getHtml();
        $tphtml = str_replace("<table","<table cellspacing='0'",$tphtml);

        $stylesheet = file_get_contents('hrd/resource/css/jadwal_karyawan.css');
        $mpdf->WriteHTML("<style>".$stylesheet."</style>");
        $mpdf->WriteHTML($tphtml); 
        $mpdf->Output("smis-temp/my.pdf");
        
        //echo $tphtml."<style>".$stylesheet."</style>";
        return "smis-temp/my.pdf";

    }

    public function pdf(){
        global $db;
        $this->getDBTable()->setShowAll(true);
        $list = $this->getDBTable()->view("","0");
        $data = $list['data'];

        $result = array();
        foreach($data as $x){
            $nik = $x->nik;
            if(!isset($result[$nik])){
                $result[$nik] = array(
                    "nama" => $x->nama_karyawan,
                    "pin" => $x->nik,
                    "unit" => $x->unit,
                    "detail" => array()
                );
            }
            $result[$nik]['detail'][$x->tanggal] = $x->shift_1.(($x->shift_2=="")?"":",".$x->shift_2);
        }

        $dari = $_POST['dari_filter'];
        $sampai = $_POST['sampai_filter'];
        
        loadLibrary("smis-libs-function-time");
        $date_range   = createDateRangeArray($dari,$sampai);
        $count        = count($date_range);
        //$start_column = 5;
        //$total        = $count +5;

        
        
        $logo = getLogo();
        $img = "<img style='height:100px;width:auto;' src='".$logo."' />";
        $img .= "<div class='tline'>&nbsp;</div>";
        $img .= "<div class='ttitle'><font>Jadwal Dinas</font></div>";
        $img .= "<div class='ttitle'><font>Unit : ".getSettings($db,"smis_autonomous_name","")."</font></div>";
        $img .= "<div class='ttitle'><font>Periode : ".ArrayAdapter::format("date M-Y",$_POST['dari_filter'])."</font></div>";
        
        $footer = "<div class='tclass'>";
            $footer .= "<div class='tt'>Dibuat Oleh :</div>";
            $footer .= "<div class='tt'>Atasan Langsung</div>";
            $footer .= "<div class='tt'>Disetujui Oleh</div>";        
        $footer .= "</div>";

        $footer .= "<div class='tclass'>";
            $footer .= "<div  class='tt'><u>________________________</u></div>";
            $footer .= "<div  class='tt'><u>________________________</u></div>";
            $footer .= "<div  class='tt'><u>________________________</u></div>";        
        $footer .= "</div>";

        

        $footer .= "<div class='tclass'>";
            $footer .= "<div  class='tt'>Koordinator Shift</div>";
            $footer .= "<div  class='tt'>Ka. Klinik ".getSettings($db,"smis_autonomous_name","")."</div>";
            $footer .= "<div  class='tt'>HR Manager</div>";        
        $footer .= "</div>";
        

        $tp = new TablePrint("jadwal_klinik");
        $tp ->setMaxWidth(true);

        $tp ->addColumn("<strong>No.</strong>",1,1);
        $tp ->addColumn("<strong>Nama</strong>",1,1);
        $tp ->addColumn("<strong>PIN</strong>",1,1);
        $tp ->addColumn("<strong>Unit</strong>",1,1);
        foreach($date_range as $dt){
            $date       = substr($dt,5);
            $tp ->addColumn("<strong>".$date."</strong>",1,1);
        }
        $tp ->commit("header");

        $tp ->addColumn("",4,1);
        foreach($date_range as $dt){
            $days = ArrayAdapter::format("date D",$dt);
            $tp   ->addColumn("<strong style='color:red'>".$days."</strong>",1,1);
        }
        $tp ->commit("header");
        $no=0;
        foreach($result as $nik=>$ctx){
            $no++;
            $tp ->addColumn($no.".",1,1);
            $tp ->addColumn($ctx['nama'],1,1);
            $tp ->addColumn($ctx['pin'],1,1);
            $tp ->addColumn($ctx['unit'],1,1);

            $detail = $ctx['detail'];
            foreach($date_range as $dt){
                if(isset($detail[$dt])){
                    $tp   ->addColumn($detail[$dt],1,1);
                }else{
                    $tp   ->addColumn("",1,1);
                }
            }
            $tp ->commit("body");
        }

        $dbtable = new DBTable($db,"smis_hrd_shift");
        $dbtable ->setShowAll(true);
        $data = $dbtable ->view("","0");
        $list = $data['data'];

        $tpb = new TablePrint("table_shift");
        $tpb ->setMaxWidth(true);

        $kodejam = "<div class='ttitle kodejam'><font>Kode Jam Kerja</font></div>";
        foreach($list as $l){
            $tpb ->addColumn($l->nama,1,1);
        }
        $tpb ->commit("header");
        foreach($list as $l){
            $tpb ->addColumn(substr($l->t_start,0,5)." - ".substr($l->t_end,0,5),1,1);
        }
        $tpb ->commit("body");
        
        
        require_once "smis-libs-out/mpdf-7.1.0/vendor/autoload.php";
        $mpdf = new \Mpdf\Mpdf(['format' => 'Legal-L']);
        
        $tphtml = $tp->getHtml();
        $tphtml = str_replace("<table","<table cellspacing='0'",$tphtml);

        $final = $img.$tphtml.$footer.$kodejam.str_replace("<table","<table cellspacing='0'",$tpb->getHtml());

        $stylesheet = file_get_contents('hrd/resource/css/jadwal_klinik.css');
        $mpdf->WriteHTML("<style>".$stylesheet."</style>");
        $mpdf->WriteHTML($final); 
        $mpdf->Output("smis-temp/jadwal_klinik.pdf");
        
        //echo $tphtml."<style>".$stylesheet."</style>";
        return "smis-temp/jadwal_klinik.pdf";
    }
    
}


?>