<?php 

class FingerPrintDBResponder extends DBResponder{


    public function excel(){
        $this->dbtable->setShowAll(true);
        $this->dbtable->setFetchMethode(DBTable::$ARRAY_FETCH);
        $view   = $this->dbtable->view("",0);
        $list_d = $view['data'];
        require_once ("smis-libs-out/php-excel/PHPExcel.php");
        $file   = new PHPExcel ();
        $sheet  = $file->getActiveSheet();


        /*start - BLOCK UNTUK BORDER*/
        $thick = array ();
        $thick['borders']=array();
        $thick['borders']['allborders']=array();
        $thick['borders']['allborders']['style']=PHPExcel_Style_Border::BORDER_THIN ;
        $sheet->getStyle ( 'A1:H1' )->applyFromArray ($thick);
 

        $sheet ->setCellValue("A1","NO");
        $sheet ->setCellValue("B1","PIN");
        $sheet ->setCellValue("C1","NIK");
        $sheet ->setCellValue("D1","NAMA");
        $sheet ->setCellValue("E1","TANGGAL");
        $sheet ->setCellValue("F1","JAM");
        $sheet ->setCellValue("G1","MODE");
        $sheet ->setCellValue("H1","UNIT KERJA");

        $sheet ->setCellValue("J1","1");
        $sheet ->setCellValue("K1","Scan Masuk");
        $sheet ->setCellValue("J2","2");
        $sheet ->setCellValue("K2","Scan Keluar");       
        $sheet ->setCellValue("J3","5");
        $sheet ->setCellValue("K3","Lembur In");
        $sheet ->setCellValue("J4","6");
        $sheet ->setCellValue("K4","Lembur Out");
        $sheet->getStyle ( 'J1:K4' )->applyFromArray ($thick);

        $backgroound['fill']=array();
        $backgroound['fill']['type']=PHPExcel_Style_Fill::FILL_SOLID;
        $backgroound['fill']['color']=array();
        $backgroound['fill']['color']['rgb']='00FFFF';
        $sheet->getStyle ( 'A1:H1' )->applyFromArray ($backgroound);

        $filename = "Format Import Finger Print";
        
        header ( 'Content-Type: application/vnd.ms-excel' );
        header ( 'Content-Disposition: attachment;filename="'.$filename.'.xls"' );
        header ( 'Cache-Control: max-age=0' );
        $writer = PHPExcel_IOFactory::createWriter ( $file, 'Excel5' );
        $writer->save ( 'php://output' );
    }


    /* @var ExcelImporter */
    private $importer;
    
    public function command($command){
       
        if($command=="import_proceed"){
            show_error();
            $pack=new ResponsePackage();
            $pack->setStatus(ResponsePackage::$STATUS_OK);
            $content=$this->import_proceed();
            $pack->setContent("");
            $pack->setWarning(true,"Import Done"," Total Data ".$content." Imported");
            return $pack->getPackage();
        }else if($command=="detach_import"){
            $pack=new ResponsePackage();
            $pack->setStatus(ResponsePackage::$STATUS_OK);
            $content=$this->detach_import();
            $pack->setContent("");
            $pack->setWarning(true,"Detach Done"," Total Data ".$content." Detached");
            return $pack->getPackage();
        }else{
            return parent::command($command);
        }
    }
    
    /**
     * @brief remove the imported data
     * @return  null
     */
    private function detach_import(){
        $id=$_POST['id'];
        $db=$this->getDBTable()->get_db();
        $query="SELECT count(*) as total FROM smis_hrd_fingerprint WHERE id_import='".$id."'";
        $total=$db->get_var($query);
        $query="DELETE FROM smis_hrd_fingerprint WHERE id_import='".$id."'";
        $db->query($query);
        return $total;
    }
    
    /**
     * @brief importing processs
     * @return  int total data imported
     */
    private function import_proceed(){
        $id=$_POST['id'];
        $row=$this->dbtable->select($id);
        $this->importer->setFilePath($row->file);
        if($row->max_memory!=""){
            ini_set('memory_limit',$row->max_memory);
        }
        if($row->max_time*1>0){
            ini_set('max_execution_time',$row->max_time);
        }
        
        $column_map=array();
        $column_map[1]="pin_karyawan";
        $column_map[2]="nip_karyawan";
        $column_map[3]="nama_karyawan";
        $column_map[4]="tanggal";
        $column_map[5]="jam";
        $column_map[6]="mode";
        $column_map[7]="unit_kerja";
        
        $this->importer->addKey("nip_karyawan");
        $this->importer->addKey("tanggal");
        $this->importer->addKey("jam");
        $this->importer->addKey("mode");
       
        $this->importer->addSetup(0,2,$column_map,null);
        $this->importer->addFixValue("id_import",$row->id);
        $ttl = $this->importer->execute();
        $query = "UPDATE smis_hrd_fingerprint LEFT JOIN smis_hrd_employee 
                         ON   smis_hrd_fingerprint.nip_karyawan = smis_hrd_employee.nip
                         SET smis_hrd_fingerprint.id_karyawan = smis_hrd_employee.id
                         WHERE smis_hrd_fingerprint.id_import = '".$row->id."' ";
        $this->dbtable->get_db()->query($query);
        return $ttl;
    }
    
    public function postToArray(){
        $result=parent::postToArray();
        $this->importer->setFilePath($result['file']);
        $sheet=$this->importer->countSheet();
        $result['sheets']=$sheet;
        return $result;
    }
    
    public function setImporter(ExcelImporter $importer){
        $this->importer=$importer;
        return $this;
    }
}