<?php 
class EmployeeResponder extends DuplicateResponder{

    public function command($command){
        if($command=="search_user"){
            $pack    = new ResponsePackage();
            $content = $this->searchPegawai();
            $pack->setContent($content);
            $pack->setStatus(ResponsePackage::$STATUS_OK);
            return $pack->getPackage();
        }else{
            return parent::command($command);
        }
    }

    public function searchPegawai(){
        $dbtable = new DBTable($this->getDB(),"smis_adm_user");
        $row = $dbtable ->select(array("username"=>$_POST['id']) );
        return $row->id;
    }

    public function excel(){
        $this->dbtable->setShowAll(true);
        $this->dbtable->setOrder(" unit_kerja  ASC ",true);
        $data = $this->dbtable->view("",0);
        $fix = $data['data'];

        require_once ("smis-libs-out/php-excel/PHPExcel.php");
        $file  = new PHPExcel ();
        $sheet = $file->getActiveSheet ();
        
        $row   = 1;
        $sheet->mergeCells("A".$row.":H".$row);
        $sheet->getStyle('A'.$row.':'.'H'.$row)->getFont()->setBold(true);
        $sheet->getStyle('A'.$row.':'.'H'.$row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->setCellValue("A".$row, "DATA PEGAWAI CASA MEDICAL");
        $row++;
        
        $sheet->mergeCells("A".$row.":H".$row);
        $sheet->getStyle('A'.$row.':'.'H'.$row)->getFont()->setBold(true);
        $sheet->getStyle('A'.$row.':'.'H'.$row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->setCellValue("A".$row, "Tanggal Cetak : ".ArrayAdapter::format("date d M Y H:i",date("Y-m-d H:i:s")));
        $row += 2;
        

        $sheet->setCellValue("A".$row, "Unit Kerja");
        $sheet->setCellValue("B".$row, "ID");
        $sheet->setCellValue("C".$row, "Nama");
        $sheet->setCellValue("D".$row, "Bagian");
        $sheet->setCellValue("E".$row, "Jabatan");
        $sheet->setCellValue("F".$row, "Tgl. Bergabung");
        $sheet->setCellValue("G".$row, "Tgl. Permanen");
        $sheet->setCellValue("H".$row, "Masa Kerja");
        $sheet->setCellValue("I".$row, "Status Kayawan");
        $sheet->setCellValue("J".$row, "Tempat Lahir");
        $sheet->setCellValue("K".$row, "Tanggal Lahir");
        $sheet->setCellValue("L".$row, "Status");
        $sheet->setCellValue("M".$row, "No. HP");
        $sheet->setCellValue("N".$row, "No. KTP");
        $sheet->getStyle('A'.$row.':'.'N'.$row)->getFont()->setBold(true);
        $sheet->getStyle('A'.$row.':'.'N'.$row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $row++;
        
        $cur_unit = "-";

        $no = 1;
        foreach($fix as $x) {
            if($cur_unit!=$x->unit_kerja){
                $sheet->mergeCells("A".$row.":H".$row);
                $sheet->setCellValue("A".$row, $x->unit_kerja);
                $cur_unit = $x->unit_kerja;
                $sheet->getStyle('A'.$row.':'.'H'.$row)->getFont()->setBold(true);
                $row++;
            }
            
            $masker = month_different($x->tanggal_masuk,date("Y-m-d"));
            $sheet->setCellValue("A".$row, $no.". ");
            $sheet->getStyle('A'.$row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
            $sheet->setCellValue("B".$row, $x->id);
            $sheet->setCellValue("C".$row, $x->nama);
           

            $sheet->setCellValue("D".$row, $x->nama_jabatan);
            $sheet->setCellValue("E".$row, $x->struktural);

            $sheet->setCellValue("F".$row, ArrayAdapter::format("date d M Y",$x->tanggal_masuk));
            $sheet->setCellValue("G".$row, ArrayAdapter::format("date d M Y",$x->tanggal_permanen));
            $sheet->setCellValue("H".$row, $masker);
            $sheet->setCellValue("I".$row, $x->tenaga);

            $sheet->setCellValue("J".$row, $x->tmp_lahir);
            $sheet->setCellValue("K".$row,  ArrayAdapter::format("date d M Y",$x->tgl_lahir));
            $sheet->setCellValue("L".$row, $x->menikah);
            $sheet->setCellValue("M".$row, " ".$x->hp);
            $sheet->setCellValue("N".$row, " ".$x->noktp);
            $row++;
            $no++;
        }
        
        foreach(range('A','N') as $columnID) {
            $sheet->getColumnDimension($columnID)->setAutoSize(true);
        }

        $sheet->getStyle("A1:N".($row-1) ) ->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
        
        header ( 'Content-Type: application/vnd.ms-excel' );
        header ( 'Content-Disposition: attachment;filename="LAPORAN PEGAWAI.xls"' );
        header ( 'Cache-Control: max-age=0' );
        $writer = PHPExcel_IOFactory::createWriter ( $file, 'Excel5' );
        $writer->save ( 'php://output' );
		return;
    }

}