<?php
    class EmployeeChooserResponder extends DBResponder {
        private $_db;
        private $_name;
        private $_jobSlug;
        private $_dbtable;
        private $_table;
        private $_adapter;

        public function __construct($db, $name, $jobSlug) {
            $this->_db = $db;
            $this->_name = $name;
            $this->_jobSlug = $jobSlug;
            $this->initializeDBTable();
            $this->initializeTable();
            $this->initializeAdapter();
            parent::__construct($this->_dbtable, $this->_table, $this->_adapter);
        }

        public function getName() {
            return $this->_name;
        }

        private function initializeDBTable() {
            $this->_dbtable = new DBTable($this->_db, "smis_hrd_employee");
            $this->_dbtable->setViewForSelect(true);
            $staticFilter = "a.prop = '' AND a.keluar = 0 AND b.slug LIKE '%" . $this->_jobSlug . "%'";
            if ($this->_jobSlug == "") {
                $staticFilter = "a.prop = '' AND a.keluar = 0";
            }
            $dynamicFilter = "";
            if (isset($_POST['kriteria'])) {
                $dynamicFilter = "AND (a.nama LIKE '%" . $_POST['kriteria'] . "%')";
            }
            $queryValue = "SELECT a.id, a.nama, a.nip, b.nama nama_jabatan FROM smis_hrd_employee a LEFT JOIN smis_hrd_job b ON a.jabatan = b.id WHERE " . $staticFilter . " " . $dynamicFilter . " LIMIT 0, 5";
            $queryCount = "SELECT COUNT(*) FROM (" . $queryValue . ") v";
            $this->_dbtable->setPreferredQuery(true, $queryValue, $queryCount);
            $this->_dbtable->setShowAll(true);
        }

        private function initializeTable() {
            require_once("hrd/class/table/EmployeeChooserTable.php");
            $columns = ['NIP', 'Nama', 'Jabatan'];
            $this->_table = new EmployeeChooserTable(
                $columns,
                "",
                null,
                true
            );
            $this->_table->setName($this->_name);
            $this->_table->setModel(Table::$SELECT);
        }

        private function initializeAdapter() {
            $this->_adapter = new SimpleAdapter();
            $this->_adapter->add("NIP", "nip");
            $this->_adapter->add("Nama", "nama");
            $this->_adapter->add("Jabatan", "nama_jabatan");
        }

        public function edit() {
            $id = $_POST['id'];
            return $this->_db->get_row("SELECT a.id, a.nama, a.nip, b.nama nama_jabatan FROM smis_hrd_employee a LEFT JOIN smis_hrd_job b ON a.jabatan = b.id WHERE a.id = '" . $id . "'");
        }
    }