<?php

class CompareDBResponder extends DBResponder{
    public function excel(){
		global $user;
		loadLibrary("smis-libs-function-export");
        
        $this->getDBTable()->setShowAll(true);		
		$list = $this->template;
        
        $this->getDBTable()->setShowAll(true);
        $d = $this->getDBTable()->view("","0");

        $data = $d['data'];
        

        date_default_timezone_set ( "Asia/Jakarta" );
        require_once ("smis-libs-out/php-excel/PHPExcel.php");
        $file = new PHPExcel ();
        $sheet=$file->getActiveSheet();
       
        
        $border['borders']=array();
        $border['borders']['allborders']=array();
        $border['borders']['allborders']['style']=PHPExcel_Style_Border::BORDER_THIN ;

        $center = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            )
        );
    
        $sheet->getStyle("A1:M3")->applyFromArray($center);
        
        $last_col=PHPExcel_Cell::stringFromColumnIndex($total-1);
        $sheet ->mergeCells("A1:M1")
               ->setCellValue("A1","LAPORAN ABSENSI CASA MEDICAL");
        $sheet ->mergeCells("A2:M2")
               ->setCellValue("A2",ArrayAdapter::format("date M Y",$_POST['s_sampai']));
        $sheet ->mergeCells("A3:M3")
               ->setCellValue("A3","UNIT : ".strtoupper($_POST['s_unit_kerja']) );

        $row=5;

        /* header */
        $sheet  ->setCellValue("A".$row,"No.")
                ->setCellValue("B".$row,"NIK")
                ->setCellValue("C".$row,"Tanggal")
                ->setCellValue("D".$row,"Pegawai")
                ->setCellValue("E".$row,"Unit Kerja")
                ->setCellValue("F".$row,"Shift")
                ->setCellValue("G".$row,"Jadwal Masuk")
                ->setCellValue("H".$row,"Jadwal Keluar")
                ->setCellValue("I".$row,"Aktual Masuk")
                ->setCellValue("J".$row,"Aktual Keluar")
                ->setCellValue("K".$row,"Telat")
                ->setCellValue("L".$row,"Mendahului")
                ->setCellValue("M".$row,"Lebih Jam"); 

        $sheet->getStyle ( "A1:M5" )->getFont ()->setBold ( true );
        
        $row++;
        foreach($data as $d){
            $number++;
            $sheet  ->setCellValue("A".$row,$number.". ")
                    ->setCellValue("B".$row,$d->nik)
                    ->setCellValue("C".$row,ArrayAdapter::format("date d M Y",$d->tanggal) )
                    ->setCellValue("D".$row,$d->nama_karyawan)
                    ->setCellValue("E".$row,$d->unit_kerja)
                    ->setCellValue("F".$row,$d->nama_shift)
                    ->setCellValue("G".$row,$d->jadwal_masuk)
                    ->setCellValue("H".$row,$d->jadwal_keluar)
                    ->setCellValue("I".$row,$d->real_masuk)
                    ->setCellValue("J".$row,$d->real_keluar)
                    ->setCellValue("K".$row,$d->telat." Menit")
                    ->setCellValue("L".$row,$d->mendahului." Menit")
                    ->setCellValue("M".$row,$d->lebih_jam." Menit"); 
            $row++;
        }
        $sheet->getStyle ( "A5:M".($row-1) )->applyFromArray ( $border );
        
        header ( 'Content-Type: application/vnd.ms-excel' );
        header ( 'Content-Disposition: attachment;filename="Laporan Absensi Pegawai.xls"' );
        header ( 'Cache-Control: max-age=0' );
        $writer = PHPExcel_IOFactory::createWriter ( $file, 'Excel5' );
        $writer->save ( 'php://output' );
		return;
	}
}