<?php 


class JadwalDinasExcelImporter extends ExcelImporter{

    public function execute(){
        //ini_set('memory_limit','1024M');
        $url_file                   = $this->getFile();
        $total_data                 = 0;
        if($url_file!=null){             
            $fileType               = PHPExcel_IOFactory::identify($url_file);    
            foreach($this->setup as $setup_index=>$setup){
                $objReader          = PHPExcel_IOFactory::createReader($fileType);
                $objReader->setLoadSheetsOnly($setup['sheet_name']);
                $objPHPExcel        = $objReader->load($url_file);            
                $actived=$objPHPExcel->setActiveSheetIndex($setup_index);
                
                $setup_column       = $setup['column'];
                $setup_sheet_map    = $setup['sheet'];
                $rowindex           = 1;               
                foreach($actived->getRowIterator() as $row){
                    if($rowindex>=$setup['start']){                       
                        $onerow     = array();
                        $idx        = array();
                        $this->oneSetup($onerow,$idx,$setup_column,$rowindex,$actived);
                        if($onerow==null){
                            continue;
                        }
                        if($setup_sheet_map!=null && $setup_sheet_map!=""){
                            $onerow[$setup_sheet_map]   = $actived->getTitle();
                        }
                        /* adding fix value */
                        $onerow     = array_merge($onerow,$this->fix_value);
                        if(count($this->id)>0){
                            $this->dbtable->insertOrUpdate($onerow,$idx);
                        }else{
                            $this->dbtable->insert($onerow);
                        }
                        $total_data++;
                    }
                    $rowindex++;
                }
            }
        }
        return $total_data;
    }

    public function oneSetup(array &$onerow,array &$idx,array &$setup_column,int $rowindex,PHPExcel_Worksheet $sheet){
        foreach($setup_column as $index=>$name){
            
            $cell           = $sheet->getCellByColumnAndRow($index,$rowindex);
            $value          = $cell->getValue();
            if($name=="nik" && ($value==null || $value=="")){
                $onerow=null;
                return;
            }
            if(PHPExcel_Shared_Date::isDateTime($cell)) {
                $value      = date("Y-m-d", PHPExcel_Shared_Date::ExcelToPHP($value));
            }
            $onerow[$name]  = $value;
            if(in_array($name,$this->id)){
                $idx[$name] = $value;
            }
        }
    }
}