<?php
	class BarangTTable extends Table {
		public function getBodyContent(){
			$content = "";
			if ($this->content!=NULL) {
				foreach ($this->content as $d) {
					$content .= "<tr>";
					foreach ($this->header as $h) {
						$content .= "<td>" . $d[$h] . "</td>";
					}
					if ($this->is_action) {
						$content .= "<td>" . $this->getFilteredContentButton($d['id'], $d['unit'], $d['kode'])->getHtml() . "</td>";
					}
					$content .= "</tr>";
				}
			}
			return $content;
		}
		public function getFilteredContentButton($id, $unit, $kode) {
			$btn_group = new ButtonGroup("noprint");
			if ($unit == "") {
				$btn = new Button("", "", "Ubah");
				$btn->setAction($this->action . ".edit('" . $id . "')");
				$btn->setClass("btn-warning");
				$btn->setAtribute("data-content='Ubah' data-toggle='popover'");
				$btn->setIcon("icon-edit icon-white");
				$btn->setIsButton(Button::$ICONIC);
				$btn_group->addElement($btn);
				$btn = new Button("", "", "Kirim");
				$btn->setAction($this->action . ".prepare_send('" . $id . "')");
				$btn->setClass("btn-success");
				$btn->setAtribute("data-content='Kirim' data-toggle='popover'");
				$btn->setIcon("fa fa-share");
				$btn->setIsButton(Button::$ICONIC);
				$btn_group->addElement($btn);
			} else {
				$btn = new Button("", "", "Ubah");
				$btn->setAction($this->action . ".edit_kondisi('" . $id . "')");
				$btn->setClass("btn-warning");
				$btn->setAtribute("data-content='Ubah' data-toggle='popover'");
				$btn->setIcon("icon-edit icon-white");
				$btn->setIsButton(Button::$ICONIC);
				$btn_group->addElement($btn);
			}
			$btn = new Button("", "", "Riwayat Inventaris");
			$btn->setAction($this->action . ".view_history('" . $id . "')");
			$btn->setAtribute("data-content='Lihat Riwayat' data-toggle='popover'");
			$btn->setIcon("fa fa-history");
			$btn->setIsButton(Button::$ICONIC);
			$btn_group->addElement($btn);
			$btn = new Button("", "", "Cetak Kode");
			$btn->setAction($this->action . ".print_kode('" . $kode . "')");
			$btn->setClass("btn-inverse");
			$btn->setAtribute("data-content='Ubah' data-toggle='popover'");
			$btn->setIcon("icon-print icon-white");
			$btn->setIsButton(Button::$ICONIC);
			$btn_group->addElement($btn);
			return $btn_group;
		}
	}
?>