<?php 
	$riwayat_penyesuaian_stok_form = new Form("form_riwayat_penyesuaian_stok", "", "");
	$tanggal_from_text = new Text("riwayat_penyesuaian_stok_tanggal_from", "riwayat_penyesuaian_stok_tanggal_from", date('Y-m-') . "01");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-m-d'");
	$tanggal_from_text->setClass("mydate");
	$riwayat_penyesuaian_stok_form->addElement("Tanggal Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("riwayat_penyesuaian_stok_tanggal_to", "riwayat_penyesuaian_stok_tanggal_to", date('Y-m-d'));
	$tanggal_to_text->setAtribute("data-date-format='yyyy-m-d'");
	$tanggal_to_text->setClass("mydate");
	$riwayat_penyesuaian_stok_form->addElement("Tanggal Akhir", $tanggal_to_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setisButton(Button::$ICONIC);
	$show_button->setAction("riwayat_penyesuaian_stok.view()");
	$download_button = new Button("", "", "Unduh PDF");
	$download_button->setClass("btn-success");
	$download_button->setIcon("fa fa-download");
	$download_button->setisButton(Button::$ICONIC_TEXT);
	$download_button->setAction("riwayat_penyesuaian_stok.export_pdf()");
	$button_group = new ButtonGroup("");
	$button_group->addButton($show_button);
	$button_group->addButton($download_button);
	$riwayat_penyesuaian_stok_form->addElement("", $button_group);
	
	$riwayat_penyesuaian_stok_table = new Table(
		array("Tanggal", "Nama Barang", "Jenis Barang", "Jml. Awal", "Jml. Aktual", "Selisih", "Keterangan", "Petugas Entri"),
		"",
		null,
		true
	);
	$riwayat_penyesuaian_stok_table->setName("riwayat_penyesuaian_stok");
	$riwayat_penyesuaian_stok_table->setAddButtonEnable(false);
	$riwayat_penyesuaian_stok_table->setReloadButtonEnable(false);
	$riwayat_penyesuaian_stok_table->setPrintButtonEnable(false);
	$riwayat_penyesuaian_stok_table->setAction(false);
	
	if (isset($_POST['command'])) {
		if ($_POST['command'] == "export_pdf") {
			$tanggal_dari = $_POST['tanggal_from'];
            $tanggal_sampai = $_POST['tanggal_to'];
            require_once("finance/class/template/pdf.php");
			$fpdf = new PDF("L", "mm", "A4");
			$fpdf->SetMargins(5, 5);
		
            $fpdf->AddPage();
            $fpdf->SetFont("Arial", "B", 12);
            $fpdf->Cell(285, 5, "Riwayat Penyesuaian Stok Barang", 0, 1, "C");
            $fpdf->SetFont("Arial", "", 10);
            $fpdf->Cell(25, 5, "Tanggal Awal", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, ArrayAdapter::format("date d-m-Y", $tanggal_dari), 0, 1);
            $fpdf->Cell(25, 5, "Tanggal Akhir", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, ArrayAdapter::format("date d-m-Y", $tanggal_sampai), 0, 1);
            $fpdf->Cell(285, 5, "", 0, 1, "C");
            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(20, 5, "Tanggal", 1, 0, "C");
            $fpdf->Cell(65, 5, "Nama Barang", 1, 0, "C");
            $fpdf->Cell(30, 5, "Jenis Barang", 1, 0, "C");
            $fpdf->Cell(20, 5, "Jml. Awal", 1, 0, "C");
            $fpdf->Cell(20, 5, "Jml. Aktual", 1, 0, "C");
            $fpdf->Cell(20, 5, "Selisih", 1, 0, "C");
            $fpdf->Cell(65, 5, "Keterangan", 1, 0, "C");
            $fpdf->Cell(45, 5, "Petugas Entri", 1, 1, "C");
            $data = $db->get_result("
                SELECT 
                	a.*, b.nama_barang, b.nama_jenis_barang, b.satuan
				FROM 
					smis_gd_penyesuaian_stok a 
						LEFT JOIN smis_gd_stok_barang b ON a.id_stok_barang = b.id
				WHERE 
					a.prop LIKE '' 
						AND a.tanggal >= '" . $_POST['tanggal_from'] . "' 
						AND a.tanggal <= '" . $_POST['tanggal_to'] . "'
            ");
            if (count($data) > 0) {
                $fpdf->SetFont("Arial", "", 9);
                foreach ($data as $d) {
                    $fpdf->Cell(20, 5, ArrayAdapter::format("date d-m-Y", $d->tanggal), 1, 0);
		            
                    $lastX = $fpdf->GetX();
                    $lastY = $fpdf->GetY();
                    $fpdf->MultiCell(65, 5, $d->nama_barang, 1, "J", false, 1);
                    $fpdf->SetX($lastX);
                    $fpdf->SetY($lastY);
                    $fpdf->Cell(85, 5, "", 0, 0, "");

                    $lastX = $fpdf->GetX();
                    $lastY = $fpdf->GetY();
                    $fpdf->MultiCell(30, 5, $d->nama_jenis_barang, 1, "J", false, 1);
					$fpdf->SetX($lastX);
                    $fpdf->SetY($lastY);
                    $fpdf->Cell(115, 5, "", 0, 0, "");

		            $fpdf->Cell(20, 5, $d->jumlah_lama, 1, 0, "R");
		            $fpdf->Cell(20, 5, $d->jumlah_baru, 1, 0, "R");
		            $selisih = $d->jumlah_baru - $d->jumlah_lama;
		            if ($selisih > 0)
		            	$selisih = "+" . $selisih;
		            $fpdf->Cell(20, 5, $selisih, 1, 0, "R");

		            $lastX = $fpdf->GetX();
                    $lastY = $fpdf->GetY();
                    $fpdf->MultiCell(65, 5, $d->keterangan, 1, "J", false, 1);
					$fpdf->SetX($lastX);
                    $fpdf->SetY($lastY);
                    $fpdf->Cell(240, 5, "", 0, 0, "");

                    $fpdf->MultiCell(45, 5, $d->nama_user, 1, "J", false, 1);
                }
            }

			global $user;
		    $md5 = md5(date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "Riwayat Penyesuaian Stok Barang.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
			echo json_encode($pathfile);
			return;
		}
		class RiwayatPenyesuaianStokAdapter extends ArrayAdapter {
			public function adapt($row) {
				$array = array();
				$array['Tanggal'] = self::format("date d M Y", $row->tanggal);
				$array['Nama Barang'] = $row->nama_barang;
				$array['Jenis Barang'] = $row->nama_jenis_barang;
				$array['Jml. Awal'] = $row->jumlah_lama . " " . $row->satuan;
				$array['Jml. Aktual'] = $row->jumlah_baru . " " . $row->satuan;
				$sign = "";
				if ($row->jumlah_baru - $row->jumlah_lama > 0) {
					$sign = "+";
				}
				$array['Selisih'] = $sign . ($row->jumlah_baru - $row->jumlah_lama) . " " . $row->satuan;
				$array['Keterangan'] = $row->keterangan;
				$array['Petugas Entri'] = $row->nama_user;
				return $array;
			}
		}
		$riwayat_penyesuaian_stok_adapter = new RiwayatPenyesuaianStokAdapter();
		$riwayat_penyesuaian_stok_dbtable = new DBTable(
			$db,
			"smis_gd_penyesuaian_stok"
		);
		$filter = "";
		if (isset($_POST['kriteria'])) {
			$filter = " AND (smis_gd_stok_barang.nama_barang LIKE '%" . $_POST['kriteria'] . "%' OR smis_gd_stok_barang.nama_jenis_barang LIKE '%" . $_POST['kriteria'] . "%' OR smis_gd_penyesuaian_stok.nama_user LIKE '%" . $_POST['kriteria'] . "%' OR smis_gd_stok_barang.produsen LIKE '%" . $_POST['kriteria'] . "%' OR smis_gd_stok_barang.nama_vendor LIKE '%" . $_POST['kriteria'] . "%')";
		}
		$query_value = "
			SELECT smis_gd_penyesuaian_stok.*, smis_gd_stok_barang.nama_barang, smis_gd_stok_barang.nama_jenis_barang, smis_gd_stok_barang.satuan
			FROM smis_gd_penyesuaian_stok LEFT JOIN smis_gd_stok_barang ON smis_gd_penyesuaian_stok.id_stok_barang = smis_gd_stok_barang.id
			WHERE smis_gd_penyesuaian_stok.prop NOT LIKE 'del' AND smis_gd_penyesuaian_stok.tanggal >= '" . $_POST['tanggal_from'] . "' AND smis_gd_penyesuaian_stok.tanggal <= '" . $_POST['tanggal_to'] . "' " . $filter . "
		";
		$query_count = "
			SELECT COUNT(*)
			FROM  (
				" . $query_value . "
			) v_riwayat_penyesuaian_stok
		";
		$riwayat_penyesuaian_stok_dbtable->setPreferredQuery(true, $query_value, $query_count);
		$riwayat_penyesuaian_stok_dbresponder = new DBResponder(
			$riwayat_penyesuaian_stok_dbtable,
			$riwayat_penyesuaian_stok_table,
			$riwayat_penyesuaian_stok_adapter
		);
		$data = $riwayat_penyesuaian_stok_dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	
	echo $riwayat_penyesuaian_stok_form->getHtml();
	echo "<div id'table_content'>";
	echo $riwayat_penyesuaian_stok_table->getHtml();
	echo "</div>";
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	function RiwayatPenyesuaianStokAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	RiwayatPenyesuaianStokAction.prototype.constructor = RiwayatPenyesuaianStokAction;
	RiwayatPenyesuaianStokAction.prototype = new TableAction();
	RiwayatPenyesuaianStokAction.prototype.addViewData = function(data) {
		data['tanggal_from'] = $("#riwayat_penyesuaian_stok_tanggal_from").val();
		data['tanggal_to'] = $("#riwayat_penyesuaian_stok_tanggal_to").val();
		data['kriteria'] = $("#riwayat_penyesuaian_stok_kriteria").val();
		return data;
	};
	RiwayatPenyesuaianStokAction.prototype.export_pdf = function() {
		var data = this.getRegulerData();
		data['command'] = "export_pdf";
		data['tanggal_from'] = $("#riwayat_penyesuaian_stok_tanggal_from").val();
		data['tanggal_to'] = $("#riwayat_penyesuaian_stok_tanggal_to").val();
		showLoading();
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) {
					dismissLoading();
					return;
				}
				var getUrl = window.location['pathname'] + json;
	            window.open(getUrl, 'pdf');
	            dismissLoading();
			}
		);
	};
	
	var riwayat_penyesuaian_stok;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		riwayat_penyesuaian_stok = new RiwayatPenyesuaianStokAction(
			"riwayat_penyesuaian_stok", 
			"gudang_umum", 
			"riwayat_penyesuaian_stok_barang",
			new Array()
		);
		riwayat_penyesuaian_stok.view();
	});
</script>