<?php
	require_once("smis-base/smis-include-service-consumer.php");
	global $db;

	$table = new Table(
		array("Nomor", "Kode", "Jenis", "Barang", "Merk", "Harga", "Tahun", "Penyusutan", "Kondisi", "Lokasi", "Status"),
		"Gudang Umum : Retur Inventaris"
	);
	$table->setName("retur_inventaris_unit");
	$table->setReloadButtonEnable(false);
	$table->setPrintButtonEnable(false);
	$table->setAddButtonEnable(false);
	$table->setDelButtonEnable(false);

	if (isset($_POST['command'])) {
		$adapter = new SimpleAdapter();
		$adapter->add("id", "id");
		$adapter->add("Nomor", "id","digit8");
		$adapter->add("Kode", "kode");
		$adapter->add("Jenis", "medis","trivial_1_Medis_Non-Medis");
		$adapter->add("Barang", "nama_barang");
		$adapter->add("Merk", "merk");
		$adapter->add("Harga", "hna","money Rp.");
		$adapter->add("Tahun", "tahun_perolehan", "date d-m-Y");
		$adapter->add("Penyusutan", "usia_penyusutan", "back Tahun");
		$adapter->add("Kondisi", "kondisi_baik","trivial_1_Baik_Rusak");
		$adapter->add("Lokasi", "unit","unslug");
		$adapter->add("Status", "status", "trivial_sudah_SUDAH DITERIMA_BELUM DITERIMA");
		$dbtable = new DBTable($db, "smis_gd_inventaris");
		$dbtable->addCustomKriteria(" tipe ", " = 'retur' ");
		$dbtable->addCustomKriteria(" status ", " = 'belum' ");
		$dbresponder = new DBResponder(
			$dbtable,
			$table,
			$adapter
		);
		if ($dbresponder->isSave()) {
			if ($_POST['status'] == "accept") {
				require_once("gudang_umum/service_consumer/SetStatusReturInventarisServiceConsumer.php");
				$service_consumer = new SetStatusReturInventarisServiceConsumer($db, $_POST['id'], "sudah", $_POST['unit']);
				$result = $service_consumer->execute();

				$_POST['status'] = "";
				$_POST['tipe'] = "";
				$_POST['unit'] = "";
				$_POST['tanggal_mutasi'] = "0000-00-00 00:00";
				$_POST['user_mutasi'] = "";
				$_POST['tanggal_acc_mutasi'] = "0000-00-00 00:00";
				$_POST['user_acc_mutasi'] = "";
			} else {
				require_once("gudang_umum/service_consumer/SetStatusReturInventarisServiceConsumer.php");
				$service_consumer = new SetStatusReturInventarisServiceConsumer($db, $_POST['id'], "belum", $_POST['unit']);
				$result = $service_consumer->execute();
				
				$_POST['tipe'] = "mutasi";
				$_POST['status'] = "";
			}
		}
		$data = $dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}

	$modal = new Modal("retur_inventaris_unit_add_form", "smis_form_container", "inventaris_retur");
	$modal->setTitle("Retur Barang Inventaris");
	$id_hidden = new Hidden("retur_inventaris_unit_id", "retur_inventaris_unit_id", "");
	$modal->addElement("", $id_hidden);
	$nama_barang_text = new Text("retur_inventaris_unit_nama_barang", "retur_inventaris_unit_nama_barang", "");
	$nama_barang_text->setAtribute("disabled='disabled'");
	$modal->addElement("Nama Barang", $nama_barang_text);
	$tanggal_text = new Text("retur_inventaris_unit_tanggal_retur", "retur_inventaris_unit_tanggal_retur", date("d-m-Y H:i"));
	$tanggal_text->setClass("mydatetime");
	$tanggal_text->setAtribute("data-date-format='dd-mm-yyyy hh:ii' disabled='disabled'");
	$modal->addElement("Tanggal", $tanggal_text);
	require_once("gudang_umum/service_consumer/UnitInventarisServiceConsumer.php");
	$unit_service_consumer = new UnitInventarisServiceConsumer($db);
	$unit_service_consumer->execute();
	$unit_option = $unit_service_consumer->getContent();
	$unit_select = new Select("retur_inventaris_unit_unit", "retur_inventaris_unit_unit", $unit_option);
	$unit_select->setAtribute("disabled='disabled'");
	$modal->addElement("Lokasi", $unit_select);
	$kode_text = new Text("retur_inventaris_unit_kode", "retur_inventaris_unit_kode", "");
	$kode_text->setAtribute("disabled='disabled'");
	$modal->addElement("Kode", $kode_text);
	$medis_option = new OptionBuilder();
	$medis_option->add("Medis", "1");
	$medis_option->add("Non-Medis", "0");
	$medis_select = new Select("retur_inventaris_unit_medis", "retur_inventaris_unit_medis", $medis_option->getContent());
	$medis_select->setAtribute("disabled='disabled'");
	$modal->addElement("Jenis", $medis_select);
	$merk_text = new Text("retur_inventaris_unit_merk", "retur_inventaris_unit_merk", "");
	$merk_text->setAtribute("disabled='disabled'");
	$modal->addElement("Merk", $merk_text);
	$keterangan_textarea = new TextArea("retur_inventaris_unit_keterangan_retur", "retur_inventaris_unit_keterangan_retur", "");
	$keterangan_textarea->setLine(2);
	$keterangan_textarea->setAtribute("disabled='disabled'");
	$modal->addElement("Keterangan", $keterangan_textarea);
	$kondisi_option = array(
		array(
			'name'	=> "Baik",
			'value'	=> 1
		),
		array(
			'name'	=> "Rusak",
			'value'	=> 0
		)
	);
	$kondisi_select = new Select("retur_inventaris_unit_kondisi_baik", "retur_inventaris_unit_kondisi_baik", $kondisi_option);
	$kondisi_select->setAtribute("disabled='disabled'");
	$modal->addElement("Kondisi", $kondisi_select);
	$confirm_button = new Button("", "", "Terima");
	$confirm_button->setAction("retur_inventaris_unit.accept()");
	$confirm_button->setAtribute("id='retur_inventaris_unit_accept_btn'");
	$confirm_button->setClass("btn-success");
	$confirm_button->setIcon("fa fa-check");
	$confirm_button->setIsButton(Button::$ICONIC);
	$modal->addFooter($confirm_button);
	$cancel_button = new Button("", "", "Kembalikan");
	$cancel_button->setAction("retur_inventaris_unit.cancel()");
	$cancel_button->setAtribute("id='retur_inventaris_unit_cancel_btn'");
	$cancel_button->setClass("btn-danger");
	$cancel_button->setIcon("fa fa-times");
	$cancel_button->setIsButton(Button::$ICONIC);
	$modal->addFooter($cancel_button);

	echo $modal->getHtml();
	echo $table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	var retur_inventaris_unit;
	$(document).ready(function() {
		retur_inventaris_unit = new TableAction(
			"retur_inventaris_unit",
			"gudang_umum",
			"retur_inventaris_unit",
			new Array("id", "nama_barang", "medis", "kode", "merk", "kondisi_baik", "tanggal_retur", "keterangan_retur", "unit")
		);
		retur_inventaris_unit.accept = function() {
			var self = this;
			var id = $("#retur_inventaris_unit_id").val();
			$("#retur_inventaris_unit_add_form").smodal("hide");
			bootbox.confirm(
				"Yakin menerima Retur Inventaris ini?",
				function(result) {
					if (result) {
						showLoading();
						var data = self.getRegulerData();
						data['command'] = "save";
						data['status'] = "accept";
						data['unit'] = $("#retur_inventaris_unit_unit").val();
						data['id'] = id;
						$.post(
							"",
							data,
							function() {
								self.view();
								dismissLoading();
							}
						);
					} else {
						$("#retur_inventaris_unit_add_form").smodal("show");
					}
				}
			);
		};
		retur_inventaris_unit.cancel = function() {
			var self = this;
			var id = $("#retur_inventaris_unit_id").val();
			$("#retur_inventaris_unit_add_form").smodal("hide");
			bootbox.confirm(
				"Yakin menolak Retur Inventaris ini?",
				function(result) {
					if (result) {
						showLoading();
						var data = self.getRegulerData();
						data['command'] = "save";
						data['status'] = "cancel";
						data['unit'] = $("#retur_inventaris_unit_unit").val();
						data['id'] = id;
						$.post(
							"",
							data,
							function() {
								self.view();
								dismissLoading();
							}
						);
					} else {
						$("#retur_inventaris_unit_add_form").smodal("show");
					}
				}
			);
		};
		retur_inventaris_unit.view();
	});
</script>