<?php
	require_once("smis-base/smis-include-duplicate.php");

	class BarangKeluarDBResponder extends DuplicateResponder {
		public function command($command) {
			if ($command != "print_mutasi" && $command != "export_pdf")
				return parent::command($command);
			$pack = new ResponsePackage();
			if ($command == "print_mutasi") {
				$content = $this->print_mutasi();
				$pack->setContent($content);
				$pack->setStatus(ResponsePackage::$STATUS_OK);
			}
			if ($command == "export_pdf") {
				$content = $this->export_pdf();
				$pack->setContent($content);
				$pack->setStatus(ResponsePackage::$STATUS_OK);
			}
			return $pack->getPackage();
		}
		private function export_pdf() {
			$id = $_POST['id'];
			
			$header_row = $this->dbtable->get_db()->get_row("
				SELECT *
				FROM smis_gd_barang_keluar
				WHERE id = '" . $id . "'
			");

			$nama_instansi = "KLINIK CASA MEDICAL PANBIL";
			$alamat_instansi_1 = "Komp. Panbil Komersil Area Blok A";
			$alamat_instansi_2 = "No. 3A Kelurahan Muka Kuning";
			$no_izin_instansi = getSettings($this->dbtable->get_db(), "instansi_no_ijin", "");

			$nomor = $header_row->id;
			$tanggal = ArrayAdapter::format("date d-m-Y", $header_row->tanggal);
			$unit = ArrayAdapter::format("unslug", $header_row->unit);

			$manager_umum = getSettings($this->dbtable->get_db(), "mutasi_barang-nama_manager_umum", "");		
			$verifikator = getSettings($this->dbtable->get_db(), "mutasi_barang-nama_verifikator", "");
			$petugas_gudang = getSettings($this->dbtable->get_db(), "mutasi_barang-nama_petugas_gudang", "");

			$margin_left = 10;
			$margin_top = 10;
			$total = 0;
			$jumlah_item = 0;
			$jumlah_item_per_halaman = getSettings($this->dbtable->get_db(), "mutasi_barang-n_item_per_page", 13);
			$jumlah_detail_row = $this->dbtable->get_db()->get_row("
				SELECT COUNT(*) jumlah
				FROM smis_gd_dbarang_keluar
				WHERE id_barang_keluar = '" . $id . "' AND prop = ''
			");
			if ($jumlah_detail_row != null)
				$jumlah_item += $jumlah_detail_row->jumlah;
			$jumlah_halaman = $jumlah_item % $jumlah_item_per_halaman == 0 ? $jumlah_item / $jumlah_item_per_halaman : floor($jumlah_item / $jumlah_item_per_halaman) + 1;

			require_once("gudang_umum/kelas/PDF.php");
			$fpdf = new PDF("P", "mm", "A4");
			$fpdf->SetMargins($margin_left, $margin_top);

			for ($i_halaman = 0; $i_halaman < $jumlah_halaman; $i_halaman++) {
				$number = 1;
				$fpdf->AddPage();
				$fpdf->SetFont("Arial", "", 12);
				$fpdf->SetY($fpdf->GetY());
				$fpdf->SetX(56);
				$fpdf->Image(getLogo(), 13, 9, 20, 20);
				$fpdf->Cell(70, 5, $nama_instansi, 0, 0, "C");
				$fpdf->Cell(25, 5, "", 0, 0);
				$fpdf->Cell(20, 5, "Nomor", 0, 0);
				$fpdf->Cell(40, 5, ": " . $nomor, 0, 0);
				$fpdf->Ln(5);
				$fpdf->SetX(56);
				$fpdf->Cell(70, 5, $alamat_instansi_1, 0, 0, "C");
				$fpdf->Cell(25, 5, "", 0, 0);
				$fpdf->Cell(20, 5, "Tanggal", 0, 0);
				$fpdf->Cell(40, 5, ": " . $tanggal, 0, 0);
				$fpdf->Ln(5);
				$fpdf->SetX(56);
				$fpdf->Cell(70, 5, $alamat_instansi_2, 0, 0, "C");
				$fpdf->Cell(25, 5, "", 0, 0);
				$fpdf->Cell(20, 5, "Halaman", 0, 0);
				$fpdf->Cell(40, 5, ": " . ($i_halaman + 1) . " / " . $jumlah_halaman, 0, 0);
				$fpdf->Ln(10);
				$fpdf->SetX(10);
				$fpdf->SetFont("Arial", "B", 12);
				$fpdf->Cell(190, 5, "BUKTI PENGELUARAN BARANG / BAHAN PELENGKAP", 0, 0, "C");
				$fpdf->Ln(5);
				$fpdf->SetX(10);
				$fpdf->SetFont("Arial", "", 12);
				$fpdf->Cell(190, 5, "Unit : " . $unit, 0, 0, "C");
				$fpdf->Ln(10);
				$last_y = $fpdf->GetY();

				$fpdf->SetX(2);
				$fpdf->Cell(23, 10, "Kode", 1, 0, "C");
				$fpdf->Cell(73, 10, "Nama Barang", 1, 0, "C");
				$fpdf->Cell(10, 10, "Sat.", 1, 0, "C");
				$fpdf->Cell(15, 10, "", 0, 0, "C");
				$fpdf->Cell(15, 10, "", 0, 0, "C");
				$fpdf->Cell(15, 10, "", 0, 0, "C");
				$fpdf->Cell(15, 10, "", 0, 0, "C");
				$fpdf->Cell(25, 10, "", 0, 0, "C");
				$fpdf->Cell(15, 10, "", 0, 0, "C");
				$fpdf->Ln(10);
				$fpdf->SetX(2);
				$fpdf->Cell(23, 5, "1", 1, 0, "C");
				$fpdf->Cell(73, 5, "2", 1, 0, "C");
				$fpdf->Cell(10, 5, "3", 1, 0, "C");
				$fpdf->Cell(15, 5, "4", 1, 0, "C");
				$fpdf->Cell(15, 5, "5", 1, 0, "C");
				$fpdf->Cell(15, 5, "6", 1, 0, "C");
				$fpdf->Cell(15, 5, "7", 1, 0, "C");
				$fpdf->Cell(25, 5, "8", 1, 0, "C");
				$fpdf->Cell(15, 5, "9", 1, 0, "C");
				$fpdf->SetY($last_y);
				$fpdf->SetX(2);
				$fpdf->Cell(23, 5, "", 0, 0, "C");
				$fpdf->Cell(73, 5, "", 0, 0, "C");
				$fpdf->Cell(10, 5, "", 0, 0, "C");
				$fpdf->Cell(60, 5, "Banyaknya", 1, 0, "C");
				$fpdf->Cell(40, 5, "Nilai", 1, 0, "C");
				$fpdf->Ln(4.8);
				$fpdf->SetX(2);
				$fpdf->Cell(23, 5, "", 0, 0, "C");
				$fpdf->Cell(73, 5, "", 0, 0, "C");
				$fpdf->Cell(10, 5, "", 0, 0, "C");
				$fpdf->Cell(15, 5, "Stok", 1, 0, "C");
				$fpdf->Cell(15, 5, "Diminta", 1, 0, "C");
				$fpdf->Cell(15, 5, "Keluar", 1, 0, "C");
				$fpdf->Cell(15, 5, "Setuju", 1, 0, "C");
				$fpdf->Cell(25, 5, "Harga", 1, 0, "C");
				$fpdf->Cell(15, 5, "Jml.", 1, 0, "C");
				$fpdf->Ln(10.5);

				$detail_rows = $this->dbtable->get_db()->get_result("
					SELECT *
					FROM smis_gd_dbarang_keluar
					WHERE id_barang_keluar = '" . $id . "' AND prop = ''
					LIMIT " . $i_halaman * $jumlah_item_per_halaman . ", " . $jumlah_item_per_halaman . "
				");

				if ($detail_rows != null) {
					foreach ($detail_rows as $detail_row) {
						$fpdf->SetX(2);
						$fpdf->Cell(23, 5, substr("", 0, 8), 1, 0);
						$fpdf->Cell(73, 5, substr($detail_row->nama_barang, 0, 33), 1, 0);
						$fpdf->Cell(10, 5, substr($detail_row->satuan, 0, 4), 1, 0);
						$fpdf->Cell(15, 5, "", 1, 0, "R");
						$fpdf->Cell(15, 5, $detail_row->jumlah_diminta, 1, 0, "R");
						$fpdf->Cell(15, 5, $detail_row->jumlah, 1, 0, "R");
						$fpdf->Cell(15, 5, $detail_row->jumlah, 1, 0, "R");
						$fpdf->Cell(25, 5, "", 1, 0, "R");
						$fpdf->Cell(15, 5, "", 1, 0, "R");
						$fpdf->Ln(5);
						$number++;
						$stok_keluar_rows = $this->dbtable->get_db()->get_result("
							SELECT a.jumlah, CASE WHEN b.tanggal_exp = '0000-00-00' THEN 'N/A' ELSE b.tanggal_exp END tanggal_exp, b.no_batch
							FROM smis_gd_stok_barang_keluar a INNER JOIN smis_gd_stok_barang b ON a.id_stok_obat = b.id
							WHERE a.id_dbarang_keluar = '" . $detail_row->id . "' AND a.prop = ''
						");
						if ($stok_keluar_rows != null) {
							foreach ($stok_keluar_rows as $sk) {
								$fpdf->SetX(2);
								$fpdf->Cell(23, 5, "", 1, 0);
								$fpdf->Cell(73, 5, "", 1, 0);
								$fpdf->Cell(55, 5, "NB : " . $sk->no_batch, 1, 0);
								$ed = $sk->tanggal_exp == 'N/A' ? "N/A" : ArrayAdapter::format("date d-m-Y", $sk->tanggal_exp);
								$fpdf->Cell(40, 5, "ED : " . $ed, 1, 0);
								$fpdf->Cell(15, 5, $sk->jumlah, 1, 0, "R");
								$fpdf->Ln(5);
								$number++;
							}
						}
					}
				}
				for ($i = $number; $i <= $jumlah_item_per_halaman; $i++) {
					$fpdf->SetX(2);
					$fpdf->Cell(23, 5, "", 1, 0, "C");
					$fpdf->Cell(73, 5, "", 1, 0, "C");
					$fpdf->Cell(10, 5, "", 1, 0, "C");
					$fpdf->Cell(15, 5, "", 1, 0, "C");
					$fpdf->Cell(15, 5, "", 1, 0, "C");
					$fpdf->Cell(15, 5, "", 1, 0, "C");
					$fpdf->Cell(15, 5, "", 1, 0, "C");
					$fpdf->Cell(25, 5, "", 1, 0, "C");
					$fpdf->Cell(15, 5, "", 1, 0, "C");
					$fpdf->Ln(5);
				}
				$last_y = $fpdf->GetY();
				$fpdf->SetX(2);
				$fpdf->Cell(206, 25, "", 1, 0, "C");
				$fpdf->Ln(3);
				$fpdf->SetX(2);
				
				$footer_sentence_1 = "";
				$footer_sentence_2 = "";
				$footer_sentence_3 = "";
				$footer_title_1 = "";
				$footer_title_2 = "";
				$footer_title_3 = "";
				$footer_pic_1 = "";
				$footer_pic_2 = "";
				$footer_pic_3 = "";
				if ($i_halaman == $jumlah_halaman - 1) {
					$footer_sentence_1 = "Diperiksa oleh,";
					$footer_sentence_2 = "Dikeluarkan oleh,";
					$footer_sentence_3 = "Diterima oleh,";
					$footer_title_1 = "Verifikator,";
					$footer_title_2 = "Petugas Gudang";
					$footer_title_3 = "";
					$footer_pic_1 = "(" . $verifikator . ")";
					$footer_pic_2 = "(" . $petugas_gudang . ")";
					$footer_pic_3 = "(__________________)";	
				}		

				$fpdf->Cell(60, 5, $footer_sentence_1, 0, 0, "C");
				$fpdf->Cell(19, 5, "", 0, 0, "C");
				$fpdf->Cell(50, 5, $footer_sentence_2, 0, 0, "C");
				$fpdf->Cell(19, 5, "", 0, 0, "C");
				$fpdf->Cell(50, 5, $footer_sentence_3, 0, 0, "C");
				$fpdf->Ln(5);
				$fpdf->SetX(2);
				$fpdf->Cell(60, 5, $footer_title_1, 0, 0, "C");
				$fpdf->Cell(19, 5, "", 0, 0, "C");
				$fpdf->Cell(50, 5, $footer_title_2, 0, 0, "C");
				$fpdf->Cell(19, 5, "", 0, 0, "C");
				$fpdf->Cell(50, 5, $footer_title_3, 0, 0, "C");
				$fpdf->Ln(5);
				$fpdf->SetX(2);
				$fpdf->Cell(177, 10, "", 0, 0, "C");
				$fpdf->Ln(5);
				$fpdf->SetX(2);
				$fpdf->Cell(60, 5, $footer_pic_1, 0, 0, "C");
				$fpdf->Cell(19, 5, "", 0, 0, "C");
				$fpdf->Cell(50, 5, $footer_pic_2, 0, 0, "C");
				$fpdf->Cell(19, 5, "", 0, 0, "C");
				$fpdf->Cell(50, 5, $footer_pic_3, 0, 0, "C");
			}

			global $user;
			$md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "mutasi_" . $unit . ".pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
			return $pathfile;
		}
		public function print_mutasi() {
			$id = $_POST['id'];
			$status = $_POST['status'];
			$row_header = $this->dbtable->get_row("
				SELECT *
				FROM smis_gd_barang_keluar
				WHERE id = '" . $id . "'
			");
			$rows_detail = $this->dbtable->get_result("
				SELECT *
				FROM smis_gd_dbarang_keluar
				WHERE id_barang_keluar = '" . $id . "'
			");
			$print_data = "";
			$print_data .= "<center><strong>NOTA MUTASI BARANG NO. " . ArrayAdapter::format("only-digit8", $id) . "</strong></center><br/>";
			$print_data .= "<table border='0'>
								<tr>
									<td>Unit Pengirim</td>
									<td>:</td>
									<td>" . ArrayAdapter::format("unslug", "gudang_umum") . "</td>
								</tr>
								<tr>
									<td>Unit Penerima</td>
									<td>:</td>
									<td>" . ArrayAdapter::format("unslug", $row_header->unit) . "</td>
								</tr>
								<tr>
									<td>Tanggal</td>
									<td>:</td>
									<td>" . ArrayAdapter::format("date d M Y", $row_header->tanggal) . "</td>
								</tr>
								<tr>
									<td>Status</td>
									<td>:</td>
									<td>" . ($status == 'belum'? "SUDAH / DIKEMBALIKAN" : ArrayAdapter::format("unslug", $status)) . "</td>
								</tr>
								<tr>
									<td colspan='3'>&Tab;</td>
								</tr>
							</table>";
			$print_data .= "<table border='1'>
								<tr>
									<th>No.</th>
									<th>Nama Barang</th>
									<th>Jenis Barang</th>
									<th>Jumlah</th>
								</tr>";
			$no = 1;
			if (count($rows_detail) > 0) {
				foreach($rows_detail as $d) {
					$print_data .= "<tr>
										<td>" . $no++ . "</td>
										<td>" . $d->nama_barang . "</td>
										<td>" . $d->nama_jenis_barang . "</td>
										<td>" . $d->jumlah . " " . $d->satuan . "</td>
									</tr>";
					$detail_no = 'a';
					$rows_stok_keluar = $this->dbtable->get_result("
						SELECT smis_gd_stok_barang_keluar.id, smis_gd_stok_barang.tanggal_exp, smis_gd_stok_barang.hna, smis_gd_stok_barang_keluar.jumlah, smis_gd_stok_barang.satuan
						FROM smis_gd_stok_barang_keluar LEFT JOIN smis_gd_stok_barang ON smis_gd_stok_barang_keluar.id_stok_barang = smis_gd_stok_barang.id
						WHERE smis_gd_stok_barang_keluar.id_dbarang_keluar = '" . $d->id . "'
					");
					foreach($rows_stok_keluar as $dsk) {
						$print_data .= "<tr>
											<td></td>
											<td colspan='2'>" . $detail_no++ . ". ED. " . ArrayAdapter::format("date d/m/Y", $dsk->tanggal_exp) . " - " . ArrayAdapter::format("only-money Rp. ", $dsk->hna) . " : " . $dsk->jumlah . " " . $dsk->satuan . "</td>
											<td></td>
										</tr>";
					}
				}
			} else {
				$print_data .= "<tr>
									<td colspan='4' align='center'><i>Tidak terdapat data detail mutasi barang</i></td>
								</tr>";
			}
			$print_data .= "</table><br/>";
			global $user;
			$print_data .= "<table border='0' align='center'>
								<tr>
									<td align='center'>Tuban, " . ArrayAdapter::format("date d M Y", date("Y-m-d")) . "</td>
									<td>&Tab;</td>
									<td>&nbsp;</td>
								</tr>
								<tr>
									<td align='center'>PETUGAS GUDANG UMUM</td>
									<td>&Tab;</td>
									<td align='center'>PETUGAS " . ArrayAdapter::format("unslug", $row_header->unit) . "</td>
								</tr>
								<tr>
									<td>&nbsp;</td>
									<td>&Tab;</td>
									<td>&nbsp;</td>
								</tr>
								<tr>
									<td>&nbsp;</td>
									<td>&Tab;</td>
									<td>&nbsp;</td>
								</tr>
								<tr>
									<td>&nbsp;</td>
									<td>&Tab;</td>
									<td>&nbsp;</td>
								</tr>
								<tr>
									<td>&nbsp;</td>
									<td>&Tab;</td>
									<td>&nbsp;</td>
								</tr>
								<tr>
									<td align='center'><b>" . $user->getNameOnly() . "</b></td>
									<td>&Tab;</td>
									<td align='center'>(_____________________)</td>
								</tr>
							</table>";
			return $print_data;
		}
		public function save() {
			$header_data = $this->postToArray();
			$id['id'] = $_POST['id'];
			if ($id['id'] == 0 || $id['id'] == "") {
				//do insert header here:
				$header_data['status_acc']      = 0;
				$header_data['autonomous'] 		= "[" . getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") . "]";
				$header_data['duplicate'] 		= 0;
				$header_data['time_updated'] 	= date("Y-m-d H:i:s");
				$header_data['origin'] 			= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
				$header_data['origin_updated'] 	= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
				$result = $this->dbtable->insert($header_data);
				$id['id'] = $this->dbtable->get_inserted_id();
				$success['type'] = "insert";
				if (isset($_POST['detail'])) {
					//do insert detail here:
					$dbarang_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_dbarang_keluar");
					$detail = $_POST['detail'];
					foreach($detail as $d) {
						$detail_data = array();
						$detail_data['id_barang_keluar'] = $id['id'];
						$detail_data['id_barang'] = $d['id_barang'];
						$detail_data['nama_barang'] = $d['nama_barang'];
						$detail_data['nama_jenis_barang'] = $d['nama_jenis_barang'];
						$detail_data['jumlah'] = $d['jumlah'];
						$detail_data['satuan'] = $d['satuan'];
						$detail_data['konversi'] = $d['konversi'];
						$detail_data['satuan_konversi'] = $d['satuan_konversi'];

						$detail_data['autonomous'] 		= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
				        $detail_data['duplicate'] 		= 0;
				        $detail_data['time_updated'] 	= date("Y-m-d H:i:s");
				        $detail_data['origin_updated'] 	= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
						$detail_data['origin'] 			= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
						
						$dbarang_keluar_dbtable->insert($detail_data);
						$id_detail = $dbarang_keluar_dbtable->get_inserted_id();
						$stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_stok_barang");
						$stok_query = "
							SELECT smis_gd_stok_barang.id, smis_gd_stok_barang.sisa
							FROM smis_gd_stok_barang LEFT JOIN smis_gd_dbarang_masuk ON smis_gd_stok_barang.id_dbarang_masuk = smis_gd_dbarang_masuk.id
							WHERE smis_gd_dbarang_masuk.id_barang = '" . $d['id_barang'] . "' AND smis_gd_stok_barang.satuan = '" . $d['satuan'] . "' AND smis_gd_stok_barang.konversi = '" . $d['konversi'] . "' AND smis_gd_stok_barang.satuan_konversi = '" . $d['satuan_konversi'] . "'
							ORDER BY smis_gd_stok_barang.tanggal_exp ASC
						";
						$stok_rows = $stok_dbtable->get_result($stok_query);
						$jumlah = $detail_data['jumlah'];
						foreach($stok_rows as $sr) {
							$sisa_stok = 0;
							$jumlah_stok_keluar = 0;
							if ($sr->sisa >= $jumlah) {
								$sisa_stok = $sr->sisa - $jumlah;
								$jumlah_stok_keluar = $jumlah;
								$jumlah = 0;
							} else {
								$sisa_stok = 0;
								$jumlah_stok_keluar = $sr->sisa;
								$jumlah = $jumlah - $sr->sisa;
							}
							//do update stok barang here:
							$stok_data = array();
							$stok_data['sisa'] = $sisa_stok;

							$stok_data['autonomous'] 		= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
					        $stok_data['duplicate'] 		= 0;
					        $stok_data['time_updated'] 		= date("Y-m-d H:i:s");
							$stok_data['origin_updated'] 	= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
							
							$stok_id['id'] = $sr->id;
							$stok_dbtable->update($stok_data, $stok_id);
							//logging riwayat stok barang:
							$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_riwayat_stok_barang");
							$data_riwayat = array();
							$data_riwayat['tanggal'] = date("Y-m-d");
							$data_riwayat['id_stok_barang'] = $sr->id;
							$data_riwayat['jumlah_keluar'] = $jumlah_stok_keluar;
							$data_riwayat['sisa'] = $sisa_stok;
							$data_riwayat['keterangan'] = "Stok Keluar ke " . ArrayAdapter::format("unslug", $_POST['unit']);
							global $user;
							$data_riwayat['nama_user'] = $user->getName();							
							$riwayat_dbtable->insert($data_riwayat);

							//logging kartu stok barang:
							$ks_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_kartu_stok");
							$id_barang = 0;
							$nama_barang = "";
							$nama_jenis_barang = "";
							$barang_row = $ks_dbtable->get_row("
								SELECT a.id_barang, a.nama_barang, a.nama_jenis_barang
								FROM smis_gd_dbarang_masuk a INNER JOIN smis_gd_stok_barang b ON a.id = b.id_dbarang_masuk
								WHERE b.id = " . $sr->id . "
							");
							if ($barang_row != null) {
								$id_barang = $barang_row->id_barang;
								$nama_barang = $barang_row->nama_barang;
								$nama_jenis_barang = $barang_row->nama_jenis_barang;
							}
							$stok_row = $ks_dbtable->get_row("
								SELECT SUM(b.sisa) sisa
								FROM smis_gd_dbarang_masuk a INNER JOIN smis_gd_stok_barang b ON a.id = b.id_dbarang_masuk
								WHERE b.prop = '' AND a.id_barang = '" . $id_barang . "'
							");
							$stok = 0;
							if ($stok_row != null)
								$stok = $stok_row->sisa;
							$ks_data = array();
							$ks_data['f_id'] = $id_detail;
							$ks_data['unit'] = ArrayAdapter::format("unslug", $_POST['unit']);
							$ks_data['no_bon'] = $id['id'];
							$ks_data['id_barang'] = $id_barang;
							$ks_data['kode_barang'] = $id_barang;
							$ks_data['nama_barang'] = $nama_barang;
							$ks_data['nama_jenis_barang'] = $nama_jenis_barang;
							$ks_data['tanggal'] = date("Y-m-d");
							$ks_data['masuk'] = 0;
							$ks_data['keluar'] = $jumlah_stok_keluar;
							$ks_data['sisa'] = $stok;
							
							$ks_data['autonomous'] 		= "[" . getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") . "]";
							$ks_data['duplicate'] 		= 0;
							$ks_data['time_updated'] 	= date("Y-m-d H:i:s");
							$ks_data['origin_updated'] 	= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
							$ks_data['origin'] 			= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");

							$ks_dbtable->insert($ks_data);

							//do insert stok barang keluar here:
							$stok_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_stok_barang_keluar");
							$stok_keluar_data = array();
							$stok_keluar_data['id_dbarang_keluar'] = $id_detail;
							$stok_keluar_data['id_stok_barang'] = $sr->id;
							$stok_keluar_data['jumlah'] = $jumlah_stok_keluar;
							
							$stok_keluar_data['autonomous'] 	= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
					        $stok_keluar_data['duplicate'] 		= 0;
					        $stok_keluar_data['time_updated'] 	= date("Y-m-d H:i:s");
					        $stok_keluar_data['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
					        $stok_keluar_data['origin'] 		= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
							
							$stok_keluar_dbtable->insert($stok_keluar_data);
							if ($jumlah == 0) break;
						}
					}
				}
			} else {
				//do update header here:
				$header_data = array();
				$header_data['status'] 			= $_POST['status'];
				$header_data['keterangan'] 		= $_POST['keterangan'];
				$header_data['autonomous'] 		= "[" . getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") . "]";
				$header_data['duplicate'] 		= 0;
				$header_data['time_updated'] 	= date("Y-m-d H:i:s");
				$header_data['origin'] 			= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
				$header_data['origin_updated'] 	= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
				$result = $this->dbtable->update($header_data, $id);
				$success['type'] = "update";
				if (isset($_POST['detail'])) {
					//do update detail here:
					$dbarang_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_dbarang_keluar");
					$detail = $_POST['detail'];
					foreach($detail as $d) {
						if ($d['cmd'] == "insert") {
							$detail_data = array();
							$detail_data['id_barang_keluar'] = $id['id'];
							$detail_data['id_barang'] = $d['id_barang'];
							$detail_data['nama_barang'] = $d['nama_barang'];
							$detail_data['nama_jenis_barang'] = $d['nama_jenis_barang'];
							$detail_data['jumlah'] = $d['jumlah'];
							$detail_data['satuan'] = $d['satuan'];
							$detail_data['konversi'] = $d['konversi'];
							$detail_data['satuan_konversi'] = $d['satuan_konversi'];
							
							$detail_data['autonomous'] 		= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
					        $detail_data['duplicate'] 		= 0;
					        $detail_data['time_updated'] 	= date("Y-m-d H:i:s");
							$detail_data['origin_updated'] 	= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
							
							$dbarang_keluar_dbtable->insert($detail_data);
							$id_detail = $dbarang_keluar_dbtable->get_inserted_id();
							$stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_stok_barang");
							$stok_query = "
								SELECT smis_gd_stok_barang.id, smis_gd_stok_barang.sisa
								FROM smis_gd_stok_barang LEFT JOIN smis_gd_dbarang_masuk ON smis_gd_stok_barang.id_dbarang_masuk = smis_gd_dbarang_masuk.id
								WHERE smis_gd_dbarang_masuk.id_barang = '" . $d['id_barang'] . "' AND smis_gd_stok_barang.satuan = '" . $d['satuan'] . "' AND smis_gd_stok_barang.konversi = '" . $d['konversi'] . "' AND smis_gd_stok_barang.satuan_konversi = '" . $d['satuan_konversi'] . "'
								ORDER BY smis_gd_stok_barang.tanggal_exp DESC
							";
							$stok_rows = $stok_dbtable->get_result($stok_query);
							$jumlah = $detail_data['jumlah'];
							foreach($stok_rows as $sr) {
								$sisa_stok = 0;
								$jumlah_stok_keluar = 0;
								if ($sr->sisa >= $jumlah) {
									$sisa_stok = $sr->sisa - $jumlah;
									$jumlah_stok_keluar = $jumlah;
									$jumlah = 0;
								} else {
									$sisa_stok = 0;
									$jumlah_stok_keluar = $sr->sisa;
									$jumlah = $jumlah - $sr->sisa;
								}
								//do update stok barang here:
								$stok_data = array();
								$stok_data['sisa'] = $sisa_stok;
								
								$stok_data['autonomous'] 		= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
						        $stok_data['duplicate'] 		= 0;
						        $stok_data['time_updated'] 		= date("Y-m-d H:i:s");
								$stok_data['origin_updated'] 	= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
								
								$stok_id['id'] = $sr->id;
								$stok_dbtable->update($stok_data, $stok_id);
								//logging riwayat stok barang:
								$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_riwayat_stok_barang");
								$data_riwayat = array();
								$data_riwayat['tanggal'] = date("Y-m-d");
								$data_riwayat['id_stok_barang'] = $sr->id;
								$data_riwayat['jumlah_keluar'] = $jumlah_stok_keluar;
								$data_riwayat['sisa'] = $sisa_stok;
								$data_riwayat['keterangan'] = "Perubahan Stok Keluar ke " . ArrayAdapter::format("unslug", $_POST['unit']);
								global $user;
								$data_riwayat['nama_user'] = $user->getName();

								$data_riwayat['autonomous'] 	= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
						        $data_riwayat['duplicate'] 		= 0;
						        $data_riwayat['time_updated'] 	= date("Y-m-d H:i:s");
								$data_riwayat['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
								$data_riwayat['origin'] 		= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
								
								$riwayat_dbtable->insert($data_riwayat);

								//logging kartu stok barang:
								$ks_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_kartu_stok");
								$id_barang = 0;
								$nama_barang = "";
								$nama_jenis_barang = "";
								$barang_row = $ks_dbtable->get_row("
									SELECT a.id_barang, a.nama_barang, a.nama_jenis_barang
									FROM smis_gd_dbarang_masuk a INNER JOIN smis_gd_stok_barang b ON a.id = b.id_dbarang_masuk
									WHERE b.id = " . $sr->id . "
								");
								if ($barang_row != null) {
									$id_barang = $barang_row->id_barang;
									$nama_barang = $barang_row->nama_barang;
									$nama_jenis_barang = $barang_row->nama_jenis_barang;
								}
								$stok_row = $ks_dbtable->get_row("
									SELECT SUM(b.sisa) sisa
									FROM smis_gd_dbarang_masuk a INNER JOIN smis_gd_stok_barang b ON a.id = b.id_dbarang_masuk
									WHERE b.prop = '' AND a.id_barang = '" . $id_barang . "'
								");
								$stok = 0;
								if ($stok_row != null)
									$stok = $stok_row->sisa;
								$ks_data = array();
								$ks_data['f_id'] = $id_detail;
								$ks_data['unit'] = ArrayAdapter::format("unslug", $_POST['unit']);
								$ks_data['no_bon'] = $id['id'];
								$ks_data['id_barang'] = $id_barang;
								$ks_data['kode_barang'] = $id_barang;
								$ks_data['nama_barang'] = $nama_barang;
								$ks_data['nama_jenis_barang'] = $nama_jenis_barang;
								$ks_data['tanggal'] = date("Y-m-d");
								$ks_data['masuk'] = 0;
								$ks_data['keluar'] = $jumlah_stok_keluar;
								$ks_data['sisa'] = $stok;

								$ks_data['autonomous'] 		= "[" . getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") . "]";
								$ks_data['duplicate'] 		= 0;
								$ks_data['time_updated'] 	= date("Y-m-d H:i:s");
								$ks_data['origin_updated'] 	= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
								$ks_data['origin'] 			= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");

								$ks_dbtable->insert($ks_data);

								//do insert stok barang keluar here:
								$stok_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_stok_barang_keluar");
								$stok_keluar_data = array();
								$stok_keluar_data['id_dbarang_keluar'] = $id_detail;
								$stok_keluar_data['id_stok_barang'] = $sr->id;
								$stok_keluar_data['jumlah'] = $jumlah_stok_keluar;
								
								$stok_keluar_data['autonomous'] 	= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
						        $stok_keluar_data['duplicate'] 		= 0;
						        $stok_keluar_data['time_updated'] 	= date("Y-m-d H:i:s");
								$stok_keluar_data['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
								$stok_keluar_data['origin'] 		= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
								
								$stok_keluar_dbtable->insert($stok_keluar_data);
								if ($jumlah == 0) break;
							}
						} else if ($d['cmd'] == "update") {
							$detail_data = array();
							$detail_data['jumlah'] = $d['jumlah'];
							
							$detail_data['autonomous'] = "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
					        $detail_data['duplicate'] = 0;
					        $detail_data['time_updated'] = date("Y-m-d H:i:s");
							$detail_data['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
							
							$detail_id['id'] = $d['id'];
							$dbarang_keluar_dbtable->update($detail_data, $detail_id);
							if ($d['jumlah'] > $d['jumlah_lama']) {
								//jumlah baru > jumlah lama:
								$stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_stok_barang");
								$stok_query = "
									SELECT smis_gd_stok_barang.id, smis_gd_stok_barang.sisa
									FROM smis_gd_stok_barang LEFT JOIN smis_gd_dbarang_masuk ON smis_gd_stok_barang.id_dbarang_masuk = smis_gd_dbarang_masuk.id
									WHERE smis_gd_dbarang_masuk.id_barang = '" . $d['id_barang'] . "' AND smis_gd_stok_barang.satuan = '" . $d['satuan'] . "' AND smis_gd_stok_barang.konversi = '" . $d['konversi'] . "' AND smis_gd_stok_barang.satuan_konversi = '" . $d['satuan_konversi'] . "'
									ORDER BY smis_gd_stok_barang.tanggal_exp DESC
								";
								$stok_rows = $stok_dbtable->get_result($stok_query);
								$jumlah = $d['jumlah'] - $d['jumlah_lama'];
								foreach($stok_rows as $sr) {
									$sisa_stok = 0;
									$jumlah_stok_keluar = 0;
									if ($sr->sisa >= $jumlah) {
										$sisa_stok = $sr->sisa - $jumlah;
										$jumlah_stok_keluar = $jumlah;
										$jumlah = 0;
									} else {
										$sisa_stok = 0;
										$jumlah_stok_keluar = $sr->sisa;
										$jumlah = $jumlah - $sr->sisa;
									}
									//do update stok barang here:
									$stok_data = array();
									$stok_data['sisa'] = $sisa_stok;
									
									$stok_data['autonomous'] 		= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
							        $stok_data['duplicate'] 		= 0;
							        $stok_data['time_updated'] 		= date("Y-m-d H:i:s");
									$stok_data['origin_updated'] 	= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
									
									$stok_id['id'] = $sr->id;
									$stok_dbtable->update($stok_data, $stok_id);
									//logging riwayat stok barang:
									$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_riwayat_stok_barang");
									$data_riwayat = array();
									$data_riwayat['tanggal'] = date("Y-m-d");
									$data_riwayat['id_stok_barang'] = $sr->id;
									$data_riwayat['jumlah_keluar'] = $jumlah_stok_keluar;
									$data_riwayat['sisa'] = $sisa_stok;
									$data_riwayat['keterangan'] = "Perubahan Stok Keluar ke " . ArrayAdapter::format("unslug", $_POST['unit']);
									global $user;
									$data_riwayat['nama_user'] = $user->getName();

									$data_riwayat['autonomous'] 	= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
							        $data_riwayat['duplicate'] 		= 0;
							        $data_riwayat['time_updated'] 	= date("Y-m-d H:i:s");
							        $data_riwayat['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
									$data_riwayat['origin'] 		= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
									
									$riwayat_dbtable->insert($data_riwayat);

									//logging kartu stok barang:
									$ks_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_kartu_stok");
									$id_barang = 0;
									$nama_barang = "";
									$nama_jenis_barang = "";
									$barang_row = $ks_dbtable->get_row("
										SELECT a.id_barang, a.nama_barang, a.nama_jenis_barang
										FROM smis_gd_dbarang_masuk a INNER JOIN smis_gd_stok_barang b ON a.id = b.id_dbarang_masuk
										WHERE b.id = " . $sr->id . "
									");
									if ($barang_row != null) {
										$id_barang = $barang_row->id_barang;
										$nama_barang = $barang_row->nama_barang;
										$nama_jenis_barang = $barang_row->nama_jenis_barang;
									}
									$stok_row = $ks_dbtable->get_row("
										SELECT SUM(b.sisa) sisa
										FROM smis_gd_dbarang_masuk a INNER JOIN smis_gd_stok_barang b ON a.id = b.id_dbarang_masuk
										WHERE b.prop = '' AND a.id_barang = '" . $id_barang . "'
									");
									$stok = 0;
									if ($stok_row != null)
										$stok = $stok_row->sisa;
									$ks_data = array();
									$ks_data['f_id'] = $detail_id['id'];
									$ks_data['unit'] = ArrayAdapter::format("unslug", $_POST['unit']);
									$ks_data['no_bon'] = $id['id'];
									$ks_data['id_barang'] = $id_barang;
									$ks_data['kode_barang'] = $id_barang;
									$ks_data['nama_barang'] = $nama_barang;
									$ks_data['nama_jenis_barang'] = $nama_jenis_barang;
									$ks_data['tanggal'] = date("Y-m-d");
									$ks_data['masuk'] = 0;
									$ks_data['keluar'] = $jumlah_stok_keluar;
									$ks_data['sisa'] = $stok;

									$ks_data['autonomous'] 		= "[" . getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") . "]";
									$ks_data['duplicate'] 		= 0;
									$ks_data['time_updated'] 	= date("Y-m-d H:i:s");
									$ks_data['origin_updated'] 	= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
									$ks_data['origin'] 			= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");

									$ks_dbtable->insert($ks_data);

									//do insert stok barang keluar here:
									$stok_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_stok_barang_keluar");
									$stok_keluar_data = array();
									$stok_keluar_data['id_dbarang_keluar'] = $d['id'];
									$stok_keluar_data['id_stok_barang'] = $sr->id;
									$stok_keluar_data['jumlah'] = $jumlah_stok_keluar;

									$stok_keluar_data['autonomous'] 	= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
							        $stok_keluar_data['duplicate'] 		= 0;
							        $stok_keluar_data['time_updated'] 	= date("Y-m-d H:i:s");
							        $stok_keluar_data['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
									$stok_keluar_data['origin'] 		= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
									
									$stok_keluar_dbtable->insert($stok_keluar_data);
									if ($jumlah == 0) break;
								}
							} else if ($d['jumlah'] < $d['jumlah_lama']) {
								//jumlah baru < jumlah lama:
								$stok_barang_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_stok_barang_keluar");
								$stok_keluar_query = "
									SELECT *
									FROM smis_gd_stok_barang_keluar
									WHERE id_dbarang_keluar = '" . $d['id'] . "'
									ORDER BY id DESC
								";
								$stok_keluar = $stok_barang_keluar_dbtable->get_result($stok_keluar_query);
								$jumlah = $d['jumlah_lama'] - $d['jumlah'];
								foreach($stok_keluar as $sk) {
									$simpan_stok_keluar = 0;
									$simpan_stok = 0;
									if ($jumlah >= $sk->jumlah) {
										$jumlah = $jumlah - $sk->jumlah;
										$simpan_stok = $sk->jumlah;
										$simpan_stok_keluar = 0;
									} else {
										$simpan_stok_keluar = $sk->jumlah - $jumlah;
										$simpan_stok = $jumlah;
										$jumlah = 0;
									}
									$stok_keluar_data = array();
									$stok_keluar_data['jumlah'] = $simpan_stok_keluar;
									$stok_keluar_data['autonomous'] = "[".$this->getAutonomous()."]";
							        $stok_keluar_data['duplicate'] = 0;
							        $stok_keluar_data['time_updated'] = date("Y-m-d H:i:s");
							        $stok_keluar_data['origin_updated'] = $this->getAutonomous();
									if ($simpan_stok_keluar == 0)
										$stok_keluar_data['prop'] = "del";
									$stok_keluar_id['id'] = $sk->id;
									$stok_barang_keluar_dbtable->update($stok_keluar_data, $stok_keluar_id);
									$stok_barang_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_stok_barang");
									$stok_query = "
										SELECT *
										FROM smis_gd_stok_barang
										WHERE id = '" . $sk->id_stok_barang . "'
									";
									$stok_barang_row = $stok_barang_dbtable->get_row($stok_query);
									$stok_data = array();
									$stok_data['sisa'] = $stok_barang_row->sisa + $simpan_stok;
									
									$stok_data['autonomous'] 		= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
							        $stok_data['duplicate'] 		= 0;
							        $stok_data['time_updated'] 		= date("Y-m-d H:i:s");
									$stok_data['origin_updated'] 	= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
									
									$stok_id['id'] = $sk->id_stok_barang;
									$stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_stok_barang");
									$stok_dbtable->update($stok_data, $stok_id);
									//logging riwayat stok barang:
									$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_riwayat_stok_barang");
									$data_riwayat = array();
									$data_riwayat['tanggal'] = date("Y-m-d");
									$data_riwayat['id_stok_barang'] = $sk->id_stok_barang;
									$data_riwayat['jumlah_masuk'] = $simpan_stok;
									$data_riwayat['sisa'] = $stok_barang_row->sisa + $simpan_stok;
									$data_riwayat['keterangan'] = "Perubahan Stok Keluar ke " . ArrayAdapter::format("unslug", $_POST['unit']);
									global $user;
									$data_riwayat['nama_user'] = $user->getName();

									$data_riwayat['autonomous'] 	= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
							        $data_riwayat['duplicate'] 		= 0;
							        $data_riwayat['time_updated'] 	= date("Y-m-d H:i:s");
							        $data_riwayat['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
									$data_riwayat['origin'] 		= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
									
									$riwayat_dbtable->insert($data_riwayat);

									//logging kartu stok barang:
									$ks_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_kartu_stok");
									$id_barang = 0;
									$nama_barang = "";
									$nama_jenis_barang = "";
									$barang_row = $ks_dbtable->get_row("
										SELECT a.id_barang, a.nama_barang, a.nama_jenis_barang
										FROM smis_gd_dbarang_masuk a INNER JOIN smis_gd_stok_barang b ON a.id = b.id_dbarang_masuk
										WHERE b.id = " . $sk->id_stok_barang . "
									");
									if ($barang_row != null) {
										$id_barang = $barang_row->id_barang;
										$nama_barang = $barang_row->nama_barang;
										$nama_jenis_barang = $barang_row->nama_jenis_barang;
									}
									$stok_row = $ks_dbtable->get_row("
										SELECT SUM(b.sisa) sisa
										FROM smis_gd_dbarang_masuk a INNER JOIN smis_gd_stok_barang b ON a.id = b.id_dbarang_masuk
										WHERE b.prop = '' AND a.id_barang = '" . $id_barang . "'
									");
									$stok = 0;
									if ($stok_row != null)
										$stok = $stok_row->sisa;
									$ks_data = array();
									$ks_data['f_id'] = $detail_id['id'];
									$ks_data['unit'] = ArrayAdapter::format("unslug", $_POST['unit']);
									$ks_data['no_bon'] = $id['id'];
									$ks_data['id_barang'] = $id_barang;
									$ks_data['kode_barang'] = $id_barang;
									$ks_data['nama_barang'] = $nama_barang;
									$ks_data['nama_jenis_barang'] = $nama_jenis_barang;
									$ks_data['tanggal'] = date("Y-m-d");
									$ks_data['masuk'] = $simpan_stok;
									$ks_data['keluar'] = 0;
									$ks_data['sisa'] = $stok;

									$ks_data['autonomous'] 		= "[" . getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") . "]";
									$ks_data['duplicate'] 		= 0;
									$ks_data['time_updated'] 	= date("Y-m-d H:i:s");
									$ks_data['origin_updated'] 	= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
									$ks_data['origin'] 			= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");

									$ks_dbtable->insert($ks_data);

									if ($jumlah == 0) break;
								}
							} //end of update
						} else if($d['cmd'] == "delete") {
							$detail_data = array();
							$detail_data['prop'] = "del";
							
							$detail_data['autonomous'] 		= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
					        $detail_data['duplicate'] 		= 0;
					        $detail_data['time_updated'] 	= date("Y-m-d H:i:s");
							$detail_data['origin_updated'] 	= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
							
							$detail_id['id'] = $d['id'];
							$dbarang_keluar_dbtable->update($detail_data, $detail_id);
							$stok_barang_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_stok_barang_keluar");
							$stok_keluar_query = "
								SELECT *
								FROM smis_gd_stok_barang_keluar
								WHERE id_dbarang_keluar = '" . $d['id'] . "'
								ORDER BY id DESC
							";
							$stok_keluar = $stok_barang_keluar_dbtable->get_result($stok_keluar_query);
							foreach($stok_keluar as $sk) {
								$stok_keluar_data = array();
								$stok_keluar_data['jumlah'] = 0;
								$stok_keluar_data['prop'] = "del";

								$stok_keluar_data['autonomous'] 	= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
						        $stok_keluar_data['duplicate'] 		= 0;
						        $stok_keluar_data['time_updated'] 	= date("Y-m-d H:i:s");
								$stok_keluar_data['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
								
								$stok_keluar_id['id'] = $sk->id;
								$stok_barang_keluar_dbtable->update($stok_keluar_data, $stok_keluar_id);
								$stok_barang_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_stok_barang");
								$stok_query = "
									SELECT *
									FROM smis_gd_stok_barang
									WHERE id = '" . $sk->id_stok_barang . "'
								";
								$stok_barang_row = $stok_barang_dbtable->get_row($stok_query);
								$stok_data = array();
								$stok_data['sisa'] = $stok_barang_row->sisa + $sk->jumlah;

								$stok_data['autonomous'] 		= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
						        $stok_data['duplicate'] 		= 0;
								$stok_data['time_updated'] 		= date("Y-m-d H:i:s");
								$stok_data['origin_updated'] 	= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
								
								$stok_id['id'] = $sk->id_stok_barang;
								$stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_stok_barang");
								$stok_dbtable->update($stok_data, $stok_id);
								//logging riwayat stok barang:
								$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_riwayat_stok_barang");
								$data_riwayat = array();
								$data_riwayat['tanggal'] = date("Y-m-d");
								$data_riwayat['id_stok_barang'] = $sk->id_stok_barang;
								$data_riwayat['jumlah_masuk'] = $sk->jumlah;
								$data_riwayat['sisa'] = $stok_barang_row->sisa + $sk->jumlah;
								$data_riwayat['keterangan'] = "Perubahan Stok Keluar ke " . ArrayAdapter::format("unslug", $_POST['unit']);
								global $user;
								$data_riwayat['nama_user'] = $user->getName();

								$data_riwayat['autonomous'] 	= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
						        $data_riwayat['duplicate'] 		= 0;
						        $data_riwayat['time_updated'] 	= date("Y-m-d H:i:s");
						        $data_riwayat['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
								$data_riwayat['origin'] 		= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
								
								$riwayat_dbtable->insert($data_riwayat);

								//logging kartu stok barang:
								$ks_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_kartu_stok");
								$id_barang = 0;
								$nama_barang = "";
								$nama_jenis_barang = "";
								$barang_row = $ks_dbtable->get_row("
									SELECT a.id_barang, a.nama_barang, a.nama_jenis_barang
									FROM smis_gd_dbarang_masuk a INNER JOIN smis_gd_stok_barang b ON a.id = b.id_dbarang_masuk
									WHERE b.id = " . $sk->id_stok_barang . "
								");
								if ($barang_row != null) {
									$id_barang = $barang_row->id_barang;
									$nama_barang = $barang_row->nama_barang;
									$nama_jenis_barang = $barang_row->nama_jenis_barang;
								}
								$stok_row = $ks_dbtable->get_row("
									SELECT SUM(b.sisa) sisa
									FROM smis_gd_dbarang_masuk a INNER JOIN smis_gd_stok_barang b ON a.id = b.id_dbarang_masuk
									WHERE b.prop = '' AND a.id_barang = '" . $id_barang . "'
								");
								$stok = 0;
								if ($stok_row != null)
									$stok = $stok_row->sisa;
								$ks_data = array();
								$ks_data['f_id'] = $detail_id['id'];
								$ks_data['unit'] = ArrayAdapter::format("unslug", $_POST['unit']);
								$ks_data['no_bon'] = $id['id'];
								$ks_data['id_barang'] = $id_barang;
								$ks_data['kode_barang'] = $id_barang;
								$ks_data['nama_barang'] = $nama_barang;
								$ks_data['nama_jenis_barang'] = $nama_jenis_barang;
								$ks_data['tanggal'] = date("Y-m-d");
								$ks_data['masuk'] = $sk->jumlah;
								$ks_data['keluar'] = 0;
								$ks_data['sisa'] = $stok;

								$ks_data['autonomous'] 		= "[" . getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") . "]";
								$ks_data['duplicate'] 		= 0;
								$ks_data['time_updated'] 	= date("Y-m-d H:i:s");
								$ks_data['origin_updated'] 	= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
								$ks_data['origin'] 			= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");

								$ks_dbtable->insert($ks_data);
							}
						}
					}
				}
			}
			$success['id'] = $id['id'];
			$success['success'] = 1;
			if ($result === false) $success['success'] = 0;
			return $success;
		}
		public function edit() {
			$id = $_POST['id'];
			$header_row = $this->dbtable->get_row("
				SELECT *
				FROM smis_gd_barang_keluar
				WHERE id = '" . $id . "'
			");
			$data['header'] = $header_row;
			$dbarang_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_dbarang_keluar");
			$data['detail'] = $dbarang_keluar_dbtable->get_result("
				SELECT *
				FROM smis_gd_dbarang_keluar
				WHERE id_barang_keluar = '" . $id . "' AND prop NOT LIKE 'del'
			");
			$data['subdetail'] = $dbarang_keluar_dbtable->get_result("
				SELECT
					id, GROUP_CONCAT(CONCAT(CAST(tanggal_exp AS CHAR CHARACTER SET utf8), ';', CAST(no_batch AS CHAR CHARACTER SET utf8), ';', CAST(jumlah AS CHAR CHARACTER SET utf8))) detail_info
				FROM (
					SELECT 
						a.id, a.id_barang, CASE WHEN c.tanggal_exp = '0000-00-00' THEN 'N/A' ELSE c.tanggal_exp END tanggal_exp, c.no_batch, SUM(b.jumlah) jumlah
					FROM 
						(smis_gd_dbarang_keluar a INNER JOIN smis_gd_stok_barang_keluar b ON a.id = b.id_dbarang_keluar) INNER JOIN smis_gd_stok_barang c ON b.id_stok_barang = c.id
					WHERE 
						a.id_barang_keluar = '" . $id . "' AND a.prop NOT LIKE 'del'
					GROUP BY 
						a.id, a.id_barang, c.tanggal_exp, c.no_batch
				) v
				GROUP BY
					id
			");
			return $data;
		}
		public function delete() {
			$id['id'] = $_POST['id'];
			if ($this->dbtable->isRealDelete()) {
				$result = $this->dbtable->delete(null,$id);
			} else {
				$data['prop'] = "del";

				$data['autonomous'] 	= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
		        $data['duplicate'] 		= 0;
		        $data['time_updated'] 	= date("Y-m-d H:i:s");
				$data['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
				
				$result = $this->dbtable->update($data, $id);
			}
			$stok_barang_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_stok_barang_keluar");
			$stok_barang_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_stok_barang");
			$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_riwayat_stok_barang");
			$stok_keluar_query = "
				SELECT smis_gd_stok_barang_keluar.*, smis_gd_barang_keluar.unit
				FROM (smis_gd_stok_barang_keluar LEFT JOIN smis_gd_dbarang_keluar ON smis_gd_stok_barang_keluar.id_dbarang_keluar = smis_gd_dbarang_keluar.id) LEFT JOIN smis_gd_barang_keluar ON smis_gd_dbarang_keluar.id_barang_keluar = smis_gd_barang_keluar.id
				WHERE smis_gd_dbarang_keluar.id_barang_keluar = '" . $id['id'] . "' AND smis_gd_stok_barang_keluar.prop NOT LIKE 'del'
				ORDER BY smis_gd_stok_barang_keluar.id DESC
			";
			$stok_keluar = $this->dbtable->get_result($stok_keluar_query);
			foreach($stok_keluar as $sk) {
				$stok_keluar_data = array();
				$stok_keluar_data['jumlah'] = 0;
				$stok_keluar_data['prop'] = "del";
				
				$stok_keluar_data['autonomous'] 	= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
		        $stok_keluar_data['duplicate'] 		= 0;
		        $stok_keluar_data['time_updated'] 	= date("Y-m-d H:i:s");
				$stok_keluar_data['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
				
				$stok_keluar_id['id'] = $sk->id;
				$stok_barang_keluar_dbtable->update($stok_keluar_data, $stok_keluar_id);
				$stok_query = "
					SELECT *
					FROM smis_gd_stok_barang
					WHERE id = '" . $sk->id_stok_barang . "'
				";
				$stok_barang_row = $this->dbtable->get_row($stok_query);
				$stok_data = array();
				$stok_data['sisa'] = $stok_barang_row->sisa + $sk->jumlah;

				$stok_data['autonomous'] 		= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
		        $stok_data['duplicate'] 		= 0;
		        $stok_data['time_updated'] 		= date("Y-m-d H:i:s");
				$stok_data['origin_updated'] 	= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
				
				$stok_id['id'] = $sk->id_stok_barang;
				$stok_barang_dbtable->update($stok_data, $stok_id);
				//logging riwayat stok barang:
				$data_riwayat = array();
				$data_riwayat['tanggal'] = date("Y-m-d");
				$data_riwayat['id_stok_barang'] = $sk->id_stok_barang;
				$data_riwayat['jumlah_masuk'] = $sk->jumlah;
				$data_riwayat['sisa'] = $stok_barang_row->sisa + $sk->jumlah;
				$data_riwayat['keterangan'] = "Pembatalan Stok Keluar ke " . ArrayAdapter::format("unslug", $sk->unit);
				global $user;
				$data_riwayat['nama_user'] = $user->getName();

				$data_riwayat['autonomous'] 	= "[". getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") ."]";
		        $data_riwayat['duplicate'] 		= 0;
		        $data_riwayat['time_updated'] 	= date("Y-m-d H:i:s");
		        $data_riwayat['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
				$data_riwayat['origin'] 		= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
				
				$riwayat_dbtable->insert($data_riwayat);

				//logging kartu stok barang:
				$ks_dbtable = new DBTable($this->dbtable->get_db(), "smis_gd_kartu_stok");
				$id_barang = 0;
				$nama_barang = "";
				$nama_jenis_barang = "";
				$barang_row = $ks_dbtable->get_row("
					SELECT a.id_barang, a.nama_barang, a.nama_jenis_barang
					FROM smis_gd_dbarang_masuk a INNER JOIN smis_gd_stok_barang b ON a.id = b.id_dbarang_masuk
					WHERE b.id = " . $sk->id_stok_barang . "
				");
				if ($barang_row != null) {
					$id_barang = $barang_row->id_barang;
					$nama_barang = $barang_row->nama_barang;
					$nama_jenis_barang = $barang_row->nama_jenis_barang;
				}
				$stok_row = $ks_dbtable->get_row("
					SELECT SUM(b.sisa) sisa
					FROM smis_gd_dbarang_masuk a INNER JOIN smis_gd_stok_barang b ON a.id = b.id_dbarang_masuk
					WHERE b.prop = '' AND a.id_barang = '" . $id_barang . "'
				");
				$stok = 0;
				if ($stok_row != null)
					$stok = $stok_row->sisa;
				$ks_data = array();
				$ks_data['f_id'] = $_POST['id'];
				$ks_data['unit'] = ArrayAdapter::format("unslug", $sk->unit) . " (Pembatalan)";
				$ks_data['no_bon'] = $id['id'];
				$ks_data['id_barang'] = $id_barang;
				$ks_data['kode_barang'] = $id_barang;
				$ks_data['nama_barang'] = $nama_barang;
				$ks_data['nama_jenis_barang'] = $nama_jenis_barang;
				$ks_data['tanggal'] = date("Y-m-d");
				$ks_data['masuk'] = $sk->jumlah;
				$ks_data['keluar'] = 0;
				$ks_data['sisa'] = $stok;

				$ks_data['autonomous'] 		= "[" . getSettings($this->dbtable->get_db(), "smis_autonomous_id", "") . "]";
				$ks_data['duplicate'] 		= 0;
				$ks_data['time_updated'] 	= date("Y-m-d H:i:s");
				$ks_data['origin_updated'] 	= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
				$ks_data['origin'] 			= getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");

				$ks_dbtable->insert($ks_data);
			}
			$success['success'] = 1;
			$success['id'] = $_POST['id'];
			if ($result === 'false') $success['success'] = 0;
			return $success;
		}
	}
?>