<?php
	require_once("smis-base/smis-include-service-consumer.php");
	require_once("gudang_umum/responder/BarangMasukDBResponder.php");
	require_once("gudang_umum/responder/StokDBResponder.php");
	global $db;

	$id = isset($_POST['id']) ? $_POST['id'] : "";
	$id_po = isset($_POST['id_po']) ? $_POST['id_po'] : "0";
	$no_opl = isset($_POST['no_opl']) ? $_POST['no_opl'] : "";
	$no_bbm = isset($_POST['no_bbm']) ? $_POST['no_bbm'] : "BBM-" . ArrayAdapter::format("only-digit8", getSettings($db, "no_bbm", 0) + 1);
	$tipe = isset($_POST['tipe']) ? $_POST['tipe'] : "";
	$id_vendor = isset($_POST['id_vendor']) ? $_POST['id_vendor'] : "";
	$nama_vendor = isset($_POST['nama_vendor']) ? $_POST['nama_vendor'] : "";
	$no_faktur = isset($_POST['no_faktur']) ? $_POST['no_faktur'] : "";
	$tanggal = isset($_POST['tanggal']) ? $_POST['tanggal'] : date("Y-m-d");
	$tanggal_datang = isset($_POST['tanggal_datang']) ? $_POST['tanggal_datang'] : date("Y-m-d");
	$tanggal_tempo = isset($_POST['tanggal_tempo']) ? $_POST['tanggal_tempo'] : date('Y-m-d', strtotime("+30 days"));
	$diskon = isset($_POST['diskon']) ? ArrayAdapter::format("only-money", $_POST['diskon']) : "0,00";
	$t_diskon = isset($_POST['t_diskon']) ? $_POST['t_diskon'] : "persen";
	$materai = isset($_POST['materai']) ? $_POST['materai'] : "0,00";
	$keterangan = isset($_POST['keterangan']) ? $_POST['keterangan'] : "";
	$use_ppn = isset($_POST['use_ppn']) ? $_POST['use_ppn'] : "";
	$tipe_bayar = isset($_POST['tipe_bayar']) ? $_POST['tipe_bayar'] : "hutang";
	$nama_klinik = isset($_POST['nama_klinik']) ? $_POST['nama_klinik'] : "";
	$editable_header = isset($_POST['editable_header']) ? $_POST['editable_header'] : "false";
	$editable_detail = isset($_POST['editable_detail']) ? $_POST['editable_detail'] : "false";
	$limited = isset($_POST['limited']) ? $_POST['limited'] : "false";

	$header_form = new Form("", "", "Gudang Umum : Penerimaan Barang (BBM - Non-OPL)");
	$flag_hidden = new Hidden("penerimaan_barang_flag", "penerimaan_barang_flag", "bbm_non_opl");
	$header_form->addElement("", $flag_hidden);
	$id_hidden = new Hidden("penerimaan_barang_id", "penerimaan_barang_id", $id);
	$header_form->addElement("", $id_hidden);
	$limited_hidden = new Hidden("penerimaan_barang_limited", "penerimaan_barang_limited", $limited);
	$header_form->addElement("", $limited_hidden);
	$id_po_hidden = new Hidden("penerimaan_barang_id_po", "penerimaan_barang_id_po", $id_po);
	$header_form->addElement("", $id_po_hidden);
	$no_opl_text = new Text("penerimaan_barang_no_opl", "penerimaan_barang_no_opl", $no_opl);
	if ($editable_header == "false")
		$no_opl_text->setAtribute("disabled='disabled'");
	$header_form->addElement("No. OPL", $no_opl_text);
	$no_bbm_text = new Text("penerimaan_barang_no_bbm", "penerimaan_barang_no_bbm", $no_bbm);
	$no_bbm_text->setAtribute("disabled='disabled'");
	$header_form->addElement("No. BBM", $no_bbm_text);
	$no_faktur_text = new Text("penerimaan_barang_no_faktur", "penerimaan_barang_no_faktur", $no_faktur);
	if ($editable_header == "false")
		$no_faktur_text->setAtribute("disabled='disabled'");
	$header_form->addElement("No. Faktur", $no_faktur_text);
	$id_vendor_hidden = new Hidden("penerimaan_barang_id_vendor", "penerimaan_barang_id_vendor", $id_vendor);
	$header_form->addElement("", $id_vendor_hidden);
	$nama_vendor_text = new Text("penerimaan_barang_nama_vendor", "penerimaan_barang_nama_vendor", $nama_vendor);
	$nama_vendor_text->setAtribute("disabled='disabled'");
	if ($editable_header == "true" && ($id_po == 0 || $id_po == "")) {
		$nama_vendor_text->setClass("smis-one-option-input");
		$vendor_browse_button = new Button("", "", "Pilih");
		$vendor_browse_button->setClass("btn-info");
		$vendor_browse_button->setIsButton(Button::$ICONIC);
		$vendor_browse_button->setIcon("fa fa-list");
		$vendor_browse_button->setAction("vendor.chooser('vendor', 'vendor', 'vendor', vendor)");
		$vendor_browse_button->setAtribute("id='vendor_browse'");
		$vendor_input_group = new InputGroup("");
		$vendor_input_group->addComponent($nama_vendor_text);
		$vendor_input_group->addComponent($vendor_browse_button);
		$header_form->addElement("Rekanan", $vendor_input_group);
	} else
		$header_form->addElement("Rekanan", $nama_vendor_text);
	$tanggal_text = new Text("penerimaan_barang_tanggal", "penerimaan_barang_tanggal", $tanggal);
	if ($editable_header == "true") {
		$tanggal_text->setAtribute("data-date-format='yyyy-mm-dd'");
		$tanggal_text->setClass("mydate");
	} else {
		$tanggal_text->setAtribute("disabled='disabled'");
	}
	$header_form->addElement("Tgl. Faktur", $tanggal_text);
	$tanggal_datang_text = new Text("penerimaan_barang_tanggal_datang", "penerimaan_barang_tanggal_datang", $tanggal_datang);
	if ($editable_header == "true") {
		$tanggal_datang_text->setAtribute("data-date-format='yyyy-mm-dd'");
		$tanggal_datang_text->setClass("mydate");
	} else{
		$tanggal_datang_text->setAtribute("disabled='disabled'");
	}
	$header_form->addElement("Tgl. Diterima", $tanggal_datang_text);
	$tanggal_tempo_text = new Text("penerimaan_barang_tanggal_tempo", "penerimaan_barang_tanggal_tempo", $tanggal_tempo);
	if ($editable_header == "true") {
		$tanggal_tempo_text->setAtribute("data-date-format='yyyy-mm-dd'");
		$tanggal_tempo_text->setClass("mydate");
	} else {
		$tanggal_tempo_text->setAtribute("disabled='disabled'");
	}
	$header_form->addElement("Jatuh Tempo", $tanggal_tempo_text);
	$diskon_hidden = new Hidden("penerimaan_barang_diskon", "penerimaan_barang_diskon", $diskon);
	$header_form->addElement("", $diskon_hidden);
	$t_diskon_hidden = new Hidden("penerimaan_barang_t_diskon", "penerimaan_barang_t_diskon", $t_diskon);
	$header_form->addElement("", $t_diskon_hidden);
	$materai_text = new Text("penerimaan_barang_materai", "penerimaan_barang_materai", $materai);
	if ($editable_header == "true") {
		$materai_text->setTypical("money");
		$materai_text->setAtribute("data-thousands='.' data-decimal=',' data-precision='2'");
	} else {
		$materai_text->setAtribute("disabled='disabled'");
	}
	$header_form->addElement("Materai", $materai_text);
	$keterangan_hidden = new Hidden("penerimaan_barang_keterangan", "penerimaan_barang_keterangan", $keterangan);
	$header_form->addElement("", $keterangan_hidden);
	$use_ppn_option = new OptionBuilder();
	if ($use_ppn == "") {
		$use_ppn_option->add("Ya", 1, 1);
		$use_ppn_option->add("Tidak", 0);
	} else {
		if ($use_ppn == 1) {
			$use_ppn_option->add("Ya", 1, 1);
			$use_ppn_option->add("Tidak", 0);
		} else {
			$use_ppn_option->add("Ya", 1);
			$use_ppn_option->add("Tidak", 0, 1);
		}
	}
	$use_ppn_select = new Select("penerimaan_barang_use_ppn", "penerimaan_barang_use_ppn", $use_ppn_option->getContent());
	if ($editable_detail == "false")
		$use_ppn_select->setAtribute("disabled='disabled'");
	$header_form->addElement("Inc. PPn", $use_ppn_select);
	$tipe_bayar_option = new OptionBuilder();
	if ($tipe_bayar == "") {
		$tipe_bayar_option->add("Tunai", "tunai");
		$tipe_bayar_option->add("Hutang", "hutang", "1");
	} else {
		$tipe_bayar_option->add("Tunai", "tunai", $tipe_bayar == "tunai" ? "1" : "0");
		$tipe_bayar_option->add("Hutang", "hutang", $tipe_bayar == "hutang" ? "1" : "0");
	}
	$tipe_bayar_select = new Select("penerimaan_barang_tipe_bayar", "penerimaan_barang_tipe_bayar", $tipe_bayar_option->getContent());
	if ($editable_header == "false")
		$tipe_bayar_select->setAtribute("disabled='disabled'");
	$header_form->addElement("Tunai/Hutang", $tipe_bayar_select);
	$nama_klinik_option = new OptionBuilder();
	if ($nama_klinik == "")
		$nama_klinik_option->add("", "", "1");
	else
		$nama_klinik_option->add("", "");
	$faskes_rows = $db->get_result("
		SELECT *
		FROM smis_rg_faskes
		WHERE prop = ''
		ORDER BY nama ASC
	");
	if ($faskes_rows != null) {
		foreach ($faskes_rows as $fr) {
			if ($fr->nama == $nama_klinik)
				$nama_klinik_option->add($fr->nama, $fr->nama, "1");
			else
				$nama_klinik_option->add($fr->nama, $fr->nama);
		}
	}
	$nama_klinik_select = new Select("penerimaan_barang_nama_klinik", "penerimaan_barang_nama_klinik", $nama_klinik_option->getContent());
	if ($editable_header == "false")
		$nama_klinik_select->setAtribute("disabled='disabled'");
	$header_form->addElement("Klinik", $nama_klinik_select);

	$detail_form = new Form("", "", "");
	$row_num_hidden = new Hidden("dpenerimaan_barang_row_num", "dpenerimaan_barang_row_num", "");
	$detail_form->addElement("", $row_num_hidden);
	$id_barang_hidden = new Hidden("dpenerimaan_barang_id_barang", "dpenerimaan_barang_id_barang", "");
	$detail_form->addElement("", $id_barang_hidden);
	$name_barang_hidden = new Hidden("dpenerimaan_barang_name_barang", "dpenerimaan_barang_name_barang", "");
	$detail_form->addElement("", $name_barang_hidden);
	$medis_hidden = new Hidden("dpenerimaan_barang_medis", "dpenerimaan_barang_medis", "");
	$detail_form->addElement("", $medis_hidden);	
	$inventaris_hidden = new Hidden("dpenerimaan_barang_inventaris", "dpenerimaan_barang_inventaris", "");
	$detail_form->addElement("", $inventaris_hidden);
	$stok_entri_hidden = new Hidden("dpenerimaan_barang_stok_entri", "dpenerimaan_barang_stok_entri", "");
	$detail_form->addElement("", $stok_entri_hidden);
	$sisa_hidden = new Hidden("dpenerimaan_barang_sisa", "dpenerimaan_barang_sisa", "");
	$detail_form->addElement("", $sisa_hidden);
	$nama_barang_text = new Text("dpenerimaan_barang_nama_barang", "dpenerimaan_barang_nama_barang", "");
	if ($limited == "true") {
		$nama_barang_text->setAtribute("disabled='disabled'");
		$detail_form->addElement("Nama Barang", $nama_barang_text);
	} else {
		$nama_barang_text->setClass("smis-one-option-input");
		$barang_browse_button = new Button("", "", "BBM - Non-OPL");
		$barang_browse_button->setClass("btn-info");
		$barang_browse_button->setIsButton(Button::$ICONIC);
		$barang_browse_button->setIcon("fa fa-list");
		$barang_browse_button->setAction("barang.chooser('barang', 'barang', 'barang', barang)");
		$barang_browse_button->setAtribute("id='barang_browse'");
		$barang_input_group = new InputGroup("");
		$barang_input_group->addComponent($nama_barang_text);
		$barang_input_group->addComponent($barang_browse_button);
		$detail_form->addElement("Nama Barang", $barang_input_group);
	}
	$kode_barang_text = new Text("dpenerimaan_barang_kode_barang", "dpenerimaan_barang_kode_barang", "");
	$kode_barang_text->setAtribute("disabled='disabled'");
	$detail_form->addElement("Kode Barang", $kode_barang_text);
	$nama_jenis_barang_text = new Text("dpenerimaan_barang_nama_jenis_barang", "dpenerimaan_barang_nama_jenis_barang", "");
	$nama_jenis_barang_text->setAtribute("disabled='disabled'");
	$detail_form->addElement("Jenis Barang", $nama_jenis_barang_text);
	$jumlah_tercatat_text = new Text("dpenerimaan_barang_jumlah_tercatat", "dpenerimaan_barang_jumlah_tercatat", "");
	if ($limited == "true")
		$jumlah_tercatat_text->setAtribute("disabled='disabled'");
	$detail_form->addElement("Jml. Tercatat", $jumlah_tercatat_text);
	$jumlah_text = new Text("dpenerimaan_barang_jumlah", "dpenerimaan_barang_jumlah", "");
	if ($limited == "true")
		$jumlah_text->setAtribute("disabled='disabled'");
	$detail_form->addElement("Jml. Diterima", $jumlah_text);
	$satuan_text = new Text("dpenerimaan_barang_satuan", "dpenerimaan_barang_satuan", "");
	$satuan_text->setAtribute("disabled='disabled'");
	$detail_form->addElement("Satuan", $satuan_text);
	$konversi_text = new Text("dpenerimaan_barang_konversi", "dpenerimaan_barang_konversi", "");
	$detail_form->addElement("Konversi", $konversi_text);
	$satuan_konversi_text = new Text("dpenerimaan_barang_satuan_konversi", "dpenerimaan_barang_satuan_konversi", "");
	$satuan_konversi_text->setAtribute("disabled='disabled'");
	$detail_form->addElement("Sat. Konversi", $satuan_konversi_text);
	$hna_text = new Text("dpenerimaan_barang_hna", "dpenerimaan_barang_hna", "");
	$hna_text->setTypical("money");
	if ($limited == "true")
		$hna_text->setAtribute("data-thousands='.' data-decimal=',' data-prefix='Rp. '  data-precision='2' disabled='disabled'");
	else
		$hna_text->setAtribute("data-thousands='.' data-decimal=',' data-prefix='Rp. '  data-precision='2'");
	$detail_form->addElement("HNA", $hna_text);
	$hpp_text = new Text("dpenerimaan_barang_hpp", "dpenerimaan_barang_hpp", "");
	$hpp_text->setTypical("money");
	if ($limited == "true")
		$hpp_text->setAtribute("data-thousands='.' data-decimal=',' data-prefix='Rp. '  data-precision='2' disabled='disabled'");
	else
		$hpp_text->setAtribute("data-thousands='.' data-decimal=',' data-prefix='Rp. '  data-precision='2'");
	$detail_form->addElement("HPP", $hpp_text);
	$diskon_text = new Text("dpenerimaan_barang_diskon", "dpenerimaan_barang_diskon", "0,00");
	$diskon_text->setTypical("money");
	$diskon_text->setAtribute("data-thousands='.' data-decimal=',' data-precision='2'");
	$detail_form->addElement("Diskon", $diskon_text);
	$t_diskon_option = new OptionBuilder();
	$t_diskon_option->add("Persen (%)", "persen", "1");
	$t_diskon_option->add("Nominal (Rp.)", "nominal");
	$t_diskon_select = new Select("dpenerimaan_barang_t_diskon", "dpenerimaan_barang_t_diskon", $t_diskon_option->getContent());
	$detail_form->addElement("T. Diskon", $t_diskon_select);
	$produsen_text = new Text("dpenerimaan_barang_produsen", "dpenerimaan_barang_produsen", "");
	if ($limited == "true")
		$produsen_text->setAtribute("disabled='disabled'");
	$detail_form->addElement("Produsen", $produsen_text);
	$tanggal_exp_text = new Text("dpenerimaan_barang_tanggal_exp", "dpenerimaan_barang_tanggal_exp", "");
	if ($limited == "true")
		$tanggal_exp_text->setAtribute("data-date-format='yyyy-mm-dd' disabled='disabled'");
	else
		$tanggal_exp_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$tanggal_exp_text->setClass("mydate");
	$detail_form->addElement("Tgl. Exp.", $tanggal_exp_text);
	$no_batch_text = new Text("dpenerimaan_barang_no_batch", "dpenerimaan_barang_no_batch", "");
	if ($limited == "true")
		$no_batch_text->setAtribute("disabled='disabled'");
	$detail_form->addElement("No. Batch", $no_batch_text);

	$save_button = new Button("", "", "Tambahkan");
	$save_button->setClass("btn-info");
	$save_button->setIsButton(Button::$ICONIC_TEXT);
	$save_button->setIcon("fa fa-chevron-right");
	$save_button->setAction("dpenerimaan_barang.save()");
	$save_button->setAtribute("id='penerimaan_barang_form_save'");

	$update_button = new Button("", "", "Perbarui");
	$update_button->setClass("btn-info");
	$update_button->setIsButton(Button::$ICONIC_TEXT);
	$update_button->setIcon("fa fa-chevron-right");
	$update_button->setAction("dpenerimaan_barang.save()");
	$update_button->setAtribute("id='penerimaan_barang_form_update'");

	$cancel_button = new Button("", "", "Batal");
	$cancel_button->setClass("btn-danger");
	$cancel_button->setIsButton(Button::$ICONIC_TEXT);
	$cancel_button->setIcon("icon-white icon-remove");
	$cancel_button->setAction("dpenerimaan_barang.cancel()");
	$cancel_button->setAtribute("id='penerimaan_barang_form_cancel'");	

	$button_group = new ButtonGroup("");
	$button_group->addButton($update_button);
	$button_group->addButton($cancel_button);

	if ($limited == "false")
		$detail_form->addElement("", $save_button);
	$detail_form->addElement("", $button_group);

	$table = new Table(
		array("No.", "Kode", "Barang", "Jenis", "Stok<sup>*</sup>", "Tercatat", "Diterima", "Satuan", "Jumlah Konversi", "Satuan Konversi", "HNA", "Diskon", "Subtotal", "Ubah", "Hapus"),
		"",
		null,
		true
	);
	$table->setName("dpenerimaan_barang");
	$table->setFooterVisible(false);
	$table->setAction(false);
	
	$button_group = new ButtonGroup("");
	$back_button = new Button("", "", "Kembali");
	$back_button->setClass("btn-inverse");
	$back_button->setIsButton(Button::$ICONIC_TEXT);
	$back_button->setIcon("fa fa-chevron-left");
	$back_button->setAction("penerimaan_barang.back()");
	$back_button->setAtribute("id='penerimaan_barang_back'");
	$button_group->addButton($back_button);
	if ($editable_header == "true") {
		if ($limited == "false") {
			$save_button = new Button("", "", "Simpan Draft");
			$save_button->setClass("btn-success");
			$save_button->setIsButton(Button::$ICONIC_TEXT);
			$save_button->setIcon("fa fa-floppy-o");
			$save_button->setAction("penerimaan_barang.save()");
			$save_button->setAtribute("id='penerimaan_barang_save'");
			$button_group->addButton($save_button);
		} else {
			$save_button = new Button("", "", "Update Info. BBM");
			$save_button->setClass("btn-success");
			$save_button->setIsButton(Button::$ICONIC_TEXT);
			$save_button->setIcon("fa fa-floppy-o");
			$save_button->setAction("penerimaan_barang.update_info_bbm()");
			$save_button->setAtribute("id='penerimaan_barang_update'");
			$button_group->addButton($save_button);
		}
	}

	//get_daftar_vendor_consumer:
	$vendor_table = new Table(
		array("Nama", "NPWP", "Alamat", "No. Telp."),
		"",
		null,
		true
	);
	$vendor_table->setName("vendor");
	$vendor_table->setModel(Table::$SELECT);
	$vendor_adapter = new SimpleAdapter();
	$vendor_adapter->add("Nama", "nama");
	$vendor_adapter->add("NPWP", "npwp");
	$vendor_adapter->add("Alamat", "alamat");
	$vendor_adapter->add("No. Telp.", "telpon");
	$vendor_service_responder = new ServiceResponder(
		$db,
		$vendor_table,
		$vendor_adapter,
		"get_daftar_vendor_non_medis"
	);
	
	//get_daftar_barang_reguler_consumer:
	$barang_table = new Table(
		array("ID", "Barang", "Jenis", "Satuan", "Konversi", "Sat. Konversi"),
		"",
		null,
		true
	);
	$barang_table->setName("barang");
	$barang_table->setModel(Table::$SELECT);
	$barang_adapter = new SimpleAdapter();
	$barang_adapter->add("ID", "id");
	$barang_adapter->add("Barang", "nama");
	$barang_adapter->add("Jenis", "nama_jenis_barang");
	$barang_adapter->add("Satuan", "satuan");
	$barang_adapter->add("Konversi", "konversi", "number");
	$barang_adapter->add("Sat. Konversi", "satuan_konversi");
	$barang_service_responder = new ServiceResponder(
		$db,
		$barang_table,
		$barang_adapter,
		"get_daftar_barang_nm"
	);	
	
	//get stok:
	$stok_table = new Table(array("id_barang", "sisa", "satuan", "konversi", "satuan_konversi"));
	$stok_table->setName("sisa");
	$stok_adapter = new SimpleAdapter();
	$stok_adapter->add("id_barang", "id_barang");
	$stok_adapter->add("sisa", "sisa");
	$stok_adapter->add("satuan", "satuan");
	$stok_adapter->add("konversi", "konversi");
	$stok_adapter->add("satuan_konversi", "satuan_konversi");
	$columns = array("id_barang", "sisa", "satuan", "konversi", "satuan_konversi");
	$stok_dbtable = new DBTable(
		$db,
		"smis_gd_stok_barang",
		$columns
	);
	$stok_dbresponder = new StokDBResponder(
		$stok_dbtable,
		$stok_table,
		$stok_adapter
	);
	
	//get satuan typeahead items:
	$satuan_table = new Table(
		array("Satuan"),
		"",
		null,
		true
	);
	$satuan_table->setName("satuan");
	$satuan_adapter = new SimpleAdapter();
	$satuan_adapter->add("Satuan", "satuan");
	$satuan_dbtable = new DBTable($db, "smis_gd_dbarang_masuk");
	$filter = "";
	if (isset($_POST['kriteria'])) {
		$filter = " AND satuan LIKE '%" . $_POST['kriteria'] . "%' ";
	}
	$query_value = "
		SELECT satuan AS 'id', satuan
		FROM (
			SELECT DISTINCT satuan
			FROM smis_gd_dbarang_masuk
			WHERE prop NOT LIKE 'del' " . $filter . "
		) v_satuan
	";
	$query_count = "
		SELECT COUNT(*)
		FROM (
			SELECT DISTINCT satuan
			FROM smis_gd_dbarang_masuk
			WHERE prop NOT LIKE 'del' " . $filter . "
		) v_satuan
	";
	$satuan_dbtable->setPreferredQuery(true, $query_value, $query_count);
	$satuan_dbresponder = new DBResponder(
		$satuan_dbtable,
		$satuan_table,
		$satuan_adapter
	);
	
	//get produsen typeahead items:
	$produsen_table = new Table(
		array("Produsen"),
		"",
		null,
		true
	);
	$produsen_table->setName("produsen");
	$produsen_adapter = new SimpleAdapter();
	$produsen_adapter->add("Produsen", "produsen");
	$produsen_dbtable = new DBTable($db, "smis_gd_stok_barang");
	$filter = "";
	if (isset($_POST['kriteria'])) {
		$filter = " AND produsen LIKE '%" . $_POST['kriteria'] . "%' ";
	}
	$query_value = "
		SELECT produsen AS 'id', produsen
		FROM (
			SELECT DISTINCT produsen
			FROM smis_gd_stok_barang
			WHERE prop NOT LIKE 'del' " . $filter . "
		) v_produsen
	";
	$query_count = "
		SELECT COUNT(*)
		FROM (
			SELECT DISTINCT produsen
			FROM smis_gd_stok_barang
			WHERE prop NOT LIKE 'del' " . $filter . "
		) v_produsen
	";
	$produsen_dbtable->setPreferredQuery(true, $query_value, $query_count);
	$produsen_dbresponder = new DBResponder(
		$produsen_dbtable,
		$produsen_table,
		$produsen_adapter
	);
	
	$super_command = new SuperCommand();
	$super_command->addResponder("barang", $barang_service_responder);
	$super_command->addResponder("vendor", $vendor_service_responder);
	$super_command->addResponder("stok", $stok_dbresponder);
	$super_command->addResponder("satuan", $satuan_dbresponder);
	$super_command->addResponder("produsen", $produsen_dbresponder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "show_detail") {
			$id = $_POST['id'];
			$limited = isset($_POST['limited']) ? $_POST['limited'] : "false";
			$dbtable = new DBTable($db, "smis_gd_barang_masuk");
			$header_row = $dbtable->select($id);
			$detail_rows = $dbtable->get_result("
				SELECT a.*, b.produsen, b.tanggal_exp, b.no_batch
				FROM smis_gd_dbarang_masuk a LEFT JOIN smis_gd_stok_barang b ON a.id = b.id_dbarang_masuk
				WHERE a.id_barang_masuk = '" . $id . "' AND a.prop NOT LIKE 'del'
			");
			$locked = isset($_POST['locked']) ? $_POST['locked'] : false;
			$html = "";
			$num = 0;
			if ($detail_rows != null) {
				foreach ($detail_rows as $row) {
					$html_edit_action = "";
					if ($limited == "true")
						$html_edit_action = "<a href='#' onclick='dpenerimaan_barang.edit(" . $num . ")' class='input btn btn-warning'><i class='fa fa-pencil'></i></a>";
					$html_del_action = "";
					$subtotal = $row->hna * $row->jumlah;
					$hpp = $row->hna;
					$f_diskon = $row->diskon . " %";
					if ($row->t_diskon == "nominal") {
						$f_diskon = ArrayAdapter::format("only-money", $row->diskon);
						$subtotal = $subtotal - $row->diskon;
					} else {
						$subtotal = $subtotal - ($row->diskon * $subtotal) / 100;
					}
					$subtotal = round($subtotal);
					$f_subtotal = ArrayAdapter::format("money", $subtotal);
					$html .= "
						<tr id='data_" . $num . "'>
							<td id='nomor'></td>
							<td id='id' style='display: none;'>" . $row->id . "</td>
							<td id='id_dpo' style='display: none;'>" . $row->id_dpo . "</td>
							<td id='id_barang' style='display: none;'>" . $row->id_barang . "</td>
							<td id='kode_barang'><small>" . $row->kode_barang . "</small></td>
							<td id='nama_barang'><small>" . $row->nama_barang . "</small></td>
							<td id='nama_jenis_barang'><small>" . $row->nama_jenis_barang . "</small></td>
							<td id='stok_entri' style='display: none;'>" . $row->stok_entri . "</td>
							<td id='f_stok_entri'><small>" . $row->stok_entri . "</small></td>
							<td id='jumlah_tercatat' style='display: none;'>" . $row->jumlah_tercatat . "</td>
							<td id='f_jumlah_tercatat'><small>" . $row->jumlah_tercatat . "</small></td>
							<td id='jumlah' style='display: none;'>" . $row->jumlah . "</td>
							<td id='f_jumlah'><small>" . $row->jumlah . "</small></td>
							<td id='satuan'><small>" . $row->satuan . "</small></td>
							<td id='konversi'>" . $row->konversi . "</td>
							<td id='satuan_konversi'>" . $row->satuan_konversi . "</td>
							<td id='hna' style='display: none;'>" . $row->hna . "</td>
							<td id='hpp' style='display: none;'>" . $hpp . "</td>
							<td id='f_hna'><small>" . ArrayAdapter::format("money", $hpp) . "</small></td>
							<td id='diskon' style='display: none;'>" . $row->diskon . "</td>
							<td id='t_diskon' style='display: none;'>" . $row->t_diskon . "</td>
							<td id='f_diskon'><small><div align='right'>" . $f_diskon . "</div></small></td>
							<td id='subtotal' style='display: none;'>" . $subtotal . "</td>
							<td id='f_subtotal'><small>" . $f_subtotal . "</small></td>
							<td id='produsen' style='display: none;'>" . $row->produsen . "</td>
							<td id='tanggal_exp' style='display: none;'>" . $row->tanggal_exp . "</td>
							<td id='no_batch' style='display: none;'>" . $row->no_batch . "</td>
							<td>" . $html_edit_action . "</td>
							<td>" . $html_del_action . "</td>
						</tr>";
					$num++;
				}
			}
			$data = array();
			$data['html'] = $html;
			$data['row_num'] = $num;
			echo json_encode($data);
		} else if ($_POST['command'] == "show_footer") {
			$html = "<tfoot>
						<tr>
							<td colspan='12'><div align='right'><small><strong>Total</strong></small></div></td>
							<td id='total'></td>
							<td colspan='2'>&nbsp;</td>
						</tr>
						<tr>
							<td colspan='12'><div align='right'><small><strong>Diskon</strong></small></div></td>
							<td id='diskon_global'></td>
							<td colspan='2'>&nbsp;</td>
						</tr>
						<tr style='display: none;'>
							<td colspan='12'><div align='right'><small><strong>Total II</strong></small></div></td>
							<td id='total_2'></td>
							<td colspan='2'>&nbsp;</td>
						</tr>
						<tr>
							<td colspan='12'><div align='right'><small><strong>PPn</strong></small></div></td>
							<td id='ppn'></td>
							<td colspan='2'>&nbsp;</td>
						</tr>
						<tr>
							<td colspan='12'><div align='right'><small><strong>Jumlah Tagihan</strong></small></div></td>
							<td id='tagihan'></td>
							<td colspan='2'>&nbsp;</td>
						</tr>
					</tfoot>
			";
			$data = array();
			$data['html'] = $html;
			echo json_encode($data);
		} else if ($_POST['command'] == "get_last_item") {
			$id_barang = $_POST['id_barang'];
			$dbtable = new DBTable($db, "smis_gd_dbarang_masuk");
			$row = $dbtable->get_row("
				SELECT *
				FROM smis_gd_dbarang_masuk
				WHERE id_barang = '" . $id_barang . "'
				ORDER BY id DESC
				LIMIT 0, 1
			");
			$data = array(
				"data"	=> $row
			);
			echo json_encode($data);
		} else {
			$adapter = new SimpleAdapter();
			$dbtable = new DBTable($db, "smis_gd_barang_masuk");
			$dbresponder = new BarangMasukDBResponder(
				$dbtable,
				$table,
				$adapter
			);
			if ($dbresponder->isSave() && ($_POST['id'] == 0 || $_POST['id'] == "")) {
				$no_bbm = getSettings($db, "no_bbm", 0) + 1;
				setSettings($db, "no_bbm", $no_bbm);
			}
			$data = $dbresponder->command($_POST['command']);
			echo json_encode($data);
		}
		return;
	}

	echo $header_form->getHtml();
	echo "<div id='table_content'>" .
			 "<div class='row-fluid'>";
	if ($editable_detail == "true") {
		echo	 "<div class='span4'>" .
					 $detail_form->getHtml() .
				 "</div>" .
				 "<div class='span8'>" .
					 $table->getHtml() .
					 "<div align='right'>" . $button_group->getHtml() . "</div>" .
				 "</div>";
	} else {
		echo	 "<div class='span12'>" .
					 $table->getHtml() .
					 "<div align='right'>" . $button_group->getHtml() . "</div>" .
				 "</div>";
	}
	echo 	 "</div>" .
		 "</div>";
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
	echo addJS("gudang_umum/js/penerimaan_barang_vendor_action.js", false);
	echo addJS("gudang_umum/js/penerimaan_barang_barang_action.js", false);
	echo addJS("gudang_umum/js/dpenerimaan_barang_non_opl_action.js", false);
	echo addJS("gudang_umum/js/penerimaan_barang_action.js", false);
	echo addJS("gudang_umum/js/penerimaan_barang_non_opl_form.js", false);
?>