<?php
	require_once("smis-base/smis-include-service-consumer.php");
	require_once("gudang_umum/table/BarangMasukTable.php");
	require_once("gudang_umum/responder/BarangMasukDBResponder.php");
	global $db;

	$table = new BarangMasukTable(
		array("No.", "No. BBM", "No. OPL", "No. Faktur", "Tgl. Faktur", "Rekanan", "Klinik", "Tgl. Diterima", "Jatuh Tempo"),
		"Gudang Umum : Penerimaan Barang (BBM - OPL)",
		null,
		true
	);
	$table->setName("penerimaan_barang");

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "export_xls") {
			require_once("smis-libs-out/php-excel/PHPExcel.php");
			$id = $_POST['id'];
			$objPHPExcel = PHPExcel_IOFactory::load("gudang_umum/templates/template_au-53.xlsx");
			$objPHPExcel->setActiveSheetIndexByName("AU-53.K");
			$objWorksheet = $objPHPExcel->getActiveSheet();
			$dbtable = new DBTable($db, "smis_gd_barang_masuk");
			$header_info = $dbtable->get_row("
				SELECT *
				FROM smis_gd_barang_masuk
				WHERE id = '" . $id . "'
			");
			$objWorksheet->setCellValue("F4", ": " . $header_info->nama_vendor);
			$objWorksheet->setCellValue("O2", ": " . $header_info->no_opl);
			$objWorksheet->setCellValue("O3", ": " . $header_info->no_faktur);
			$objWorksheet->setCellValue("O4", ": " . $header_info->no_bbm);
			$objWorksheet->setCellValue("O5", ": " . ArrayAdapter::format("date d-m-Y", $header_info->tanggal));

			global $user;
			$nama_petugas_gudang = $user->getNameOnly(); // getSettings($db, "bbm-nama_petugas_gudang", "PETUGAS GUDANG");
			$nama_manajer_umum = "MANAJER UMUM";
			$nama_verifikator = "VERIFIKATOR";
			for ($i = 27; $i <= 270; $i += 27) {
				$objWorksheet->setCellValue("B" . $i, "(" . $nama_manajer_umum . ")");
				$objWorksheet->setCellValue("G" . $i, "(" . $nama_verifikator . ")");
				$objWorksheet->setCellValue("K" . $i, "(" . $nama_petugas_gudang . ")");
				$objWorksheet->setCellValue("N" . $i, "(" . $nama_petugas_gudang . ")");
			}

			$detail_info = $dbtable->get_result("
				SELECT a.*, b.tanggal_exp
				FROM smis_gd_dbarang_masuk a LEFT JOIN smis_gd_stok_barang b ON a.id = b.id_dbarang_masuk
				WHERE a.id_barang_masuk = '" . $id . "' AND a.prop NOT LIKE 'del'
			");
			
			$jumlah_item = count($detail_info);
			$jumlah_item_per_halaman = 10;
			$jumlah_halaman = ceil($jumlah_item / $jumlah_item_per_halaman);
			$start_row_index = 1;
			$end_row_index = 27;
			$value_index_incr = 27;

			$cur_item_index = 0;
			$print_area_str = "";
			$total = 0;
			for ($cur_page = 1; $cur_page <= $jumlah_halaman; $cur_page++) {
				$cur_row_index = ($start_row_index + 8) + ($cur_page - 1) * $value_index_incr;
				$start_print_area = $start_row_index + $value_index_incr * ($cur_page - 1);
				$end_print_area = $end_row_index + $value_index_incr * ($cur_page - 1);
				$print_area_str .= "A" . $start_print_area . ":N" . $end_print_area . ",";
				for ($cur_item_num = 1; $cur_item_num <= $jumlah_item_per_halaman && $cur_item_index < $jumlah_item; $cur_item_num++) {
					$objWorksheet->setCellValue("A" . $cur_row_index, $detail_info[$cur_item_index]->kode_barang);
					$objWorksheet->setCellValue("B" . $cur_row_index, $detail_info[$cur_item_index]->nama_barang);
					$objWorksheet->setCellValue("D" . $cur_row_index, $detail_info[$cur_item_index]->satuan);
					$objWorksheet->setCellValue("E" . $cur_row_index, "@" . $detail_info[$cur_item_index]->konversi . " " . $detail_info[$cur_item_index]->satuan_konversi);
					$objWorksheet->setCellValue("F" . $cur_row_index, $detail_info[$cur_item_index]->jumlah_tercatat);
					// $objWorksheet->getStyle("F" . $cur_row_index)->getNumberFormat()->setFormatCode("#,##0");
					$objWorksheet->setCellValue("G" . $cur_row_index, $detail_info[$cur_item_index]->jumlah);
					// $objWorksheet->getStyle("G" . $cur_row_index)->getNumberFormat()->setFormatCode("#,##0");
					$objWorksheet->setCellValue("H" . $cur_row_index, $detail_info[$cur_item_index]->jumlah - $detail_info[$cur_item_index]->jumlah_tercatat);
					// $objWorksheet->getStyle("H" . $cur_row_index)->getNumberFormat()->setFormatCode("#,##0");
					$objWorksheet->setCellValue("I" . $cur_row_index, $detail_info[$cur_item_index]->stok_entri + ($detail_info[$cur_item_index]->jumlah * $detail_info[$cur_item_index]->konversi));
					// $objWorksheet->getStyle("I" . $cur_row_index)->getNumberFormat()->setFormatCode("#,##0");
					$objWorksheet->setCellValue("J" . $cur_row_index, "");
					$tanggal_exp = "-";
					if ($detail_info[$cur_item_index]->tanggal_exp != "0000-00-00")
						$tanggal_exp = ArrayAdapter::format("date d-m-Y", $detail_info[$cur_item_index]->tanggal_exp);
					$objWorksheet->setCellValue("K" . $cur_row_index, $tanggal_exp);
					$hna_barang = ($detail_info[$cur_item_index]->hna / 1.1) * $detail_info[$cur_item_index]->jumlah;
					if ($header_info->use_ppn == 0)
						$hna_barang = $detail_info[$cur_item_index]->hna * $detail_info[$cur_item_index]->jumlah;
					$diskon = $detail_info[$cur_item_index]->diskon;
					if ($detail_info[$cur_item_index]->t_diskon == "persen")
						$diskon = $hna_barang * $detail_info[$cur_item_index]->diskon / 100;
					if ($header_info->use_ppn == 1)
						$objWorksheet->setCellValue("L" . $cur_row_index, ($detail_info[$cur_item_index]->hna / 1.1));
					else
						$objWorksheet->setCellValue("L" . $cur_row_index, $detail_info[$cur_item_index]->hna);
					$objWorksheet->getStyle("L" . $cur_row_index)->getNumberFormat()->setFormatCode("#,##0.00");
					$objWorksheet->setCellValue("M" . $cur_row_index, $diskon);
					$objWorksheet->getStyle("M" . $cur_row_index)->getNumberFormat()->setFormatCode("#,##0.00");
					$objWorksheet->setCellValue("N" . $cur_row_index, "=ROUND(" . $hna_barang . "-" . $diskon . ", 0)");
					$objWorksheet->getStyle("N" . $cur_row_index)->getNumberFormat()->setFormatCode("#,##0.00");
					$total += ($hna_barang - $diskon);
					$cur_item_index++;
					$cur_row_index++;
				}
			}
			$objWorksheet->setCellValue("N19", "=FLOOR(" . $total . ", 1)");
			if ($header_info->use_ppn == 0)
				$objWorksheet->setCellValue("N20", 0);
			else
				$objWorksheet->setCellValue("N20", floor($total * 0.1));
			$objWorksheet->getPageSetup()->setPrintArea(rtrim($print_area_str, ","));
			
			header("Content-type: application/vnd.ms-excel");	
			header("Content-Disposition: attachment; filename=AU_53-OPL_" . $header_info->no_opl . "-BBM_" . $header_info->no_bbm . ".xlsx");
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objWriter->save("php://output");
			return;
		}
		$adapter = new SimpleAdapter(true, "No.");
		$adapter->add("No. BBM", "no_bbm");
		$adapter->add("No. OPL", "no_opl");
		$adapter->add("No. Faktur", "no_faktur");
		$adapter->add("Tgl. Faktur", "tanggal", "date d-m-Y");
		$adapter->add("Rekanan", "nama_vendor");
		$adapter->add("Klinik", "nama_klinik");
		$adapter->add("Tgl. Diterima", "tanggal_datang", "date d-m-Y");
		$adapter->add("Jatuh Tempo", "tanggal_tempo", "date d-m-Y");
		$dbtable = new DBTable($db, "smis_gd_barang_masuk");
		$dbtable->addCustomKriteria(" id ", " <> 0 ");
		$dbtable->setOrder(" id DESC ");
		$dbresponder = new BarangMasukDBResponder(
			$dbtable,
			$table,
			$adapter
		);
		$data = $dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}

	echo $table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("gudang_umum/js/penerimaan_barang_action.js", false);
	echo addJS("gudang_umum/js/penerimaan_barang.js", false);
?>