<?php
	global $db;

	$inventaris_table = new Table(
		array("Nomor", "Kode", "Jenis", "Barang", "No. BBM", "Merk", "Harga", "Tahun Perolehan", "Penyusutan", "Kondisi"),
		"",
		null,
		true
	);
	$inventaris_table->setName("inventaris");
	$inventaris_table->setModel(Table::$SELECT);
	$inventaris_adapter = new SimpleAdapter();
	$inventaris_adapter->add("Nomor", "id", "digit6");
	$inventaris_adapter->add("Kode", "kode");
	$inventaris_adapter->add("Jenis", "medis", "trivial_1_Medis_Non-Medis");
	$inventaris_adapter->add("Barang", "nama_barang");
	$inventaris_adapter->add("No. BBM", "no_bbm");
	$inventaris_adapter->add("Merk", "merk");
	$inventaris_adapter->add("Harga", "hna", "money");
	$inventaris_adapter->add("Tahun Perolehan", "tahun_perolehan");
	$inventaris_adapter->add("Penyusutan", "usia_penyusutan", "back Tahun");
	$inventaris_adapter->add("Kondisi", "kondisi_baik", "trivial_1_Baik_Rusak");
	$inventaris_dbtable = new DBTable($db, "smis_gd_inventaris");
	$inventaris_dbtable->setViewForSelect(true);
	$filter = "";
	if (isset($_POST['kriteria'])) {
		$filter = "
			AND (			
				a.kode LIKE '%" . $_POST['kriteria'] . "%' OR
				a.nama_barang LIKE '%" . $_POST['kriteria'] . "%' OR
				c.no_bbm LIKE '%" . $_POST['kriteria'] . "%' OR
				a.merk LIKE '%" . $_POST['kriteria'] . "%'
			)
		";
	}
	$query_value = "
		SELECT
			a.*, c.no_bbm
		FROM
			smis_gd_inventaris a
				INNER JOIN smis_gd_dbarang_masuk b ON a.id_dbarang_masuk = b.id
				INNER JOIN smis_gd_barang_masuk c ON b.id_barang_masuk = c.id
		WHERE
			a.prop LIKE ''
			 	AND a.kondisi_baik = 0
			 	AND a.tipe = ''
			 	AND a.unit = ''
				" . $filter . "
	";
	$query_count = "
		SELECT
			COUNT(*)
		FROM
			(" . $query_value . ") v
	";
	$inventaris_dbtable->setPreferredQuery(true, $query_value, $query_count);
	require_once("gudang_umum/responder/InventarisDBResponder.php");
	$inventaris_dbresponder = new InventarisDBResponder(
		$inventaris_dbtable,
		$inventaris_table,
		$inventaris_adapter
	);
	$super_command = new SuperCommand();
	$super_command->addResponder("inventaris", $inventaris_dbresponder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}

	$table = new Table(
		array("Nomor", "Tanggal", "Kode Barang", "Nama Barang", "Jenis", "Merk", "Kondisi"),
		"Gudang Umum : Pemusnahan Barang Inventaris",
		null,
		true
	);
	$table->setReloadButtonEnable(false);
	$table->setPrintButtonEnable(false);
	$table->setEditButtonEnable(false);
	$table->setDelButtonEnable(false);
	$table->setName("pemusnahan_inventaris");
	$button = new Button("", "", "Lihat");
    $button->setClass("btn-success");
    $button->setIsButton(Button::$ICONIC);
    $button->setIcon("icon-eye-open icon-white");
    $table->addContentButton("detail", $button);
    $button = new Button("", "", "Hapus");
    $button->setClass("btn-danger");
    $button->setIsButton(Button::$ICONIC);
    $button->setIcon("fa fa-times");
    $table->addContentButton("del", $button);

	if (isset($_POST['command'])) {
		$adapter = new SimpleAdapter();
		$adapter->add("Nomor", "id", "digit6");
		$adapter->add("Tanggal", "tanggal_pemusnahan", "date d-m-Y");
		$adapter->add("Kode Barang", "kode");
		$adapter->add("Nama Barang", "nama_barang");
		$adapter->add("Jenis", "medis", "trivial_1_Medis_Non-Medis");
		$adapter->add("Merk", "merk");
		$adapter->add("Kondisi", "kondisi_baik", "trivial_1_Baik_Rusak");
		$columns = array("id", "tipe", "tanggal_pemusnahan", "keterangan_pemusnahan", "user_pemusnahan");
		$dbtable = new DBTable($db, "smis_gd_inventaris", $columns);
		$dbtable->addCustomKriteria(" tipe ", " = 'musnah' ");
		$dbresponder = new DBResponder(
			$dbtable,
			$table,
			$adapter
		);
		if ($dbresponder->isSave()) {
			global $user;
			$dbresponder->addColumnFixValue("user_pemusnahan", $user->getNameOnly());
			$dbresponder->addColumnFixValue("tipe", "musnah");
		} else if ($dbresponder->isDel()) {
			$_POST['command'] = "save";
			$dbresponder->addColumnFixValue("tipe", "");
			$dbresponder->addColumnFixValue("user_pemusnahan", "");
			$dbresponder->addColumnFixValue("tanggal_pemusnahan", "");
			$dbresponder->addColumnFixValue("keterangan_pemusnahan", "");
		}
		$data = $dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}

	$table->addModal("id", "hidden", "", "", "n");
	$table->addModal("tanggal_pemusnahan", "date", "Tanggal", "", "n");
	$table->addModal("nama_barang", "chooser-pemusnahan_inventaris-inventaris-Data Inventaris Rusak", "Barang", "", "n", null, true);
	$table->addModal("kode", "text", "Kode", "", "n", null, true);
	$medis_option = new OptionBuilder();
	$medis_option->add("", "", "1");
	$medis_option->add("Medis", "1");
	$medis_option->add("Non-Medis", "0");
	$table->addModal("medis", "select", "Jenis", $medis_option->getContent(), "n", null, true);
	$table->addModal("merk", "text", "Merk", "", "n", null, true);
	$table->addModal("hna", "text", "Harga", "", "n", "money", true);
	$table->addModal("tahun_perolehan", "text", "Thn. Perolehan", "", "n", null, true);
	$kondisi_baik_option = new OptionBuilder();
	$kondisi_baik_option->add("", "", "1");
	$kondisi_baik_option->add("Baik", "1");
	$kondisi_baik_option->add("Rusak", "0");
	$table->addModal("kondisi_baik", "select", "Kondisi", $kondisi_baik_option->getContent(), "n", null, true);
	$table->addModal("keterangan_pemusnahan", "textarea", "Keterangan", "", "n");
	$modal = $table->getModal();
	$modal->setTitle("Data Pemusnahan Inventaris");
	$ok_button = new Button("", "", "OK");
	$ok_button->setAtribute("id='pemusnahan_inventaris_ok'");
    $ok_button->setClass("btn-inverse");
    $ok_button->setAction("$($(this).data('target')).smodal('hide')");
    $modal->addFooter($ok_button);

	echo $modal->getHtml();
	echo $table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
	var pemusnahan_inventaris;
	var inventaris;
	$(document).ready(function() {
		$(".mydate").datepicker();
		$("#smis-chooser-modal").on("show", function() {
			$("#smis-chooser-modal").removeClass("half_model");
			$("#smis-chooser-modal").removeClass("full_model");
			$("#smis-chooser-modal").addClass("full_model");
		});
		inventaris = new TableAction(
			"inventaris",
			"gudang_umum",
			"pemusnahan_inventaris",
			new Array()
		);
		inventaris.selected = function(json) {
			$("#pemusnahan_inventaris_id").val(json.id);
			$("#pemusnahan_inventaris_nama_barang").val(json.nama_barang);
			$("#pemusnahan_inventaris_kode").val(json.kode);
			$("#pemusnahan_inventaris_medis").val(json.medis);
			$("#pemusnahan_inventaris_merk").val(json.merk);
			$("#pemusnahan_inventaris_hna").val(json.hna);
			$("#pemusnahan_inventaris_tahun_perolehan").val(json.tahun_perolehan);
			$("#pemusnahan_inventaris_kondisi_baik").val(json.kondisi_baik);
		};
		inventaris.setSuperCommand("inventaris");
		pemusnahan_inventaris = new TableAction(
			"pemusnahan_inventaris",
			"gudang_umum",
			"pemusnahan_inventaris",
			new Array(
				'id',
				'tanggal_pemusnahan',
				'nama_barang',
				'kode',
				'medis',
				'merk',
				'hna',
				'tahun_perolehan',
				'kondisi_baik',
				'keterangan_pemusnahan'
			)
		);
		pemusnahan_inventaris.show_add_form = function() {
			TableAction.prototype.show_add_form.call(this);
			$("#pemusnahan_inventaris_nama_barang").removeClass("smis-one-option-input");
			$("#pemusnahan_inventaris_nama_barang").addClass("smis-one-option-input");
			$("#pemusnahan_inventaris_chooser_nama_barang").show();
			$("#pemusnahan_inventaris_tanggal_pemusnahan").removeAttr("disabled");
			$("#pemusnahan_inventaris_keterangan_pemusnahan").removeAttr("disabled");
			$("#pemusnahan_inventaris_save").show();
			$("#pemusnahan_inventaris_ok").hide();
		};
		pemusnahan_inventaris.detail = function(id) {
			TableAction.prototype.edit.call(this, id);
			$("#pemusnahan_inventaris_nama_barang").removeClass("smis-one-option-input");
			$("#pemusnahan_inventaris_chooser_nama_barang").hide();
			$("#pemusnahan_inventaris_tanggal_pemusnahan").removeAttr("disabled");
			$("#pemusnahan_inventaris_tanggal_pemusnahan").attr("disabled", "disabled");
			$("#pemusnahan_inventaris_keterangan_pemusnahan").removeAttr("disabled");
			$("#pemusnahan_inventaris_keterangan_pemusnahan").attr("disabled", "disabled");
			$("#pemusnahan_inventaris_save").hide();
			$("#pemusnahan_inventaris_ok").show();
		};
		pemusnahan_inventaris.view();
	});
</script>