<?php
global $db;

$lso_table = new Table(
	array("Jenis Barang", "Jumlah", "Total H. Netto"),
	"Gudang Umum : Laporan Rekap Perbekalan Barang",
	null,
	true
);
$lso_table->setName("lso");
$lso_table->setPrintButtonEnable(false);
$lso_table->setAddButtonEnable(false);
$lso_table->setEditButtonEnable(false);
$lso_table->setDelButtonEnable(false);
$download_button = new Button("", "", "Eksport XLS");
$download_button->setClass("btn-inverse");
$download_button->setIcon("fa fa-download");
$download_button->setIsButton(Button::$ICONIC);
$download_button->setAction("lso.export_xls()");
$lso_table->addHeaderButton($download_button);

if (isset($_POST['command'])) {
	if ($_POST['command'] == "export_xls") {
		$data = $db->get_result("
			SELECT nama_jenis_barang, SUM(sisa) AS 'jumlah', SUM(sisa * hna) AS 'total_hna'
			FROM smis_gd_stok_barang
			WHERE prop NOT LIKE 'del'
			GROUP BY nama_jenis_barang
			ORDER BY nama_jenis_barang
		");
		$last_column = "C";

		require_once("smis-libs-out/php-excel/PHPExcel.php");

		$file = new PHPExcel();
		$sheet = $file->getActiveSheet();
		$sheet->setTitle("Rekap Perbekalan Barang");
		$i = 1;

		$sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Laporan Rekap Perbekalan Barang");
		$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$sheet->getStyle("A" . $i)->getFont()->setBold(true);
		$i = $i + 1;
		$sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, getSettings($db, "smis_autonomous_title", ""));
		$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$sheet->getStyle("A" . $i)->getFont()->setBold(true);
		$i = $i + 2;

		$border_start = $i;
		$col = 65;
		$sheet->setCellValue(chr($col) . $i, "Jenis Barang");
		$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Jenis Barang") + 10);
		$col++;
		$sheet->setCellValue(chr($col) . $i, "Jumlah");
		$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Jumlah") + 30);
		$col++;
		$sheet->setCellValue(chr($col) . $i, "Total H. Netto");
		$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Total H. Netto") + 25);
		$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getFont()->setBold(true);
		$i = $i + 1;

		if ($data != null) {
			foreach ($data as $d) {
				$sheet->setCellValue("A" . $i, $d->nama_jenis_barang);
				$sheet->setCellValue("B" . $i, $d->jumlah);
				$sheet->setCellValue("C" . $i, $d->total_hna);
				$sheet->getStyle('B' . $i)->getNumberFormat()->setFormatCode('#,##0');
				$sheet->getStyle("B" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
				$sheet->getStyle('C' . $i)->getNumberFormat()->setFormatCode('#,##0');
				$sheet->getStyle("C" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
				$i = $i + 1;
			}
		}

		$thin = array();
		$thin['borders'] = array();
		$thin['borders']['allborders'] = array();
		$thin['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
		$sheet->getStyle("A" . $border_start . ":" . $last_column . ($i - 1))->applyFromArray($thin);

		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Laporan Rekap Perbekalan Barang - ' . ArrayAdapter::format("date Ymd",date("Y-m-d")) . '.xls"');
		header('Cache-Control: max-age=0');
		$writer = PHPExcel_IOFactory::createWriter($file, 'Excel5');
		$writer->save('php://output');
		return;
	}
	class LLSOAdapter extends ArrayAdapter {
		public function adapt($row) {
			$array = array();
			$array['id'] = "";
			$array['Jenis Barang'] = $row->nama_jenis_barang;
			$array['Jumlah'] = self::format("number", $row->jumlah);
			$array['Total H. Netto'] = self::format("money Rp. ", $row->total_hna);
			return $array;
		}
	}
	$lso_adapter = new LLSOAdapter();
	$lso_dbtable = new DBTable($db, "smis_gd_stok_barang");
	$filter = "1";
	if (isset($_POST['kriteria'])) {
		$filter .= " AND (nama_jenis_barang LIKE '%" . $_POST['kriteria'] . "%') ";
	}
	$query_value = "
			SELECT *
			FROM (
				SELECT nama_jenis_barang, SUM(sisa) AS 'jumlah', SUM(sisa * hna) AS 'total_hna'
				FROM smis_gd_stok_barang
				WHERE prop NOT LIKE 'del'
				GROUP BY nama_jenis_barang
			) v_lso
			WHERE " . $filter . "
			ORDER BY nama_jenis_barang ASC
		";
	$query_count = "
			SELECT COUNT(*)
			FROM (
				SELECT nama_jenis_barang, SUM(sisa) AS 'jumlah', SUM(sisa * hna) AS 'total_hna'
				FROM smis_gd_stok_barang
				WHERE prop NOT LIKE 'del'
				GROUP BY nama_jenis_barang
			) v_lso
			WHERE " . $filter . "
			ORDER BY nama_jenis_barang ASC
		";
	$lso_dbtable->setPreferredQuery(true, $query_value, $query_count);
	class LLSODBResponder extends DBResponder
	{
		public function command($command)
		{
			if ($command != "print_laporan") {
				return parent::command($command);
			}
			$pack = new ResponsePackage();
			if ($command == "print_laporan") {
				$content = $this->print_report();
				$pack->setContent($content);
				$pack->setStatus(ResponsePackage::$STATUS_OK);
			}
			return $pack->getPackage();
		}
		public function print_report()
		{
			$data = $this->dbtable->get_result("
					SELECT *
					FROM (
						SELECT nama_jenis_barang, SUM(sisa) AS 'jumlah', SUM(sisa * hna) AS 'total_hna'
						FROM smis_gd_stok_barang
						WHERE prop NOT LIKE 'del'
						GROUP BY nama_jenis_barang
					) v_lso
					ORDER BY nama_jenis_barang ASC
				");
			$print_data = "";
			$print_data .= "<center><strong>LAPORAN REKAPITULASI PERBEKALAN BARANG GUDANG UMUM</strong></center><br/>";
			$print_data .= "Periode : " . ArrayAdapter::format("date d M Y", date("Y-m-d"));
			$print_data .= "<table border='1'>
									<tr>
										<th>No.</th>
										<th>Jenis Barang</th>
										<th>Jumlah</th>
										<th>Total Harga Netto</th>
									</tr>";
			$total_jumlah = 0;
			$total_netto = 0;
			if (count($data) > 0) {
				$no = 1;
				foreach ($data as $d) {
					$tanggal_part = explode(" ", $d->tanggal);
					$time_part = explode(":", $tanggal_part[1]);
					$print_data .= "<tr>
											<td>" . $no++ . "</td>
											<td>" . $d->nama_jenis_barang . "</td>
											<td>" . ArrayAdapter::format("number", $d->jumlah) . "</td>
											<td>" . ArrayAdapter::format("money Rp. ", $d->total_hna) . "</td>
										</tr>";
					$total_jumlah += $d->jumlah;
					$total_netto += $d->total_hna;
				}
			} else {
				$print_data .= "<tr>
										<td colspan='4' align='center'><i>Tidak terdapat data stok barang</i></td>
									</tr>";
			}
			$print_data .= "<tr>
									<td colspan='2' align='center'><b>T O T A L</b></td>
									<td><b>" . ArrayAdapter::format("number", $total_jumlah) . "</b></td>
									<td><b>" . ArrayAdapter::format("money Rp. ", $total_netto) . "</b></td>
								</tr>";
			$print_data .= "</table><br/>";
			global $user;
			$print_data .= "<table border='0' align='center' class='united'>
									<tr>
										<td colspan='3' align='center'>Mengetahui :</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td align='center'>Jember, " . ArrayAdapter::format("date d M Y", date("Y-m-d")) . "</td>
										<td>&Tab;</td>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td align='center'>KAUR. GUDANG NON OBAT</td>
										<td>&Tab;</td>
										<td align='center'>PETUGAS GUDANG UMUM</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
										<td>&Tab;</td>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
										<td>&Tab;</td>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
										<td>&Tab;</td>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
										<td>&Tab;</td>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td align='center'><b>Suharyanto</b></td>
										<td>&Tab;</td>
										<td align='center'><b>" . $user->getNameOnly() . "</b></td>
									</tr>
								</table>";
			return $print_data;
		}
	}
	$lso_dbresponder = new LLSODBResponder(
		$lso_dbtable,
		$lso_table,
		$lso_adapter
	);
	$data = $lso_dbresponder->command($_POST['command']);
	echo json_encode($data);
	return;
}

echo $lso_table->getHtml();
echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	function LLSOAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LLSOAction.prototype.constructor = LLSOAction;
	LLSOAction.prototype = new TableAction();
	LLSOAction.prototype.export_xls = function() {
		var data = this.getRegulerData();
		data['command'] = "export_xls";
		postForm(data);
	};

	var lso;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		lso = new LLSOAction(
			"lso",
			"gudang_umum",
			"laporan_rekap_perbekalan_barang",
			new Array()
		)
	});
</script>