<?php
	require_once("gudang_umum/kelas/GudangUmumInventory.php");
	global $db;

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "get_jumlah") {
			$jumlah = $db->get_var("
				SELECT
					COUNT(*) jumlah
				FROM
					smis_gd_barang_keluar
				WHERE
					prop LIKE ''
						AND status NOT LIKE 'dibatalkan'
						AND tanggal >= '" . $_POST['tanggal_from'] . "'
						AND tanggal <= '" . $_POST['tanggal_to'] . "'
			");
			$data = array();
			$data['jumlah'] = $jumlah;
			echo json_encode($data);
		} else if ($_POST['command'] == "get_info") {
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$num = $_POST['num'];
			
			$data_header = $db->get_row("
				SELECT
					*
				FROM
					smis_gd_barang_keluar
				WHERE
					prop LIKE ''
						AND status NOT LIKE 'dibatalkan'
						AND tanggal >= '" . $_POST['tanggal_from'] . "'
						AND tanggal <= '" . $_POST['tanggal_to'] . "'
				LIMIT
					" . $num . ", 1
			");

			$nomor_mutasi = $data_header->id;
			$tanggal = ArrayAdapter::format("date d-m-Y", $data_header->tanggal);
			$ruangan = ArrayAdapter::format("unslug", $data_header->unit);
			$status = ArrayAdapter::format("unslug", $data_header->status);

			$details = $db->get_result("
				SELECT
					d.id_barang, b.kode_barang, b.nama_barang, a.jumlah, b.satuan, b.tanggal_exp, d.diskon, d.t_diskon
				FROM
					smis_gd_stok_barang_keluar a
						INNER JOIN smis_gd_stok_barang b ON a.id_stok_barang = b.id
						INNER JOIN smis_gd_dbarang_keluar c ON a.id_dbarang_keluar = c.id
						INNER JOIN smis_gd_dbarang_masuk d ON b.id_dbarang_masuk = d.id
				WHERE
					c.id_barang_keluar = '" . $data_header->id . "'
						AND a.jumlah > 0
						AND a.prop LIKE ''
						AND c.prop LIKE ''
			");

			$html = "";
			
			if ($details != null) {
				foreach ($details as $d) {
					$id_barang = $d->id_barang;
					$nama_barang = $d->nama_barang;
					$jumlah = $d->jumlah;
					$satuan = $d->satuan;
					$hpp = GudangUmumInventory::getStockValue($db, $id_barang, $data_header->tanggal);
					$f_hpp = $hpp == 0 ? "0,00" : ArrayAdapter::format("only-money", $hpp);
					$f_diskon = $d->t_diskon == "nominal" ? ArrayAdapter::format("money Rp. ", $d->diskon) : $d->diskon . "%";
					$total_hpp = $jumlah * $hpp;
					$f_total = $total_hpp == 0 ? "0,00" : ArrayAdapter::format("only-money", $total_hpp);
					$tanggal_exp = ArrayAdapter::format("date d-m-Y", $d->tanggal_exp);

					$html .= "
						<tr>
							<td id='id_barang' style='display: none;'>" .  $id_barang . "</td>
							<td id='hpp' style='display: none;'>" .  $hpp . "</td>
							<td id='diskon' style='display: none;'>" .  $d->diskon . "</td>
							<td id='t_diskon' style='display: none;'>" .  $d->t_diskon . "</td>
							<td id='total' style='display: none;'>" .  $total_hpp . "</td>
							<td id='nomor_mutasi'><small>" . $nomor_mutasi . "</small></td>
							<td id='tanggal'><small>" . $tanggal . "</small></td>
							<td id='ruangan'><small>" . $ruangan . "</small></td>
							<td id='nama_barang'><small>" . $nama_barang . "</small></td>
							<td id='jumlah'><small>" . $jumlah . "</small></td>
							<td id='satuan'><small>" . $satuan . "</small></td>
							<td id='f_hpp'><small>" . $f_hpp . "</small></td>
							<td id='f_diskon'><small>" . $f_diskon . "</small></td>
							<td id='f_total'><small>" . $f_total . "</small></td>
							<td id='tanggal_exp'><small>" . $tanggal_exp . "</small></td>
							<td id='status'><small>" . $status . "</small></td>
						</tr>
					";
				}
			}

			$data = array();
			$data['id'] = $data_header->id;
			$data['tanggal'] = $data_header->tanggal;
			$data['unit'] = ArrayAdapter::format("unslug", $data_header->unit);
			$data['html'] = $html;
			echo json_encode($data);
		} else if ($_POST['command'] == "export_xls") {
			$nama_entitas = getSettings($db, "smis_autonomous_title", "");
			$alamat_entitas = getSettings($db, "smis_autonomous_address", "");
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			require_once("smis-libs-out/php-excel/PHPExcel.php");
			$objPHPExcel = PHPExcel_IOFactory::load("gudang_umum/templates/template_rekap_mutasi_barang.xlsx");
			$objPHPExcel->setActiveSheetIndexByName("REKAP MUTASI BARANG");
			$objWorksheet = $objPHPExcel->getActiveSheet();
			$objWorksheet->setCellValue("B2", "GUDANG UMUM - " . ArrayAdapter::format("unslug", $nama_entitas));
			$objWorksheet->setCellValue("B3", "UNIT : SEMUA");
			$objWorksheet->setCellValue("B4", "PERIODE : " . ArrayAdapter::format("date d-m-Y", $tanggal_from) . " s/d " . ArrayAdapter::format("date d-m-Y", $tanggal_to));
			$data = json_decode($_POST['d_data'], true);
			if ($_POST['num_rows'] - 2 > 0)
				$objWorksheet->insertNewRowBefore(8, $_POST['num_rows'] - 2);
			$start_row_num = 8;
			$end_row_num = 8;
			$row_num = $start_row_num;
			$no = 1;
			foreach ($data as $d) {
				$col_num = 1;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $no);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['nomor_mutasi']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['tanggal']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['ruangan']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['kode_barang']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['nama_barang']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['jumlah']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['satuan']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['hpp']);
				$col_num++;
				$f_diskon = $d['t_diskon'] == "nominal" ? ArrayAdapter::format("money Rp. ", $d['diskon']) : $d['diskon'] . "%";
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $f_diskon);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['jumlah'] * $d['hpp']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['tanggal_exp']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['status']);
				$objWorksheet->getStyle("I" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->getStyle("K" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$row_num++;
				$end_row_num++;
				$no++;
			}
			ob_end_clean();
			header("Content-type: application/vnd.ms-excel");	
			header("Content-Disposition: attachment; filename=REKAP_MUTASI_BARANG_GUDANG_UMUM_KE_SEMUA_UNIT_" . ArrayAdapter::format("date Ymd", $tanggal_from) . "_" . ArrayAdapter::format("date Ymd", $tanggal_to) . "_" . date("Ymd_His") . ".xlsx");
			ob_end_clean();
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objWriter->save("php://output");
		}
		return;
	}

	$laporan_form = new Form("lrm_form", "", "Gudang Umum : Rekap Mutasi Barang");
	$tanggal_from_text = new Text("lrm_tanggal_from", "lrm_tanggal_from", date("Y-m-") . "01");
	$tanggal_from_text->setClass("mydate");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("lrm_tanggal_to", "lrm_tanggal_to", date("Y-m-d"));
	$tanggal_to_text->setClass("mydate");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Akhir", $tanggal_to_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lrm.view()");
	$btn_group = new ButtonGroup("noprint");
	$export_button = new Button("", "", "Unduh");
	$export_button->setClass("btn-inverse");
	$export_button->setIcon("fa fa-download");
	$export_button->setIsButton(Button::$ICONIC);
	$export_button->setAtribute("id='lrm_export_button'");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($export_button);
	$laporan_form->addElement("", $btn_group);

	$lrm_table = new Table(
		array("No. Mutasi", "Tanggal", "Ruangan", "Nama Barang", "Jumlah", "Satuan", "H. Netto", "Diskon", "Total H. Netto", "Tgl. Exp.", "Status"),
		"",
		null,
		true
	);
	$lrm_table->setName("lrm");
	$lrm_table->setFooterVisible(false);
	$lrm_table->setAction(false);

	$loading_bar = new LoadingBar("lrm_loading_bar", "");
	$button = new Button("", "", "Batal");
	$button->addClass("btn-primary");
	$button->setIsButton(Button::$ICONIC_TEXT);
	$button->setIcon("fa fa-close");
	$button->setAction("lrm.cancel()");
	$loading_modal = new Modal("lrm_loading_modal", "", "Proses..");
	$loading_modal->addHtml($loading_bar->getHtml(), "after");
	$loading_modal->addFooter($button);

	echo $loading_modal->getHtml();
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo $lrm_table->getHtml();
	echo "</div>";
	echo "<div id='lrm_info'></div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addJS("base-js/smis-base-loading.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
	var lrm;
	var FINISHED;
	$(document).ready(function() {
		lrm = new TableAction(
			"lrm",
			"gudang_umum",
			"laporan_rekap_mutasi",
			new Array()
		);
		lrm.view = function() {
			if ($("#lrm_tanggal_from").val() == "" || $("#lrm_tanggal_to").val() == "")
				return;
			var self = this;
			$("#lrm_info").empty();
			$("#lrm_loading_bar").sload("true", "Harap ditunggu...", 0);
			$("#lrm_loading_modal").smodal("show");
			FINISHED = false;
			var data = this.getRegulerData();
			data['command'] = "get_jumlah";
			data['tanggal_from'] = $("#lrm_tanggal_from").val();
			data['tanggal_to'] = $("#lrm_tanggal_to").val();
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) return;
					$("#lrm_list").empty();
					self.fillHtml(0, json.jumlah);
				}
			);
		};
		lrm.fillHtml = function(num, limit) {
			if (FINISHED || num == limit) {
				if (FINISHED == false && num == limit) {
					this.finalize();
				} else {
					$("#lrm_loading_modal").smodal("hide");
					$("#lrm_info").html(
						"<div class='alert alert-block alert-inverse'>" +
							 "<center><strong>PROSES DIBATALKAN</strong></center>" +
						 "</div>"
					);
					$("#lrm_export_button").removeAttr("onclick");
				}
				return;
			}
			var self = this;
			var data = this.getRegulerData();
			data['command'] = "get_info";
			data['num'] = num;
			data['tanggal_from'] = $("#lrm_tanggal_from").val();
			data['tanggal_to'] = $("#lrm_tanggal_to").val();
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) return;
					$("tbody#lrm_list").append(
						json.html
					);
					$("#lrm_loading_bar").sload("true", json.id + " - " + json.tanggal + " - " + json.unit + " (" + (num + 1) + " / " + limit + ")", (num + 1) * 100 / limit - 1);
					self.fillHtml(num + 1, limit);
				}
			);
		};
		lrm.finalize = function() {
			var num_rows = $("tbody#lrm_list tr").length;
			$("#lrm_loading_modal").smodal("hide");
			$("#lrm_info").html(
				"<div class='alert alert-block alert-info'>" +
					"<center><strong>PROSES SELESAI</strong></center>" +
				"</div>"
			);
			$("#lrm_export_button").removeAttr("onclick");
			$("#lrm_export_button").attr("onclick", "lrm.export_xls()");
		};
		lrm.cancel = function() {
			FINISHED = true;
		};
		lrm.export_xls = function() {
			showLoading();
			var num_rows = $("#lrm_list").children("tr").length;
			var d_data = {};
			for (var i = 0; i < num_rows; i++) {
				var nomor_mutasi = $("tbody#lrm_list tr:eq(" + i + ") td#nomor_mutasi").text();
				var tanggal = $("tbody#lrm_list tr:eq(" + i + ") td#tanggal").text();
				var ruangan = $("tbody#lrm_list tr:eq(" + i + ") td#ruangan").text();
				var id_barang = $("tbody#lrm_list tr:eq(" + i + ") td#id_barang").text();
				var kode_barang = $("tbody#lrm_list tr:eq(" + i + ") td#kode_barang").text();
				var nama_barang = $("tbody#lrm_list tr:eq(" + i + ") td#nama_barang").text();
				var jumlah = $("tbody#lrm_list tr:eq(" + i + ") td#jumlah").text();
				var satuan = $("tbody#lrm_list tr:eq(" + i + ") td#satuan").text();
				var hpp = $("tbody#lrm_list tr:eq(" + i + ") td#hpp").text();
				var t_diskon = $("tbody#lrm_list tr:eq(" + i + ") td#t_diskon").text();
				var diskon = $("tbody#lrm_list tr:eq(" + i + ") td#diskon").text();
				var tanggal_exp = $("tbody#lrm_list tr:eq(" + i + ") td#tanggal_exp").text();
				var status = $("tbody#lrm_list tr:eq(" + i + ") td#status").text();
				d_data[i] = {
					'nomor_mutasi' : nomor_mutasi,
					'tanggal' : tanggal,
					'ruangan' : ruangan,
					'id_barang' : id_barang,
					'kode_barang' : kode_barang,
					'nama_barang' : nama_barang,
					'jumlah' : jumlah,
					'satuan' : satuan,
					'hpp' : hpp,
					'tanggal_exp' : tanggal_exp,
					'status' : status,
					'diskon' : diskon,
					't_diskon' : t_diskon			
				};
			}
			var data = this.getRegulerData();
			data['command'] = "export_xls";
			data['tanggal_from'] = $("#lrm_tanggal_from").val();
			data['tanggal_to'] = $("#lrm_tanggal_to").val();
			data['d_data'] = JSON.stringify(d_data);
			data['num_rows'] = num_rows;
			console.log(data);
			postForm(data);
			dismissLoading();
		};
		$("#lrm_loading_modal").on("show", function() {
			$("a.close").hide();
		});
		$("#lrm_loading_modal").on("hide", function() {
			$("a.close").show();
		});
		$("tbody#lrm_list").append(
			"<tr>" +
				"<td colspan='11'><strong><center><small>LAPORAN BELUM DIPROSES</small></center></strong></td>" +
			"</tr>"
		);
		$(document).keyup(function(e) {
			if (e.which == 27) {
				FINISHED = true;
			}
		})
	});
</script>