<?php
	require_once("smis-base/smis-include-service-consumer.php");
	require_once("gudang_umum/kelas/GudangUmumInventory.php");
	global $db;

	//chooser nama barang:
	$barang_table = new Table(
		array("ID", "Kode", "Nama Barang", "Jenis Barang"),
		"",
		null,
		true
	);
	$barang_table->setName("lpb_barang");
	$barang_table->setModel(Table::$SELECT);
	$barang_adapter = new SimpleAdapter();
	$barang_adapter->add("ID", "id");
	$barang_adapter->add("Kode", "kode");
	$barang_adapter->add("Nama Barang", "nama");
	$barang_adapter->add("Jenis Barang", "nama_jenis_barang");
	$barang_dbtable = new DBTable($db, "smis_pr_barang");
	$barang_dbtable->addCustomKriteria(" medis ", " = 0 ");
	$barang_dbtable->addCustomKriteria(" inventaris ", " = 0 ");
	$barang_dbresponder = new DBResponder(
		$barang_dbtable,
		$barang_table,
		$barang_adapter
	);

	//chooser jenis barang:
	$jenis_barang_table = new Table(
		array("No.", "Kode", "Jenis Barang"),
		"",
		null,
		true
	);
	$jenis_barang_table->setName("lpb_jenis_barang");
	$jenis_barang_table->setModel(Table::$SELECT);
	$jenis_barang_adapter = new SimpleAdapter(true, "No.");
	$jenis_barang_adapter->add("Kode", "kode");
	$jenis_barang_adapter->add("Jenis Barang", "nama");
	$jenis_barang_dbtable = new DBTable($db, "smis_pr_jenis_barang");
    $jenis_barang_dbtable->addCustomKriteria(" medis ", " = 0 ");
	$jenis_barang_dbresponder = new DBResponder(
		$jenis_barang_dbtable,
		$jenis_barang_table,
		$jenis_barang_adapter
	);
	
	$super_command = new SuperCommand();
	$super_command->addResponder("lpb_barang", $barang_dbresponder);
	$super_command->addResponder("lpb_jenis_barang", $jenis_barang_dbresponder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "get_jumlah_barang") {
			$jenis_filter = $_POST['jenis_filter'];
			$params = array();
			$params['order_by'] = $_POST['urutan'];
			if ($jenis_filter == "per_barang")
				$params['filter_id_barang'] = $_POST['id_barang'];
			else
				$params['filter_id_barang'] = "%%";
			if ($jenis_filter == "per_jenis")
				$params['filter_kode_jenis_barang'] = $_POST['kode_jenis_barang'];
			else
				$params['filter_kode_jenis_barang'] = "%%";
			$consumer_service = new ServiceConsumer(
				$db,
				"get_jumlah_barang_msrs",
				$params,
				"perencanaan"
			);
			$consumer_service->setMode(ServiceConsumer::$CLEAN_BOTH);
			$content = $consumer_service->execute()->getContent();
			$jumlah = 0;
			if ($content != null)
				$jumlah = $content[0];
			$data = array();
			$data['jumlah'] = $jumlah;
			echo json_encode($data);
		} else if ($_POST['command'] == "get_info_barang") {
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$jenis_filter = $_POST['jenis_filter'];
			$num = $_POST['num'];
			$params = array();
			$params['num'] = $_POST['num'];
			$params['order_by'] = $_POST['urutan'];
			if ($jenis_filter == "per_barang")
				$params['filter_id_barang'] = $_POST['id_barang'];
			else
				$params['filter_id_barang'] = "%%";
			if ($jenis_filter == "per_jenis")
				$params['filter_kode_jenis_barang'] = $_POST['kode_jenis_barang'];
			else
				$params['filter_kode_jenis_barang'] = "%%";
			$consumer_service = new ServiceConsumer(
				$db,
				"get_barang_info_msrs",
				$params,
				"perencanaan"
			);
			$consumer_service->setMode(ServiceConsumer::$CLEAN_BOTH);
			$content = $consumer_service->execute()->getContent();
			$id_barang = $content[0];
			$kode_barang = $content[1];
			$nama_barang = $content[2];
			$nama_jenis_barang = $content[3];
			$satuan = $content[5];
			$satuan_konversi = $content[5];

			// Mendapatkan Saldo Akhir:
			$saldo_sekarang = GudangUmumInventory::getCurrentStock($db, $id_barang, $satuan, 1, $satuan_konversi);
			$jumlah_masuk = GudangUmumInventory::getStockIn($db, $id_barang, $satuan, 1, $satuan_konversi, date("Y-m-d", strtotime($tanggal_to . " +1 day")), date("Y-m-d")) + GudangUmumInventory::getPenyesuaianStokPositif($db, $id_barang, $satuan, 1, $satuan_konversi, date("Y-m-d", strtotime($tanggal_to . "+1 day")), date("Y-m-d"));
			$jumlah_keluar = GudangUmumInventory::getStockOut($db, $id_barang, $satuan, 1, $satuan_konversi,date("Y-m-d", strtotime($tanggal_to . " +1 day")), date("Y-m-d")) + GudangUmumInventory::getPenyesuaianStokNegatif($db, $id_barang, $satuan, 1, $satuan_konversi, date("Y-m-d", strtotime($tanggal_to . "+1 day")), date("Y-m-d"));
			$saldo_akhir = $saldo_sekarang - $jumlah_masuk + $jumlah_keluar;
			// Mendapatkan Penyesuaian Stok:
			$penyesuaian_stok = GudangUmumInventory::getPenyesuaianStokPositif($db, $id_barang, $satuan, 1, $satuan_konversi, $tanggal_from, $tanggal_to) - GudangUmumInventory::getPenyesuaianStokNegatif($db, $id_barang, $satuan, 1, $satuan_konversi, $tanggal_from, $tanggal_to);
			// Mendapatkan Jumlah Masuk:
			$jumlah_masuk = GudangUmumInventory::getStockIn($db, $id_barang, $satuan, 1, $satuan_konversi, $tanggal_from, $tanggal_to);
			// Mendapatkan Jumlah Keluar:
			$jumlah_keluar = GudangUmumInventory::getStockOut($db, $id_barang, $satuan, 1, $satuan_konversi, $tanggal_from, $tanggal_to);
			// Mendapatkan Saldo Awal:
			$saldo_awal = $saldo_akhir - $jumlah_masuk + $jumlah_keluar - $penyesuaian_stok;
			// Mendapatkan Harga Pokok:
			$harga_pokok = GudangUmumInventory::getStockValue($db, $id_barang, $tanggal_to);
			$f_harga_pokok = $harga_pokok == 0 ? ArrayAdapter::format("money Rp. ", "0") : ArrayAdapter::format("money Rp. ", $harga_pokok);
			// Nilai Pemakaian:
			$nilai_pemakaian = $jumlah_keluar * $harga_pokok;
			$f_nilai_pemakaian = $nilai_pemakaian == 0 ? ArrayAdapter::format("money Rp. ", "0") : ArrayAdapter::format("money Rp. ", $nilai_pemakaian);
			// Nilai Akhir:
			$nilai_akhir = $saldo_akhir * $harga_pokok;
			$f_nilai_akhir = $nilai_akhir == 0 ? ArrayAdapter::format("money Rp. ", "0") : ArrayAdapter::format("money Rp. ", $nilai_akhir);

			$html = "
				<tr>
					<td id='nomor'></td>
					<td id='id_barang'><small>" .  $id_barang . "</small></td>
					<td id='kode_barang'><small>" .  $kode_barang . "</small></td>
					<td id='nama_barang'><small>" .  $nama_barang . "</small></td>
					<td id='saldo_awal' style='display: none;'><small>" .  $saldo_awal . "</small></td>
					<td id='f_saldo_awal'><small>" .  ArrayAdapter::format("number", $saldo_awal) . "</small></td>
					<td id='penyesuaian_stok' style='display: none;'><small>" .  $penyesuaian_stok . "</small></td>
					<td id='f_penyesuaian_stok'><small>" .  ArrayAdapter::format("number", $penyesuaian_stok) . "</small></td>
					<td id='jumlah_masuk' style='display: none;'><small>" .  $jumlah_masuk . "</small></td>
					<td id='f_jumlah_masuk'><small>" .  ArrayAdapter::format("number", $jumlah_masuk) . "</small></td>
					<td id='jumlah_keluar' style='display: none;'><small>" .  $jumlah_keluar . "</small></td>
					<td id='f_jumlah_keluar'><small>" .  ArrayAdapter::format("number", $jumlah_keluar) . "</small></td>
					<td id='saldo_akhir' style='display: none;'><small>" .  $saldo_akhir . "</small></td>
					<td id='f_saldo_akhir'><small>" .  ArrayAdapter::format("number", $saldo_akhir) . "</small></td>
					<td id='satuan'><small>" .  $satuan_konversi . "</small></td>
					<td id='harga_pokok' style='display: none;'><small>" .  $harga_pokok . "</small></td>
					<td id='f_harga_pokok'><small>" .  $f_harga_pokok . "</small></td>
					<td id='nilai_pemakaian' style='display: none;'><small>" .  $nilai_pemakaian . "</small></td>
					<td id='f_nilai_pemakaian'><small>" .  $f_nilai_pemakaian . "</small></td>
					<td id='nilai_akhir' style='display: none;'><small>" .  $nilai_akhir . "</small></td>
					<td id='f_nilai_akhir'><small>" .  $f_nilai_akhir . "</small></td>
				</tr>
			";

			$data = array();
			$data['id_barang'] = ArrayAdapter::format("only-digit6", $id_barang);
			$data['kode_barang'] = $kode_barang;
			$data['nama_barang'] = $nama_barang;
			$data['nama_jenis_barang'] = $nama_jenis_barang;
			$data['html'] = $html;
			echo json_encode($data);
		} else if ($_POST['command'] == "export_xls") {
			$nama_entitas = getSettings($db, "smis_autonomous_title", "");
			$alamat_entitas = getSettings($db, "smis_autonomous_address", "");
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			require_once("smis-libs-out/php-excel/PHPExcel.php");
			$objPHPExcel = PHPExcel_IOFactory::load("gudang_umum/templates/template_persediaan_barang.xlsx");
			$objPHPExcel->setActiveSheetIndexByName("STOK OPNAME");
			$objWorksheet = $objPHPExcel->getActiveSheet();
			$objWorksheet->setCellValue("B2", "GUDANG UMUM - " . ArrayAdapter::format("unslug", $nama_entitas));
			$data = json_decode($_POST['d_data']);
			$objWorksheet->setCellValue("B3", "PERIODE : " . ArrayAdapter::format("date d-m-Y", $tanggal_from) . " s/d " . ArrayAdapter::format("date d-m-Y", $tanggal_to));
			$data = json_decode($_POST['d_data']);
			if ($_POST['num_rows'] - 2 > 0)
				$objWorksheet->insertNewRowBefore(8, $_POST['num_rows'] - 2);
			$start_row_num = 7;
			$end_row_num = 7;
			$row_num = $start_row_num;
			foreach ($data as $d) {
				$col_num = 1;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nomor);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->id_barang);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->kode_barang);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nama_barang);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->saldo_awal);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->penyesuaian_stok);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->jumlah_masuk);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->jumlah_keluar);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->saldo_akhir);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->satuan);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->harga_pokok);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nilai_pemakaian);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nilai_akhir);
				$objWorksheet->getStyle("F" . $row_num)->getNumberFormat()->setFormatCode("#,##0");
				$objWorksheet->getStyle("G" . $row_num)->getNumberFormat()->setFormatCode("#,##0");
				$objWorksheet->getStyle("H" . $row_num)->getNumberFormat()->setFormatCode("#,##0");
				$objWorksheet->getStyle("I" . $row_num)->getNumberFormat()->setFormatCode("#,##0");
				$objWorksheet->getStyle("J" . $row_num)->getNumberFormat()->setFormatCode("#,##0");
				$objWorksheet->getStyle("L" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->getStyle("M" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->getStyle("N" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$row_num++;
				$end_row_num++;
				$no++;
			}
			header("Content-type: application/vnd.ms-excel");	
			header("Content-Disposition: attachment; filename=STOK_OPNAME_GUDANG_UMUM_" . ArrayAdapter::format("date Ymd", $tanggal_from) . "_" . ArrayAdapter::format("date Ymd", $tanggal_to) . ".xlsx");
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objWriter->save("php://output");
		} else if ($_POST['command'] == "export_pdf") {
			$nama_entitas = getSettings($db, "smis_autonomous_title", "");
			$alamat_entitas = getSettings($db, "smis_autonomous_address", "");
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];

			$margin_left = 5;
			$margin_top = 5;
			$total = 0;
			$jumlah_item = $_POST['num_rows'];
			$jumlah_item_per_halaman = 30;
			$jumlah_halaman = floor($jumlah_item / $jumlah_item_per_halaman) + 1;
			$data = json_decode($_POST['d_data'], true);

			require_once("smis-libs-out/fpdf/fpdf.php");
			$fpdf = new FPDF("L", "mm", "A4");
			$fpdf->SetFont("Arial", "B", 8);
			$fpdf->SetMargins($margin_left, $margin_top);

			$fpdf->SetFont("Arial", "", 8);
		 	for ($i = $i_halaman * $jumlah_item_per_halaman; $i < $jumlah_item; $i++) {
		 		if ($i % $jumlah_item_per_halaman == 0) {
		 			$fpdf->AddPage();
					$fpdf->SetY($last_y + 10);
					$fpdf->SetX(5);
					$fpdf->Ln(4);
					$fpdf->SetFont("Arial", "B", 9);
					$fpdf->Cell(285, 5, "LAPORAN STOK OPNAME GUDANG UMUM", 0, 0, "C");
					$fpdf->Ln(5);
					$fpdf->SetFont("Arial", "B", 7);
					$fpdf->Cell(285, 5, ArrayAdapter::format("date d-m-Y", $_POST['tanggal_from']) . " s/d " . ArrayAdapter::format("date d-m-Y", $_POST['tanggal_to']), 0, 0, "C");
					$fpdf->Ln(7);
					$fpdf->SetFont("Arial", "B", 8);
					$fpdf->Cell(10, 5, "No.", 1, 0, "C");
					$fpdf->Cell(15, 5, "ID Barang", 1, 0, "C");
					$fpdf->Cell(25, 5, "Kode Barang", 1, 0, "C");
					$fpdf->Cell(45, 5, "Nama Barang", 1, 0, "C");
					$fpdf->Cell(20, 5, "Saldo Awal", 1, 0, "C");
					$fpdf->Cell(20, 5, "Penyesuaian", 1, 0, "C");
					$fpdf->Cell(20, 5, "Jml. Masuk", 1, 0, "C");
					$fpdf->Cell(20, 5, "Jml. Keluar", 1, 0, "C");
					$fpdf->Cell(20, 5, "Saldo Akhir", 1, 0, "C");
					$fpdf->Cell(15, 5, "Satuan", 1, 0, "C");
					$fpdf->Cell(25, 5, "Harga Pokok", 1, 0, "C");
					$fpdf->Cell(25, 5, "Nilai Pemakaian", 1, 0, "C");
					$fpdf->Cell(25, 5, "Nilai Akhir", 1, 0, "C");
					$fpdf->Ln(5);
		 		}
		 		$nomor = $data[$i]['nomor'];
		 		$id_barang = $data[$i]['id_barang'];
		 		$kode_barang = $data[$i]['kode_barang'];
		 		$nama_barang = $data[$i]['nama_barang'];
		 		$saldo_awal= $data[$i]['saldo_awal'];
				$penyesuaian_stok = $data[$i]['penyesuaian_stok'];
				$jumlah_masuk = $data[$i]['jumlah_masuk'];
				$jumlah_keluar = $data[$i]['jumlah_keluar'];
				$saldo_akhir = $data[$i]['saldo_akhir'];
				$satuan = $data[$i]['satuan'];
				$harga_pokok = $data[$i]['harga_pokok'];
				$nilai_pemakaian = $data[$i]['nilai_pemakaian'];
				$nilai_akhir = $data[$i]['nilai_akhir'];

				$fpdf->SetFont("Arial", "B", 8);
				$fpdf->SetX(5);
				$fpdf->Cell(10, 5, $nomor, 1, 0);
				$fpdf->Cell(15, 5, $id_barang, 1, 0);
				$fpdf->Cell(25, 5, $kode_barang, 1, 0);
				$fpdf->Cell(45, 5, substr($nama_barang, 0, 22), 1, 0);
				$fpdf->Cell(20, 5, $saldo_awal, 1, 0, "R");
				$fpdf->Cell(20, 5, $penyesuaian_stok, 1, 0, "R");
				$fpdf->Cell(20, 5, $jumlah_masuk, 1, 0, "R");
				$fpdf->Cell(20, 5, $jumlah_keluar, 1, 0, "R");
				$fpdf->Cell(20, 5, $saldo_akhir, 1, 0, "R");
				$fpdf->Cell(15, 5, $satuan, 1, 0);
				$fpdf->Cell(25, 5, ArrayAdapter::format("only-money", $harga_pokok), 1, 0, "R");
				$fpdf->Cell(25, 5, ArrayAdapter::format("only-money", $nilai_pemakaian), 1, 0, "R");
				$fpdf->Cell(25, 5, ArrayAdapter::format("only-money", $nilai_akhir), 1, 0, "R");
				$fpdf->Ln(5);
		 		if ($i == ($i_halaman * $jumlah_item_per_halaman + $jumlah_item_per_halaman - 1) || $i == $jumlah_item - 1) {
	 				$fpdf->SetX(5);
					$fpdf->SetFont("Arial", "B", 8);
					$fpdf->Cell(285, 5, "Halaman " . ($i_halaman + 1) . " / " . $jumlah_halaman, 0, 0, "R");
					$fpdf->Ln(5);
					$i_halaman++;
		 		}
		 	}
			global $user;
		    $md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "laporan_persediaan_barang.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
			$pack = new ResponsePackage();
			$pack->setContent($pathfile);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
			echo json_encode($pack->getPackage());
		}
		return;
	}

	$laporan_form = new Form("", "", "Gudang Umum : Stok Opname (SO)");
	$tanggal_from_text = new Text("lpb_tanggal_from", "lpb_tanggal_from", date("Y-m-") . "01");
	$tanggal_from_text->setClass("mydate");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("lpb_tanggal_to", "lpb_tanggal_to", date("Y-m-d"));
	$tanggal_to_text->setClass("mydate");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Akhir", $tanggal_to_text);
	$jenis_filter_option = new OptionBuilder();
	$jenis_filter_option->add("SEMUA", "semua", "1");
	$jenis_filter_option->add("PER BARANG", "per_barang");
	$jenis_filter_option->add("PER JENIS", "per_jenis");
	$jenis_filter_select = new Select("lpb_jenis_filter", "lpb_jenis_filter", $jenis_filter_option->getContent());
	$laporan_form->addElement("Jenis Filter", $jenis_filter_select);
	$kode_jenis_barang_hidden = new Hidden("lpb_kode_jenis_barang", "lpb_kode_jenis_barang", "");
	$laporan_form->addElement("", $kode_jenis_barang_hidden);
	$id_barang_hidden = new Hidden("lpb_id_barang", "lpb_id_barang", "");
	$laporan_form->addElement("", $id_barang_hidden);
	$nama_barang_text = new Text("lpb_nama_barang", "lpb_nama_barang", "");
	$nama_barang_text->setAtribute("disabled='disabled'");
	$nama_barang_text->setClass("smis-one-option-input");
	$browse_button = new Button("", "", "Pilih");
	$browse_button->setClass("btn-info");
	$browse_button->setIcon("fa fa-list");
	$browse_button->setIsButton(Button::$ICONIC);
	$browse_button->setAction("lpb_barang.chooser('lpb_barang', 'lpb_barang_button', 'lpb_barang', lpb_barang, 'Barang')");
	$input_group = new InputGroup("");
	$input_group->addComponent($nama_barang_text);
	$input_group->addComponent($browse_button);
	$laporan_form->addElement("Barang", $input_group);
	$nama_jenis_barang_text = new Text("lpb_nama_jenis_barang", "lpb_nama_jenis_barang", "");
	$nama_jenis_barang_text->setAtribute("disabled='disabled'");
	$nama_jenis_barang_text->setClass("smis-one-option-input");
	$browse_button = new Button("", "", "Pilih");
	$browse_button->setClass("btn-info");
	$browse_button->setIcon("fa fa-list");
	$browse_button->setIsButton(Button::$ICONIC);
	$browse_button->setAction("lpb_jenis_barang.chooser('lpb_jenis_barang', 'lpb_jenis_barang_button', 'lpb_jenis_barang', lpb_jenis_barang, 'Jenis Barang')");
	$input_group = new InputGroup("");
	$input_group->addComponent($nama_jenis_barang_text);
	$input_group->addComponent($browse_button);
	$laporan_form->addElement("Jenis Barang", $input_group);
	$urutan_option = new OptionBuilder();
	$urutan_option->addSingle("KODE BARANG", "1");
	$urutan_option->addSingle("NAMA BARANG");
	$urutan_select = new Select("lpb_urutan", "lpb_urutan", $urutan_option->getContent());
	$laporan_form->addElement("Urutan", $urutan_select);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lpb.view()");
	$print_button = new Button("", "", "Unduh");
	$print_button->setClass("btn-inverse");
	$print_button->setIcon("fa fa-download");
	$print_button->setIsButton(Button::$ICONIC);
	$print_button->setAtribute("id='export_button'");
	$pdf_button = new Button("", "", "Unduh");
	$pdf_button->setClass("btn-inverse");
	$pdf_button->setIcon("fa fa-file-pdf-o");
	$pdf_button->setIsButton(Button::$ICONIC);
	$pdf_button->setAtribute("id='pdf_button'");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($print_button);
	$btn_group->addButton($pdf_button);
	$laporan_form->addElement("", $btn_group);

	$lpb_table = new Table(
		array("No.", "ID Barang", "Kode Barang", "Nama Barang", "Saldo Awal", "Penyesuaian", "Jml. Masuk", "Jml. Keluar", "Saldo Akhir", "Satuan", "Harga Pokok", "Nilai Pemakaian", "Nilai Akhir"),
		"",
		null,
		true
	);
	$lpb_table->setName("lpb");
	$lpb_table->setAction(false);
	$lpb_table->setFooterVisible(false);

	$loading_bar = new LoadingBar("so_loading_bar", "");
	$button = new Button("", "", "Batal");
	$button->addClass("btn-primary");
	$button->setIsButton(Button::$ICONIC_TEXT);
	$button->setIcon("fa fa-close");
	$button->setAction("lpb.cancel()");
	$loading_modal = new Modal("loading_modal", "", "Proses..");
	$loading_modal->addHtml($loading_bar->getHtml(), "after");
	$loading_modal->addFooter($button);
	
	echo $loading_modal->getHtml();
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo $lpb_table->getHtml();
	echo "</div>";
	echo "<div id='info'></div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addJS("base-js/smis-base-loading.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
	function LPBAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LPBAction.prototype.constructor = LPBAction;
	LPBAction.prototype = new TableAction();
	LPBAction.prototype.view = function() {
		if ($("#lpb_tanggal_from").val() == "" || $("#lpb_tanggal_to").val() == "")
			return;
		var self = this;
		$("#info").empty();
		$("#loading_bar").sload("true", "Harap ditunggu...", 0);
		$("#loading_modal").smodal("show");
		FINISHED = false;
		var data = this.getRegulerData();
		data['command'] = "get_jumlah_barang";
		data['jenis_filter'] = $("#lpb_jenis_filter").val();
		data['id_barang'] = $("#lpb_id_barang").val();
		data['nama_barang'] = $("#lpb_nama_barang").val();
		data['nama_jenis_barang'] = $("#lpb_nama_jenis_barang").val();
		data['kode_jenis_barang'] = $("#lpb_kode_jenis_barang").val();
		data['urutan'] = $("#lpb_urutan").val();
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) return;
				$("#lpb_list").empty();
				self.fillHtml(0, json.jumlah);
			}
		);
	};
	LPBAction.prototype.fillHtml = function(num, limit) {
		if (FINISHED || num == limit) {
			if (FINISHED == false && num == limit) {
				this.finalize();
			} else {
				$("#loading_modal").smodal("hide");
				$("#info").html(
					"<div class='alert alert-block alert-inverse'>" +
						 "<center><strong>PROSES DIBATALKAN</strong></center>" +
					 "</div>"
				);
				$("#export_button").removeAttr("onclick");
			}
			return;
		}
		var self = this;
		var data = this.getRegulerData();
		data['command'] = "get_info_barang";
		data['num'] = num;
		data['tanggal_from'] = $("#lpb_tanggal_from").val();
		data['tanggal_to'] = $("#lpb_tanggal_to").val();
		data['jenis_filter'] = $("#lpb_jenis_filter").val();
		data['id_barang'] = $("#lpb_id_barang").val();
		data['nama_barang'] = $("#lpb_nama_barang").val();
		data['nama_jenis_barang'] = $("#lpb_nama_jenis_barang").val();
		data['kode_jenis_barang'] = $("#lpb_kode_jenis_barang").val();
		data['urutan'] = $("#lpb_urutan").val();
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) return;
				$("tbody#lpb_list").append(
					json.html
				);
				$("#so_loading_bar").sload("true", json.id_barang + " - " + json.kode_barang + " - " + json.nama_barang + " - " + json.nama_jenis_barang + " (" + (num + 1) + " / " + limit + ")", (num + 1) * 100 / limit - 1);
				self.fillHtml(num + 1, limit);
			}
		);
	};
	LPBAction.prototype.finalize = function() {
		var num_rows = $("tbody#lpb_list tr").length;
		for (var i = 0; i < num_rows; i++)
			$("tbody#lpb_list tr:eq(" + i + ") td#nomor").html("<small>" + (i + 1) + "</small>");
		$("#loading_modal").smodal("hide");
		$("#info").html(
			"<div class='alert alert-block alert-info'>" +
				 "<center><strong>PROSES SELESAI</strong></center>" +
			 "</div>"
		);
		$("#export_button").removeAttr("onclick");
		$("#export_button").attr("onclick", "lpb.export_xls()");
		$("#pdf_button").removeAttr("onclick");
		$("#pdf_button").attr("onclick", "lpb.export_pdf()");
	};
	LPBAction.prototype.cancel = function() {
		FINISHED = true;
	};
	LPBAction.prototype.export_xls = function() {
		showLoading();
		var num_rows = $("#lpb_list").children("tr").length;
		var d_data = {};
		for (var i = 0; i < num_rows; i++) {
			var nomor = $("tbody#lpb_list tr:eq(" + i + ") td#nomor").text();
			var id_barang = $("tbody#lpb_list tr:eq(" + i + ") td#id_barang").text();
			var kode_barang = $("tbody#lpb_list tr:eq(" + i + ") td#kode_barang").text();
			var nama_barang = $("tbody#lpb_list tr:eq(" + i + ") td#nama_barang").text();
			var saldo_awal = $("tbody#lpb_list tr:eq(" + i + ") td#saldo_awal").text();
			var penyesuaian_stok = $("tbody#lpb_list tr:eq(" + i + ") td#penyesuaian_stok").text();
			var jumlah_masuk = $("tbody#lpb_list tr:eq(" + i + ") td#jumlah_masuk").text();
			var jumlah_keluar = $("tbody#lpb_list tr:eq(" + i + ") td#jumlah_keluar").text();
			var saldo_akhir = $("tbody#lpb_list tr:eq(" + i + ") td#saldo_akhir").text();
			var satuan = $("tbody#lpb_list tr:eq(" + i + ") td#satuan").text();
			var harga_pokok = $("tbody#lpb_list tr:eq(" + i + ") td#harga_pokok").text();
			var nilai_pemakaian = $("tbody#lpb_list tr:eq(" + i + ") td#nilai_pemakaian").text();
			var nilai_akhir = $("tbody#lpb_list tr:eq(" + i + ") td#nilai_akhir").text();
			d_data[i] = {
				"nomor" 			: nomor,
				"id_barang" 			: id_barang,
				"kode_barang" 		: kode_barang,
				"nama_barang" 		: nama_barang,
				"saldo_awal" 		: saldo_awal,
				"penyesuaian_stok"	: penyesuaian_stok,
				"jumlah_masuk" 		: jumlah_masuk,
				"jumlah_keluar" 	: jumlah_keluar,
				"saldo_akhir" 		: saldo_akhir,
				"satuan"			: satuan,
				"harga_pokok"		: harga_pokok,
				"nilai_pemakaian"	: nilai_pemakaian,
				"nilai_akhir"		: nilai_akhir
			};
		}
		var data = this.getRegulerData();
		data['command'] = "export_xls";
		data['tanggal_from'] = $("#lpb_tanggal_from").val();
		data['tanggal_to'] = $("#lpb_tanggal_to").val();
		data['d_data'] = JSON.stringify(d_data);
		data['num_rows'] = num_rows;
		postForm(data);
		dismissLoading();
	};
	LPBAction.prototype.export_pdf = function() {
		showLoading();
		var num_rows = $("#lpb_list").children("tr").length;
		var d_data = {};
		for (var i = 0; i < num_rows; i++) {
			var nomor = $("tbody#lpb_list tr:eq(" + i + ") td#nomor").text();
			var id_barang = $("tbody#lpb_list tr:eq(" + i + ") td#id_barang").text();
			var kode_barang = $("tbody#lpb_list tr:eq(" + i + ") td#kode_barang").text();
			var nama_barang = $("tbody#lpb_list tr:eq(" + i + ") td#nama_barang").text();
			var saldo_awal = $("tbody#lpb_list tr:eq(" + i + ") td#saldo_awal").text();
			var penyesuaian_stok = $("tbody#lpb_list tr:eq(" + i + ") td#penyesuaian_stok").text();
			var jumlah_masuk = $("tbody#lpb_list tr:eq(" + i + ") td#jumlah_masuk").text();
			var jumlah_keluar = $("tbody#lpb_list tr:eq(" + i + ") td#jumlah_keluar").text();
			var saldo_akhir = $("tbody#lpb_list tr:eq(" + i + ") td#saldo_akhir").text();
			var satuan = $("tbody#lpb_list tr:eq(" + i + ") td#satuan").text();
			var harga_pokok = $("tbody#lpb_list tr:eq(" + i + ") td#harga_pokok").text();
			var nilai_pemakaian = $("tbody#lpb_list tr:eq(" + i + ") td#nilai_pemakaian").text();
			var nilai_akhir = $("tbody#lpb_list tr:eq(" + i + ") td#nilai_akhir").text();
			d_data[i] = {
				"nomor" 			: nomor,
				"id_barang" 			: id_barang,
				"kode_barang" 		: kode_barang,
				"nama_barang" 		: nama_barang,
				"saldo_awal" 		: saldo_awal,
				"penyesuaian_stok"	: penyesuaian_stok,
				"jumlah_masuk" 		: jumlah_masuk,
				"jumlah_keluar" 	: jumlah_keluar,
				"saldo_akhir" 		: saldo_akhir,
				"satuan"			: satuan,
				"harga_pokok"		: harga_pokok,
				"nilai_pemakaian"	: nilai_pemakaian,
				"nilai_akhir"		: nilai_akhir
			};
		}
		var data = this.getRegulerData();
		data['command'] = "export_pdf";
		data['tanggal_from'] = $("#lpb_tanggal_from").val();
		data['tanggal_to'] = $("#lpb_tanggal_to").val();
		data['d_data'] = JSON.stringify(d_data);
		data['num_rows'] = num_rows;
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) {
					dismissLoading();
					return;
				}
				var getUrl = window.location['pathname'] + json;
	            window.open(getUrl, 'pdf');
	            dismissLoading();
			}
		);
	};

	function LPBBarangAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LPBBarangAction.prototype.constructor = LPBBarangAction;
	LPBBarangAction.prototype = new TableAction();
	LPBBarangAction.prototype.selected = function(json) {
		$("#lpb_id_barang").val(json.id);
		$("#lpb_nama_barang").val(json.nama);
	};
	
	function LPBJenisBarangAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LPBJenisBarangAction.prototype.constructor = LPBJenisBarangAction;
	LPBJenisBarangAction.prototype = new TableAction();
	LPBJenisBarangAction.prototype.selected = function(json) {
		$("#lpb_kode_jenis_barang").val(json.kode);
		$("#lpb_nama_jenis_barang").val(json.nama);
	};

	var lpb;
	var lpb_barang;
	var lpb_jenis_barang;
	var FINISHED;
	$(document).ready(function() {
		lpb_barang = new LPBBarangAction(
			"lpb_barang",
			"gudang_umum",
			"laporan_persediaan_barang",
			new Array()
		);
		lpb_barang.setSuperCommand("lpb_barang");
		lpb_jenis_barang = new LPBJenisBarangAction(
			"lpb_jenis_barang",
			"gudang_umum",
			"laporan_persediaan_barang",
			new Array()
		);
		lpb_jenis_barang.setSuperCommand("lpb_jenis_barang");
		lpb = new LPBAction(
			"lpb",
			"gudang_umum",
			"laporan_persediaan_barang",
			new Array()
		);
		$("#laporan_persediaan_barang > div.form-container > form > div:nth-child(7)").hide();
		$("#laporan_persediaan_barang > div.form-container > form > div:nth-child(8)").hide();
		$("#lpb_jenis_filter").on("change", function() {
			var jenis_filter = $("#lpb_jenis_filter").val();
			$("#lpb_id_barang").val("");
			$("#lpb_nama_barang").val("");
			$("#lpb_kode_jenis_barang").val("");
			$("#lpb_jenis_barang").val("");
			if (jenis_filter == "semua") {
				$("#laporan_persediaan_barang > div.form-container > form > div:nth-child(7)").hide();
				$("#laporan_persediaan_barang > div.form-container > form > div:nth-child(8)").hide();
			} else if (jenis_filter == "per_barang") {
				$("#laporan_persediaan_barang > div.form-container > form > div:nth-child(7)").show();
				$("#laporan_persediaan_barang > div.form-container > form > div:nth-child(8)").hide();
			} else if (jenis_filter == "per_jenis") {
				$("#laporan_persediaan_barang > div.form-container > form > div:nth-child(7)").hide();
				$("#laporan_persediaan_barang > div.form-container > form > div:nth-child(8)").show();
			}
		});
		$("#loading_modal").on("show", function() {
			$("a.close").hide();
		});
		$("#loading_modal").on("hide", function() {
			$("a.close").show();
		});
		$("tbody#lpb_list").append(
			"<tr>" +
				"<td colspan='13'><strong><center><small>DATA PERSEDIAAN BARANG BELUM DIPROSES</small></center></strong></td>" +
			"</tr>"
		);
		$(document).keyup(function(e) {
			if (e.which == 27) {
				FINISHED = true;
			}
		})
	});
</script>