<?php
global $db;

$linm_table = new Table(
	array("Kode", "Nama Barang", "Merk", "Jumlah", "Tahun Perolehan", "Nilai Perolehan", "Keadaan", "Lokasi"),
	"Gudang Umum : Laporan Inventaris Non-Medis",
	null,
	true
);
$linm_table->setName("linm");
$linm_table->setPrintButtonEnable(false);
$linm_table->setAddButtonEnable(false);
$linm_table->setEditButtonEnable(false);
$linm_table->setDelButtonEnable(false);
$download_button = new Button("", "", "Eksport XLS");
$download_button->setClass("btn-inverse");
$download_button->setIcon("fa fa-download");
$download_button->setIsButton(Button::$ICONIC);
$download_button->setAction("linm.export_xls()");
$linm_table->addHeaderButton($download_button);

if (isset($_POST['command'])) {
	if ($_POST['command'] == "export_xls") {
		$data = $db->get_result("
			SELECT *
			FROM smis_gd_inventaris
			WHERE prop NOT LIKE 'del' AND medis = '0' AND unit <> ''
			ORDER BY unit, nama_barang ASC
		");
		$last_column = "H";

		require_once("smis-libs-out/php-excel/PHPExcel.php");

		$file = new PHPExcel();
		$sheet = $file->getActiveSheet();
		$sheet->setTitle("Inventaris Non-Medis");
		$i = 1;

		$sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Laporan Inventaris Non-Medis");
		$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$sheet->getStyle("A" . $i)->getFont()->setBold(true);
		$i = $i + 1;
		$sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, getSettings($db, "smis_autonomous_title", ""));
		$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$sheet->getStyle("A" . $i)->getFont()->setBold(true);
		$i = $i + 2;

		$border_start = $i;
		$col = 65;
		$sheet->setCellValue(chr($col) . $i, "Kode");
		$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Kode") + 10);
		$col++;
		$sheet->setCellValue(chr($col) . $i, "Nama Barang");
		$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Nama Barang") + 20);
		$col++;
		$sheet->setCellValue(chr($col) . $i, "Merk");
		$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Merk") + 20);
		$col++;
		$sheet->setCellValue(chr($col) . $i, "Jumlah");
		$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Jumlah") + 10);
		$col++;
		$sheet->setCellValue(chr($col) . $i, "Tahun Perolehan");
		$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Tahun Perolehan") + 5);
		$col++;
		$sheet->setCellValue(chr($col) . $i, "Nilai Perolehan");
		$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Nilai Perolehan") + 10);
		$col++;
		$sheet->setCellValue(chr($col) . $i, "Keadaan");
		$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Keadaan") + 5);
		$col++;
		$sheet->setCellValue(chr($col) . $i, "Lokasi");
		$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Lokasi") + 20);
		$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getFont()->setBold(true);
		$i = $i + 1;

		if ($data != null) {
			foreach ($data as $d) {
				$sheet->setCellValue("A" . $i, $d->kode);
				$sheet->setCellValue("B" . $i, $d->nama_barang);
				$sheet->setCellValue("C" . $i, $d->merk);
				$sheet->setCellValue("D" . $i, 1);
				$sheet->setCellValue("E" . $i, ArrayAdapter::format("date Y", $d->tahun_perolehan));
				$sheet->setCellValue("F" . $i, $d->hna);
				$sheet->setCellValue("G" . $i, ArrayAdapter::format("trivial_1_Baik_Rusak", $d->kondisi_baik));
				$sheet->setCellValue("H" . $i, ArrayAdapter::format("unslug", $d->unit));
				$sheet->getStyle('D' . $i)->getNumberFormat()->setFormatCode('#,##0');
				$sheet->getStyle("D" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
				$sheet->getStyle('F' . $i)->getNumberFormat()->setFormatCode('#,##0');
				$sheet->getStyle("F" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
				$i = $i + 1;
			}
		}

		$thin = array();
		$thin['borders'] = array();
		$thin['borders']['allborders'] = array();
		$thin['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
		$sheet->getStyle("A" . $border_start . ":" . $last_column . ($i - 1))->applyFromArray($thin);

		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Laporan Inventaris Non-Medis - ' . ArrayAdapter::format("date Ymd", date("Y-m-d")) . '.xls"');
		header('Cache-Control: max-age=0');
		$writer = PHPExcel_IOFactory::createWriter($file, 'Excel5');
		$writer->save('php://output');
		return;
	}
	class LLSOAdapter extends ArrayAdapter {
		public function adapt($row) {
			$array = array();
			$array['id'] = "";
			$array['Kode'] = $row->kode;
			$array['Nama Barang'] = $row->nama_barang;
			$array['Merk'] = $row->merk;
			$array['Jumlah'] = self::format("number", "1");
			$array['Tahun Perolehan'] = self::format("date Y", $row->tahun_perolehan);
			$array['Nilai Perolehan'] = self::format("money Rp.", $row->hna);
			$array['Keadaan'] = self::format("trivial_1_Baik_Rusak", $row->kondisi_baik);
			$array['Lokasi'] = self::format("unslug", $row->unit);
			return $array;
		}
	}
	$linm_adapter = new LLSOAdapter();
	$linm_dbtable = new DBTable($db, "smis_gd_inventaris");
	$filter = "1";
	if (isset($_POST['kriteria'])) {
		$filter .= " AND (kode LIKE '%" . $_POST['kriteria'] . "%' OR nama_barang LIKE '%" . $_POST['kriteria'] . "%' OR merk LIKE '%" . $_POST['kriteria'] . "%' OR unit LIKE '%" . $_POST['kriteria'] . "%') ";
	}
	$query_value = "
			SELECT *
			FROM (
				SELECT *
				FROM smis_gd_inventaris
				WHERE prop NOT LIKE 'del' AND medis = '0' AND unit <> ''
				ORDER BY unit, nama_barang ASC
			) v_linm
			WHERE " . $filter . "
		";
	$query_count = "
			SELECT COUNT(*)
			FROM (
				SELECT *
				FROM smis_gd_inventaris
				WHERE prop NOT LIKE 'del' AND medis = '0' AND unit <> ''
				ORDER BY unit, nama_barang ASC
			) v_linm
			WHERE " . $filter . "
		";
	$linm_dbtable->setPreferredQuery(true, $query_value, $query_count);
	class LLSODBResponder extends DBResponder
	{
		public function command($command)
		{
			if ($command != "print_laporan") {
				return parent::command($command);
			}
			$pack = new ResponsePackage();
			if ($command == "print_laporan") {
				$content = $this->print_report();
				$pack->setContent($content);
				$pack->setStatus(ResponsePackage::$STATUS_OK);
			}
			return $pack->getPackage();
		}
		public function print_report()
		{
			$data = $this->dbtable->get_result("
					SELECT *
					FROM (
						SELECT *
						FROM smis_gd_inventaris
						WHERE prop NOT LIKE 'del' AND medis = '0' AND unit <> ''
						ORDER BY unit, nama_barang ASC
					) v_linm
				");
			$print_data = "";
			$print_data .= "<center><strong>LAPORAN INVENTARIS NON-MEDIS RSU. KALIWATES</strong></center><br/>";
			$print_data .= "Periode : " . ArrayAdapter::format("date d M Y", date("Y-m-d"));
			$print_data .= "<table border='1'>
									<tr>
										<th>No.</th>
										<th>Kode</th>
										<th>Nama Barang</th>
										<th>Merk</th>
										<th>Jumlah</th>
										<th>Tahun Perolehan</th>
										<th>Nilai Perolehan</th>
										<th>Keadaan - Baik</th>
										<th>Keadaan - Rusak</th>
										<th>Lokasi</th>
									</tr>";
			$total_jumlah = 0;
			$total_jumlah_baik = 0;
			$total_jumlah_rusak = 0;
			$total_rupiah = 0;
			if (count($data) > 0) {
				$no = 1;
				foreach ($data as $d) {
					$tanggal_part = explode(" ", $d->tanggal);
					$time_part = explode(":", $tanggal_part[1]);
					$kondisi_sub = "<td><center>&#10003;</center></td><td>&Tab;</td>";
					if ($d->kondisi_baik == false) {
						$kondisi_sub = "<td>&Tab;</td><td><center>&#10003;</center></td>";
						$total_jumlah_rusak += 1;
					} else {
						$total_jumlah_baik += 1;
					}
					$print_data .= "<tr>
											<td>" . $no++ . "</td>
											<td>" . $d->kode . "</td>
											<td>" . $d->nama_barang . "</td>
											<td>" . $d->merk . "</td>
											<td>" . ArrayAdapter::format("number", "1") . "</td>
											<td><center>" . ArrayAdapter::format("date Y", $d->tahun_perolehan) . "</center></td>
											<td>" . ArrayAdapter::format("money Rp.", $d->hna) . "</td>
											" . $kondisi_sub . "
											<td>" . ArrayAdapter::format("unslug", $d->unit) . "</td>
										</tr>";
					$total_jumlah += 1;
					$total_rupiah += $d->hna;
				}
			} else {
				$print_data .= "<tr>
										<td colspan='10' align='center'><i>Tidak terdapat data inventaris non-medis</i></td>
									</tr>";
			}
			$print_data .= "<tr>
									<td colspan='4' align='center'><b>T O T A L</b></td>
									<td><b>" . ArrayAdapter::format("number", $total_jumlah) . "</b></td>
									<td>&Tab;</td>
									<td><b>" . ArrayAdapter::format("money Rp. ", $total_rupiah) . "</b></td>
									<td><b>" . ArrayAdapter::format("number", $total_jumlah_baik) . "</b></td>
									<td><b>" . ArrayAdapter::format("number", $total_jumlah_rusak) . "</b></td>
									<td>&Tab;</td>
								</tr>";
			$print_data .= "</table><br/>";
			$print_data .= "<table border='0' align='center' class='united'>
									<tr>
										<td colspan='3' align='center'>Mengetahui :</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td align='center'>Jember, " . ArrayAdapter::format("date d M Y", date("Y-m-d")) . "</td>
										<td>&Tab;</td>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td align='center'>KAUR. GUDANG NON OBAT</td>
										<td>&Tab;</td>
										<td align='center'>MANDBID. A K U</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
										<td>&Tab;</td>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
										<td>&Tab;</td>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
										<td>&Tab;</td>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td>&nbsp;</td>
										<td>&Tab;</td>
										<td>&nbsp;</td>
									</tr>
									<tr>
										<td align='center'><b>Suharyanto</b></td>
										<td>&Tab;</td>
										<td align='center'><b>M. Masduki, S.Pd.</b></td>
									</tr>
								</table>";
			return $print_data;
		}
	}
	$linm_dbresponder = new LLSODBResponder(
		$linm_dbtable,
		$linm_table,
		$linm_adapter
	);
	$data = $linm_dbresponder->command($_POST['command']);
	echo json_encode($data);
	return;
}

echo $linm_table->getHtml();
echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	function LINMAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LINMAction.prototype.constructor = LINMAction;
	LINMAction.prototype = new TableAction();
	LINMAction.prototype.export_xls = function() {
		var data = this.getRegulerData();
		data['command'] = "export_xls";
		postForm(data);
	};

	var linm;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		linm = new LINMAction(
			"linm",
			"gudang_umum",
			"laporan_inventaris_non_medis",
			new Array()
		)
	});
</script>