<?php
	class GudangUmumInventory {
		public static function getCurrentStock($db, $id_barang, $satuan, $konversi, $satuan_konversi) {
			$dbtable = new DBTable($db, "smis_gd_stok_barang");
			$jumlah = 0;
			$row = $dbtable->get_row("
				SELECT SUM(a.sisa) AS 'jumlah'
				FROM smis_gd_stok_barang a LEFT JOIN smis_gd_dbarang_masuk b ON a.id_dbarang_masuk = b.id
				WHERE a.prop NOT LIKE 'del' AND b.id_barang = '" . $id_barang . "'
			");
			$jumlah += $row->jumlah;
			return $jumlah;
		}

		public static function getStockValue($db, $id_barang, $tanggal_to) {
			$row = $db->get_row("
				SELECT a.id_barang_masuk AS 'id', (a.hna / a.konversi) AS 'hpp', a.diskon AS 'diskon_detail', a.t_diskon AS 't_diskon_detail', b.diskon AS 'diskon_global', b.t_diskon AS 't_diskon_global', a.jumlah, a.konversi
				FROM smis_gd_dbarang_masuk a LEFT JOIN smis_gd_barang_masuk b ON a.id_barang_masuk = b.id
				WHERE b.tanggal_datang <= '" . $tanggal_to . "' AND a.id_barang = '" . $id_barang . "' AND b.prop NOT LIKE 'del' AND a.prop NOT LIKE 'del' AND a.jumlah > 0
				ORDER BY b.tanggal_datang DESC, a.id DESC
				LIMIT 0, 1
			");
			$hpp_terakhir = 0;
			if ($row != null) {
				$hpp_terakhir = $row->hpp;
				if ($row->t_diskon_detail == "persen") {
				 	$diskon = $hpp_terakhir * $row->diskon_detail / 100;
				 	$hpp_terakhir -= $diskon;
				} else if ($row->t_diskon_detail == "nominal") {
				 	$diskon = $row->diskon_detail / ($row->jumlah * $row->konversi);
				 	$hpp_terakhir -= $diskon;
				}
				if ($row->t_diskon_global == "persen") {
				 	$diskon = $hpp_terakhir * $row->diskon_global / 100;
				 	$hpp_terakhir -= $diskon;
				} else if ($row->t_diskon_global == "nominal") {
					$dbtable = new DBTable($db, "smis_gd_stok_barang");
				 	$total_row = $dbtable->get_row("
				 		SELECT SUM(jumlah * hna) AS 'total'
				 		FROM smis_gd_dbarang_masuk
				 		WHERE id_barang_masuk = '" . $row->id . "' AND prop NOT LIKE 'del'
				 	");
					$diskon = 0;
					if ($total_row != null || $total_row->total != null)
				 		$diskon = $row->diskon_global * $row->hpp / $total_row->total;
				 	$hpp_terakhir -= $diskon;
				}
			}
			return $hpp_terakhir;
		}

		public static function getStockIn($db, $id_barang, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to) {
			$dbtable = new DBTable($db, "smis_gd_barang_masuk");
			$jumlah = 0;
			// penerimaan faktur:
			$row = $dbtable->get_row("
				SELECT SUM(a.jumlah * a.konversi) AS 'jumlah'
				FROM (smis_gd_stok_barang a LEFT JOIN smis_gd_dbarang_masuk b ON a.id_dbarang_masuk = b.id) LEFT JOIN smis_gd_barang_masuk c ON b.id_barang_masuk = c.id
				WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND c.prop NOT LIKE 'del' AND b.id_barang = '" . $id_barang . "' AND c.tanggal_datang >= '" . $tanggal_from . "' AND c.tanggal_datang <= '" . $tanggal_to . "' AND b.id_dpo != -1
			");
			$jumlah += $row->jumlah;
			// penerimaan retur unit:
			$row = $dbtable->get_row("
				SELECT SUM(jumlah) AS 'jumlah'
				FROM smis_gd_retur_barang_unit
				WHERE prop NOT LIKE 'del' AND status = 'sudah' AND restok = '1' AND id_barang = '" . $id_barang . "' AND tanggal >= '" . $tanggal_from . "' AND tanggal <= '" . $tanggal_to . "'
			");
			$jumlah += $row->jumlah;
			// penyesuaian stok positif:
			// $jumlah += $this->getPenyesuaianStokPositif($db, $id_barang, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to);
			return $jumlah;
		}

		public static function getOrderIn($db, $id_barang, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to) {
			$dbtable = new DBTable($db, "smis_gd_barang_masuk");
			$jumlah = 0;
			// penerimaan faktur:
			$row = $dbtable->get_row("
				SELECT SUM(a.jumlah * a.konversi) AS 'jumlah'
				FROM (smis_gd_stok_barang a LEFT JOIN smis_gd_dbarang_masuk b ON a.id_dbarang_masuk = b.id) LEFT JOIN smis_gd_barang_masuk c ON b.id_barang_masuk = c.id
				WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND c.prop NOT LIKE 'del' AND b.id_barang = '" . $id_barang . "' AND c.tanggal_datang >= '" . $tanggal_from . "' AND c.tanggal_datang <= '" . $tanggal_to . "' AND c.id > 0
			");
			$jumlah += $row->jumlah;
			return $jumlah;
		}

		public static function getVendorReturn($db, $id_barang, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to) {
			$dbtable = new DBTable($db, "smis_gd_retur_barang");
			$jumlah = 0;
			// retur vendor (faktur):
			$row = $dbtable->get_row("
				SELECT SUM(c.jumlah) AS 'jumlah'
				FROM ((smis_gd_dbarang_masuk a LEFT JOIN smis_gd_stok_barang b ON a.id = b.id_dbarang_masuk) LEFT JOIN smis_gd_dretur_barang c ON b.id = c.id_stok_barang) LEFT JOIN smis_gd_retur_barang d ON c.id_retur_barang = d.id
				WHERE c.prop NOT LIKE 'del' AND d.prop NOT LIKE 'del' AND d.dibatalkan = '0' AND a.id_barang = '" . $id_barang . "' AND d.tanggal >= '" . $tanggal_from . "' AND d.tanggal <= '" . $tanggal_to . "'
			");
			$jumlah += $row->jumlah;
			return $jumlah;
		}

		public static function getBMHPOut($db, $id_barang, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to) {
			$dbtable = new DBTable($db, "smis_gd_barang_keluar");
			$jumlah = 0;
			// bmhp keluar:
			$row = $dbtable->get_row("
				SELECT SUM(b.jumlah) AS 'jumlah'
				FROM smis_gd_barang_keluar a LEFT JOIN smis_gd_dbarang_keluar b ON a.id = b.id_barang_keluar 
				WHERE a.prop NOT LIKE 'del' AND a.status NOT LIKE 'dikembalikan' AND b.prop NOT LIKE 'del' AND b.id_barang = '" . $id_barang . "' AND a.tanggal >= '" . $tanggal_from . "' AND a.tanggal <= '" . $tanggal_to . "' AND unit NOT LIKE 'depo_farmasi%'
			");
			if ($row != null)
				$jumlah += $row->jumlah;
			return $jumlah;
		}

		public static function getBMHPIn($db, $id_barang, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to) {
			$dbtable = new DBTable($db, "smis_gd_retur_barang_unit");
			$jumlah = 0;
			// bmhp keluar:
			$row = $dbtable->get_row("
				SELECT SUM(jumlah) AS 'jumlah'
				FROM smis_gd_retur_barang_unit
				WHERE prop NOT LIKE 'del' AND id_barang = '" . $id_barang . "' AND tanggal >= '" . $tanggal_from . "' AND tanggal <= '" . $tanggal_to . "' AND unit NOT LIKE 'depo_farmasi%'
			");
			if ($row != null)
				$jumlah += $row->jumlah;
			return $jumlah;
		}		

		public static function getStockOut($db, $id_barang, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to) {
			$dbtable = new DBTable($db, "smis_gd_barang_masuk");
			$jumlah = 0;
			// mutasi obat:
			$row = $dbtable->get_row("
				SELECT SUM(a.jumlah) AS 'jumlah'
				FROM smis_gd_dbarang_keluar a LEFT JOIN smis_gd_barang_keluar b ON a.id_barang_keluar = b.id
				WHERE a.prop NOT LIKE 'del' AND b.prop NOT LIKE 'del' AND b.status NOT LIKE 'dikembalikan' AND a.id_barang = '" . $id_barang . "' AND b.tanggal >= '" . $tanggal_from . "' AND b.tanggal <= '" . $tanggal_to . "'
			");
			$jumlah += $row->jumlah;
			// retur vendor (faktur):
			$row = $dbtable->get_row("
				SELECT SUM(c.jumlah) AS 'jumlah'
				FROM ((smis_gd_dbarang_masuk a LEFT JOIN smis_gd_stok_barang b ON a.id = b.id_dbarang_masuk) LEFT JOIN smis_gd_dretur_barang c ON b.id = c.id_stok_barang) LEFT JOIN smis_gd_retur_barang d ON c.id_retur_barang = d.id
				WHERE c.prop NOT LIKE 'del' AND d.prop NOT LIKE 'del' AND d.dibatalkan = '0' AND a.id_barang = '" . $id_barang . "' AND d.tanggal >= '" . $tanggal_from . "' AND d.tanggal <= '" . $tanggal_to . "'
			");
			$jumlah += $row->jumlah;
			// penyesuaian stok negatif:
			// $jumlah += $this->getPenyesuaianStokNegatif($db, $id_barang, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to);
			return $jumlah;
		}

		public static function getPenyesuaianStokPositif($db, $id_barang, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to) {
			$dbtable = new DBTable($db, "smis_gd_penyesuaian_stok");
			$row = $dbtable->get_row("
				SELECT SUM(a.jumlah_baru - a.jumlah_lama) AS 'jumlah'
			 	FROM (smis_gd_penyesuaian_stok a LEFT JOIN smis_gd_stok_barang b ON a.id_stok_barang = b.id) LEFT JOIN smis_gd_dbarang_masuk c ON b.id_dbarang_masuk = c.id
			 	WHERE a.prop NOT LIKE 'del' AND c.id_barang = '" . $id_barang . "' AND a.tanggal >= '" . $tanggal_from . "' AND a.tanggal <= '" . $tanggal_to . "' AND a.jumlah_baru >= a.jumlah_lama
			");
			$jumlah = 0;
			if ($row != null)
				$jumlah = $row->jumlah;
			return $jumlah;
		}

		public static function getPenyesuaianStokNegatif($db, $id_barang, $satuan, $konversi, $satuan_konversi, $tanggal_from, $tanggal_to) {
			$dbtable = new DBTable($db, "smis_gd_penyesuaian_stok");
			$row = $dbtable->get_row("
			 	SELECT SUM(a.jumlah_lama - a.jumlah_baru) AS 'jumlah'
			 	FROM (smis_gd_penyesuaian_stok a LEFT JOIN smis_gd_stok_barang b ON a.id_stok_barang = b.id) LEFT JOIN smis_gd_dbarang_masuk c ON b.id_dbarang_masuk = c.id
			 	WHERE a.prop NOT LIKE 'del' AND c.id_barang = '" . $id_barang . "' AND a.tanggal >= '" . $tanggal_from . "' AND a.tanggal <= '" . $tanggal_to . "' AND a.jumlah_baru < a.jumlah_lama
			");
			$jumlah = 0;
			if ($row != null)
				$jumlah = $row->jumlah;
			return $jumlah;
		}
	}
