<?php
	require_once("gudang_umum/responder/BarangKSDBResponder.php");
	global $db;
	
	$form = new Form("ks_form", "", "Gudang Umum : Kartu Stok Barang");
	$id_barang_text = new Text("ks_id_barang", "ks_id_barang", "");
	$id_barang_text->setClass("smis-one-option-input");
	$id_barang_text->setAtribute("disabled='disabled'");
	$barang_button = new Button("", "", "Pilih");
	$barang_button->setClass("btn-info");
	$barang_button->setAction("barang_ks.chooser('barang_ks', 'barang_ks_button', 'barang_ks', barang_ks, 'Barang')");
	$barang_button->setIcon("icon-white icon-list-alt");
	$barang_button->setIsButton(Button::$ICONIC);
	$barang_button->setAtribute("id='barang_ks_browse'");
	$barang_input_group = new InputGroup("");
	$barang_input_group->addComponent($id_barang_text);
	$barang_input_group->addComponent($barang_button);
	$form->addElement("Kode Barang", $barang_input_group);
	$barang_text = new Text("ks_nama_barang", "ks_nama_barang", "");
	$barang_text->setAtribute("disabled='disabled'");
	$form->addElement("Nama Barang", $barang_text);
	$nama_jenis_barang_text = new Text("ks_nama_jenis_barang", "ks_nama_jenis_barang", "");
	$nama_jenis_barang_text->setAtribute("disabled='disabled'");
	$form->addElement("Jenis Barang", $nama_jenis_barang_text);
	$tanggal_from_text = new Text("ks_tanggal_from", "ks_tanggal_from", date("Y-m-") . "01");
	$tanggal_from_text->setClass("mydate");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$form->addElement("Tanggal Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("ks_tanggal_to", "ks_tanggal_to", date("Y-m-d"));
	$tanggal_to_text->setClass("mydate");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$form->addElement("Tanggal Akhir", $tanggal_to_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-success");
	$show_button->setAction("kartu_stok_barang.view()");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAtribute("id='show_button'");
	$download_button = new Button("", "", "AU-54");
	$download_button->setClass("btn-inverse");
	$download_button->setIcon("fa fa-download");
	$download_button->setIsButton(Button::$ICONIC);
	$download_button->setAtribute("id='download_button'");
	$button_group = new ButtonGroup("");
	$button_group->addButton($show_button);
	$button_group->addButton($download_button);
	$form->addElement("", $button_group);
		
	$table = new Table(
		array("No.", "Tanggal", "No. Bon", "Dipakai untuk / Diterima dari", "Masuk", "Keluar", "Sisa"),
		"",
		null,
		true
	);
	$table->setName("kartu_stok_barang");
	$table->setAction(false);
	$table->setFooterVisible(false);
	
	$barang_ks_table = new Table(
		array("ID Barang", "Nama Barang", "Jenis Barang"),
		"",
		null, 
		true
	);
	$barang_ks_table->setName("barang_ks");
	$barang_ks_table->setModel(Table::$SELECT);
	$barang_ks_adapter = new SimpleAdapter();
	$barang_ks_adapter->add("ID Barang", "id_barang");
	$barang_ks_adapter->add("Nama Barang", "nama_barang");
	$barang_ks_adapter->add("Jenis Barang", "nama_jenis_barang");
	$barang_ks_dbtable = new DBTable($db, "smis_gd_dbarang_masuk");
	$barang_ks_dbtable->setViewForSelect(true);
	$filter = "inventaris = 0";
	if (isset($_POST['kriteria'])) {
		$filter .= " AND (nama_barang LIKE '%" . $_POST['kriteria'] . "%' OR nama_jenis_barang LIKE '%" . $_POST['kriteria'] . "%') ";
	}
	$query_value = "
		SELECT DISTINCT id_barang AS 'id', id_barang, nama_barang, nama_jenis_barang
		FROM smis_gd_dbarang_masuk
		WHERE " . $filter . "
		ORDER BY id_barang ASC
	";
	$query_count = "
		SELECT COUNT(*)
		FROM (
			" . $query_value . "
		) v
	";
	$barang_ks_dbtable->setPreferredQuery(true, $query_value, $query_count);
	$barang_ks_dbresponder = new BarangKSDBResponder(
		$barang_ks_dbtable,
		$barang_ks_table,
		$barang_ks_adapter
	);
	$super_command = new SuperCommand();
	$super_command->addResponder("barang_ks", $barang_ks_dbresponder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}
	
	if (isset($_POST['command'])) {
		if ($_POST['command'] == "get_jumlah_sisa") {
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$id_barang = $_POST['id_barang'] = $_POST['id_barang'];
			$dbtable = new DBTable($db, "smis_gd_kartu_stok");
			$row = $dbtable->get_row("
				SELECT COUNT(*) AS 'jumlah'
				FROM smis_gd_kartu_stok
				WHERE tanggal >= '" . $tanggal_from . "' AND tanggal <= '" . date('Y-m-d') . "' AND id_barang = '" . $id_barang . "' AND prop NOT LIKE 'del'
			");
			$jumlah = 0;
			if ($row != null)
				$jumlah = $row->jumlah;
			$row = $dbtable->get_row("
				SELECT SUM(a.sisa) AS 'sisa'
				FROM smis_gd_stok_barang a LEFT JOIN smis_gd_dbarang_masuk b ON a.id_dbarang_masuk = b.id
				WHERE b.id_barang = '" . $id_barang . "'
			");
			$sisa = 0;
			if ($row != null)
				$sisa = $row->sisa;
			$data = array(
				"jumlah"	=> $jumlah,
				"sisa"		=> $sisa
			);
			echo json_encode($data);
			return;
		} else if ($_POST['command'] == "get_info") {
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$id_barang = $_POST['id_barang'] = $_POST['id_barang'];
			$num = $_POST['num'];
			$sisa = $_POST['sisa'];
			$dbtable = new DBTable($db, "smis_gd_kartu_stok");
			$row = $dbtable->get_row("
				SELECT *
				FROM smis_gd_kartu_stok
				WHERE tanggal >= '" . $tanggal_from . "' AND tanggal <= '" . date('Y-m-d') . "' AND id_barang = '" . $id_barang . "' AND prop NOT LIKE 'del'
				ORDER BY tanggal DESC, id DESC
				LIMIT " . $num . ", 1
			");
			$html = "";
			$nama_barang = "";
			$tanggal = "";
			$no_bon = "";
			if ($row != null) {
				if (strtotime($row->tanggal) >= strtotime($tanggal_from) && strtotime($row->tanggal) <= strtotime($tanggal_to) && ($row->masuk > 0 || $row->keluar > 0)) {
					$html = "
						<tr>
							<td id='nomor'></td>
							<td id='tanggal'>" . ArrayAdapter::format("date d-m-Y", $row->tanggal) . "</td>
							<td id='no_bon'>" . $row->no_bon . "</td>
							<td id='unit'>" . $row->unit . "</td>
							<td id='f_masuk'>" . ArrayAdapter::format("number", $row->masuk) . "</td>
							<td id='masuk' style='display: none;'>" . $row->masuk . "</td>
							<td id='f_keluar'>" . ArrayAdapter::format("number", $row->keluar) . "</td>
							<td id='keluar' style='display: none;'>" . $row->keluar . "</td>
							<td id='f_sisa'>" . ArrayAdapter::format("number", $sisa) . "</td>
							<td id='sisa' style='display: none;'>" . $sisa . "</td>
						</tr>
					";
				}
				$masuk = $row->masuk;
				$keluar = $row->keluar;
				$no_bon = $row->no_bon;
				$tanggal = $row->tanggal;
				$nama_barang = $row->nama_barang;
			}
			$data = array(
				"html" 		=> $html,
				"id_barang"	=> ArrayAdapter::format("only-digit6", $id_barang),
				"nama_barang"	=> $nama_barang,
				"tanggal"	=> ArrayAdapter::format("date d-m-Y", $tanggal),
				"no_bon"	=> $no_bon,
				"sisa"		=> $sisa - $masuk + $keluar
			);
			echo json_encode($data);
			return;
		} else if ($_POST['command'] == "export_excel") {
			require_once("smis-libs-out/php-excel/PHPExcel.php");
			
			$objPHPExcel = PHPExcel_IOFactory::load("gudang_umum/templates/template_kartu_stok.xlsx");
			$objPHPExcel->setActiveSheetIndexByName("Kartu Stok");
			$objWorksheet = $objPHPExcel->getActiveSheet();
			
			$id_barang = $_POST['id_barang'];
			$nama_barang = $_POST['nama_barang'];
			$nama_jenis_barang = $_POST['nama_jenis_barang'];
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$objWorksheet->setCellValue("E5", ": " . $id_barang);
			$objWorksheet->setCellValue("H3", ": " . $id_barang);
			$objWorksheet->setCellValue("H4", ": " . $nama_barang);
			$objWorksheet->setCellValue("H5", ": 0");
			
			$data = json_decode($_POST['d_data']);
			if ($_POST['num_rows'] - 2 > 0)
				$objWorksheet->insertNewRowBefore(10, $_POST['num_rows'] - 2);
			$start_row_num = 10;
			$end_row_num = 10;
			$row_num = $start_row_num;
			foreach ($data as $d) {
				$col_num = 1;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nomor);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->tanggal);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->unit);
				$col_num+=2;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->masuk);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->keluar);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->sisa);
				$objWorksheet->getStyle("F" . $row_num)->getNumberFormat()->setFormatCode("#,##0");
				$objWorksheet->getStyle("G" . $row_num)->getNumberFormat()->setFormatCode("#,##0");
				$objWorksheet->getStyle("H" . $row_num)->getNumberFormat()->setFormatCode("#,##0");
				$row_num++;
				$end_row_num++;
			}
			
			header("Content-type: application/vnd.ms-excel");	
			header("Content-Disposition: attachment; filename=Kartu Stok Barang-" . ArrayAdapter::format("only-digit6", $id_barang) . "_" . date("Ymd_his") . ".xlsx");
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objWriter->save("php://output");			
			return;
		}
		return;
	}
	
	$loading_bar = new LoadingBar("loading_bar", "");
	$button = new Button("", "", "Batal");
	$button->addClass("btn-primary");
	$button->setIsButton(Button::$ICONIC_TEXT);
	$button->setIcon("fa fa-close");
	$button->setAction("lpo.cancel()");
	$loading_modal = new Modal("loading_modal", "", "Proses..");
	$loading_modal->addHtml($loading_bar->getHtml(), "after");
	$loading_modal->addFooter($button);
	
	echo $loading_modal->getHtml();
	echo $form->getHtml();
	echo "<div id='table_content'>";
	echo $table->getHtml();
	echo "</div>";
	echo "<div id='info'></div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addJS("base-js/smis-base-loading.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
	echo addJS("gudang_umum/js/barang_ks_action.js", false);
	echo addJS("gudang_umum/js/kartu_stok_barang_action.js", false);
	echo addJS("gudang_umum/js/kartu_stok_barang.js", false);
?>