var penerimaan_barang;
var dpenerimaan_barang;
var vendor;
var barang;
var row_num;
var previous_use_ppn;

$(document).ready(function() {
	$(".mydate").datepicker();
	barang = new BarangAction(
		"barang",
		"gudang_umum",
		"penerimaan_barang_non_opl_form",
		new Array()
	);
	barang.setSuperCommand("barang");
	vendor = new VendorAction(
		"vendor",
		"gudang_umum",
		"penerimaan_barang_non_opl_form",
		new Array()
	);
	vendor.setSuperCommand("vendor");
	dpenerimaan_barang = new DPenerimaanBarangAction(
		"dpenerimaan_barang",
		"gudang_umum",
		"penerimaan_barang_non_opl_form",
		new Array("hpp", "hna", "diskon")
	);
	penerimaan_barang = new PenerimaanBarangAction(
		"penerimaan_barang",
		"gudang_umum",
		"penerimaan_barang_non_opl_form",
		new Array("diskon", "materai")
	);

	var id = $("#penerimaan_barang_id").val();
	row_num = 0;
	penerimaan_barang.get_footer();
	penerimaan_barang.show_detail_form(id);
	dpenerimaan_barang.setEditMode("true");
	$("#penerimaan_barang_no_opl").focus();

	$("#penerimaan_barang_diskon").on("change", function() {
		var diskon = $("#penerimaan_barang_diskon").val().replace(/[^0-9-,]/g, '').replace(",", ".");
		if (diskon == "") {
			$("#penerimaan_barang_diskon").val("0,00");
		}
	});
	
	$("#penerimaan_barang_t_diskon").on("change", function() {
		var diskon = $("#penerimaan_barang_diskon").val().replace(/[^0-9-,]/g, '').replace(",", ".");
		var t_diskon = $("#penerimaan_barang_t_diskon").val();
		if (diskon > 100 && t_diskon == "persen") {
			bootbox.alert("<b>Diskon</b> tidak boleh melebihi 100%");
			return;
		}
		penerimaan_barang.update_total();
	});
	
	$("#penerimaan_barang_diskon").on("keyup", function() {
		var diskon = $("#penerimaan_barang_diskon").val().replace(/[^0-9-,]/g, '').replace(",", ".");
		var t_diskon = $("#penerimaan_barang_t_diskon").val();
		if (diskon > 100 && t_diskon == "persen") {
			bootbox.alert("<b>Diskon</b> tidak boleh melebihi 100%");
			return;
		}
		penerimaan_barang.update_total();
	});

	$("#dpenerimaan_barang_diskon").on("change", function() {
		var diskon = $("#dpenerimaan_barang_diskon").val().replace(/[^0-9-,]/g, '').replace(",", ".");
		if (diskon == "") {
			$("#dpenerimaan_barang_diskon").val("0,00");
		}
	});

	$("#penerimaan_barang_no_opl").keypress(function(e) {
		if (e.which == 13) {
			$("#penerimaan_barang_no_bbm").focus();
		}
	});
	$("#penerimaan_barang_no_bbm").keypress(function(e) {
		if (e.which == 13) {
			$("#penerimaan_barang_no_faktur");
		}
	});
	$("#penerimaan_barang_no_faktur").keypress(function(e) {
		if (e.which == 13) {
			$("#penerimaan_barang_tanggal").focus();
		}
	});
	$("#penerimaan_barang_tanggal").keypress(function(e) {
		if (e.which == 13) {
			$("#penerimaan_barang_tanggal_datang").focus();
		}
	});
	$("#penerimaan_barang_tanggal_datang").keypress(function(e) {
		if (e.which == 13) {
			$("#penerimaan_barang_tanggal_tempo").focus();
		}
	});
	$("#penerimaan_barang_tanggal_tempo").keypress(function(e) {
		if (e.which == 13) {
			$("#penerimaan_barang_diskon").focus();
			$("div.datepicker").hide();
		}
	});
	$("#penerimaan_barang_use_ppn").on("focus", function() {
		previous_use_ppn = this.value;
	}).change(function() {
		var hpp = $("#dpenerimaan_barang_hpp").val();
		var hna = $("#dpenerimaan_barang_hna").val();
		var use_ppn = $("#penerimaan_barang_use_ppn").val();
		if (hna != "") {
			hna = parseFloat($("#dpenerimaan_barang_hna").val().replace(/[^0-9-,]/g, '').replace(",", "."));
			hpp = hna * 1.1;
			if (use_ppn == 0)
				hpp = hna;
			var f_hpp = "Rp. " + hpp.formatMoney("2", ".", ",");
			$("#dpenerimaan_barang_hpp").val(f_hpp);
		} else if (hpp != "") {
			hpp = parseFloat($("#dpenerimaan_barang_hpp").val().replace(/[^0-9-,]/g, '').replace(",", "."));
			hna = hpp / 1.1;
			if (use_ppn == 0)
				hna = hpp;
			var f_hna = "Rp. " + hna.formatMoney("2", ".", ",");
			$("#dpenerimaan_barang_hna").val(f_hna);
		}
		var num_rows = $("tbody#dpenerimaan_barang_list").children("tr").length;
		for (var i = 0; i < num_rows; i++) {
			var r_hna = parseFloat($("tbody#dpenerimaan_barang_list tr:eq(" + i + ") td#hna").text());
			var r_hpp = r_hna * 1.1;
			if (use_ppn == 0)
				r_hpp = r_hna;
			$("tbody#dpenerimaan_barang_list tr:eq(" + i + ") td#hpp").html(r_hpp);
		}
		penerimaan_barang.update_total();
	});

	$("#dpenerimaan_barang_nama_barang").keypress(function(e) {
		if (e.which == 13) {		
			$("ul.typeahead").html("");
			$("ul.typeahead").hide();
			$("#dpenerimaan_barang_jumlah_tercatat").focus();
		}
	});
	$("#dpenerimaan_barang_jumlah_tercatat").keypress(function(e) {
		if (e.which == 13) {
			$("#dpenerimaan_barang_jumlah").focus();
		}
	});
	$("#dpenerimaan_barang_jumlah").keypress(function(e) {
		if (e.which == 13) {
			$("#dpenerimaan_barang_hpp").focus();
		}
	});
	$("#dpenerimaan_barang_hna").keypress(function(e) {
		if (e.which == 13) {
			$("#dpenerimaan_barang_hna").focus();
		}
		var use_ppn = $("#penerimaan_barang_use_ppn").val();
		if ($("#dpenerimaan_barang_hna").val() == "") {
			$("#dpenerimaan_barang_hpp").val("Rp. 0,00");
			$("#dpenerimaan_barang_hna").val("Rp. 0,00");
		} else {
			var hna = parseFloat($("#dpenerimaan_barang_hna").val().replace(/[^0-9-,]/g, '').replace(",", "."));
			var hpp = hna * 1.1;
			if (use_ppn == false)
				hpp = hna;
			var f_hpp = "Rp. " + hpp.formatMoney("2", ".", ",");
			$("#dpenerimaan_barang_hpp").val(f_hpp);
		}
	});
	$("#dpenerimaan_barang_hpp").keypress(function(e) {
		if (e.which == 13) {
			$("#dpenerimaan_barang_diskon").focus();
		}
		var use_ppn = $("#penerimaan_barang_use_ppn").val();
		if ($("#dpenerimaan_barang_hpp").val() == "") {
			$("#dpenerimaan_barang_hpp").val("Rp. 0,00");
			$("#dpenerimaan_barang_hna").val("Rp. 0,00");
		} else {
			var hpp = parseFloat($("#dpenerimaan_barang_hpp").val().replace(/[^0-9-,]/g, '').replace(",", "."));
			var hna = hpp / 1.1;
			if (use_ppn == false)
				hna = hpp;
			var f_hna = "Rp. " + hna.formatMoney("2", ".", ",");
			$("#dpenerimaan_barang_hna").val(f_hna);
		}
	});
	$("#dpenerimaan_barang_hna").on("change", function() {
		var use_ppn = $("#penerimaan_barang_use_ppn").val();
		if ($("#dpenerimaan_barang_hna").val() == "") {
			$("#dpenerimaan_barang_hpp").val("Rp. 0,00");
			$("#dpenerimaan_barang_hna").val("Rp. 0,00");
		} else {
			var hna = parseFloat($("#dpenerimaan_barang_hna").val().replace(/[^0-9-,]/g, '').replace(",", "."));
			var hpp = hna * 1.1;
			if (use_ppn == false)
				hpp = hna;
			var f_hpp = "Rp. " + hpp.formatMoney("2", ".", ",");
			$("#dpenerimaan_barang_hpp").val(f_hpp);
		}
	});
	$("#dpenerimaan_barang_hpp").on("change", function() {
		var use_ppn = $("#penerimaan_barang_use_ppn").val();
		if ($("#dpenerimaan_barang_hpp").val() == "") {
			$("#dpenerimaan_barang_hpp").val("Rp. 0,00");
			$("#dpenerimaan_barang_hna").val("Rp. 0,00");
		} else {
			var hpp = parseFloat($("#dpenerimaan_barang_hpp").val().replace(/[^0-9-,]/g, '').replace(",", "."));
			var hna = hpp / 1.1;
			if (use_ppn == false)
				hna = hpp;
			var f_hna = "Rp. " + hna.formatMoney("2", ".", ",");
			$("#dpenerimaan_barang_hna").val(f_hna);
		}
	});
	$("#dpenerimaan_barang_diskon").keydown(function(e) {
		if (e.which == 13) {
			$("#dpenerimaan_barang_t_diskon").focus();
		}
	});
	$("#dpenerimaan_barang_t_diskon").keypress(function(e) {
		if (e.which == 13) {
			$("#dpenerimaan_barang_produsen").focus();
		}
	});
	$("#dpenerimaan_barang_produsen").keypress(function(e) {
		if (e.which == 13) {
			$("#dpenerimaan_barang_tanggal_exp").focus();
		}
	});
	$("#dpenerimaan_barang_tanggal_exp").keypress(function(e) {
		if (e.which == 13) {
			$("#dpenerimaan_barang_no_batch").focus();
			$("div.datepicker").hide();
		}
	});

	var barang_data = barang.getViewData();
	$("#dpenerimaan_barang_nama_barang").typeahead({
		minLength	: 3,
		source		: function (query, process) {
			var $items = new Array;
			$items = [""];                
			barang_data['kriteria'] = $('#dpenerimaan_barang_nama_barang').val();
			$.ajax({
				url		: "",
				type	: "POST",
				data	: barang_data,
				success	: function(response) {
					var json = getContent(response);
					var t_data = json.d.data;
					$items = [""];      				
					$.map(t_data, function(data) {
						var group;
						group = {
							id		: data.id,
							name	: data.nama, 
							kode	: data.kode, 
							toString: function () {
								return JSON.stringify(this);
							},
							toLowerCase: function () {
								return this.name.toLowerCase();
							},
							indexOf: function (string) {
								return String.prototype.indexOf.apply(this.name, arguments);
							},
							replace: function (string) {
								var value = "";
								value +=  this.kode + " - " + this.name;
								if(typeof(this.level) != "undefined") {
									value += " <span class='pull-right muted'>";
									value += this.level;
									value += "</span>";
								}
								return String.prototype.replace.apply("<div class='typeaheadiv'>" + value + "</div>", arguments);
							}
						};
						$items.push(group);
					});
					process($items);
				}
			});
		},
		updater		: function (item) {
			var item = JSON.parse(item);  
			barang.select(item.id);  
			$("#dpenerimaan_barang_nama_barang").focus();       
			return item.name;
		}
	});
});