function DPenerimaanBarangAction(name, page, action, column) {
	this.initialize(name, page, action, column);
}
DPenerimaanBarangAction.prototype.constructor = DPenerimaanBarangAction;
DPenerimaanBarangAction.prototype = new TableAction();
DPenerimaanBarangAction.prototype.validate = function() {
	var valid = true;
	var invalid_msg = "";
	var nama_barang = $("#dpenerimaan_barang_name_barang").val();
	var jumlah_tercatat = $("#dpenerimaan_barang_jumlah_tercatat").val();
	var jumlah = $("#dpenerimaan_barang_jumlah").val();
	var konversi = $("#dpenerimaan_barang_konversi").val();
	var hna = $("#dpenerimaan_barang_hna").val().replace(/[^0-9-,]/g, '').replace(",", ".");
	var diskon = $("#dpenerimaan_barang_diskon").val().replace(/[^0-9-,]/g, '').replace(",", ".");
	var inventaris = $("#dpenerimaan_barang_inventaris").val();
	if (nama_barang == "") {
		valid = false;
		invalid_msg += "</br><strong>Nama Barang</strong> tidak boleh kosong";
		$("#dpenerimaan_barang_nama_barang").addClass("error_field");
	}
	if (jumlah_tercatat == "") {
		valid = false;
		invalid_msg += "</br><strong>Jumlah Tercatat</strong> tidak boleh kosong";
		$("#dpenerimaan_barang_jumlah_tercatat").addClass("error_field");
	} else if (inventaris == 1 && !is_numeric(jumlah_tercatat)) {
		valid = false;
		invalid_msg += "</br><strong>Jumlah Tercatat</strong> seharusnya numerik (0-9 / Tidak Diperkenankan Desimal)";
		$("#dpenerimaan_barang_jumlah_tercatat").addClass("error_field");
	} else if (inventaris == 0 && isNaN(jumlah_tercatat)) {
		valid = false;
		invalid_msg += "</br><strong>Jumlah Tercatat</strong> seharusnya numerik (0-9 / Diperkenankan Desimal)";
		$("#dpenerimaan_barang_jumlah_tercatat").addClass("error_field");
	} else if (jumlah_tercatat <= 0) {
		valid = false;
		invalid_msg += "</br><strong>Jumlah Tercatat</strong> seharusnya > 0";
		$("#dpenerimaan_barang_jumlah_tercatat").addClass("error_field");
	}
	if (jumlah == "") {
		valid = false;
		invalid_msg += "</br><strong>Jumlah Diterima</strong> tidak boleh kosong";
		$("#dpenerimaan_barang_jumlah").addClass("error_field");
	} else if (inventaris == 1 && !is_numeric(jumlah)) {
		valid = false;
		invalid_msg += "</br><strong>Jumlah Diterima</strong> seharusnya numerik (0-9 / Tidak Diperkenankan Desimal)";
		$("#dpenerimaan_barang_jumlah").addClass("error_field");
	} else if (inventaris == 0 && isNaN(jumlah)) {
		valid = false;
		invalid_msg += "</br><strong>Jumlah Diterima</strong> seharusnya numerik (0-9 / Diperkenankan Desimal)";
		$("#dpenerimaan_barang_jumlah").addClass("error_field");
	} else if (jumlah <= 0) {
		valid = false;
		invalid_msg += "</br><strong>Jumlah Diterima</strong> seharusnya > 0";
		$("#dpenerimaan_barang_jumlah").addClass("error_field");
	}
	if (konversi == "") {
		valid = false;
		invalid_msg += "</br><strong>Konversi</strong> tidak boleh kosong";
		$("#dpenerimaan_barang_konversi").addClass("error_field");
	} else if (!is_numeric(konversi)) {
		valid = false;
		invalid_msg += "</br><strong>Konversi</strong> seharusnya numerik (0-9)";
		$("#dpenerimaan_barang_konversi").addClass("error_field");
	} else if (jumlah <= 0) {
		valid = false;
		invalid_msg += "</br><strong>Konversi</strong> seharusnya > 0";
		$("#dpenerimaan_barang_konversi").addClass("error_field");
	}
	if (hna == "") {
		valid = false;
		invalid_msg += "</br><strong>Harga</strong> tidak boleh kosong";
		$("#dpenerimaan_barang_hna").addClass("error_field");
	} else if (jumlah <= 0) {
		valid = false;
		invalid_msg += "</br><strong>Harga</strong> tidak boleh 0";
		$("#dpenerimaan_barang_hna").addClass("error_field");
	}
	if (diskon == "") {
		valid = false;
		invalid_msg += "</br><strong>Diskon</strong> tidak boleh kosong";
		$("#dpenerimaan_barang_diskon").addClass("error_field");
	}
	if (!valid)
		bootbox.alert(invalid_msg);
	return valid;
};
DPenerimaanBarangAction.prototype.clear = function() {
	$("#dpenerimaan_barang_row_num").val("");
	$("#dpenerimaan_barang_id_barang").val("");
	$("#dpenerimaan_barang_kode_barang").val("");
	$("#dpenerimaan_barang_name_barang").val("");
	$("#dpenerimaan_barang_nama_barang").val("");
	$("#dpenerimaan_barang_nama_jenis_barang").val("");
	$("#dpenerimaan_barang_medis").val("");
	$("#dpenerimaan_barang_inventaris").val("");
	$("#dpenerimaan_barang_jumlah_tercatat").val("");
	$("#dpenerimaan_barang_jumlah").val("");
	$("#dpenerimaan_barang_satuan").val("");
	$("#dpenerimaan_barang_konversi").val("");
	$("#dpenerimaan_barang_satuan_konversi").val("");
	$("#dpenerimaan_barang_hpp").val("Rp. 0,00");
	$("#dpenerimaan_barang_hna").val("Rp. 0,00");
	$("#dpenerimaan_barang_diskon").val("0,00");
	$("#dpenerimaan_barang_t_diskon").val("persen");
	$("#dpenerimaan_barang_produsen").val("");
	$("#dpenerimaan_barang_tanggal_exp").val("");
	$("#dpenerimaan_barang_no_batch").val("");
};
DPenerimaanBarangAction.prototype.save = function() {
	if (!this.validate())
		return;
	var r_num = $("#dpenerimaan_barang_row_num").val();
	var id_barang = $("#dpenerimaan_barang_id_barang").val();
	var kode_barang = $("#dpenerimaan_barang_kode_barang").val();
	var nama_barang = $("#dpenerimaan_barang_name_barang").val();
	var nama_jenis_barang = $("#dpenerimaan_barang_nama_jenis_barang").val();
	var medis = $("#dpenerimaan_barang_medis").val();
	var inventaris = $("#dpenerimaan_barang_inventaris").val();
	var stok_entri = $("#dpenerimaan_barang_stok_entri").val();
	var f_stok_entri = stok_entri;
	var jumlah_tercatat = $("#dpenerimaan_barang_jumlah_tercatat").val();
	var f_jumlah_tercatat = jumlah_tercatat;
	var jumlah = $("#dpenerimaan_barang_jumlah").val();
	var f_jumlah = jumlah;
	var satuan = $("#dpenerimaan_barang_satuan").val();
	var konversi = $("#dpenerimaan_barang_konversi").val();
	var satuan_konversi = $("#dpenerimaan_barang_satuan_konversi").val();
	var hna = parseFloat($("#dpenerimaan_barang_hna").val().replace(/[^0-9-,]/g, '').replace(",", "."));
	var f_hna = hna.formatMoney("2", ".", ",");
	var hpp = hna / 1.1;
	var use_ppn = $("#penerimaan_barang_use_ppn").val();
	if (use_ppn == 0)
		hpp = hna;
	var diskon = parseFloat($("#dpenerimaan_barang_diskon").val().replace(/[^0-9-,]/g, '').replace(",", "."));
	var t_diskon = $("#dpenerimaan_barang_t_diskon").val();
	var f_diskon = diskon + " %";
	if (t_diskon == "nominal")
		f_diskon = diskon.formatMoney("2", ".", ",");
	var produsen = $("#dpenerimaan_barang_produsen").val();
	var tanggal_exp = $("#dpenerimaan_barang_tanggal_exp").val();
	var no_batch = $("#dpenerimaan_barang_no_batch").val();
	var subtotal = jumlah * hna;
	if (t_diskon == "persen")
		subtotal = subtotal - (diskon * subtotal / 100);
	else
		subtotal = subtotal - diskon;
	subtotal = Math.round(subtotal);
	var f_subtotal = subtotal.formatMoney("2", ".", ",");
	
	if (r_num != "") {
		$("tr#data_" + r_num + " td#jumlah_tercatat").html(jumlah_tercatat);
		$("tr#data_" + r_num + " td#f_jumlah_tercatat").html("<small><div align='right'>" + f_jumlah_tercatat + "</div></small>");
		$("tr#data_" + r_num + " td#jumlah").html(jumlah);
		$("tr#data_" + r_num + " td#f_jumlah").html("<small><div align='right'>" + f_jumlah + "</div></small>");
		$("tr#data_" + r_num + " td#konversi").html(konversi);
		$("tr#data_" + r_num + " td#hna").html(hna);
		$("tr#data_" + r_num + " td#hpp").html(hpp);
		$("tr#data_" + r_num + " td#f_hna").html("<small><div align='right'>" + f_hna + "</div></small>");
		$("tr#data_" + r_num + " td#diskon").html(diskon);
		$("tr#data_" + r_num + " td#t_diskon").html(t_diskon);
		$("tr#data_" + r_num + " td#f_diskon").html("<small><div align='right'>" + f_diskon + "</div></small>");
		$("tr#data_" + r_num + " td#produsen").html(produsen);
		$("tr#data_" + r_num + " td#tanggal_exp").html(tanggal_exp);
		$("tr#data_" + r_num + " td#no_batch").html(no_batch);
		$("tr#data_" + r_num + " td#subtotal").html(subtotal);
		$("tr#data_" + r_num + " td#f_subtotal").html("<small><div align='right'>" + f_subtotal + "</div></small>");
	} else {
		var html_edit_action = "<a href='#' onclick='dpenerimaan_barang.edit(" + row_num + ")' class='input btn btn-warning'><i class='fa fa-pencil'></i></a>";
		var html_del_action = "<a href='#' onclick='dpenerimaan_barang.del(" + row_num + ")' class='input btn btn-danger'><i class='fa fa-trash-o'></i></a>";
		$("tbody#dpenerimaan_barang_list").append(
			"<tr id='data_" + row_num + "'>" +
				"<td id='nomor'></td>" +
				"<td id='id' style='display: none;'></td>" +
				"<td id='id_dpo' style='display: none;'>0</td>" +
				"<td id='id_barang' style='display: none;'>" + id_barang + "</td>" +
				"<td id='medis' style='display: none;'>" + medis + "</td>" +
				"<td id='inventaris' style='display: none;'>" + inventaris + "</td>" +
				"<td id='kode_barang'><small>" + kode_barang + "</small></td>" +
				"<td id='nama_barang'><small>" + nama_barang + "</small></td>" +
				"<td id='nama_jenis_barang'><small>" + nama_jenis_barang + "</small></td>" +
				"<td id='stok_entri' style='display: none;'>" + stok_entri + "</td>" +
				"<td id='f_stok_entri'><small><div align='right'>" + f_stok_entri + "</div></small></td>" +
				"<td id='jumlah_tercatat' style='display: none;'>" + jumlah_tercatat + "</td>" +
				"<td id='f_jumlah_tercatat'><small><div align='right'>" + f_jumlah_tercatat + "</div></small></td>" +
				"<td id='jumlah' style='display: none;'>" + jumlah + "</td>" +
				"<td id='f_jumlah'><small><div align='right'>" + f_jumlah + "</div></small></td>" +
				"<td id='satuan'><small>" + satuan + "</small></td>" +
				"<td id='konversi'>" + konversi + "</td>" +
				"<td id='satuan_konversi'>" + satuan_konversi + "</td>" +
				"<td id='hna' style='display: none;'>" + hna + "</td>" +
				"<td id='hpp' style='display: none;'>" + hpp + "</td>" +
				"<td id='f_hna'><small>" + f_hna + "</small></td>" +
				"<td id='diskon' style='display: none;'>" + diskon + "</td>" +
				"<td id='t_diskon' style='display: none;'>" + t_diskon + "</td>" +
				"<td id='f_diskon'><small><div align='right'>" + f_diskon + "</div></small></td>" +
				"<td id='subtotal' style='display: none;'>" + subtotal + "</td>" +
				"<td id='f_subtotal'><small><div align='right'>" + f_subtotal + "</div></small></td>" +
				"<td id='produsen' style='display: none;'>" + produsen + "</td>" +
				"<td id='tanggal_exp' style='display: none;'>" + tanggal_exp + "</td>" +
				"<td id='no_batch' style='display: none;'>" + no_batch + "</td>" +
				"<td>" + html_edit_action + "</td>" +
				"<td>" + html_del_action + "</td>" +
			"</tr>"
		);
		row_num++;
	}
	this.clear();
	penerimaan_barang.update_total();
	this.setEditMode("true");
};
DPenerimaanBarangAction.prototype.setEditMode = function(enable) {
	if (enable == "true") {
		$("#penerimaan_barang_form_save").show();
		$("#penerimaan_barang_form_update").hide();
		$("#penerimaan_barang_form_cancel").hide();
	} else {
		$("#penerimaan_barang_form_save").hide();
		$("#penerimaan_barang_form_update").show();
		$("#penerimaan_barang_form_cancel").show();
	}
};
DPenerimaanBarangAction.prototype.edit = function(r_num) {
	var kode_barang = $("tr#data_" + r_num + " td#kode_barang").text();
	var nama_barang = $("tr#data_" + r_num + " td#nama_barang").text();
	var nama_jenis_barang = $("tr#data_" + r_num + " td#nama_jenis_barang").text();
	var medis = $("tr#data_" + r_num + " td#medis").text();
	var inventaris = $("tr#data_" + r_num + " td#inventaris").text();
	var jumlah_tercatat = parseFloat($("tr#data_" + r_num + " td#jumlah_tercatat").text());
	var jumlah = parseFloat($("tr#data_" + r_num + " td#jumlah").text());
	var satuan = $("tr#data_" + r_num + " td#satuan").text();
	var konversi = $("tr#data_" + r_num + " td#konversi").text();
	var satuan_konversi = $("tr#data_" + r_num + " td#satuan_konversi").text();
	var hna = "Rp. " + parseFloat($("tr#data_" + r_num + " td#hna").text()).formatMoney("2", ".", ",");
	var hpp = "Rp. " + (parseFloat($("tr#data_" + r_num + " td#hna").text()) * 1.1).formatMoney("2", ".", ",");
	var use_ppn = $("#penerimaan_barang_use_ppn").val();
	if (use_ppn == 0)
		hpp = hna;
	var diskon = $("tr#data_" + r_num + " td#diskon").text();
	var t_diskon = $("tr#data_" + r_num + " td#t_diskon").text();
	var produsen = $("tr#data_" + r_num + " td#produsen").text();
	var tanggal_exp = $("tr#data_" + r_num + " td#tanggal_exp").text();
	var no_batch = $("tr#data_" + r_num + " td#no_batch").text();
	var sisa_opl_sebelum = $("tr#data_" + r_num + " td#sisa_opl_sebelum").text();
	var sisa_opl_sesudah = $("tr#data_" + r_num + " td#sisa_opl_sesudah").text();
	this.setEditMode("false");
	$("#dpenerimaan_barang_row_num").val(r_num);
	$("#dpenerimaan_barang_kode_barang").val(kode_barang);
	$("#dpenerimaan_barang_name_barang").val(nama_barang);
	$("#dpenerimaan_barang_nama_barang").val(nama_barang);
	$("#dpenerimaan_barang_nama_jenis_barang").val(nama_jenis_barang);
	$("#dpenerimaan_barang_medis").val(medis);
	$("#dpenerimaan_barang_inventaris").val(inventaris);
	$("#dpenerimaan_barang_jumlah_tercatat").val(jumlah_tercatat);
	$("#dpenerimaan_barang_jumlah").val(jumlah);
	$("#dpenerimaan_barang_satuan").val(satuan);
	$("#dpenerimaan_barang_konversi").val(konversi);
	$("#dpenerimaan_barang_satuan_konversi").val(satuan_konversi);
	$("#dpenerimaan_barang_hpp").val(hpp);
	$("#dpenerimaan_barang_hna").val(hna);
	$("#dpenerimaan_barang_diskon").val(diskon);
	$("#dpenerimaan_barang_t_diskon").val(t_diskon);
	$("#dpenerimaan_barang_produsen").val(produsen);
	$("#dpenerimaan_barang_tanggal_exp").val(tanggal_exp);
	$("#dpenerimaan_barang_no_batch").val(no_batch);
};
DPenerimaanBarangAction.prototype.del = function(r_num) {
	var id = $("tr#data_" + r_num + " td#id").text();
	if (id.length == 0) {
		$("#data_" + r_num).remove();
	} else {
		$("#data_" + r_num).attr("style", "display: none;");
		$("#data_" + r_num).attr("class", "deleted");
	}
	penerimaan_barang.update_total();
};
DPenerimaanBarangAction.prototype.cancel = function() {
	this.clear();
	this.setEditMode("true");
};